/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.LogixNG_SelectEnum;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.swing.Bundle;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectEnumSwing_EnumDialog;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectTableSwing;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JComboBoxUtil;

public class LogixNG_SelectEnumSwing<E extends Enum<?>> {
    private final JDialog _dialog;
    private final LogixNG_SelectTableSwing _selectTableSwing;
    private LogixNG_SelectEnumSwing_EnumDialog<E> _enumDialog;
    private E[] _enumArray;
    private JTabbedPane _tabbedPane;
    private JComboBox<E> _enumComboBox;
    private JPanel _panelDirect;
    private JPanel _panelReference;
    private JPanel _panelMemory;
    private JPanel _panelLocalVariable;
    private JPanel _panelFormula;
    private JPanel _panelTable;
    private JTextField _referenceTextField;
    private BeanSelectPanel<Memory> _memoryPanel;
    private JCheckBox _listenToMemoryCheckBox;
    private JTextField _localVariableTextField;
    private JTextField _formulaTextField;

    public LogixNG_SelectEnumSwing(@Nonnull JDialog dialog, @Nonnull SwingConfiguratorInterface swi) {
        this._dialog = dialog;
        this._selectTableSwing = new LogixNG_SelectTableSwing(this._dialog, swi);
    }

    public JPanel createPanel(@CheckForNull LogixNG_SelectEnum<E> selectEnum, E[] enumArray) {
        return this.createPanel(selectEnum, (Enum[])enumArray, null);
    }

    public JPanel createPanel(@CheckForNull LogixNG_SelectEnum<E> selectEnum, E[] enumArray, E defaultValue) {
        this._enumArray = enumArray;
        JPanel panel = new JPanel();
        this._tabbedPane = new JTabbedPane();
        this._panelDirect = new JPanel();
        this._panelReference = new JPanel();
        this._panelMemory = new JPanel();
        this._panelLocalVariable = new JPanel();
        this._panelFormula = new JPanel();
        this._panelTable = selectEnum != null ? this._selectTableSwing.createPanel(selectEnum.getSelectTable()) : this._selectTableSwing.createPanel(null);
        this._memoryPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._listenToMemoryCheckBox = new JCheckBox(Bundle.getMessage("ListenToMemory"));
        this._panelMemory.setLayout(new BoxLayout(this._panelMemory, 1));
        this._panelMemory.add(this._memoryPanel);
        this._panelMemory.add(this.createEnumDialogButton());
        this._panelMemory.add(this._listenToMemoryCheckBox);
        this._tabbedPane.addTab(NamedBeanAddressing.Direct.toString(), this._panelDirect);
        this._tabbedPane.addTab(NamedBeanAddressing.Reference.toString(), this._panelReference);
        this._tabbedPane.addTab(NamedBeanAddressing.Memory.toString(), this._panelMemory);
        this._tabbedPane.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelLocalVariable);
        this._tabbedPane.addTab(NamedBeanAddressing.Formula.toString(), this._panelFormula);
        this._tabbedPane.addTab(NamedBeanAddressing.Table.toString(), this._panelTable);
        this._enumComboBox = new JComboBox();
        for (E e : enumArray) {
            this._enumComboBox.addItem(e);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this._enumComboBox);
        this._enumComboBox.setRenderer(new ComboBoxRenderer<E>(this._enumComboBox.getRenderer()));
        this._panelDirect.add(this._enumComboBox);
        this._referenceTextField = new JTextField();
        this._referenceTextField.setColumns(30);
        this._panelReference.setLayout(new BoxLayout(this._panelReference, 1));
        this._panelReference.add(this._referenceTextField);
        this._panelReference.add(this.createEnumDialogButton());
        this._localVariableTextField = new JTextField();
        this._localVariableTextField.setColumns(30);
        this._panelLocalVariable.setLayout(new BoxLayout(this._panelLocalVariable, 1));
        this._panelLocalVariable.add(this._localVariableTextField);
        this._panelLocalVariable.add(this.createEnumDialogButton());
        this._formulaTextField = new JTextField();
        this._formulaTextField.setColumns(30);
        this._panelFormula.setLayout(new BoxLayout(this._panelFormula, 1));
        this._panelFormula.add(this._formulaTextField);
        this._panelFormula.add(this.createEnumDialogButton());
        if (defaultValue != null) {
            this._enumComboBox.setSelectedItem(defaultValue);
        }
        if (selectEnum != null) {
            switch (selectEnum.getAddressing()) {
                case Direct: {
                    this._tabbedPane.setSelectedComponent(this._panelDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPane.setSelectedComponent(this._panelReference);
                    break;
                }
                case Memory: {
                    this._tabbedPane.setSelectedComponent(this._panelMemory);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPane.setSelectedComponent(this._panelLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPane.setSelectedComponent(this._panelFormula);
                    break;
                }
                case Table: {
                    this._tabbedPane.setSelectedComponent(this._panelTable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + selectEnum.getAddressing().name());
                }
            }
            if (selectEnum.getEnum() != null) {
                this._enumComboBox.setSelectedItem(selectEnum.getEnum());
            }
            this._referenceTextField.setText(selectEnum.getReference());
            this._memoryPanel.setDefaultNamedBean(selectEnum.getMemory());
            this._listenToMemoryCheckBox.setSelected(selectEnum.getListenToMemory());
            this._localVariableTextField.setText(selectEnum.getLocalVariable());
            this._formulaTextField.setText(selectEnum.getFormula());
        }
        panel.add(this._tabbedPane);
        return panel;
    }

    public JButton createEnumDialogButton() {
        JButton enumDialogButton = new JButton(Bundle.getMessage("LogixNG_SelectEnumSwing_ButtonEnumDialog"));
        enumDialogButton.addActionListener(this::showEnumDialog);
        return enumDialogButton;
    }

    public void showEnumDialog(ActionEvent e) {
        if (this._enumDialog != null) {
            this._enumDialog.setVisible(true);
        } else {
            Runnable windowIsClosed = () -> {
                this._enumDialog = null;
            };
            this._enumDialog = new LogixNG_SelectEnumSwing_EnumDialog(this._enumArray, windowIsClosed);
        }
    }

    public void addAddressingListener(ChangeListener listener) {
        this._tabbedPane.addChangeListener(listener);
    }

    public void addEnumListener(ActionListener listener) {
        this._enumComboBox.addActionListener(listener);
    }

    public boolean validate(@Nonnull LogixNG_SelectEnum<E> selectEnum, @Nonnull List<String> errorMessages) {
        try {
            if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
                selectEnum.setReference(this._referenceTextField.getText());
            }
        }
        catch (IllegalArgumentException e) {
            errorMessages.add(e.getMessage());
            return false;
        }
        try {
            selectEnum.setFormula(this._formulaTextField.getText());
            selectEnum.setAddressing(this.getAddressing());
        }
        catch (ParserException e) {
            errorMessages.add("Cannot parse formula: " + e.getMessage());
            return false;
        }
        this._selectTableSwing.validate(selectEnum.getSelectTable(), errorMessages);
        return errorMessages.isEmpty();
    }

    public void updateObject(@Nonnull LogixNG_SelectEnum<E> selectEnum) {
        block9: {
            if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
                selectEnum.setEnum((Enum)this._enumComboBox.getItemAt(this._enumComboBox.getSelectedIndex()));
            }
            try {
                if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
                    selectEnum.setAddressing(NamedBeanAddressing.Direct);
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
                    selectEnum.setAddressing(NamedBeanAddressing.Reference);
                    selectEnum.setReference(this._referenceTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelMemory) {
                    selectEnum.setAddressing(NamedBeanAddressing.Memory);
                    selectEnum.setMemory(this._memoryPanel.getNamedBean());
                    selectEnum.setListenToMemory(this._listenToMemoryCheckBox.isSelected());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelLocalVariable) {
                    selectEnum.setAddressing(NamedBeanAddressing.LocalVariable);
                    selectEnum.setLocalVariable(this._localVariableTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelFormula) {
                    selectEnum.setAddressing(NamedBeanAddressing.Formula);
                    selectEnum.setFormula(this._formulaTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelTable) {
                    selectEnum.setAddressing(NamedBeanAddressing.Table);
                    break block9;
                }
                throw new IllegalArgumentException("_tabbedPaneEnum has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
        this._selectTableSwing.updateObject(selectEnum.getSelectTable());
    }

    public boolean isEnumSelected(E e) {
        if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
            return this._enumComboBox.getItemAt(this._enumComboBox.getSelectedIndex()) == e;
        }
        return false;
    }

    public boolean isEnumSelectedOrIndirectAddressing(E e) {
        if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
            return this._enumComboBox.getItemAt(this._enumComboBox.getSelectedIndex()) == e;
        }
        return true;
    }

    public NamedBeanAddressing getAddressing() {
        if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
            return NamedBeanAddressing.Direct;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
            return NamedBeanAddressing.Reference;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelMemory) {
            return NamedBeanAddressing.Memory;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelLocalVariable) {
            return NamedBeanAddressing.LocalVariable;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelFormula) {
            return NamedBeanAddressing.Formula;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelTable) {
            return NamedBeanAddressing.Table;
        }
        throw new IllegalArgumentException("_tabbedPane has unknown selection");
    }

    public E getEnum() {
        return (E)((Enum)this._enumComboBox.getItemAt(this._enumComboBox.getSelectedIndex()));
    }

    public void setEnum(E e) {
        this._enumComboBox.setSelectedItem(e);
    }

    public void dispose() {
        this._selectTableSwing.dispose();
        if (this._enumDialog != null) {
            this._enumDialog.setVisible(false);
            this._enumDialog.dispose();
            this._enumDialog = null;
        }
    }

    private static class ComboBoxRenderer<E>
    extends JLabel
    implements ListCellRenderer<E> {
        private final JSeparator _separator = new JSeparator(0);
        private final ListCellRenderer<E> _old;

        private ComboBoxRenderer(ListCellRenderer<E> old) {
            this._old = old;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
            if ("---------------".equals(value.toString())) {
                return this._separator;
            }
            return this._old.getListCellRendererComponent(list, (E)value, index, isSelected, cellHasFocus);
        }
    }
}

