/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.swing;

import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.LogixNG_SelectInteger;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.swing.Bundle;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectTableSwing;
import jmri.util.swing.BeanSelectPanel;

public class LogixNG_SelectIntegerSwing {
    private final JDialog _dialog;
    private final LogixNG_SelectTableSwing _selectTableSwing;
    private JTabbedPane _tabbedPane;
    private JTextField _valueTextField;
    private JPanel _panelDirect;
    private JPanel _panelReference;
    private JPanel _panelMemory;
    private JPanel _panelLocalVariable;
    private JPanel _panelFormula;
    private JPanel _panelTable;
    private JTextField _referenceTextField;
    private BeanSelectPanel<Memory> _memoryPanel;
    private JCheckBox _listenToMemoryCheckBox;
    private JTextField _localVariableTextField;
    private JTextField _formulaTextField;

    public LogixNG_SelectIntegerSwing(@Nonnull JDialog dialog, @Nonnull SwingConfiguratorInterface swi) {
        this._dialog = dialog;
        this._selectTableSwing = new LogixNG_SelectTableSwing(this._dialog, swi);
    }

    public JPanel createPanel(@Nonnull LogixNG_SelectInteger selectInteger) {
        LogixNG_SelectInteger.FormatterParserValidator _formatterParserValidator = selectInteger.getFormatterParserValidator();
        JPanel panel = new JPanel();
        this._tabbedPane = new JTabbedPane();
        this._panelDirect = new JPanel();
        this._panelReference = new JPanel();
        this._panelMemory = new JPanel();
        this._panelLocalVariable = new JPanel();
        this._panelFormula = new JPanel();
        this._panelTable = this._selectTableSwing.createPanel(selectInteger.getSelectTable());
        this._memoryPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._listenToMemoryCheckBox = new JCheckBox(Bundle.getMessage("ListenToMemory"));
        this._panelMemory.setLayout(new BoxLayout(this._panelMemory, 1));
        this._panelMemory.add(this._memoryPanel);
        this._panelMemory.add(this._listenToMemoryCheckBox);
        this._tabbedPane.addTab(NamedBeanAddressing.Direct.toString(), this._panelDirect);
        this._tabbedPane.addTab(NamedBeanAddressing.Reference.toString(), this._panelReference);
        this._tabbedPane.addTab(NamedBeanAddressing.Memory.toString(), this._panelMemory);
        this._tabbedPane.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelLocalVariable);
        this._tabbedPane.addTab(NamedBeanAddressing.Formula.toString(), this._panelFormula);
        this._tabbedPane.addTab(NamedBeanAddressing.Table.toString(), this._panelTable);
        this._valueTextField = new JTextField(30);
        this._valueTextField.setText(_formatterParserValidator.format(_formatterParserValidator.getInitialValue()));
        this._panelDirect.add(this._valueTextField);
        this._referenceTextField = new JTextField();
        this._referenceTextField.setColumns(30);
        this._panelReference.add(this._referenceTextField);
        this._localVariableTextField = new JTextField();
        this._localVariableTextField.setColumns(30);
        this._panelLocalVariable.add(this._localVariableTextField);
        this._formulaTextField = new JTextField();
        this._formulaTextField.setColumns(30);
        this._panelFormula.add(this._formulaTextField);
        switch (selectInteger.getAddressing()) {
            case Direct: {
                this._tabbedPane.setSelectedComponent(this._panelDirect);
                break;
            }
            case Reference: {
                this._tabbedPane.setSelectedComponent(this._panelReference);
                break;
            }
            case Memory: {
                this._tabbedPane.setSelectedComponent(this._panelMemory);
                break;
            }
            case LocalVariable: {
                this._tabbedPane.setSelectedComponent(this._panelLocalVariable);
                break;
            }
            case Formula: {
                this._tabbedPane.setSelectedComponent(this._panelFormula);
                break;
            }
            case Table: {
                this._tabbedPane.setSelectedComponent(this._panelTable);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _addressing state: " + selectInteger.getAddressing().name());
            }
        }
        this._valueTextField.setText(_formatterParserValidator.format(selectInteger.getValue()));
        this._referenceTextField.setText(selectInteger.getReference());
        this._memoryPanel.setDefaultNamedBean(selectInteger.getMemory());
        this._listenToMemoryCheckBox.setSelected(selectInteger.getListenToMemory());
        this._localVariableTextField.setText(selectInteger.getLocalVariable());
        this._formulaTextField.setText(selectInteger.getFormula());
        panel.add(this._tabbedPane);
        return panel;
    }

    public boolean validate(@Nonnull LogixNG_SelectInteger selectInteger, @Nonnull List<String> errorMessages) {
        block12: {
            String result;
            if (this._tabbedPane.getSelectedComponent() == this._panelDirect && (result = selectInteger.getFormatterParserValidator().validate(this._valueTextField.getText())) != null) {
                errorMessages.add(result);
            }
            try {
                if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
                    selectInteger.setReference(this._referenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                selectInteger.setFormula(this._formulaTextField.getText());
                if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
                    selectInteger.setAddressing(NamedBeanAddressing.Direct);
                    break block12;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
                    selectInteger.setAddressing(NamedBeanAddressing.Reference);
                    break block12;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelMemory) {
                    selectInteger.setAddressing(NamedBeanAddressing.Memory);
                    break block12;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelLocalVariable) {
                    selectInteger.setAddressing(NamedBeanAddressing.LocalVariable);
                    break block12;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelFormula) {
                    selectInteger.setAddressing(NamedBeanAddressing.Formula);
                    break block12;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelTable) {
                    selectInteger.setAddressing(NamedBeanAddressing.Table);
                    break block12;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
                return false;
            }
        }
        this._selectTableSwing.validate(selectInteger.getSelectTable(), errorMessages);
        return errorMessages.isEmpty();
    }

    public void updateObject(@Nonnull LogixNG_SelectInteger selectInteger) {
        block9: {
            if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
                selectInteger.setValue(selectInteger.getFormatterParserValidator().parse(this._valueTextField.getText()));
            }
            try {
                if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
                    selectInteger.setAddressing(NamedBeanAddressing.Direct);
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
                    selectInteger.setAddressing(NamedBeanAddressing.Reference);
                    selectInteger.setReference(this._referenceTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelMemory) {
                    selectInteger.setAddressing(NamedBeanAddressing.Memory);
                    selectInteger.setMemory(this._memoryPanel.getNamedBean());
                    selectInteger.setListenToMemory(this._listenToMemoryCheckBox.isSelected());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelLocalVariable) {
                    selectInteger.setAddressing(NamedBeanAddressing.LocalVariable);
                    selectInteger.setLocalVariable(this._localVariableTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelFormula) {
                    selectInteger.setAddressing(NamedBeanAddressing.Formula);
                    selectInteger.setFormula(this._formulaTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelTable) {
                    selectInteger.setAddressing(NamedBeanAddressing.Table);
                    break block9;
                }
                throw new IllegalArgumentException("_tabbedPaneEnum has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
        this._selectTableSwing.updateObject(selectInteger.getSelectTable());
    }

    public void setEnabled(boolean enabled) {
        this._tabbedPane.setEnabled(enabled);
        this._valueTextField.setEnabled(enabled);
        this._referenceTextField.setEnabled(enabled);
        this._memoryPanel.getBeanCombo().setEnabled(enabled);
        this._listenToMemoryCheckBox.setEnabled(enabled);
        this._localVariableTextField.setEnabled(enabled);
        this._formulaTextField.setEnabled(enabled);
        this._selectTableSwing.setEnabled(enabled);
    }

    public void dispose() {
        this._selectTableSwing.dispose();
    }
}

