/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.swing;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.LogixNG_SelectNamedBean;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.swing.Bundle;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectTableSwing;
import jmri.util.swing.BeanSelectPanel;

public class LogixNG_SelectNamedBeanSwing<E extends NamedBean> {
    @Nonnull
    private final Manager<E> _manager;
    private final JDialog _dialog;
    private final LogixNG_SelectTableSwing _selectTableSwing;
    private boolean onlyDirectAddressing = false;
    private JTabbedPane _tabbedPane;
    private BeanSelectPanel<E> _namedBeanPanel;
    private JPanel _panelDirect;
    private JPanel _panelReference;
    private JPanel _panelMemory;
    private JPanel _panelLocalVariable;
    private JPanel _panelFormula;
    private JPanel _panelTable;
    private JTextField _referenceTextField;
    private BeanSelectPanel<Memory> _memoryPanel;
    private JCheckBox _listenToMemoryCheckBox;
    private JTextField _localVariableTextField;
    private JTextField _formulaTextField;

    public LogixNG_SelectNamedBeanSwing(@Nonnull Manager<E> manager, @Nonnull JDialog dialog, @Nonnull SwingConfiguratorInterface swi) {
        this._manager = manager;
        this._dialog = dialog;
        this._selectTableSwing = new LogixNG_SelectTableSwing(this._dialog, swi);
    }

    public JPanel createPanel(@CheckForNull LogixNG_SelectNamedBean<E> selectNamedBean) {
        return this.createPanel(selectNamedBean, null);
    }

    public JPanel createPanel(@CheckForNull LogixNG_SelectNamedBean<E> selectNamedBean, @CheckForNull Predicate<E> filter) {
        this.onlyDirectAddressing = selectNamedBean != null && selectNamedBean.getOnlyDirectAddressingAllowed();
        JPanel panel = new JPanel();
        this._tabbedPane = new JTabbedPane();
        this._panelDirect = new JPanel();
        this._panelReference = new JPanel();
        this._panelMemory = new JPanel();
        this._panelLocalVariable = new JPanel();
        this._panelFormula = new JPanel();
        this._panelTable = selectNamedBean != null ? this._selectTableSwing.createPanel(selectNamedBean.getSelectTable()) : this._selectTableSwing.createPanel(null);
        this._memoryPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._listenToMemoryCheckBox = new JCheckBox(Bundle.getMessage("ListenToMemory"));
        this._panelMemory.setLayout(new BoxLayout(this._panelMemory, 1));
        this._panelMemory.add(this._memoryPanel);
        this._panelMemory.add(this._listenToMemoryCheckBox);
        this._tabbedPane.addTab(NamedBeanAddressing.Direct.toString(), this._panelDirect);
        this._tabbedPane.addTab(NamedBeanAddressing.Reference.toString(), this._panelReference);
        this._tabbedPane.addTab(NamedBeanAddressing.Memory.toString(), this._panelMemory);
        this._tabbedPane.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelLocalVariable);
        this._tabbedPane.addTab(NamedBeanAddressing.Formula.toString(), this._panelFormula);
        this._tabbedPane.addTab(NamedBeanAddressing.Table.toString(), this._panelTable);
        this._namedBeanPanel = new BeanSelectPanel<Object>(this._manager, null, NamedBean.DisplayOptions.DISPLAYNAME, true, filter);
        this._panelDirect.add(this._namedBeanPanel);
        this._referenceTextField = new JTextField();
        this._referenceTextField.setColumns(30);
        this._panelReference.add(this._referenceTextField);
        this._localVariableTextField = new JTextField();
        this._localVariableTextField.setColumns(30);
        this._panelLocalVariable.add(this._localVariableTextField);
        this._formulaTextField = new JTextField();
        this._formulaTextField.setColumns(30);
        this._panelFormula.add(this._formulaTextField);
        if (selectNamedBean != null) {
            switch (selectNamedBean.getAddressing()) {
                case Direct: {
                    this._tabbedPane.setSelectedComponent(this._panelDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPane.setSelectedComponent(this._panelReference);
                    break;
                }
                case Memory: {
                    this._tabbedPane.setSelectedComponent(this._panelMemory);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPane.setSelectedComponent(this._panelLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPane.setSelectedComponent(this._panelFormula);
                    break;
                }
                case Table: {
                    this._tabbedPane.setSelectedComponent(this._panelTable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + selectNamedBean.getAddressing().name());
                }
            }
            if (selectNamedBean.getNamedBean() != null) {
                this._namedBeanPanel.setDefaultNamedBean(selectNamedBean.getNamedBean().getBean());
            }
            this._referenceTextField.setText(selectNamedBean.getReference());
            this._memoryPanel.setDefaultNamedBean(selectNamedBean.getMemory());
            this._listenToMemoryCheckBox.setSelected(selectNamedBean.getListenToMemory());
            this._localVariableTextField.setText(selectNamedBean.getLocalVariable());
            this._formulaTextField.setText(selectNamedBean.getFormula());
        }
        if (!this.onlyDirectAddressing) {
            panel.add(this._tabbedPane);
        } else {
            panel.add(this._panelDirect);
        }
        return panel;
    }

    public boolean validate(@Nonnull LogixNG_SelectNamedBean<E> selectNamedBean, @Nonnull List<String> errorMessages) {
        try {
            if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
                selectNamedBean.setReference(this._referenceTextField.getText());
            }
        }
        catch (IllegalArgumentException e) {
            errorMessages.add(e.getMessage());
            return false;
        }
        try {
            selectNamedBean.setFormula(this._formulaTextField.getText());
            selectNamedBean.setAddressing(this.getAddressing());
        }
        catch (ParserException e) {
            errorMessages.add("Cannot parse formula: " + e.getMessage());
            return false;
        }
        this._selectTableSwing.validate(selectNamedBean.getSelectTable(), errorMessages);
        return errorMessages.isEmpty();
    }

    public void updateObject(@Nonnull LogixNG_SelectNamedBean<E> selectNamedBean) {
        if (this.onlyDirectAddressing || this._tabbedPane.getSelectedComponent() == this._panelDirect) {
            E namedBean = this._namedBeanPanel.getNamedBean();
            if (namedBean != null) {
                NamedBeanHandle<E> handle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(namedBean.getDisplayName(), namedBean);
                selectNamedBean.setNamedBean(handle);
            } else {
                selectNamedBean.removeNamedBean();
            }
        } else {
            selectNamedBean.removeNamedBean();
        }
        try {
            NamedBeanAddressing addressing = this.getAddressing();
            selectNamedBean.setAddressing(addressing);
            switch (addressing) {
                case Direct: {
                    break;
                }
                case Reference: {
                    selectNamedBean.setReference(this._referenceTextField.getText());
                    break;
                }
                case Memory: {
                    if (this._memoryPanel.getNamedBean() != null) {
                        selectNamedBean.setMemory(this._memoryPanel.getNamedBean());
                    }
                    selectNamedBean.setListenToMemory(this._listenToMemoryCheckBox.isSelected());
                    break;
                }
                case LocalVariable: {
                    selectNamedBean.setLocalVariable(this._localVariableTextField.getText());
                    break;
                }
                case Formula: {
                    selectNamedBean.setFormula(this._formulaTextField.getText());
                    break;
                }
                case Table: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown addressing: " + addressing.name());
                }
            }
        }
        catch (ParserException e) {
            throw new RuntimeException("ParserException: " + e.getMessage(), e);
        }
        this._selectTableSwing.updateObject(selectNamedBean.getSelectTable());
    }

    public BeanSelectPanel<E> getBeanSelectPanel() {
        return this._namedBeanPanel;
    }

    public NamedBeanAddressing getAddressing() {
        if (this.onlyDirectAddressing) {
            return NamedBeanAddressing.Direct;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
            return NamedBeanAddressing.Direct;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
            return NamedBeanAddressing.Reference;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelMemory) {
            return NamedBeanAddressing.Memory;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelLocalVariable) {
            return NamedBeanAddressing.LocalVariable;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelFormula) {
            return NamedBeanAddressing.Formula;
        }
        if (this._tabbedPane.getSelectedComponent() == this._panelTable) {
            return NamedBeanAddressing.Table;
        }
        throw new IllegalArgumentException("_tabbedPane has unknown selection");
    }

    public void addAddressingListener(ChangeListener l) {
        this._tabbedPane.addChangeListener(l);
    }

    public void removeAddressingListener(ChangeListener l) {
        this._tabbedPane.removeChangeListener(l);
    }

    public E getBean() {
        if (this.getAddressing() == NamedBeanAddressing.Direct) {
            return this._namedBeanPanel.getNamedBean();
        }
        throw new IllegalArgumentException("Addressing is not Direct");
    }

    public void dispose() {
        if (this._namedBeanPanel != null) {
            this._namedBeanPanel.dispose();
        }
        this._selectTableSwing.dispose();
    }
}

