/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.swing;

import java.io.IOException;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.LogixNG_SelectString;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.swing.Bundle;
import jmri.jmrit.logixng.util.swing.LogixNG_SelectTableSwing;
import jmri.util.FileUtil;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JmriJFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogixNG_SelectStringSwing {
    private final JDialog _dialog;
    private final LogixNG_SelectTableSwing _selectTableSwing;
    private JTabbedPane _tabbedPane;
    private JTextField _valueTextField;
    private JPanel _panelDirect;
    private JPanel _panelReference;
    private JPanel _panelMemory;
    private JPanel _panelLocalVariable;
    private JPanel _panelFormula;
    private JPanel _panelTable;
    private JTextField _referenceTextField;
    private BeanSelectPanel<Memory> _memoryPanel;
    private JCheckBox _listenToMemoryCheckBox;
    private JTextField _localVariableTextField;
    private JTextField _formulaTextField;
    private static final Logger log = LoggerFactory.getLogger(LogixNG_SelectStringSwing.class);

    public LogixNG_SelectStringSwing(@Nonnull JDialog dialog, @Nonnull SwingConfiguratorInterface swi) {
        this._dialog = dialog;
        this._selectTableSwing = new LogixNG_SelectTableSwing(this._dialog, swi);
    }

    public JPanel createPanel(@CheckForNull LogixNG_SelectString selectStr) {
        this._panelDirect = new JPanel();
        this._valueTextField = new JTextField(30);
        this._panelDirect.add(this._valueTextField);
        return this.internalCreatePanel(selectStr);
    }

    public JPanel createFilenamePanel(@CheckForNull LogixNG_SelectString selectStr, String path) {
        this._panelDirect = new JPanel();
        JButton selectFileButton = new JButton("...");
        selectFileButton.setMaximumSize(selectFileButton.getPreferredSize());
        selectFileButton.setToolTipText(Bundle.getMessage("FileButtonHint"));
        selectFileButton.addActionListener(e -> {
            JmriJFileChooser fileChooser = new JmriJFileChooser(path);
            fileChooser.rescanCurrentDirectory();
            int retVal = fileChooser.showOpenDialog(null);
            if (retVal == 0) {
                try {
                    this._valueTextField.setText(FileUtil.getPortableFilename(fileChooser.getSelectedFile().getCanonicalPath()));
                }
                catch (IOException ex) {
                    log.error("exception setting file location", (Throwable)ex);
                    this._valueTextField.setText("");
                }
            }
        });
        this._valueTextField = new JTextField(30);
        this._panelDirect.add(this._valueTextField);
        this._panelDirect.add(selectFileButton);
        return this.internalCreatePanel(selectStr);
    }

    private JPanel internalCreatePanel(@CheckForNull LogixNG_SelectString selectStr) {
        JPanel panel = new JPanel();
        this._tabbedPane = new JTabbedPane();
        this._panelReference = new JPanel();
        this._panelMemory = new JPanel();
        this._panelLocalVariable = new JPanel();
        this._panelFormula = new JPanel();
        if (selectStr != null) {
            this._panelTable = this._selectTableSwing.createPanel(selectStr.getSelectTable());
            if (selectStr.isOnlyDirectAddressingAllowed()) {
                this._tabbedPane.setEnabled(false);
                this._panelReference.setEnabled(false);
                this._panelMemory.setEnabled(false);
                this._panelLocalVariable.setEnabled(false);
                this._panelFormula.setEnabled(false);
            }
        } else {
            this._panelTable = this._selectTableSwing.createPanel(null);
        }
        this._memoryPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(MemoryManager.class), null);
        this._listenToMemoryCheckBox = new JCheckBox(Bundle.getMessage("ListenToMemory"));
        this._panelMemory.setLayout(new BoxLayout(this._panelMemory, 1));
        this._panelMemory.add(this._memoryPanel);
        this._panelMemory.add(this._listenToMemoryCheckBox);
        this._tabbedPane.addTab(NamedBeanAddressing.Direct.toString(), this._panelDirect);
        this._tabbedPane.addTab(NamedBeanAddressing.Reference.toString(), this._panelReference);
        this._tabbedPane.addTab(NamedBeanAddressing.Memory.toString(), this._panelMemory);
        this._tabbedPane.addTab(NamedBeanAddressing.LocalVariable.toString(), this._panelLocalVariable);
        this._tabbedPane.addTab(NamedBeanAddressing.Formula.toString(), this._panelFormula);
        this._tabbedPane.addTab(NamedBeanAddressing.Table.toString(), this._panelTable);
        this._referenceTextField = new JTextField();
        this._referenceTextField.setColumns(30);
        this._panelReference.add(this._referenceTextField);
        this._localVariableTextField = new JTextField();
        this._localVariableTextField.setColumns(30);
        this._panelLocalVariable.add(this._localVariableTextField);
        this._formulaTextField = new JTextField();
        this._formulaTextField.setColumns(30);
        this._panelFormula.add(this._formulaTextField);
        if (selectStr != null) {
            switch (selectStr.getAddressing()) {
                case Direct: {
                    this._tabbedPane.setSelectedComponent(this._panelDirect);
                    break;
                }
                case Reference: {
                    this._tabbedPane.setSelectedComponent(this._panelReference);
                    break;
                }
                case Memory: {
                    this._tabbedPane.setSelectedComponent(this._panelMemory);
                    break;
                }
                case LocalVariable: {
                    this._tabbedPane.setSelectedComponent(this._panelLocalVariable);
                    break;
                }
                case Formula: {
                    this._tabbedPane.setSelectedComponent(this._panelFormula);
                    break;
                }
                case Table: {
                    this._tabbedPane.setSelectedComponent(this._panelTable);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _addressing state: " + selectStr.getAddressing().name());
                }
            }
            if (selectStr.getValue() != null) {
                this._valueTextField.setText(selectStr.getValue());
            }
            this._referenceTextField.setText(selectStr.getReference());
            this._memoryPanel.setDefaultNamedBean(selectStr.getMemory());
            this._listenToMemoryCheckBox.setSelected(selectStr.getListenToMemory());
            this._localVariableTextField.setText(selectStr.getLocalVariable());
            this._formulaTextField.setText(selectStr.getFormula());
        }
        panel.add(this._tabbedPane);
        return panel;
    }

    public boolean validate(@Nonnull LogixNG_SelectString selectStr, @Nonnull List<String> errorMessages) {
        block12: {
            try {
                if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
                    selectStr.setValue(this._valueTextField.getText());
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
                    selectStr.setReference(this._referenceTextField.getText());
                }
            }
            catch (IllegalArgumentException e) {
                errorMessages.add(e.getMessage());
                return false;
            }
            try {
                selectStr.setFormula(this._formulaTextField.getText());
                if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
                    selectStr.setAddressing(NamedBeanAddressing.Direct);
                    break block12;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
                    selectStr.setAddressing(NamedBeanAddressing.Reference);
                    break block12;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelMemory) {
                    selectStr.setAddressing(NamedBeanAddressing.Memory);
                    break block12;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelLocalVariable) {
                    selectStr.setAddressing(NamedBeanAddressing.LocalVariable);
                    break block12;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelFormula) {
                    selectStr.setAddressing(NamedBeanAddressing.Formula);
                    break block12;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelTable) {
                    selectStr.setAddressing(NamedBeanAddressing.Table);
                    break block12;
                }
                throw new IllegalArgumentException("_tabbedPane has unknown selection");
            }
            catch (ParserException e) {
                errorMessages.add("Cannot parse formula: " + e.getMessage());
                return false;
            }
        }
        this._selectTableSwing.validate(selectStr.getSelectTable(), errorMessages);
        return errorMessages.isEmpty();
    }

    public void setEnabled(boolean value) {
        this._tabbedPane.setEnabled(value);
        this._valueTextField.setEnabled(value);
        this._referenceTextField.setEnabled(value);
        this._localVariableTextField.setEnabled(value);
        this._formulaTextField.setEnabled(value);
    }

    public void updateObject(@Nonnull LogixNG_SelectString selectStr) {
        block9: {
            if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
                selectStr.setValue(this._valueTextField.getText());
            }
            try {
                if (this._tabbedPane.getSelectedComponent() == this._panelDirect) {
                    selectStr.setAddressing(NamedBeanAddressing.Direct);
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelReference) {
                    selectStr.setAddressing(NamedBeanAddressing.Reference);
                    selectStr.setReference(this._referenceTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelMemory) {
                    selectStr.setAddressing(NamedBeanAddressing.Memory);
                    selectStr.setMemory(this._memoryPanel.getNamedBean());
                    selectStr.setListenToMemory(this._listenToMemoryCheckBox.isSelected());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelLocalVariable) {
                    selectStr.setAddressing(NamedBeanAddressing.LocalVariable);
                    selectStr.setLocalVariable(this._localVariableTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelFormula) {
                    selectStr.setAddressing(NamedBeanAddressing.Formula);
                    selectStr.setFormula(this._formulaTextField.getText());
                    break block9;
                }
                if (this._tabbedPane.getSelectedComponent() == this._panelTable) {
                    selectStr.setAddressing(NamedBeanAddressing.Table);
                    break block9;
                }
                throw new IllegalArgumentException("_tabbedPaneEnum has unknown selection");
            }
            catch (ParserException e) {
                throw new RuntimeException("ParserException: " + e.getMessage(), e);
            }
        }
        this._selectTableSwing.updateObject(selectStr.getSelectTable());
    }

    public void dispose() {
        this._selectTableSwing.dispose();
    }
}

