/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.logixng.util.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jmri.InstanceManager;
import jmri.jmrit.logixng.NamedBeanAddressing;
import jmri.jmrit.logixng.NamedTable;
import jmri.jmrit.logixng.NamedTableManager;
import jmri.jmrit.logixng.swing.LogixNG_DataDialog;
import jmri.jmrit.logixng.swing.SwingConfiguratorInterface;
import jmri.jmrit.logixng.util.LogixNG_SelectTable;
import jmri.jmrit.logixng.util.parser.ParserException;
import jmri.jmrit.logixng.util.swing.Bundle;
import jmri.util.swing.BeanSelectPanel;
import jmri.util.swing.JmriJOptionPane;

public class LogixNG_SelectTableSwing {
    private final JDialog _dialog;
    private final LogixNG_DataDialog _logixNG_DataDialog;
    private WindowFocusListener _focusListener;
    private JLabel _tableNameLabel;
    private JLabel _rowNameLabel;
    private JLabel _columnNameLabel;
    private JButton _selectTableNameButton;
    private JButton _selectRowNameButton;
    private JButton _selectColumnNameButton;
    private NamedBeanAddressing _tableNameAddressing = NamedBeanAddressing.Direct;
    private BeanSelectPanel<NamedTable> _compareToTableBeanPanel;
    private JTextField _tableNameReferenceTextField;
    private JTextField _tableNameLocalVariableTextField;
    private JTextField _tableNameFormulaTextField;
    private NamedBeanAddressing _tableRowAddressing = NamedBeanAddressing.Direct;
    private JComboBox<String> _tableRowNameComboBox;
    private JTextField _tableRowNameTextField;
    private JTextField _tableRowReferenceTextField;
    private JTextField _tableRowLocalVariableTextField;
    private JTextField _tableRowFormulaTextField;
    private NamedBeanAddressing _tableColumnAddressing = NamedBeanAddressing.Direct;
    private JComboBox<String> _tableColumnNameComboBox;
    private JTextField _tableColumnNameTextField;
    private JTextField _tableColumnReferenceTextField;
    private JTextField _tableColumnLocalVariableTextField;
    private JTextField _tableColumnFormulaTextField;
    private final List<ChangeListener> _changeListeners = new ArrayList<ChangeListener>();

    public LogixNG_SelectTableSwing(@Nonnull JDialog dialog, @Nonnull SwingConfiguratorInterface swi) {
        this._logixNG_DataDialog = new LogixNG_DataDialog(swi);
        this._dialog = dialog;
    }

    private String getTableNameDescription() {
        String namedBean;
        switch (this._tableNameAddressing) {
            case Direct: {
                String tableName = this._compareToTableBeanPanel.getNamedBean() != null ? this._compareToTableBeanPanel.getNamedBean().getDisplayName() : Bundle.getMessage("BeanNotSelected");
                namedBean = Bundle.getMessage("AddressByDirect", tableName);
                break;
            }
            case Reference: {
                namedBean = Bundle.getMessage("AddressByReference", this._tableNameReferenceTextField.getText());
                break;
            }
            case LocalVariable: {
                namedBean = Bundle.getMessage("AddressByLocalVariable", this._tableNameLocalVariableTextField.getText());
                break;
            }
            case Formula: {
                namedBean = Bundle.getMessage("AddressByFormula", this._tableNameFormulaTextField.getText());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _tableNameAddressing: " + this._tableNameAddressing.name());
            }
        }
        return Bundle.getMessage("LogixNG_SelectTableSwing_Table", namedBean);
    }

    private String getTableRowDescription() {
        String row;
        switch (this._tableRowAddressing) {
            case Direct: {
                String rowName = this._tableNameAddressing == NamedBeanAddressing.Direct ? this._tableRowNameComboBox.getItemAt(this._tableRowNameComboBox.getSelectedIndex()) : this._tableRowNameTextField.getText();
                row = Bundle.getMessage("AddressByDirect", rowName);
                break;
            }
            case Reference: {
                row = Bundle.getMessage("AddressByReference", this._tableRowReferenceTextField.getText());
                break;
            }
            case LocalVariable: {
                row = Bundle.getMessage("AddressByLocalVariable", this._tableRowLocalVariableTextField.getText());
                break;
            }
            case Formula: {
                row = Bundle.getMessage("AddressByFormula", this._tableRowFormulaTextField.getText());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _tableRowAddressing: " + this._tableRowAddressing.name());
            }
        }
        return Bundle.getMessage("LogixNG_SelectTableSwing_Row", row);
    }

    private String getTableColumnDescription() {
        String column;
        switch (this._tableColumnAddressing) {
            case Direct: {
                String columnName = this._tableNameAddressing == NamedBeanAddressing.Direct ? this._tableColumnNameComboBox.getItemAt(this._tableColumnNameComboBox.getSelectedIndex()) : this._tableColumnNameTextField.getText();
                column = Bundle.getMessage("AddressByDirect", columnName);
                break;
            }
            case Reference: {
                column = Bundle.getMessage("AddressByReference", this._tableColumnReferenceTextField.getText());
                break;
            }
            case LocalVariable: {
                column = Bundle.getMessage("AddressByLocalVariable", this._tableColumnLocalVariableTextField.getText());
                break;
            }
            case Formula: {
                column = Bundle.getMessage("AddressByFormula", this._tableColumnFormulaTextField.getText());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid _tableRowAddressing: " + this._tableColumnAddressing.name());
            }
        }
        return Bundle.getMessage("LogixNG_SelectTableSwing_Column", column);
    }

    private void selectTableNameFinished() {
        this._tableNameAddressing = this._logixNG_DataDialog.getAddressing();
        this._tableNameLabel.setText(this.getTableNameDescription());
        this.fireChange();
    }

    private void selectTableRowFinished() {
        this._tableRowAddressing = this._logixNG_DataDialog.getAddressing();
        this._rowNameLabel.setText(this.getTableRowDescription());
        this.fireChange();
    }

    private void selectTableColumnFinished() {
        this._tableColumnAddressing = this._logixNG_DataDialog.getAddressing();
        this._columnNameLabel.setText(this.getTableColumnDescription());
        this.fireChange();
    }

    private void setupRowOrColumnNameComboBox(@CheckForNull LogixNG_SelectTable selectTable) {
        String rowName = selectTable != null ? selectTable.getTableRowName() : null;
        String columnName = selectTable != null ? selectTable.getTableColumnName() : null;
        this._tableRowNameComboBox.removeAllItems();
        this._tableColumnNameComboBox.removeAllItems();
        NamedTable table = this._compareToTableBeanPanel.getNamedBean();
        if (table != null) {
            Object header;
            for (int row = 0; row <= table.numRows(); ++row) {
                header = table.getCell(row, 0);
                if (header == null || header.toString().isEmpty()) continue;
                this._tableRowNameComboBox.addItem(header.toString());
            }
            for (int column = 0; column <= table.numColumns(); ++column) {
                header = table.getCell(0, column);
                if (header == null || header.toString().isEmpty()) continue;
                this._tableColumnNameComboBox.addItem(header.toString());
            }
            this._tableRowNameComboBox.setSelectedItem(rowName);
            this._tableColumnNameComboBox.setSelectedItem(columnName);
        }
    }

    public void addChangeListener(ChangeListener l) {
        this._changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._changeListeners.remove(l);
    }

    private void fireChange() {
        for (ChangeListener l : this._changeListeners) {
            l.stateChanged(new ChangeEvent(this));
        }
    }

    public JPanel createPanel(@CheckForNull LogixNG_SelectTable selectTable) {
        this._compareToTableBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(NamedTableManager.class), null);
        this._tableNameLabel = new JLabel();
        this._rowNameLabel = new JLabel();
        this._columnNameLabel = new JLabel();
        this._tableNameAddressing = NamedBeanAddressing.Direct;
        this._compareToTableBeanPanel = new BeanSelectPanel<Object>(InstanceManager.getDefault(NamedTableManager.class), null);
        this._compareToTableBeanPanel.getBeanCombo().addActionListener(evt -> this.setupRowOrColumnNameComboBox(selectTable));
        this._tableRowNameComboBox = new JComboBox();
        this._tableRowNameTextField = new JTextField(30);
        this._tableColumnNameComboBox = new JComboBox();
        this._tableColumnNameTextField = new JTextField(30);
        this._selectTableNameButton = new JButton(Bundle.getMessage("LogixNG_SelectTableSwing_Select"));
        this._selectRowNameButton = new JButton(Bundle.getMessage("LogixNG_SelectTableSwing_Select"));
        this._selectColumnNameButton = new JButton(Bundle.getMessage("LogixNG_SelectTableSwing_Select"));
        this._tableNameReferenceTextField = new JTextField(30);
        this._tableNameLocalVariableTextField = new JTextField(30);
        this._tableNameFormulaTextField = new JTextField(30);
        this._tableRowReferenceTextField = new JTextField(30);
        this._tableRowLocalVariableTextField = new JTextField(30);
        this._tableRowFormulaTextField = new JTextField(30);
        this._tableColumnReferenceTextField = new JTextField(30);
        this._tableColumnLocalVariableTextField = new JTextField(30);
        this._tableColumnFormulaTextField = new JTextField(30);
        this._selectTableNameButton.addActionListener(evt -> this._logixNG_DataDialog.showDialog(Bundle.getMessage("LogixNG_SelectTableSwing_SelectTable"), this._tableNameAddressing, this._compareToTableBeanPanel, this._tableNameReferenceTextField, this._tableNameLocalVariableTextField, this._tableNameFormulaTextField, this::selectTableNameFinished));
        this._selectRowNameButton.addActionListener(evt -> {
            if (this._tableNameAddressing == NamedBeanAddressing.Direct) {
                this._logixNG_DataDialog.showDialog(Bundle.getMessage("LogixNG_SelectTableSwing_SelectRow"), this._tableRowAddressing, this._tableRowNameComboBox, this._tableRowReferenceTextField, this._tableRowLocalVariableTextField, this._tableRowFormulaTextField, this::selectTableRowFinished);
            } else {
                this._logixNG_DataDialog.showDialog(Bundle.getMessage("LogixNG_SelectTableSwing_SelectRow"), this._tableRowAddressing, this._tableRowNameTextField, this._tableRowReferenceTextField, this._tableRowLocalVariableTextField, this._tableRowFormulaTextField, this::selectTableRowFinished);
            }
        });
        this._selectColumnNameButton.addActionListener(evt -> {
            if (this._tableNameAddressing == NamedBeanAddressing.Direct) {
                this._logixNG_DataDialog.showDialog(Bundle.getMessage("LogixNG_SelectTableSwing_SelectColumn"), this._tableColumnAddressing, this._tableColumnNameComboBox, this._tableColumnReferenceTextField, this._tableColumnLocalVariableTextField, this._tableColumnFormulaTextField, this::selectTableColumnFinished);
            } else {
                this._logixNG_DataDialog.showDialog(Bundle.getMessage("LogixNG_SelectTableSwing_SelectColumn"), this._tableColumnAddressing, this._tableColumnNameTextField, this._tableColumnReferenceTextField, this._tableColumnLocalVariableTextField, this._tableColumnFormulaTextField, this::selectTableColumnFinished);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 13;
        panel.add((Component)this._selectTableNameButton, constraints);
        constraints.gridy = 1;
        panel.add((Component)this._selectRowNameButton, constraints);
        constraints.gridy = 2;
        panel.add((Component)this._selectColumnNameButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        panel.add((Component)this._tableNameLabel, constraints);
        constraints.gridy = 1;
        panel.add((Component)this._rowNameLabel, constraints);
        constraints.gridy = 2;
        panel.add((Component)this._columnNameLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        panel.add((Component)new JLabel("  "), constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.anchor = 17;
        panel.add((Component)this._selectTableNameButton, constraints);
        constraints.gridy = 1;
        panel.add((Component)this._selectRowNameButton, constraints);
        constraints.gridy = 2;
        panel.add((Component)this._selectColumnNameButton, constraints);
        if (selectTable != null) {
            this._tableNameAddressing = selectTable.getTableNameAddressing();
            switch (this._tableNameAddressing) {
                case Direct: {
                    if (selectTable.getTable() == null) break;
                    this._compareToTableBeanPanel.setDefaultNamedBean(selectTable.getTable().getBean());
                    break;
                }
                case Reference: {
                    this._tableNameReferenceTextField.setText(selectTable.getTableNameReference());
                    break;
                }
                case LocalVariable: {
                    this._tableNameLocalVariableTextField.setText(selectTable.getTableNameLocalVariable());
                    break;
                }
                case Formula: {
                    this._tableNameFormulaTextField.setText(selectTable.getTableNameFormula());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _tableNameAddressing: " + this._tableNameAddressing.name());
                }
            }
            this._tableRowAddressing = selectTable.getTableRowAddressing();
            switch (this._tableRowAddressing) {
                case Direct: {
                    if (this._tableNameAddressing == NamedBeanAddressing.Direct) {
                        this._tableRowNameComboBox.setSelectedItem(selectTable.getTableRowName());
                        break;
                    }
                    this._tableRowNameTextField.setText(selectTable.getTableRowName());
                    break;
                }
                case Reference: {
                    this._tableRowReferenceTextField.setText(selectTable.getTableRowReference());
                    break;
                }
                case LocalVariable: {
                    this._tableRowLocalVariableTextField.setText(selectTable.getTableRowLocalVariable());
                    break;
                }
                case Formula: {
                    this._tableRowFormulaTextField.setText(selectTable.getTableRowFormula());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _tableRowAddressing: " + this._tableRowAddressing.name());
                }
            }
            this._tableColumnAddressing = selectTable.getTableColumnAddressing();
            switch (this._tableColumnAddressing) {
                case Direct: {
                    if (this._tableNameAddressing == NamedBeanAddressing.Direct) {
                        this._tableColumnNameComboBox.setSelectedItem(selectTable.getTableColumnName());
                        break;
                    }
                    this._tableColumnNameTextField.setText(selectTable.getTableColumnName());
                    break;
                }
                case Reference: {
                    this._tableColumnReferenceTextField.setText(selectTable.getTableColumnReference());
                    break;
                }
                case LocalVariable: {
                    this._tableColumnLocalVariableTextField.setText(selectTable.getTableColumnLocalVariable());
                    break;
                }
                case Formula: {
                    this._tableColumnFormulaTextField.setText(selectTable.getTableColumnFormula());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _tableColumnAddressing: " + this._tableColumnAddressing.name());
                }
            }
        }
        this._tableNameLabel.setText(this.getTableNameDescription());
        this._rowNameLabel.setText(this.getTableRowDescription());
        this._columnNameLabel.setText(this.getTableColumnDescription());
        this._focusListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                LogixNG_SelectTableSwing.this._logixNG_DataDialog.checkOpenDialog();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        };
        this._dialog.addWindowFocusListener(this._focusListener);
        return panel;
    }

    public boolean validate(@Nonnull LogixNG_SelectTable selectTable, @Nonnull List<String> errorMessages) {
        try {
            switch (this._tableNameAddressing) {
                case Direct: {
                    NamedTable table = this._compareToTableBeanPanel.getNamedBean();
                    if (table != null) {
                        selectTable.setTable(table);
                        break;
                    }
                    selectTable.removeTable();
                    break;
                }
                case Reference: {
                    selectTable.setTableNameReference(this._tableNameReferenceTextField.getText());
                    break;
                }
                case LocalVariable: {
                    selectTable.setTableNameLocalVariable(this._tableNameLocalVariableTextField.getText());
                    break;
                }
                case Formula: {
                    selectTable.setTableNameFormula(this._tableNameFormulaTextField.getText());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _tableNameAddressing: " + this._tableNameAddressing.name());
                }
            }
            String rowName = this._tableNameAddressing == NamedBeanAddressing.Direct ? this._tableRowNameComboBox.getItemAt(this._tableRowNameComboBox.getSelectedIndex()) : this._tableRowNameTextField.getText();
            switch (this._tableRowAddressing) {
                case Direct: {
                    selectTable.setTableRowName(rowName);
                    break;
                }
                case Reference: {
                    selectTable.setTableRowReference(this._tableRowReferenceTextField.getText());
                    break;
                }
                case LocalVariable: {
                    selectTable.setTableRowLocalVariable(this._tableRowLocalVariableTextField.getText());
                    break;
                }
                case Formula: {
                    selectTable.setTableRowFormula(this._tableRowFormulaTextField.getText());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _tableRowAddressing: " + this._tableRowAddressing.name());
                }
            }
            String columnName = this._tableNameAddressing == NamedBeanAddressing.Direct ? this._tableColumnNameComboBox.getItemAt(this._tableColumnNameComboBox.getSelectedIndex()) : this._tableColumnNameTextField.getText();
            switch (this._tableColumnAddressing) {
                case Direct: {
                    selectTable.setTableColumnName(columnName);
                    break;
                }
                case Reference: {
                    selectTable.setTableColumnReference(this._tableColumnReferenceTextField.getText());
                    break;
                }
                case LocalVariable: {
                    selectTable.setTableColumnLocalVariable(this._tableColumnLocalVariableTextField.getText());
                    break;
                }
                case Formula: {
                    selectTable.setTableColumnFormula(this._tableColumnFormulaTextField.getText());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _tableColumnAddressing: " + this._tableColumnAddressing.name());
                }
            }
        }
        catch (IllegalArgumentException e) {
            errorMessages.add("Invalid value: " + e.getMessage());
            return false;
        }
        catch (ParserException e) {
            errorMessages.add("Cannot parse formula: " + e.getMessage());
            return false;
        }
        return true;
    }

    public void updateObject(@Nonnull LogixNG_SelectTable selectTable) {
        try {
            selectTable.setTableNameAddressing(this._tableNameAddressing);
            switch (this._tableNameAddressing) {
                case Direct: {
                    NamedTable table = this._compareToTableBeanPanel.getNamedBean();
                    if (table != null) {
                        selectTable.setTable(table);
                        break;
                    }
                    selectTable.removeTable();
                    break;
                }
                case Reference: {
                    selectTable.setTableNameReference(this._tableNameReferenceTextField.getText());
                    break;
                }
                case LocalVariable: {
                    selectTable.setTableNameLocalVariable(this._tableNameLocalVariableTextField.getText());
                    break;
                }
                case Formula: {
                    selectTable.setTableNameFormula(this._tableNameFormulaTextField.getText());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _tableNameAddressing: " + this._tableNameAddressing.name());
                }
            }
            selectTable.setTableRowAddressing(this._tableRowAddressing);
            String rowName = this._tableNameAddressing == NamedBeanAddressing.Direct ? this._tableRowNameComboBox.getItemAt(this._tableRowNameComboBox.getSelectedIndex()) : this._tableRowNameTextField.getText();
            switch (this._tableRowAddressing) {
                case Direct: {
                    selectTable.setTableRowName(rowName);
                    break;
                }
                case Reference: {
                    selectTable.setTableRowReference(this._tableRowReferenceTextField.getText());
                    break;
                }
                case LocalVariable: {
                    selectTable.setTableRowLocalVariable(this._tableRowLocalVariableTextField.getText());
                    break;
                }
                case Formula: {
                    selectTable.setTableRowFormula(this._tableRowFormulaTextField.getText());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _tableRowAddressing: " + this._tableRowAddressing.name());
                }
            }
            selectTable.setTableColumnAddressing(this._tableColumnAddressing);
            String columnName = this._tableNameAddressing == NamedBeanAddressing.Direct ? this._tableColumnNameComboBox.getItemAt(this._tableColumnNameComboBox.getSelectedIndex()) : this._tableColumnNameTextField.getText();
            switch (this._tableColumnAddressing) {
                case Direct: {
                    selectTable.setTableColumnName(columnName);
                    break;
                }
                case Reference: {
                    selectTable.setTableColumnReference(this._tableColumnReferenceTextField.getText());
                    break;
                }
                case LocalVariable: {
                    selectTable.setTableColumnLocalVariable(this._tableColumnLocalVariableTextField.getText());
                    break;
                }
                case Formula: {
                    selectTable.setTableColumnFormula(this._tableColumnFormulaTextField.getText());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid _tableColumnAddressing: " + this._tableColumnAddressing.name());
                }
            }
        }
        catch (ParserException e) {
            throw new RuntimeException("ParserException: " + e.getMessage(), e);
        }
    }

    public String toString() {
        return Bundle.getMessage("LocalVariable_Short");
    }

    public boolean canClose() {
        if (this._logixNG_DataDialog.checkOpenDialog()) {
            JmriJOptionPane.showMessageDialog(this._dialog, Bundle.getMessage("Error_InSelectMode"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
        this._selectTableNameButton.setEnabled(enabled);
        this._selectRowNameButton.setEnabled(enabled);
        this._selectColumnNameButton.setEnabled(enabled);
    }

    public void dispose() {
        this._logixNG_DataDialog.dispose();
        this._dialog.removeWindowFocusListener(this._focusListener);
    }
}

