/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.mailreport;

import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import jmri.Application;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.Version;
import jmri.configurexml.LoadXmlUserAction;
import jmri.jmrit.audio.AudioFactory;
import jmri.jmrit.roster.Roster;
import jmri.jmrix.AbstractSerialPortController;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.util.EarlyInitializationPreferences;
import jmri.util.FileUtil;
import jmri.util.JmriInsets;
import jmri.util.JmriJFrame;
import jmri.util.PortNameMapper;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.util.node.NodeIdentity;
import jmri.util.zeroconf.ZeroConfService;
import jmri.util.zeroconf.ZeroConfServiceManager;

public class ReportContext {
    String report = "";

    public String getReport(boolean reportNetworkInfo) {
        this.addString("JMRI Version: " + Version.name() + "   ");
        this.addEarlyInitializationPreferences();
        this.addString("JMRI configuration file name: " + System.getProperty("org.jmri.apps.Apps.configFilename") + "   (from org.jmri.apps.Apps.configFilename system property)");
        if (!JmriJFrame.getFrameList().isEmpty() && JmriJFrame.getFrameList().get(0) != null) {
            this.addString("JMRI main window name: " + JmriJFrame.getFrameList().get(0).getTitle() + "   ");
        } else {
            this.addString("No main window present");
        }
        this.addString("JMRI Application: " + Application.getApplicationName() + "   ");
        ConnectionConfigManager cm = InstanceManager.getNullableDefault(ConnectionConfigManager.class);
        if (cm != null) {
            ConnectionConfig[] connList = cm.getConnections();
            for (int x = 0; x < connList.length; ++x) {
                ConnectionConfig conn = connList[x];
                this.addString("Connection " + x + ": " + conn.getManufacturer() + " connected via " + conn.name() + " on " + conn.getInfo() + " Disabled " + conn.getDisabled() + "   ");
            }
        } else {
            this.addString("No connections present");
        }
        this.addString("Available Communication Ports:");
        this.addCommunicationPortInfo();
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        if (profile != null) {
            this.addString("Active profile: " + profile.getName() + "   ");
            this.addString("Profile location: " + profile.getPath().getPath() + "   ");
            this.addString("Profile ID: " + profile.getId() + "   ");
        } else {
            this.addString("No active profile");
        }
        this.addString("JMRI Network ID: " + NodeIdentity.networkIdentity());
        this.addString("JMRI Storage ID: " + NodeIdentity.storageIdentity(profile));
        String prefs = FileUtil.getUserFilesPath();
        this.addString("Preferences directory: " + prefs + "   ");
        String prog = System.getProperty("user.dir");
        this.addString("Program directory: " + prog + "   ");
        String roster = Roster.getDefault().getRosterIndexPath();
        this.addString("Roster index location: " + roster + "   ");
        File panel = LoadXmlUserAction.getCurrentFile();
        this.addString("Current panel file: " + (panel == null ? "[none]" : panel.getPath()) + "   ");
        this.addString("Locale: " + InstanceManager.getDefault(GuiLafPreferencesManager.class).getLocale());
        AudioManager am = InstanceManager.getNullableDefault(AudioManager.class);
        AudioFactory af = null;
        if (am != null) {
            af = am.getActiveAudioFactory();
        }
        String audio = af != null ? af.toString() : "[not initialised]";
        this.addString("Audio factory type: " + audio + "   ");
        this.addProperty("java.version");
        this.addProperty("java.vendor");
        this.addProperty("java.home");
        this.addProperty("java.vm.version");
        this.addProperty("java.vm.vendor");
        this.addProperty("java.vm.name");
        this.addProperty("java.specification.version");
        this.addProperty("java.specification.vendor");
        this.addProperty("java.specification.name");
        this.addProperty("java.class.version");
        this.addProperty("java.class.path");
        this.addProperty("java.library.path");
        this.addProperty("java.compiler");
        this.addProperty("java.ext.dirs");
        this.addProperty("file.encoding");
        this.addProperty("os.name");
        this.addProperty("os.arch");
        this.addProperty("os.version");
        this.addProperty("python.home");
        this.addProperty("python.path");
        this.addProperty("python.cachedir");
        this.addProperty("python.cachedir.skip");
        this.addProperty("python.startup");
        this.addProperty("user.name");
        this.addProperty("user.home");
        this.addProperty("user.dir");
        this.addProperty("user.country");
        this.addProperty("user.language");
        this.addProperty("user.timezone");
        this.addProperty("jmri.log.path");
        this.addString("FileSystemView#getDefaultDirectory(): " + FileSystemView.getFileSystemView().getDefaultDirectory().getPath());
        this.addString("FileSystemView#getHomeDirectory(): " + FileSystemView.getFileSystemView().getHomeDirectory().getPath());
        this.addString("Default JFileChooser(): " + new JFileChooser().getCurrentDirectory().getPath());
        this.addScreenSize();
        if (reportNetworkInfo) {
            this.addNetworkInfo();
        }
        return this.report;
    }

    void addString(String val) {
        this.report = this.report + val + "\n";
    }

    void addProperty(String prop) {
        this.addString(prop + ": " + System.getProperty(prop) + "   ");
    }

    void addEarlyInitializationPreferences() {
        EarlyInitializationPreferences eip = EarlyInitializationPreferences.getInstance();
        for (String pref : eip.getStartupPreferences()) {
            this.addString(pref + "   ");
        }
    }

    public void addScreenSize() {
        try {
            Dimension screen;
            JFrame dummy = new JFrame();
            try {
                Insets insets = dummy.getToolkit().getScreenInsets(dummy.getGraphicsConfiguration());
                screen = dummy.getToolkit().getScreenSize();
                this.addString("Screen size h:" + screen.height + ", w:" + screen.width + " Inset t:" + insets.top + ", b:" + insets.bottom + "; l:" + insets.left + ", r:" + insets.right);
            }
            catch (NoSuchMethodError ex) {
                screen = dummy.getToolkit().getScreenSize();
                this.addString("Screen size h:" + screen.height + ", w:" + screen.width + " (No Inset method available)");
            }
        }
        catch (HeadlessException ex) {
            this.addString("(Cannot sense screen size due to " + ex.toString() + ")");
        }
        try {
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            this.addString("Screen resolution: " + dpi);
        }
        catch (HeadlessException ex) {
            this.addString("Screen resolution not available");
        }
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            this.addString("Environment max bounds: " + ge.getMaximumWindowBounds());
            try {
                for (JmriJFrame.ScreenDimensions sd : JmriJFrame.getScreenDimensions()) {
                    this.addString("Device: " + sd.getGraphicsDevice().getIDstring() + " bounds = " + sd.getBounds());
                    this.addString("Device: " + sd.getGraphicsDevice().getIDstring() + " insets = " + sd.getInsets());
                }
            }
            catch (HeadlessException ex) {
                this.addString("Exception getting device bounds " + ex.getMessage());
            }
        }
        catch (HeadlessException ex) {
            this.addString("Exception getting max window bounds " + ex.getMessage());
        }
        try {
            Insets jmriInsets = JmriInsets.getInsets();
            this.addString("JmriInsets t:" + jmriInsets.top + ", b:" + jmriInsets.bottom + "; l:" + jmriInsets.left + ", r:" + jmriInsets.right);
        }
        catch (Exception ex) {
            this.addString("Exception getting JmriInsets " + ex.getMessage());
        }
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf != null) {
            this.addString("Look and Feel: " + laf.getName());
        } else {
            this.addString("null LookAndFeel");
        }
    }

    private void addNetworkInfo() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    String[] inetAddress = inetAddresses.nextElement();
                    String hostAddress = inetAddress.getHostAddress();
                    if (hostAddress.equals("0.0.0.0") || hostAddress.regionMatches(0, "127", 0, 3) || hostAddress.contains(":")) continue;
                    this.addString("Network Interface: " + networkInterface.getName());
                    this.addString(" Long Name: " + networkInterface.getDisplayName());
                    this.addString(" Host Name: " + inetAddress.getHostName());
                    this.addString(" IP address: " + hostAddress);
                }
            }
        }
        catch (SocketException ex) {
            this.addString("Unable to enumerate Network Interfaces");
        }
        Collection<ZeroConfService> services = InstanceManager.getDefault(ZeroConfServiceManager.class).allServices();
        for (InetAddress address : InstanceManager.getDefault(ZeroConfServiceManager.class).getAddresses()) {
            this.addString("ZeroConfService host: " + InstanceManager.getDefault(ZeroConfServiceManager.class).hostName(address) + " running " + services.size() + " service(s)");
        }
        if (!services.isEmpty()) {
            for (ZeroConfService service : services) {
                this.addString("ZeroConfService: " + service.getServiceInfo().getQualifiedName() + "  ");
                this.addString(" Name: " + service.getName() + "   ");
                try {
                    for (String address : service.getServiceInfo().getHostAddresses()) {
                        this.addString(" Address:" + address + "   ");
                    }
                }
                catch (NullPointerException ex) {
                    this.addString(" Address: [unknown due to NPE]");
                }
                this.addString(" Port: " + service.getServiceInfo().getPort() + "   ");
                this.addString(" Server: " + service.getServiceInfo().getServer() + "   ");
                this.addString(" Type: " + service.getType() + "   ");
                try {
                    for (String url : service.getServiceInfo().getURLs()) {
                        this.addString(" URL: " + url + "   ");
                    }
                }
                catch (NullPointerException ex) {
                    this.addString(" URL: [unknown due to NPE]");
                }
                this.addString(" Published: " + (service.isPublished() ? "yes" : "no"));
            }
        }
    }

    private void addCommunicationPortInfo() {
        Vector<String> portNames = AbstractSerialPortController.getActualPortNames();
        this.addString(String.format(" Found %s serial ports", portNames.size()));
        for (String name : portNames) {
            PortNameMapper.SerialPortFriendlyName port = PortNameMapper.getPortNameMap().get(name);
            if (port == null) {
                port = new PortNameMapper.SerialPortFriendlyName(name, null);
                PortNameMapper.getPortNameMap().put(name, port);
            }
            this.addString(" Port: " + name);
        }
    }
}

