/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.nixieclock;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.nixieclock.Bundle;
import jmri.util.JmriJFrame;

public class NixieClockFrame
extends JmriJFrame
implements PropertyChangeListener {
    JLabel h1;
    JLabel h2;
    JLabel m1;
    JLabel m2;
    JLabel colon;
    double aspect;
    double iconAspect;
    int runPauseButtonWidth;
    Timebase clock;
    JButton runPauseButton;
    NamedIcon[] tubes = new NamedIcon[10];
    NamedIcon[] baseTubes = new NamedIcon[10];
    NamedIcon colonIcon;
    NamedIcon baseColon;

    public NixieClockFrame() {
        super(Bundle.getMessage("MenuItemNixieClock"));
        int i;
        this.clock = InstanceManager.getDefault(Timebase.class);
        for (i = 0; i < 10; ++i) {
            this.baseTubes[i] = new NamedIcon("resources/icons/misc/Nixie/M" + i + "B.gif", "resources/icons/misc/Nixie/M" + i + "B.gif");
            this.tubes[i] = new NamedIcon("resources/icons/misc/Nixie/M" + i + "B.gif", "resources/icons/misc/Nixie/M" + i + "B.gif");
        }
        this.colonIcon = new NamedIcon("resources/icons/misc/Nixie/colonB.gif", "resources/icons/misc/Nixie/colonB.gif");
        this.baseColon = new NamedIcon("resources/icons/misc/Nixie/colonB.gif", "resources/icons/misc/Nixie/colonB.gif");
        for (i = 0; i < 10; ++i) {
            Image scaledImage = this.baseTubes[i].getImage().getScaledInstance(23, 32, 4);
            this.tubes[i].setImage(scaledImage);
        }
        Image scaledImage = this.baseColon.getImage().getScaledInstance(12, 32, 4);
        this.colonIcon.setImage(scaledImage);
        this.runPauseButton = new JButton(Bundle.getMessage("ButtonPauseClock"));
        this.runPauseButton.setText(Bundle.getMessage("ButtonPauseClock"));
        this.runPauseButtonWidth = this.runPauseButton.getPreferredSize().width;
        this.iconAspect = 0.75;
        this.aspect = !this.clock.getShowStopButton() ? 3.375 : (108.0 + (double)this.runPauseButtonWidth) / 32.0;
        this.clock.addPropertyChangeListener(this);
        this.m1 = new JLabel(this.tubes[0]);
        this.m2 = new JLabel(this.tubes[0]);
        this.h1 = new JLabel(this.tubes[0]);
        this.h2 = new JLabel(this.tubes[0]);
        this.colon = new JLabel(this.colonIcon);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.getContentPane().add(this.h1);
        this.getContentPane().add(this.h2);
        this.getContentPane().add(this.colon);
        this.getContentPane().add(this.m1);
        this.getContentPane().add(this.m2);
        this.getContentPane().add(this.runPauseButton);
        this.runPauseButton.addActionListener(new ButtonListener());
        this.runPauseButton.setVisible(this.clock.getShowStopButton());
        this.updateButtonText();
        this.update();
        this.pack();
        this.clock.addMinuteChangeListener(e -> this.update());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NixieClockFrame.this.scaleImage();
            }
        });
    }

    public void scaleImage() {
        int iconWidth;
        int iconHeight;
        int frameWidth = this.getContentPane().getSize().width;
        int frameHeight = this.getContentPane().getSize().height;
        if ((double)frameWidth / (double)frameHeight > this.aspect) {
            iconHeight = frameHeight;
            iconWidth = (int)(this.iconAspect * (double)iconHeight);
        } else {
            int workingWidth = frameWidth;
            if (this.clock.getShowStopButton()) {
                workingWidth = frameWidth - this.runPauseButtonWidth;
            }
            iconWidth = (int)((double)workingWidth / 4.5);
            iconHeight = (int)((double)iconWidth / this.iconAspect);
        }
        for (int i = 0; i < 10; ++i) {
            Image scaledImage = this.baseTubes[i].getImage().getScaledInstance(Math.max(1, iconWidth), Math.max(1, iconHeight), 4);
            this.tubes[i].setImage(scaledImage);
        }
        Image scaledImage = this.baseColon.getImage().getScaledInstance(Math.max(1, iconWidth / 2), Math.max(1, iconHeight), 4);
        this.colonIcon.setImage(scaledImage);
        this.getContentPane().revalidate();
    }

    void update() {
        Date now = this.clock.getTime();
        int hours = now.getHours();
        int minutes = now.getMinutes();
        this.h1.setIcon(this.tubes[hours / 10]);
        this.h2.setIcon(this.tubes[hours - hours / 10 * 10]);
        this.m1.setIcon(this.tubes[minutes / 10]);
        this.m2.setIcon(this.tubes[minutes - minutes / 10 * 10]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.updateButtonText();
    }

    private void updateButtonText() {
        this.runPauseButton.setText(Bundle.getMessage(this.clock.getRun() ? "ButtonPauseClock" : "ButtonRunClock"));
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent a) {
            NixieClockFrame.this.clock.setRun(!NixieClockFrame.this.clock.getRun());
            NixieClockFrame.this.updateButtonText();
        }
    }
}

