/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.Bundle;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.gui.CarSetFrame;
import jmri.jmrit.operations.rollingstock.cars.gui.CarsTableFrame;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.gui.EngineSetFrame;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManifestText;
import jmri.jmrit.operations.trains.TrainSwitchListText;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonConductorYardmasterPanel
extends OperationsPanel
implements PropertyChangeListener {
    protected static final boolean IS_MANIFEST = true;
    protected static final String Tab = "    ";
    protected static final String Space = " ";
    protected Location _location = null;
    protected Train _train = null;
    protected TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    protected EngineManager engManager = InstanceManager.getDefault(EngineManager.class);
    protected CarManager carManager = InstanceManager.getDefault(CarManager.class);
    protected TrainCommon trainCommon = new TrainCommon();
    protected JScrollPane locoPane;
    protected JScrollPane pickupPane;
    protected JScrollPane setoutPane;
    protected JScrollPane movePane;
    protected JLabel textRailRoadName = new JLabel();
    protected JLabel textTrainDescription = new JLabel();
    protected JLabel textLocationName = new JLabel();
    protected JLabel textStatus = new JLabel();
    public JButton selectButton = new JButton(Bundle.getMessage("SelectAll"));
    public JButton clearButton = new JButton(Bundle.getMessage("ClearAll"));
    public JButton modifyButton = new JButton(Bundle.getMessage("Modify"));
    public JButton moveButton = new JButton(Bundle.getMessage("Move"));
    protected JTextPane textLocationCommentPane = new JTextPane();
    protected JTextPane textTrainCommentPane = new JTextPane();
    protected JTextPane textTrainRouteCommentPane = new JTextPane();
    protected JTextPane textTrainRouteLocationCommentPane = new JTextPane();
    protected JTextPane textSwitchListCommentPane = new JTextPane();
    protected JTextPane textTrainStatusPane = new JTextPane();
    protected JPanel pRailRoadName = new JPanel();
    protected JPanel pTrainDescription = new JPanel();
    protected JPanel pLocationName = new JPanel();
    protected JPanel pTrackComments = new JPanel();
    protected JPanel pLocos = new JPanel();
    protected JPanel pPickupLocos = new JPanel();
    protected JPanel pSetoutLocos = new JPanel();
    protected JPanel pPickups = new JPanel();
    protected JPanel pSetouts = new JPanel();
    protected JPanel pWorkPanes = new JPanel();
    protected JPanel pMoves = new JPanel();
    protected JPanel pStatus = new JPanel();
    protected JPanel pButtons = new JPanel();
    protected ConcurrentHashMap<String, JCheckBox> checkBoxes = new ConcurrentHashMap();
    protected List<RollingStock> rollingStock = Collections.synchronizedList(new ArrayList());
    protected boolean isSetMode = false;
    CarSetFrame csf = null;
    EngineSetFrame esf = null;
    private static final Logger log = LoggerFactory.getLogger(CommonConductorYardmasterPanel.class);

    public CommonConductorYardmasterPanel() {
        this.initComponents();
    }

    public void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.locoPane = new JScrollPane(this.pLocos);
        this.locoPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Engines")));
        this.pickupPane = new JScrollPane(this.pPickups);
        this.pickupPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Pickup")));
        this.setoutPane = new JScrollPane(this.pSetouts);
        this.setoutPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SetOut")));
        this.movePane = new JScrollPane(this.pMoves);
        this.movePane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LocalMoves")));
        this.pTrackComments.setLayout(new BoxLayout(this.pTrackComments, 1));
        this.pPickupLocos.setLayout(new BoxLayout(this.pPickupLocos, 1));
        this.pSetoutLocos.setLayout(new BoxLayout(this.pSetoutLocos, 1));
        this.pPickups.setLayout(new BoxLayout(this.pPickups, 1));
        this.pSetouts.setLayout(new BoxLayout(this.pSetouts, 1));
        this.pMoves.setLayout(new BoxLayout(this.pMoves, 1));
        this.pRailRoadName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RailroadName")));
        this.pRailRoadName.add(this.textRailRoadName);
        this.pLocationName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        this.pLocationName.add(this.textLocationName);
        this.textLocationCommentPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LocationComment")));
        this.textLocationCommentPane.setBackground(null);
        this.textLocationCommentPane.setEditable(false);
        this.textLocationCommentPane.setMaximumSize(new Dimension(2000, 200));
        this.pTrainDescription.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Description")));
        this.pTrainDescription.add(this.textTrainDescription);
        this.textTrainCommentPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainComment")));
        this.textTrainCommentPane.setBackground(null);
        this.textTrainCommentPane.setEditable(false);
        this.textTrainCommentPane.setMaximumSize(new Dimension(2000, 200));
        this.textTrainRouteCommentPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RouteComment")));
        this.textTrainRouteCommentPane.setBackground(null);
        this.textTrainRouteCommentPane.setEditable(false);
        this.textTrainRouteCommentPane.setMaximumSize(new Dimension(2000, 200));
        this.textTrainRouteLocationCommentPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RouteLocationComment")));
        this.textTrainRouteLocationCommentPane.setBackground(null);
        this.textTrainRouteLocationCommentPane.setEditable(false);
        this.textTrainRouteLocationCommentPane.setMaximumSize(new Dimension(2000, 200));
        this.textSwitchListCommentPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        this.textSwitchListCommentPane.setBackground(null);
        this.textSwitchListCommentPane.setEditable(false);
        this.textSwitchListCommentPane.setMaximumSize(new Dimension(2000, 200));
        this.textTrainStatusPane.setBorder(BorderFactory.createTitledBorder(""));
        this.textTrainStatusPane.setBackground(null);
        this.textTrainStatusPane.setEditable(false);
        this.textTrainStatusPane.setMaximumSize(new Dimension(2000, 200));
        this.pLocos.setLayout(new BoxLayout(this.pLocos, 1));
        this.pWorkPanes.setLayout(new BoxLayout(this.pWorkPanes, 1));
        this.pLocos.add(this.pPickupLocos);
        this.pLocos.add(this.pSetoutLocos);
        this.pWorkPanes.add(this.pickupPane);
        this.pWorkPanes.add(this.setoutPane);
        this.pStatus.setLayout(new GridBagLayout());
        this.pStatus.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(this.pStatus, this.textStatus, 0, 0);
        this.pButtons.setLayout(new GridBagLayout());
        this.pButtons.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Work")));
        this.addItem(this.pButtons, this.selectButton, 0, 0);
        this.addItem(this.pButtons, this.clearButton, 1, 0);
        this.addItem(this.pButtons, this.modifyButton, 2, 0);
        this.addButtonAction(this.selectButton);
        this.addButtonAction(this.clearButton);
        this.addButtonAction(this.modifyButton);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.selectButton) {
            this.selectCheckboxes(true);
        }
        if (ae.getSource() == this.clearButton) {
            this.selectCheckboxes(false);
        }
        if (ae.getSource() == this.modifyButton) {
            this.isSetMode = !this.isSetMode;
            this.update();
            if (this.isSetMode) {
                this.addCarToTrain();
            }
        }
        this.check();
    }

    protected void initialize() {
        this.removePropertyChangeListerners();
        this.pTrackComments.removeAll();
        this.pPickupLocos.removeAll();
        this.pSetoutLocos.removeAll();
        this.pPickups.removeAll();
        this.pSetouts.removeAll();
        this.pMoves.removeAll();
        this.pWorkPanes.setVisible(false);
        this.pickupPane.setVisible(false);
        this.setoutPane.setVisible(false);
        this.locoPane.setVisible(false);
        this.pPickupLocos.setVisible(false);
        this.pSetoutLocos.setVisible(false);
        this.movePane.setVisible(false);
        this.textTrainRouteLocationCommentPane.setVisible(false);
        this.setModifyButtonText();
    }

    protected void updateComplete() {
        this.pTrackComments.repaint();
        this.pPickupLocos.repaint();
        this.pSetoutLocos.repaint();
        this.pPickups.repaint();
        this.pSetouts.repaint();
        this.pMoves.repaint();
        this.pTrackComments.revalidate();
        this.pPickupLocos.revalidate();
        this.pSetoutLocos.revalidate();
        this.pPickups.revalidate();
        this.pSetouts.revalidate();
        this.pMoves.revalidate();
        this.selectButton.setEnabled(!this.checkBoxes.isEmpty() && !this.isSetMode);
        this.clearButton.setEnabled(!this.checkBoxes.isEmpty() && !this.isSetMode);
        this.check();
        log.debug("update complete");
    }

    private void addCarToTrain() {
        if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("WantAddCarsToTrain?", this._train.getName()), Bundle.getMessage("AddCarsToTrain?"), 0) == 0) {
            new CarsTableFrame(false, this._train.getCurrentRouteLocation().getName(), null);
        }
    }

    public void carSetButtonActionPerfomed(ActionEvent ae) {
        String name = ((JButton)ae.getSource()).getName();
        log.debug("Set button for car {}", (Object)name);
        Car car = (Car)this.carManager.getById(name);
        if (this.csf != null) {
            this.csf.dispose();
        }
        this.csf = new CarSetFrame();
        this.csf.initComponents();
        this.csf.load(car);
    }

    public void engineSetButtonActionPerfomed(ActionEvent ae) {
        String name = ((JButton)ae.getSource()).getName();
        log.debug("Set button for loco {}", (Object)name);
        Engine eng = (Engine)this.engManager.getById(name);
        if (this.esf != null) {
            this.esf.dispose();
        }
        this.esf = new EngineSetFrame();
        this.esf.initComponents();
        this.esf.load(eng);
    }

    @Override
    protected void checkBoxActionPerformed(ActionEvent ae) {
        this.check();
    }

    protected void check() {
        Enumeration<JCheckBox> en = this.checkBoxes.elements();
        while (en.hasMoreElements()) {
            JCheckBox checkBox = en.nextElement();
            if (checkBox.isSelected()) continue;
            this.moveButton.setEnabled(false);
            this.modifyButton.setEnabled(true);
            return;
        }
        this.moveButton.setEnabled(this._train != null && this._train.isBuilt());
        this.modifyButton.setEnabled(false);
        this.isSetMode = false;
        this.setModifyButtonText();
    }

    protected void selectCheckboxes(boolean enable) {
        Enumeration<JCheckBox> en = this.checkBoxes.elements();
        while (en.hasMoreElements()) {
            JCheckBox checkBox = en.nextElement();
            checkBox.setSelected(enable);
        }
        this.isSetMode = false;
    }

    protected void loadTrainDescription() {
        this.textTrainDescription.setText(TrainCommon.getTextColorString(this._train.getDescription()));
        this.textTrainDescription.setForeground(TrainCommon.getTextColor(this._train.getDescription()));
    }

    protected void loadTrainComment() {
        if (this._train.getComment().equals("")) {
            this.textTrainCommentPane.setVisible(false);
        } else {
            this.textTrainCommentPane.setVisible(true);
            this.textTrainCommentPane.setText(this._train.getComment());
            this.textTrainCommentPane.setForeground(TrainCommon.getTextColor(this._train.getCommentWithColor()));
        }
    }

    protected void loadRailroadName() {
        if (!this._train.getRailroadName().equals("")) {
            this.textRailRoadName.setText(TrainCommon.getTextColorString(this._train.getRailroadName()));
            this.textRailRoadName.setForeground(TrainCommon.getTextColor(this._train.getRailroadName()));
        } else {
            this.textRailRoadName.setText(Setup.getRailroadName());
        }
    }

    protected void loadLocationComment(Location location) {
        this.textLocationCommentPane.setVisible(!location.getComment().isEmpty() && Setup.isPrintLocationCommentsEnabled());
        if (this.textLocationCommentPane.isVisible()) {
            this.textLocationCommentPane.setText(location.getComment());
            this.textLocationCommentPane.setForeground(TrainCommon.getTextColor(location.getCommentWithColor()));
        }
    }

    protected void loadLocationSwitchListComment(Location location) {
        this.textSwitchListCommentPane.setVisible(!location.getSwitchListComment().isEmpty());
        if (this.textSwitchListCommentPane.isVisible()) {
            this.textSwitchListCommentPane.setText(location.getSwitchListComment());
            this.textSwitchListCommentPane.setForeground(TrainCommon.getTextColor(location.getSwitchListCommentWithColor()));
        }
    }

    protected void loadRouteComment() {
        if (this._train.getRoute() != null && this._train.getRoute().getComment().equals("") || !Setup.isPrintRouteCommentsEnabled()) {
            this.textTrainRouteCommentPane.setVisible(false);
        } else {
            this.textTrainRouteCommentPane.setVisible(true);
            this.textTrainRouteCommentPane.setText(TrainCommon.getTextColorString(this._train.getRoute().getComment()));
            this.textTrainRouteCommentPane.setForeground(TrainCommon.getTextColor(this._train.getRoute().getComment()));
        }
    }

    protected void loadRouteLocationComment(RouteLocation rl) {
        this.textTrainRouteLocationCommentPane.setVisible(!rl.getComment().equals(""));
        if (this.textTrainRouteLocationCommentPane.isVisible()) {
            this.textTrainRouteLocationCommentPane.setText(rl.getComment());
            this.textTrainRouteLocationCommentPane.setForeground(rl.getCommentColor());
        }
    }

    protected void updateTrackComments(RouteLocation rl, boolean isManifest) {
        Location location = rl.getLocation();
        if (location != null) {
            List<Track> tracks = location.getTracksByNameList(null);
            for (Track track : tracks) {
                if (isManifest && !track.isPrintManifestCommentEnabled() || !isManifest && !track.isPrintSwitchListCommentEnabled()) continue;
                boolean pickup = false;
                boolean setout = false;
                List<Car> carList = this.carManager.getByTrainDestinationList(this._train);
                for (Car car : carList) {
                    if (car.getRouteLocation() == rl && car.getTrack() != null && car.getTrack() == track) {
                        pickup = true;
                    }
                    if (car.getRouteDestination() != rl || car.getDestinationTrack() == null || car.getDestinationTrack() != track) continue;
                    setout = true;
                }
                if (!pickup && !setout) continue;
                JTextPane commentTextPane = new JTextPane();
                if (pickup && setout && !track.getCommentBoth().equals("")) {
                    commentTextPane.setText(track.getCommentBoth());
                    commentTextPane.setForeground(TrainCommon.getTextColor(track.getCommentBothWithColor()));
                } else if (pickup && !setout && !track.getCommentPickup().equals("")) {
                    commentTextPane.setText(track.getCommentPickup());
                    commentTextPane.setForeground(TrainCommon.getTextColor(track.getCommentPickupWithColor()));
                } else if (!pickup && setout && !track.getCommentSetout().equals("")) {
                    commentTextPane.setText(track.getCommentSetout());
                    commentTextPane.setForeground(TrainCommon.getTextColor(track.getCommentSetoutWithColor()));
                }
                if (commentTextPane.getText().isEmpty()) continue;
                commentTextPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment") + Space + track.getName()));
                commentTextPane.setBackground(null);
                commentTextPane.setEditable(false);
                commentTextPane.setMaximumSize(new Dimension(2000, 200));
                this.pTrackComments.add(commentTextPane);
                this.pTrackComments.setVisible(true);
            }
        }
    }

    protected void updateLocoPanes(RouteLocation rl) {
        if (Setup.isPrintHeadersEnabled()) {
            JLabel header = new JLabel(Tab + this.trainCommon.getPickupEngineHeader());
            this.setLabelFont(header);
            this.pPickupLocos.add(header);
            JLabel headerDrop = new JLabel(Tab + this.trainCommon.getDropEngineHeader());
            this.setLabelFont(headerDrop);
            this.pSetoutLocos.add(headerDrop);
        }
        List<Engine> engList = this.engManager.getByTrainBlockingList(this._train);
        for (Engine engine : engList) {
            JCheckBox checkBox;
            if (engine.getRouteLocation() == rl && engine.getTrack() != null) {
                this.locoPane.setVisible(true);
                this.pPickupLocos.setVisible(true);
                this.rollingStock.add(engine);
                engine.addPropertyChangeListener(this);
                if (this.checkBoxes.containsKey("ep" + engine.getId())) {
                    checkBox = this.checkBoxes.get("ep" + engine.getId());
                } else {
                    checkBox = new JCheckBox(this.trainCommon.pickupEngine(engine));
                    this.setCheckBoxFont(checkBox, Setup.getPickupEngineColor());
                    this.addCheckBoxAction(checkBox);
                    this.checkBoxes.put("ep" + engine.getId(), checkBox);
                }
                if (this.isSetMode && !checkBox.isSelected()) {
                    this.pPickupLocos.add(this.addSet(engine));
                } else {
                    this.pPickupLocos.add(checkBox);
                }
            }
            if (engine.getRouteDestination() != rl) continue;
            this.locoPane.setVisible(true);
            this.pSetoutLocos.setVisible(true);
            this.rollingStock.add(engine);
            engine.addPropertyChangeListener(this);
            if (this.checkBoxes.containsKey("es" + engine.getId())) {
                checkBox = this.checkBoxes.get("es" + engine.getId());
            } else {
                checkBox = new JCheckBox(this.trainCommon.dropEngine(engine));
                this.setCheckBoxFont(checkBox, Setup.getDropEngineColor());
                this.addCheckBoxAction(checkBox);
                this.checkBoxes.put("es" + engine.getId(), checkBox);
            }
            if (this.isSetMode && !checkBox.isSelected()) {
                this.pSetoutLocos.add(this.addSet(engine));
                continue;
            }
            this.pSetoutLocos.add(checkBox);
        }
        this.pPickupLocos.add(new JLabel(Space));
        this.pSetoutLocos.add(new JLabel(Space));
    }

    protected void blockCars(RouteLocation rl, boolean isManifest) {
        if (Setup.isPrintHeadersEnabled()) {
            JLabel header = new JLabel(Tab + this.trainCommon.getPickupCarHeader(isManifest, false));
            this.setLabelFont(header);
            this.pPickups.add(header);
            header = new JLabel(Tab + this.trainCommon.getDropCarHeader(isManifest, false));
            this.setLabelFont(header);
            this.pSetouts.add(header);
            header = new JLabel(Tab + this.trainCommon.getLocalMoveHeader(isManifest));
            this.setLabelFont(header);
            this.pMoves.add(header);
        }
        List<Track> tracks = rl.getLocation().getTracksByNameList(null);
        List<RouteLocation> routeList = this._train.getRoute().getBlockingOrder();
        List<Car> carList = this.carManager.getByTrainDestinationList(this._train);
        ArrayList<Car> carsDone = new ArrayList<Car>();
        for (Track track : tracks) {
            for (RouteLocation rld : routeList) {
                for (Car car : carList) {
                    if (carsDone.contains(car) || car.getTrack() == null || car.isLocalMove() && rl == rld || Setup.isSortByTrackNameEnabled() && !car.getTrack().getSplitName().equals(track.getSplitName()) || !TrainCommon.isNextCar(car, rl, rld)) continue;
                    this.pWorkPanes.setVisible(true);
                    this.pickupPane.setVisible(true);
                    if (!this.rollingStock.contains(car)) {
                        this.rollingStock.add(car);
                        car.addPropertyChangeListener(this);
                    }
                    if (this.checkBoxes.containsKey("p" + car.getId())) {
                        if (this.isSetMode && !this.checkBoxes.get("p" + car.getId()).isSelected()) {
                            this.pPickups.add(this.addSet(car));
                        } else {
                            this.pPickups.add(this.checkBoxes.get("p" + car.getId()));
                        }
                    } else {
                        String text;
                        if (car.isUtility()) {
                            text = this.trainCommon.pickupUtilityCars(carList, car, isManifest, false);
                            if (text == null) {
                                continue;
                            }
                        } else {
                            text = this.trainCommon.pickupCar(car, isManifest, false);
                        }
                        JCheckBox checkBox = new JCheckBox(text);
                        this.setCheckBoxFont(checkBox, Setup.getPickupColor());
                        this.addCheckBoxAction(checkBox);
                        this.pPickups.add(checkBox);
                        this.checkBoxes.put("p" + car.getId(), checkBox);
                    }
                    carsDone.add(car);
                }
            }
            for (Car car : carList) {
                JCheckBox checkBox;
                String text;
                if (carsDone.contains(car) || car.getRouteDestination() != rl || car.getDestinationTrack() == null) continue;
                if (car.getTrack() == null || car.getTrack() != null && car.getRouteLocation() != rl) {
                    if (Setup.isSortByTrackNameEnabled() && !car.getDestinationTrack().getName().equals(track.getName())) continue;
                    this.pWorkPanes.setVisible(true);
                    this.setoutPane.setVisible(true);
                    if (!this.rollingStock.contains(car)) {
                        this.rollingStock.add(car);
                        car.addPropertyChangeListener(this);
                    }
                    if (this.checkBoxes.containsKey("s" + car.getId())) {
                        if (this.isSetMode && !this.checkBoxes.get("s" + car.getId()).isSelected()) {
                            this.pSetouts.add(this.addSet(car));
                            continue;
                        }
                        this.pSetouts.add(this.checkBoxes.get("s" + car.getId()));
                        continue;
                    }
                    if (car.isUtility()) {
                        text = this.trainCommon.setoutUtilityCars(carList, car, false, isManifest);
                        if (text == null) {
                            continue;
                        }
                    } else {
                        text = this.trainCommon.dropCar(car, isManifest, false);
                    }
                    checkBox = new JCheckBox(text);
                    this.setCheckBoxFont(checkBox, Setup.getDropColor());
                    this.addCheckBoxAction(checkBox);
                    this.pSetouts.add(checkBox);
                    this.checkBoxes.put("s" + car.getId(), checkBox);
                    continue;
                }
                if (car.getTrack() == null || car.getRouteLocation() != rl || Setup.isSortByTrackNameEnabled() && !car.getTrack().getSplitName().equals(track.getSplitName())) continue;
                this.movePane.setVisible(true);
                if (!this.rollingStock.contains(car)) {
                    this.rollingStock.add(car);
                    car.addPropertyChangeListener(this);
                }
                if (this.checkBoxes.containsKey("m" + car.getId())) {
                    if (this.isSetMode && !this.checkBoxes.get("m" + car.getId()).isSelected()) {
                        this.pMoves.add(this.addSet(car));
                    } else {
                        this.pMoves.add(this.checkBoxes.get("m" + car.getId()));
                    }
                } else {
                    if (car.isUtility()) {
                        text = this.trainCommon.setoutUtilityCars(carList, car, true, isManifest);
                        if (text == null) {
                            continue;
                        }
                    } else {
                        text = this.trainCommon.localMoveCar(car, isManifest);
                    }
                    checkBox = new JCheckBox(text);
                    this.setCheckBoxFont(checkBox, Setup.getLocalColor());
                    this.addCheckBoxAction(checkBox);
                    this.pMoves.add(checkBox);
                    this.checkBoxes.put("m" + car.getId(), checkBox);
                }
                carsDone.add(car);
            }
            if (Setup.isSortByTrackNameEnabled()) continue;
            break;
        }
        this.pPickups.add(new JLabel(Space));
        this.pSetouts.add(new JLabel(Space));
        this.pMoves.add(new JLabel(Space));
    }

    protected JPanel addSet(RollingStock rs) {
        JPanel pSet = new JPanel();
        pSet.setLayout(new GridBagLayout());
        JButton setButton = new JButton(Bundle.getMessage("Set"));
        setButton.setToolTipText(Bundle.getMessage("SetButtonToolTip"));
        setButton.setName(rs.getId());
        setButton.addActionListener(e -> {
            if (Car.class.isInstance(rs)) {
                this.carSetButtonActionPerfomed(e);
            } else {
                this.engineSetButtonActionPerfomed(e);
            }
        });
        JLabel label = new JLabel(TrainCommon.padString(rs.toString(), Control.max_len_string_attibute + Control.max_len_string_road_number));
        this.setLabelFont(label);
        this.addItem(pSet, label, 0, 0);
        this.addItemLeft(pSet, setButton, 1, 0);
        pSet.setAlignmentX(0.0f);
        return pSet;
    }

    protected void setCheckBoxFont(JCheckBox checkBox, Color color) {
        if (Setup.isTabEnabled()) {
            Font font = new Font(Setup.getFontName(), 0, checkBox.getFont().getSize());
            checkBox.setFont(font);
            checkBox.setForeground(color);
        }
    }

    protected void setLabelFont(JLabel label) {
        if (Setup.isTabEnabled()) {
            Font font = new Font(Setup.getFontName(), 0, label.getFont().getSize());
            label.setFont(font);
        }
    }

    protected void setModifyButtonText() {
        if (this.isSetMode) {
            this.modifyButton.setText(Bundle.getMessage("Done"));
        } else {
            this.modifyButton.setText(Bundle.getMessage("Modify"));
        }
    }

    protected String getStatus(RouteLocation rl, boolean isManifest) {
        if (rl == this._train.getTrainTerminatesRouteLocation()) {
            return MessageFormat.format(TrainManifestText.getStringTrainTerminates(), this._train.getTrainTerminatesName());
        }
        if (rl != this._train.getCurrentRouteLocation() && this._train.getExpectedArrivalTime(rl).equals("-1")) {
            return MessageFormat.format(TrainSwitchListText.getStringTrainDone(), this._train.getName());
        }
        if (!this._train.isBuilt() || rl == null) {
            return this._train.getStatus();
        }
        if (Setup.isPrintLoadsAndEmptiesEnabled()) {
            int emptyCars = this._train.getNumberEmptyCarsInTrain(rl);
            String text = isManifest ? TrainManifestText.getStringTrainDepartsLoads() : TrainSwitchListText.getStringTrainDepartsLoads();
            return MessageFormat.format(text, rl.getSplitName(), rl.getTrainDirectionString(), this._train.getNumberCarsInTrain(rl) - emptyCars, emptyCars, this._train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), this._train.getTrainWeight(rl), this._train.getTrainTerminatesName(), this._train.getName());
        }
        String text = isManifest ? TrainManifestText.getStringTrainDepartsCars() : TrainSwitchListText.getStringTrainDepartsCars();
        return MessageFormat.format(text, rl.getSplitName(), rl.getTrainDirectionString(), this._train.getNumberCarsInTrain(rl), this._train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), this._train.getTrainWeight(rl), this._train.getTrainTerminatesName(), this._train.getName());
    }

    protected void removeCarFromList(Car car) {
        this.checkBoxes.remove("p" + car.getId());
        this.checkBoxes.remove("s" + car.getId());
        this.checkBoxes.remove("m" + car.getId());
        log.debug("Car ({}) removed from list", (Object)car.toString());
        if (car.isUtility()) {
            this.clearAndUpdate();
        }
    }

    protected void clearAndUpdate() {
        this.trainCommon.clearUtilityCarTypes();
        this.checkBoxes.clear();
        this.isSetMode = false;
        this.update();
    }

    protected abstract void update();

    protected void removePropertyChangeListerners() {
        this.rollingStock.stream().forEach(rs -> rs.removePropertyChangeListener(this));
        this.rollingStock.clear();
    }

    @Override
    public void dispose() {
        this._train = null;
        this._location = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change {} for: {} old: {} new: {}", new Object[]{e.getPropertyName(), e.getSource(), e.getOldValue(), e.getNewValue()});
    }
}

