/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.automation.AutomationItem;
import jmri.jmrit.operations.automation.actions.Action;
import jmri.jmrit.operations.automation.actions.HaltAction;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.util.ThreadingUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Automation
extends PropertyChangeSupport
implements PropertyChangeListener {
    protected String _id = "";
    protected String _name = "";
    protected String _comment = "";
    protected AutomationItem _currentAutomationItem = null;
    protected AutomationItem _lastAutomationItem = null;
    protected AutomationItem _gotoAutomationItem = null;
    protected boolean _running = false;
    protected HashMap<String, AutomationItem> _automationHashTable = new HashMap();
    protected int _IdNumber = 0;
    public static final String REGEX = "c";
    public static final String LISTCHANGE_CHANGED_PROPERTY = "automationListChange";
    public static final String CURRENT_ITEM_CHANGED_PROPERTY = "automationCurrentItemChange";
    public static final String RUNNING_CHANGED_PROPERTY = "automationRunningChange";
    public static final String DISPOSE = "automationDispose";
    private static final Logger log = LoggerFactory.getLogger(Automation.class);

    public Automation(String id, String name) {
        log.debug("New automation ({}) id: {}", (Object)name, (Object)id);
        this._name = name;
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        String old = this._name;
        this._name = name;
        if (!old.equals(name)) {
            this.setDirtyAndFirePropertyChange("AutomationName", old, name);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this._name;
    }

    public int getSize() {
        return this._automationHashTable.size();
    }

    public void setComment(String comment) {
        String old = this._comment;
        this._comment = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange("AutomationComment", old, comment);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public String getCurrentActionString() {
        if (this.getCurrentAutomationItem() != null && this.getCurrentAutomationItem().getAction() != null) {
            return this.getCurrentAutomationItem().getId() + " " + this.getCurrentAutomationItem().getAction().getActionString();
        }
        return "";
    }

    public String getActionStatus() {
        if (this.getCurrentAutomationItem() != null) {
            return this.getCurrentAutomationItem().getStatus();
        }
        return "";
    }

    public String getMessage() {
        if (this.getCurrentAutomationItem() != null && this.getCurrentAutomationItem().getAction() != null) {
            return this.getCurrentAutomationItem().getAction().getFormatedMessage(this.getCurrentAutomationItem().getMessage());
        }
        return "";
    }

    public void setRunning(boolean running) {
        boolean old = this._running;
        this._running = running;
        if (old != running) {
            this.firePropertyChange(RUNNING_CHANGED_PROPERTY, old, running);
        }
    }

    public boolean isRunning() {
        return this._running;
    }

    public boolean isActionRunning() {
        for (AutomationItem item : this.getItemsBySequenceList()) {
            if (!item.isActionRunning()) continue;
            return true;
        }
        return false;
    }

    public boolean isReadyToRun() {
        return this.getSize() > 0 && this.getCurrentAutomationItem() == this.getItemsBySequenceList().get(0);
    }

    public void run() {
        if (this.getSize() > 0) {
            log.debug("run automation ({})", (Object)this.getName());
            this._gotoAutomationItem = null;
            this.setCurrentAutomationItem(this.getItemsBySequenceList().get(0));
            this.setRunning(true);
            this.step();
        }
    }

    public void step() {
        log.debug("step automation ({})", (Object)this.getName());
        if (this.getCurrentAutomationItem() != null && this.getCurrentAutomationItem().getAction() != null) {
            if (this.getCurrentAutomationItem().getAction().getClass().equals(HaltAction.class) && this.getCurrentAutomationItem().isActionRan() && this.getCurrentAutomationItem() != this.getItemsBySequenceList().get(0)) {
                this.setNextAutomationItem();
            }
            if (this.getCurrentAutomationItem() == this.getItemsBySequenceList().get(0)) {
                this.resetAutomationItems();
            }
            this.performAction(this.getCurrentAutomationItem());
        }
    }

    private void performAction(AutomationItem item) {
        if (item.isActionRunning()) {
            log.debug("Action ({}) item id: {} already running", (Object)item.getAction().getName(), (Object)item.getId());
        } else {
            log.debug("Perform action ({}) item id: {}", (Object)item.getAction().getName(), (Object)item.getId());
            item.getAction().removePropertyChangeListener(this);
            item.getAction().addPropertyChangeListener(this);
            Thread runAction = ThreadingUtil.newThread(() -> item.getAction().doAction());
            runAction.setName("Run action item: " + item.getId());
            runAction.start();
        }
    }

    public void stop() {
        log.debug("stop automation ({})", (Object)this.getName());
        if (this.getCurrentAutomationItem() != null && this.getCurrentAutomationItem().getAction() != null) {
            this.setRunning(false);
            this.cancelActions();
        }
    }

    private void cancelActions() {
        for (AutomationItem item : this.getItemsBySequenceList()) {
            item.getAction().cancelAction();
        }
    }

    public void resume() {
        if (this.getSize() > 0) {
            log.debug("resume automation ({})", (Object)this.getName());
            this.setRunning(true);
            this.step();
        }
    }

    public void reset() {
        this.stop();
        if (this.getSize() > 0) {
            this.setCurrentAutomationItem(this.getItemsBySequenceList().get(0));
            this.resetAutomationItems();
        }
    }

    private void resetAutomationItems() {
        this.resetAutomationItems(this.getCurrentAutomationItem());
    }

    public void resetAutomationItems(AutomationItem item) {
        boolean found = false;
        for (AutomationItem automationItem : this.getItemsBySequenceList()) {
            if (!found && automationItem != item) continue;
            found = true;
            automationItem.reset();
        }
    }

    public void setNextAutomationItem() {
        log.debug("set next automation ({})", (Object)this.getName());
        if (this.getSize() > 0) {
            if (this._gotoAutomationItem != null) {
                this.getCurrentAutomationItem().setGotoBranched(true);
                this.setCurrentAutomationItem(this._gotoAutomationItem);
                this.resetAutomationItems(this._gotoAutomationItem);
                this._gotoAutomationItem = null;
                return;
            }
            List<AutomationItem> items = this.getItemsBySequenceList();
            for (int index = 0; index < items.size(); ++index) {
                AutomationItem item = items.get(index);
                if (item != this.getCurrentAutomationItem()) continue;
                if (index + 1 < items.size()) {
                    item = items.get(index + 1);
                    this.setCurrentAutomationItem(item);
                    if (item.isActionRan()) {
                        continue;
                    }
                } else {
                    this.setCurrentAutomationItem(this.getItemsBySequenceList().get(0));
                    this.setRunning(false);
                }
                return;
            }
        }
        this.setCurrentAutomationItem(null);
    }

    private AutomationItem getNextAutomationItem(AutomationItem item) {
        List<AutomationItem> items = this.getItemsBySequenceList();
        for (int index = 0; index < items.size(); ++index) {
            if (item != items.get(index)) continue;
            if (index + 1 >= items.size()) break;
            return items.get(index + 1);
        }
        return null;
    }

    public void setCurrentAutomationItem(AutomationItem item) {
        this._lastAutomationItem = this._currentAutomationItem;
        this._currentAutomationItem = item;
        if (this._lastAutomationItem != item) {
            this.setDirtyAndFirePropertyChange(CURRENT_ITEM_CHANGED_PROPERTY, this._lastAutomationItem, item);
        }
    }

    public AutomationItem getCurrentAutomationItem() {
        return this._currentAutomationItem;
    }

    public AutomationItem getLastAutomationItem() {
        return this._lastAutomationItem;
    }

    public boolean isLastActionSuccessful() {
        if (this.getLastAutomationItem() != null) {
            return this.getLastAutomationItem().isActionSuccessful();
        }
        return false;
    }

    public void dispose() {
        this.firePropertyChange(DISPOSE, null, DISPOSE);
    }

    public AutomationItem addItem() {
        ++this._IdNumber;
        String id = this.getId() + REGEX + Integer.toString(this._IdNumber);
        log.debug("Adding new item to ({}) id: {}", (Object)this.getName(), (Object)id);
        AutomationItem item = new AutomationItem(id);
        this._automationHashTable.put(item.getId(), item);
        item.setSequenceId(this.getSize());
        if (this.getCurrentAutomationItem() == null) {
            this.setCurrentAutomationItem(item);
        }
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, this.getSize() - 1, this.getSize());
        return item;
    }

    public AutomationItem addNewItem(int sequence) {
        AutomationItem item = this.addItem();
        if (sequence < 0 || sequence > this.getSize()) {
            return item;
        }
        for (int i = 0; i < this.getSize() - sequence - 1; ++i) {
            this.moveItemUp(item);
        }
        return item;
    }

    public void register(AutomationItem item) {
        this._automationHashTable.put(item.getId(), item);
        String[] getId = item.getId().split(REGEX);
        int id = Integer.parseInt(getId[1]);
        if (id > this._IdNumber) {
            this._IdNumber = id;
        }
        if (this.getCurrentAutomationItem() == null) {
            this.setCurrentAutomationItem(item);
        }
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, this.getSize() - 1, this.getSize());
    }

    public void deleteItem(AutomationItem item) {
        if (item != null) {
            if (item.isActionRunning()) {
                this.stop();
            }
            if (this.getCurrentAutomationItem() == item) {
                this.setNextAutomationItem();
            }
            String id = item.getId();
            item.dispose();
            int old = this.getSize();
            this._automationHashTable.remove(id);
            this.resequenceIds();
            if (this.getSize() <= 0) {
                this.setCurrentAutomationItem(null);
            }
            this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, old, this.getSize());
        }
    }

    private void resequenceIds() {
        int i = 1;
        for (AutomationItem item : this.getItemsBySequenceList()) {
            item.setSequenceId(i++);
        }
    }

    public AutomationItem getItemById(String id) {
        return this._automationHashTable.get(id);
    }

    private List<AutomationItem> getItemsByIdList() {
        ArrayList<AutomationItem> out = new ArrayList<AutomationItem>();
        this._automationHashTable.keySet().stream().sorted().forEach(id -> out.add(this.getItemById((String)id)));
        return out;
    }

    public List<AutomationItem> getItemsBySequenceList() {
        ArrayList<AutomationItem> items = new ArrayList<AutomationItem>();
        for (AutomationItem item : this.getItemsByIdList()) {
            for (int j = 0; j < items.size(); ++j) {
                if (item.getSequenceId() >= ((AutomationItem)items.get(j)).getSequenceId()) continue;
                items.add(j, item);
                break;
            }
            if (items.contains(item)) continue;
            items.add(item);
        }
        return items;
    }

    public JComboBox<AutomationItem> getComboBox() {
        JComboBox<AutomationItem> box = new JComboBox<AutomationItem>();
        for (AutomationItem item : this.getItemsBySequenceList()) {
            box.addItem(item);
        }
        return box;
    }

    public void moveItemUp(AutomationItem item) {
        int sequenceId = item.getSequenceId();
        if (sequenceId - 1 <= 0) {
            item.setSequenceId(this.getSize() + 1);
            this.resequenceIds();
        } else {
            AutomationItem replaceSi = this.getItemBySequenceId(sequenceId - 1);
            if (replaceSi != null) {
                replaceSi.setSequenceId(sequenceId);
                item.setSequenceId(sequenceId - 1);
            } else {
                this.resequenceIds();
            }
        }
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, null, sequenceId);
    }

    public void moveItemDown(AutomationItem item) {
        int sequenceId = item.getSequenceId();
        if (sequenceId + 1 > this.getSize()) {
            item.setSequenceId(0);
            this.resequenceIds();
        } else {
            AutomationItem replaceSi = this.getItemBySequenceId(sequenceId + 1);
            if (replaceSi != null) {
                replaceSi.setSequenceId(sequenceId);
                item.setSequenceId(sequenceId + 1);
            } else {
                this.resequenceIds();
            }
        }
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, null, sequenceId);
    }

    public AutomationItem getItemBySequenceId(int sequenceId) {
        for (AutomationItem item : this.getItemsByIdList()) {
            if (item.getSequenceId() != sequenceId) continue;
            return item;
        }
        return null;
    }

    public void copyAutomation(Automation automation) {
        if (automation != null) {
            this.setComment(automation.getComment());
            for (AutomationItem item : automation.getItemsBySequenceList()) {
                this.addItem().copyItem(item);
            }
            for (AutomationItem item : this.getItemsBySequenceList()) {
                if (item.getGotoAutomationItem() == null) continue;
                item.setGotoAutomationItem(this.getItemBySequenceId(item.getGotoAutomationItem().getSequenceId()));
            }
        }
    }

    public Automation(Element e) {
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in automation element when reading operations");
        }
        a = e.getAttribute("name");
        if (a != null) {
            this._name = a.getValue();
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
        if (e.getChildren("item") != null) {
            List eAutomationItems = e.getChildren("item");
            log.debug("automation: {} has {} items", (Object)this.getName(), (Object)eAutomationItems.size());
            for (Element eAutomationItem : eAutomationItems) {
                this.register(new AutomationItem(eAutomationItem));
            }
        }
        if ((a = e.getAttribute("currentItem")) != null) {
            this._currentAutomationItem = this.getItemById(a.getValue());
        }
    }

    public Element store() {
        Element e = new Element("automation");
        e.setAttribute("id", this.getId());
        e.setAttribute("name", this.getName());
        e.setAttribute("comment", this.getComment());
        if (this.getCurrentAutomationItem() != null) {
            e.setAttribute("currentItem", this.getCurrentAutomationItem().getId());
        }
        for (AutomationItem item : this.getItemsBySequenceList()) {
            e.addContent((Content)item.store());
        }
        return e;
    }

    private void checkForActionPropertyChange(PropertyChangeEvent evt) {
        Action action;
        if (evt.getPropertyName().equals("actionComplete") || evt.getPropertyName().equals("actionHalt")) {
            action = (Action)evt.getSource();
            action.removePropertyChangeListener(this);
        }
        if (evt.getPropertyName().equals("actionRunning")) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                AutomationItem item;
                AutomationItem nextItem;
                action = (Action)evt.getSource();
                log.debug("Action ({}) is running", (Object)action.getActionString());
                if (action.isConcurrentAction() && (nextItem = this.getNextAutomationItem(item = action.getAutomationItem())) != null && nextItem.getAction().isConcurrentAction()) {
                    this.performAction(nextItem);
                }
            }
        }
        if (this.getCurrentAutomationItem() != null && this.getCurrentAutomationItem().getAction() == evt.getSource()) {
            if (evt.getPropertyName().equals("actionComplete") || evt.getPropertyName().equals("actionHalt")) {
                this.getCurrentAutomationItem().getAction().cancelAction();
                if (evt.getPropertyName().equals("actionComplete")) {
                    this.setNextAutomationItem();
                    if (this.isRunning()) {
                        this.step();
                    }
                } else if (evt.getPropertyName().equals("actionHalt")) {
                    if (((Boolean)evt.getNewValue()).booleanValue()) {
                        log.debug("User halted successful action");
                        this.setNextAutomationItem();
                    }
                    this.stop();
                }
            }
            if (evt.getPropertyName().equals("actionGoto") && (evt.getOldValue() == null || ((Boolean)evt.getOldValue()).booleanValue() == this.isLastActionSuccessful())) {
                this._gotoAutomationItem = (AutomationItem)evt.getNewValue();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.checkForActionPropertyChange(e);
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(TrainManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }
}

