/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.automation.Automation;
import jmri.jmrit.operations.trains.TrainManagerXml;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomationManager
extends PropertyChangeSupport
implements InstanceManagerAutoDefault,
PropertyChangeListener {
    public static final String LISTLENGTH_CHANGED_PROPERTY = "automationListLength";
    private int _id = 0;
    protected Hashtable<String, Automation> _automationHashTable = new Hashtable();
    protected Automation _startupAutomation;
    private static final Logger log = LoggerFactory.getLogger(AutomationManager.class);

    public int getSize() {
        return this._automationHashTable.size();
    }

    public Automation getAutomationByName(String name) {
        Enumeration<Automation> en = this._automationHashTable.elements();
        while (en.hasMoreElements()) {
            Automation automation = en.nextElement();
            if (!automation.getName().equals(name)) continue;
            return automation;
        }
        return null;
    }

    public Automation getAutomationById(String id) {
        return this._automationHashTable.get(id);
    }

    public Automation newAutomation(String name) {
        Automation automation = this.getAutomationByName(name);
        if (automation == null) {
            ++this._id;
            automation = new Automation(Integer.toString(this._id), name);
            Integer oldSize = this._automationHashTable.size();
            this._automationHashTable.put(automation.getId(), automation);
            this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._automationHashTable.size());
        }
        return automation;
    }

    public void register(Automation automation) {
        Integer oldSize = this._automationHashTable.size();
        this._automationHashTable.put(automation.getId(), automation);
        int id = Integer.parseInt(automation.getId());
        if (id > this._id) {
            this._id = id;
        }
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._automationHashTable.size());
    }

    public void deregister(Automation automation) {
        if (automation == null) {
            return;
        }
        automation.dispose();
        Integer oldSize = this._automationHashTable.size();
        this._automationHashTable.remove(automation.getId());
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._automationHashTable.size());
    }

    public List<Automation> getAutomationsByNameList() {
        List<Automation> sortList = this.getList();
        ArrayList<Automation> out = new ArrayList<Automation>();
        for (Automation automation : sortList) {
            for (int j = 0; j < out.size(); ++j) {
                if (automation.getName().compareToIgnoreCase(((Automation)out.get(j)).getName()) >= 0) continue;
                out.add(j, automation);
                break;
            }
            if (out.contains(automation)) continue;
            out.add(automation);
        }
        return out;
    }

    public List<Automation> getAutomationsByIdList() {
        List<Automation> sortList = this.getList();
        ArrayList<Automation> out = new ArrayList<Automation>();
        for (Automation automation : sortList) {
            for (int j = 0; j < out.size(); ++j) {
                try {
                    if (Integer.parseInt(automation.getId()) >= Integer.parseInt(((Automation)out.get(j)).getId())) continue;
                    out.add(j, automation);
                    break;
                }
                catch (NumberFormatException e) {
                    log.debug("list id number isn't a number");
                }
            }
            if (out.contains(automation)) continue;
            out.add(automation);
        }
        return out;
    }

    private List<Automation> getList() {
        ArrayList<Automation> out = new ArrayList<Automation>();
        Enumeration<Automation> en = this._automationHashTable.elements();
        while (en.hasMoreElements()) {
            out.add(en.nextElement());
        }
        return out;
    }

    public JComboBox<Automation> getComboBox() {
        JComboBox<Automation> box = new JComboBox<Automation>();
        this.updateComboBox(box);
        return box;
    }

    public void updateComboBox(JComboBox<Automation> box) {
        box.removeAllItems();
        box.addItem(null);
        for (Automation automation : this.getAutomationsByNameList()) {
            box.addItem(automation);
        }
    }

    public void resumeAutomations() {
        for (Automation automation : this.getAutomationsByNameList()) {
            if (automation.isActionRunning() || automation.isReadyToRun()) continue;
            automation.resume();
        }
    }

    public Automation copyAutomation(Automation automation, String newName) {
        Automation newAutomation = this.newAutomation(newName);
        newAutomation.copyAutomation(automation);
        return newAutomation;
    }

    public Automation getStartupAutomation() {
        return this._startupAutomation;
    }

    protected String getStartupAutomationId() {
        String id = "";
        if (this.getStartupAutomation() != null) {
            id = this.getStartupAutomation().getId();
        }
        return id;
    }

    public void setStartupAutomation(Automation automation) {
        Automation old = this._startupAutomation;
        this._startupAutomation = automation;
        this.setDirtyAndFirePropertyChange("automationStartupIdChanged", old, automation);
    }

    public void runStartupAutomation() {
        Automation startup = this.getStartupAutomation();
        if (startup != null) {
            log.debug("Run automation: {}", (Object)startup.getName());
            startup.run();
        }
    }

    public void dispose() {
        this._automationHashTable.clear();
        this._id = 0;
    }

    public void load(Element root) {
        Attribute a;
        Element e;
        if (root.getChild("automations") != null) {
            List eAutomations = root.getChild("automations").getChildren("automation");
            log.debug("readFile sees {} automations", (Object)eAutomations.size());
            for (Element eAutomation : eAutomations) {
                this.register(new Automation(eAutomation));
            }
        }
        if ((e = root.getChild("automationOptions")) != null && (a = e.getAttribute("automationStartupId")) != null) {
            this._startupAutomation = this.getAutomationById(a.getValue());
        }
    }

    public void store(Element root) {
        Element e = new Element("automationOptions");
        e.setAttribute("automationStartupId", this.getStartupAutomationId());
        root.addContent((Content)e);
        Element values = new Element("automations");
        root.addContent((Content)values);
        for (Automation automation : this.getAutomationsByNameList()) {
            values.addContent((Content)automation.store());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(TrainManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }
}

