/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation.actions;

import java.io.File;
import jmri.InstanceManager;
import jmri.jmrit.operations.automation.actions.Action;
import jmri.jmrit.operations.automation.actions.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainSwitchLists;
import jmri.jmrit.operations.trains.csv.TrainCsvSwitchLists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateSwitchListChangesAction
extends Action {
    private static final int _code = 5644;
    protected static final boolean IS_CHANGED = true;
    private static final Logger log = LoggerFactory.getLogger(GenerateSwitchListChangesAction.class);

    @Override
    public int getCode() {
        return 5644;
    }

    @Override
    public String getName() {
        return Bundle.getMessage("GenerateSwitchListChanges");
    }

    @Override
    public void doAction() {
        this.doAction(true);
    }

    protected void doAction(boolean isChanged) {
        if (this.getAutomationItem() != null) {
            if (!Setup.isGenerateCsvSwitchListEnabled()) {
                log.warn("Generate CSV Switch List isn't enabled!");
                this.finishAction(false);
                return;
            }
            this.setRunning(true);
            TrainSwitchLists trainSwitchLists = new TrainSwitchLists();
            TrainCsvSwitchLists trainCsvSwitchLists = new TrainCsvSwitchLists();
            for (Location location : InstanceManager.getDefault(LocationManager.class).getUniqueLocationsByNameList()) {
                if (!location.isSwitchListEnabled() || isChanged && !location.getStatus().equals(Location.MODIFIED)) continue;
                File csvFile = trainCsvSwitchLists.buildSwitchList(location);
                trainSwitchLists.buildSwitchList(location);
                if (csvFile != null && csvFile.exists()) continue;
                log.error("CSV switch list file was not created for location {}", (Object)location.getName());
                this.finishAction(false);
                return;
            }
            InstanceManager.getDefault(TrainManager.class).setTrainsSwitchListStatus(Train.PRINTED);
            this.finishAction(true);
        }
    }

    @Override
    public void cancelAction() {
    }
}

