/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation.actions;

import jmri.InstanceManager;
import jmri.jmrit.operations.automation.actions.Action;
import jmri.jmrit.operations.automation.actions.Bundle;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.excel.TrainCustomManifest;
import jmri.jmrit.operations.trains.excel.TrainCustomSwitchList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunTrainAction
extends Action {
    private static final int _code = 2317;
    private static final Logger log = LoggerFactory.getLogger(RunTrainAction.class);

    @Override
    public int getCode() {
        return 2317;
    }

    @Override
    public String getName() {
        return Bundle.getMessage("RunTrain");
    }

    @Override
    public void doAction() {
        if (this.getAutomationItem() != null) {
            if (!Setup.isGenerateCsvManifestEnabled()) {
                log.warn("Generate CSV Manifest isn't enabled!");
                this.finishAction(false);
                return;
            }
            if (!InstanceManager.getDefault(TrainCustomManifest.class).excelFileExists()) {
                log.warn("Manifest creator file not found!, directory name: {}, file name: {}", (Object)InstanceManager.getDefault(TrainCustomManifest.class).getDirectoryName(), (Object)InstanceManager.getDefault(TrainCustomManifest.class).getFileName());
                this.finishAction(false);
                return;
            }
            Train train = this.getAutomationItem().getTrain();
            if (train == null) {
                log.warn("No train selected for custom manifest");
                this.finishAction(false);
                return;
            }
            if (!train.isBuilt()) {
                log.warn("Train ({}) needs to be built before creating a custom manifest", (Object)train.getName());
                this.finishAction(false);
                return;
            }
            this.setRunning(true);
            if (!InstanceManager.getDefault(TrainCustomSwitchList.class).checkProcessReady()) {
                log.warn("Timeout waiting for excel switch list program to complete previous operation, train ({}), timeout value: {} seconds", (Object)train.getName(), (Object)Control.excelWaitTime);
            }
            if (!InstanceManager.getDefault(TrainCustomManifest.class).checkProcessReady()) {
                log.warn("Timeout waiting for excel manifest program to complete previous operation, train ({}), timeout value: {} seconds", (Object)train.getName(), (Object)Control.excelWaitTime);
            }
            if (InstanceManager.getDefault(TrainCustomManifest.class).doesCommonFileExist()) {
                log.warn("Manifest CSV common file exists!");
            }
            if (!InstanceManager.getDefault(TrainCustomManifest.class).addCsvFile(train.createCsvManifestFile())) {
                this.finishAction(false);
                return;
            }
            log.info("Queued train CSV file ({}) for custom processing", (Object)train.getName());
            boolean status = InstanceManager.getDefault(TrainCustomManifest.class).process();
            if (status) {
                try {
                    status = InstanceManager.getDefault(TrainCustomManifest.class).waitForProcessToComplete();
                }
                catch (InterruptedException e) {
                    log.error("Thread unexpectedly interrupted", (Throwable)e);
                }
                if (!status) {
                    log.warn("Timeout when creating custom manifest for train ({})", (Object)train.getName());
                }
            }
            this.finishAction(status);
        }
    }

    @Override
    public void cancelAction() {
    }
}

