/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.InstanceManager;
import jmri.jmrit.operations.automation.actions.Action;
import jmri.jmrit.operations.automation.actions.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitSwitchListAction
extends Action
implements PropertyChangeListener {
    private static final int _code = 4612;
    private static final Logger log = LoggerFactory.getLogger(WaitSwitchListAction.class);

    @Override
    public int getCode() {
        return 4612;
    }

    @Override
    public String getName() {
        return Bundle.getMessage("WaitForSwitchListChange");
    }

    @Override
    public boolean isConcurrentAction() {
        return true;
    }

    @Override
    public void doAction() {
        if (this.getAutomationItem() != null) {
            this.setRunning(true);
            this.addPropertyChangeLocations();
        }
    }

    private void checkForlocationChange() {
        for (Location location : InstanceManager.getDefault(LocationManager.class).getList()) {
            if (location == null || !location.isSwitchListEnabled() || !location.getStatus().equals(Location.MODIFIED)) continue;
            this.removePropertyChangeLocations();
            this.finishAction(true);
            break;
        }
    }

    private synchronized void addPropertyChangeLocations() {
        for (Location location : InstanceManager.getDefault(LocationManager.class).getList()) {
            location.addPropertyChangeListener(this);
        }
    }

    private synchronized void removePropertyChangeLocations() {
        for (Location location : InstanceManager.getDefault(LocationManager.class).getList()) {
            location.removePropertyChangeListener(this);
        }
    }

    @Override
    public void cancelAction() {
        if (this.getAutomationItem() != null) {
            this.setRunning(false);
            this.removePropertyChangeLocations();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("locationStatus") && evt.getNewValue().equals(Location.MODIFIED)) {
            this.checkForlocationChange();
        }
    }
}

