/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.jmrit.operations.automation.actions.Action;
import jmri.jmrit.operations.automation.actions.Bundle;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Train;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitTrainAction
extends Action
implements PropertyChangeListener {
    private static final int _code = 1807;
    private static final Logger log = LoggerFactory.getLogger(WaitTrainAction.class);

    @Override
    public int getCode() {
        return 1807;
    }

    @Override
    public String getName() {
        return Bundle.getMessage("WaitForTrain");
    }

    @Override
    public boolean isConcurrentAction() {
        return true;
    }

    @Override
    public void doAction() {
        if (this.getAutomationItem() != null) {
            Train train = this.getAutomationItem().getTrain();
            if (train != null && train.getRoute() != null) {
                this.setRunning(true);
                train.addPropertyChangeListener(this);
            } else {
                this.finishAction(false);
            }
        }
    }

    private void trainUpdate(PropertyChangeEvent evt) {
        if (this.getAutomationItem() != null) {
            if (evt.getPropertyName().equals("TrainMoveComplete") || evt.getPropertyName().equals("TrainBuilt") && ((Boolean)evt.getNewValue()).booleanValue()) {
                Train train = this.getAutomationItem().getTrain();
                RouteLocation rl = this.getAutomationItem().getRouteLocation();
                if (rl != null && rl != train.getCurrentRouteLocation()) {
                    return;
                }
                train.removePropertyChangeListener(this);
                this.finishAction(true);
            } else if (evt.getPropertyName().equals("TrainBuild") && !((Boolean)evt.getNewValue()).booleanValue()) {
                Train train = this.getAutomationItem().getTrain();
                train.removePropertyChangeListener(this);
                this.finishAction(true);
            }
        }
    }

    @Override
    public void cancelAction() {
        if (this.getAutomationItem() != null) {
            this.setRunning(false);
            Train train = this.getAutomationItem().getTrain();
            if (train != null) {
                train.removePropertyChangeListener(this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.trainUpdate(evt);
    }
}

