/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.jmrit.operations.automation.actions.Action;
import jmri.jmrit.operations.automation.actions.Bundle;
import jmri.jmrit.operations.trains.Train;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitTrainTerminatedAction
extends Action
implements PropertyChangeListener {
    private static final int _code = 3085;
    private static final Logger log = LoggerFactory.getLogger(WaitTrainTerminatedAction.class);

    @Override
    public int getCode() {
        return 3085;
    }

    @Override
    public String getName() {
        return Bundle.getMessage("WaitForTrainToTerminate");
    }

    @Override
    public boolean isConcurrentAction() {
        return true;
    }

    @Override
    public void doAction() {
        if (this.getAutomationItem() != null) {
            Train train = this.getAutomationItem().getTrain();
            if (train != null && train.getRoute() != null) {
                this.setRunning(true);
                train.addPropertyChangeListener(this);
            } else {
                this.finishAction(false);
            }
        }
    }

    private void trainUpdate(PropertyChangeEvent evt) {
        if (this.getAutomationItem() != null) {
            Train train = this.getAutomationItem().getTrain();
            if (evt.getPropertyName().equals("TrainBuilt") && train.getStatusCode() == 128 || evt.getPropertyName().equals("TrainBuild") && !((Boolean)evt.getNewValue()).booleanValue()) {
                train.removePropertyChangeListener(this);
                this.finishAction(true);
            }
        }
    }

    @Override
    public void cancelAction() {
        if (this.getAutomationItem() != null) {
            this.setRunning(false);
            Train train = this.getAutomationItem().getTrain();
            if (train != null) {
                train.removePropertyChangeListener(this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.trainUpdate(evt);
    }
}

