/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.automation.Automation;
import jmri.jmrit.operations.automation.AutomationManager;
import jmri.jmrit.operations.automation.gui.Bundle;
import jmri.jmrit.operations.setup.Setup;

public class AutomationStartupFrame
extends OperationsFrame
implements PropertyChangeListener {
    AutomationManager automationManager = InstanceManager.getDefault(AutomationManager.class);
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JButton testButton = new JButton(Bundle.getMessage("ButtonTest"));
    JComboBox<Automation> comboBox = this.automationManager.getComboBox();

    public AutomationStartupFrame() {
        super(Bundle.getMessage("MenuStartupAutomation"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pAutomation = new JPanel();
        pAutomation.setLayout(new GridBagLayout());
        pAutomation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("MenuStartupAutomation")));
        this.addItem(pAutomation, this.comboBox, 0, 0);
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        pB.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pB, this.testButton, 0, 0);
        this.addItem(pB, this.saveButton, 1, 0);
        this.getContentPane().add(pAutomation);
        this.getContentPane().add(pB);
        this.addButtonAction(this.testButton);
        this.addButtonAction(this.saveButton);
        this.comboBox.setSelectedItem(this.automationManager.getStartupAutomation());
        this.testButton.setToolTipText(Bundle.getMessage("ButtonTestTip"));
        this.automationManager.addPropertyChangeListener(this);
        this.initMinimumSize(new Dimension(500, 200));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.testButton) {
            this.automationManager.runStartupAutomation();
        }
        if (ae.getSource() == this.saveButton) {
            this.automationManager.setStartupAutomation((Automation)this.comboBox.getSelectedItem());
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    @Override
    public void dispose() {
        this.automationManager.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("automationListLength")) {
            this.automationManager.updateComboBox(this.comboBox);
            this.comboBox.setSelectedItem(this.automationManager.getStartupAutomation());
        }
    }
}

