/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.automation.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.jmrit.operations.automation.Automation;
import jmri.jmrit.operations.automation.AutomationItem;
import jmri.jmrit.operations.automation.actions.Action;
import jmri.jmrit.operations.automation.gui.AutomationTableFrame;
import jmri.jmrit.operations.automation.gui.Bundle;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.symbolicprog.ValueEditor;
import jmri.jmrit.symbolicprog.ValueRenderer;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomationTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    protected static final String POINTER = "    -->";
    private static final int ID_COLUMN = 0;
    private static final int CURRENT_COLUMN = 1;
    private static final int ACTION_COLUMN = 2;
    private static final int TRAIN_COLUMN = 3;
    private static final int ROUTE_COLUMN = 4;
    private static final int AUTOMATION_COLUMN = 5;
    private static final int STATUS_COLUMN = 6;
    private static final int HIAF_COLUMN = 7;
    private static final int MESSAGE_COLUMN = 8;
    private static final int UP_COLUMN = 9;
    private static final int DOWN_COLUMN = 10;
    private static final int DELETE_COLUMN = 11;
    private static final int HIGHEST_COLUMN = 12;
    Automation _automation;
    JTable _table;
    AutomationTableFrame _frame;
    boolean _matchMode = false;
    List<AutomationItem> _list = new ArrayList<AutomationItem>();
    private static final Logger log = LoggerFactory.getLogger(AutomationTableModel.class);

    private void updateList() {
        if (this._automation == null) {
            return;
        }
        this.removePropertyChangeAutomationItems();
        this._list = this._automation.getItemsBySequenceList();
        for (AutomationItem item : this._list) {
            item.addPropertyChangeListener(this);
        }
    }

    protected void initTable(AutomationTableFrame frame, JTable table, Automation automation) {
        this._automation = automation;
        this._table = table;
        this._frame = frame;
        if (this._automation != null) {
            this._automation.addPropertyChangeListener(this);
        }
        this.initTable(table);
    }

    private void initTable(JTable table) {
        TableColumnModel tcm = table.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(8).setCellRenderer(buttonRenderer);
        tcm.getColumn(8).setCellEditor(buttonEditor);
        tcm.getColumn(9).setCellRenderer(buttonRenderer);
        tcm.getColumn(9).setCellEditor(buttonEditor);
        tcm.getColumn(10).setCellRenderer(buttonRenderer);
        tcm.getColumn(10).setCellEditor(buttonEditor);
        tcm.getColumn(11).setCellRenderer(buttonRenderer);
        tcm.getColumn(11).setCellEditor(buttonEditor);
        table.setDefaultRenderer(JComboBox.class, new ValueRenderer());
        table.setDefaultEditor(JComboBox.class, new ValueEditor());
        table.getColumnModel().getColumn(0).setPreferredWidth(35);
        table.getColumnModel().getColumn(1).setPreferredWidth(60);
        table.getColumnModel().getColumn(2).setPreferredWidth(200);
        table.getColumnModel().getColumn(3).setPreferredWidth(200);
        table.getColumnModel().getColumn(4).setPreferredWidth(200);
        table.getColumnModel().getColumn(5).setPreferredWidth(200);
        table.getColumnModel().getColumn(6).setPreferredWidth(70);
        table.getColumnModel().getColumn(7).setPreferredWidth(50);
        table.getColumnModel().getColumn(8).setPreferredWidth(70);
        table.getColumnModel().getColumn(9).setPreferredWidth(60);
        table.getColumnModel().getColumn(10).setPreferredWidth(70);
        table.getColumnModel().getColumn(11).setPreferredWidth(70);
        this._frame.loadTableDetails(table);
        table.setRowSorter(null);
        this.updateList();
    }

    @Override
    public int getRowCount() {
        return this._list.size();
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Id");
            }
            case 1: {
                return Bundle.getMessage("Current");
            }
            case 2: {
                return Bundle.getMessage("Action");
            }
            case 3: {
                return Bundle.getMessage("Train");
            }
            case 4: {
                return Bundle.getMessage("RouteLocation");
            }
            case 5: {
                return Bundle.getMessage("AutomationOther");
            }
            case 6: {
                return Bundle.getMessage("Status");
            }
            case 8: {
                return Bundle.getMessage("Message");
            }
            case 7: {
                return Bundle.getMessage("HaltIfActionFails");
            }
            case 9: {
                return Bundle.getMessage("Up");
            }
            case 10: {
                return Bundle.getMessage("Down");
            }
            case 11: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return JComboBox.class;
            }
            case 3: {
                return JComboBox.class;
            }
            case 4: {
                return JComboBox.class;
            }
            case 5: {
                return JComboBox.class;
            }
            case 6: {
                return String.class;
            }
            case 7: {
                return Boolean.class;
            }
            case 8: {
                return JButton.class;
            }
            case 9: {
                return JButton.class;
            }
            case 10: {
                return JButton.class;
            }
            case 11: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
            case 7: {
                AutomationItem item = this._list.get(row);
                return item.getAction().isMessageFailEnabled();
            }
            case 8: {
                AutomationItem item = this._list.get(row);
                JComboBox<Action> acb = this.getActionComboBox(item);
                return ((Action)acb.getSelectedItem()).isMessageOkEnabled();
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        AutomationItem item = this._list.get(row);
        if (item == null) {
            return "ERROR automation item unknown " + row;
        }
        switch (col) {
            case 0: {
                return item.getId();
            }
            case 1: {
                return this.getCurrentPointer(row, item);
            }
            case 2: {
                return this.getActionComboBox(item);
            }
            case 3: {
                return this.getTrainComboBox(item);
            }
            case 4: {
                return this.getRouteLocationComboBox(item);
            }
            case 5: {
                return this.getAutomationComboBox(item);
            }
            case 6: {
                return this.getStatus(item);
            }
            case 7: {
                return item.isHaltFailureEnabled() & item.getAction().isMessageFailEnabled();
            }
            case 8: {
                if (item.getMessage().equals("") && item.getMessageFail().equals("")) {
                    return Bundle.getMessage("Add");
                }
                return Bundle.getMessage("ButtonEdit");
            }
            case 9: {
                return Bundle.getMessage("Up");
            }
            case 10: {
                return Bundle.getMessage("Down");
            }
            case 11: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            log.debug("Warning automation table row {} still in edit", (Object)row);
            return;
        }
        AutomationItem item = this._list.get(row);
        switch (col) {
            case 1: {
                this.setCurrent(item);
                break;
            }
            case 2: {
                this.setAction(value, item);
                break;
            }
            case 3: {
                this.setTrain(value, item);
                break;
            }
            case 4: {
                this.setRouteLocation(value, item);
                break;
            }
            case 5: {
                this.setAutomationColumn(value, item);
                break;
            }
            case 7: {
                item.setHaltFailureEnabled((Boolean)value);
                break;
            }
            case 8: {
                this.setMessage(value, item);
                break;
            }
            case 9: {
                this.moveUpAutomationItem(item);
                break;
            }
            case 10: {
                this.moveDownAutomationItem(item);
                break;
            }
            case 11: {
                this.deleteAutomationItem(item);
                break;
            }
        }
    }

    private String getCurrentPointer(int row, AutomationItem item) {
        if (this._automation.getCurrentAutomationItem() == item) {
            return POINTER;
        }
        return "";
    }

    private JComboBox<Action> getActionComboBox(AutomationItem item) {
        JComboBox<Action> cb = AutomationItem.getActionComboBox();
        for (int index = 0; index < cb.getItemCount(); ++index) {
            if (item.getAction() == null || cb.getItemAt(index).getCode() != item.getAction().getCode()) continue;
            cb.setSelectedIndex(index);
            break;
        }
        return cb;
    }

    private JComboBox<Train> getTrainComboBox(AutomationItem item) {
        JComboBox<Train> cb = InstanceManager.getDefault(TrainManager.class).getTrainComboBox();
        cb.setSelectedItem(item.getTrain());
        cb.setEnabled(item.getAction() != null && item.getAction().isTrainMenuEnabled());
        return cb;
    }

    private JComboBox<RouteLocation> getRouteLocationComboBox(AutomationItem item) {
        JComboBox<RouteLocation> cb = new JComboBox<RouteLocation>();
        if (item.getTrain() != null && item.getTrain().getRoute() != null) {
            cb = item.getTrain().getRoute().getComboBox();
            cb.setSelectedItem(item.getRouteLocation());
        }
        cb.setEnabled(item.getAction() != null && item.getAction().isRouteMenuEnabled());
        return cb;
    }

    private JComboBox<?> getAutomationComboBox(AutomationItem item) {
        if (item.getAction() != null) {
            return item.getAction().getComboBox();
        }
        return null;
    }

    private String getStatus(AutomationItem item) {
        return item.getStatus();
    }

    private void setCurrent(AutomationItem item) {
        this._automation.setCurrentAutomationItem(item);
        this._automation.resetAutomationItems(item);
    }

    private void setAction(Object value, AutomationItem item) {
        JComboBox cb = (JComboBox)value;
        item.setAction((Action)cb.getSelectedItem());
    }

    private void setTrain(Object value, AutomationItem item) {
        JComboBox cb = (JComboBox)value;
        item.setTrain((Train)cb.getSelectedItem());
    }

    private void setRouteLocation(Object value, AutomationItem item) {
        JComboBox cb = (JComboBox)value;
        item.setRouteLocation((RouteLocation)cb.getSelectedItem());
    }

    private void setAutomationColumn(Object value, AutomationItem item) {
        item.setOther(((JComboBox)value).getSelectedItem());
    }

    private void setMessage(Object value, final AutomationItem item) {
        final JDialog dialog = new JDialog();
        dialog.setLayout(new BorderLayout());
        dialog.setTitle(Bundle.getMessage("Message"));
        final JTextArea messageTextArea = new JTextArea(6, 100);
        JScrollPane messageScroller = new JScrollPane(messageTextArea);
        messageScroller.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("MessageOk")));
        dialog.add((Component)messageScroller, "North");
        messageTextArea.setText(item.getMessage());
        messageTextArea.setToolTipText(Bundle.getMessage("TipMessage"));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        dialog.add((Component)buttonPane, "South");
        final JCheckBox haltCheckBox = new JCheckBox(Bundle.getMessage("HaltIfFail"));
        haltCheckBox.setSelected(item.isHaltFailureEnabled());
        final JTextArea messageFailTextArea = new JTextArea(6, 100);
        if (item.getAction() != null && item.getAction().isMessageFailEnabled()) {
            JScrollPane messageFailScroller = new JScrollPane(messageFailTextArea);
            messageFailScroller.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("MessageFail")));
            dialog.add((Component)messageFailScroller, "Center");
            messageFailTextArea.setText(item.getMessageFail());
            messageFailTextArea.setToolTipText(Bundle.getMessage("TipMessage"));
            buttonPane.add(haltCheckBox);
            buttonPane.add(new JLabel("      "));
        }
        JButton okayButton = new JButton(Bundle.getMessage("ButtonOK"));
        okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                item.setMessage(messageTextArea.getText());
                item.setMessageFail(messageFailTextArea.getText());
                item.setHaltFailureEnabled(haltCheckBox.isSelected());
                dialog.dispose();
            }
        });
        buttonPane.add(okayButton);
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                dialog.dispose();
            }
        });
        buttonPane.add(cancelButton);
        JButton defaultMessagesButton = new JButton(Bundle.getMessage("DefaultMessages"));
        defaultMessagesButton.setToolTipText(Bundle.getMessage("TipDefaultButton"));
        defaultMessagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (messageTextArea.getText().equals("")) {
                    messageTextArea.setText(Bundle.getMessage("DefaultMessageOk"));
                }
                if (messageFailTextArea.getText().equals("")) {
                    messageFailTextArea.setText(Bundle.getMessage("DefaultMessageFail"));
                }
            }
        });
        buttonPane.add(defaultMessagesButton);
        dialog.setModal(true);
        dialog.pack();
        dialog.setVisible(true);
    }

    private void moveUpAutomationItem(AutomationItem item) {
        log.debug("move automation item up");
        this._automation.moveItemUp(item);
    }

    private void moveDownAutomationItem(AutomationItem item) {
        log.debug("move automation item down");
        this._automation.moveItemDown(item);
    }

    private void deleteAutomationItem(AutomationItem item) {
        log.debug("Delete automation item");
        this._automation.deleteItem(item);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        AutomationItem item;
        int row;
        if (e.getPropertyName().equals("automationListChange")) {
            this.updateList();
            this.fireTableDataChanged();
        }
        if (e.getPropertyName().equals("automationCurrentItemChange")) {
            SwingUtilities.invokeLater(() -> {
                int row = this._list.indexOf(this._automation.getCurrentAutomationItem());
                int viewRow = this._table.convertRowIndexToView(row);
                this._table.scrollRectToVisible(this._table.getCellRect(viewRow, 0, true));
                this.fireTableDataChanged();
            });
        }
        if (e.getSource().getClass().equals(AutomationItem.class) && (row = this._list.indexOf(item = (AutomationItem)e.getSource())) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    private void removePropertyChangeAutomationItems() {
        for (AutomationItem item : this._list) {
            item.removePropertyChangeListener(this);
        }
    }

    public void dispose() {
        if (this._automation != null) {
            this.removePropertyChangeAutomationItems();
            this._automation.removePropertyChangeListener(this);
        }
    }
}

