/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.divisions.DivisionManager;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationManagerXml
extends OperationsXml
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    private String operationsFileName = "OperationsLocationRoster.xml";
    private static final Logger log = LoggerFactory.getLogger(LocationManagerXml.class);

    @Override
    public void writeFile(String name) throws FileNotFoundException, IOException {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        Element root = new Element("operations-config");
        Document doc = LocationManagerXml.newDocument(root, this.dtdLocation + "operations-locations.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/operations-locations.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        InstanceManager.getDefault(DivisionManager.class).store(root);
        InstanceManager.getDefault(LocationManager.class).store(root);
        InstanceManager.getDefault(ScheduleManager.class).store(root);
        this.writeXML(file, doc);
        this.setDirty(false);
    }

    @Override
    public void readFile(String name) throws JDOMException, IOException {
        if (this.findFile(name) == null) {
            log.debug("{} file could not be found", (Object)name);
            return;
        }
        Element root = this.rootFromName(name);
        if (root == null) {
            log.debug("{} file could not be read", (Object)name);
            return;
        }
        if (!root.getName().equals("operations-config")) {
            log.warn("OperationsPro location file corrupted");
            return;
        }
        InstanceManager.getDefault(DivisionManager.class).load(root);
        InstanceManager.getDefault(LocationManager.class).load(root);
        InstanceManager.getDefault(ScheduleManager.class).load(root);
        this.setDirty(false);
        log.debug("Locations have been loaded!");
    }

    @Override
    public void setOperationsFileName(String name) {
        this.operationsFileName = name;
    }

    @Override
    public String getOperationsFileName() {
        return this.operationsFileName;
    }

    public void dispose() {
    }

    @Override
    public void initialize() {
        this.load();
    }
}

