/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Bundle;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.LocationManagerXml;
import jmri.jmrit.operations.locations.Pool;
import jmri.jmrit.operations.locations.divisions.Division;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Track
extends PropertyChangeSupport {
    public static final String NONE = "";
    protected String _id = "";
    protected String _name = "";
    protected String _trackType = "";
    protected Location _location;
    protected int _trainDir = 15;
    protected int _numberRS = 0;
    protected int _numberCars = 0;
    protected int _numberEngines = 0;
    protected int _pickupRS = 0;
    protected int _dropRS = 0;
    protected int _length = 0;
    protected int _reserved = 0;
    protected int _reservedLengthDrops = 0;
    protected int _numberCarsEnRoute = 0;
    protected int _usedLength = 0;
    protected int _ignoreUsedLengthPercentage = 0;
    public static final int IGNORE_0 = 0;
    public static final int IGNORE_25 = 25;
    public static final int IGNORE_50 = 50;
    public static final int IGNORE_75 = 75;
    public static final int IGNORE_100 = 100;
    protected int _moves = 0;
    protected int _blockingOrder = 0;
    protected String _alternateTrackId = "";
    protected String _comment = "";
    protected List<String> _typeList = new ArrayList<String>();
    protected boolean _printCommentManifest = true;
    protected boolean _printCommentSwitchList = false;
    protected String _commentPickup = "";
    protected String _commentSetout = "";
    protected String _commentBoth = "";
    protected String _roadOption = ALL_ROADS;
    protected List<String> _roadList = new ArrayList<String>();
    protected String _loadOption = ALL_LOADS;
    protected List<String> _loadList = new ArrayList<String>();
    protected String _shipLoadOption = ALL_LOADS;
    protected List<String> _shipLoadList = new ArrayList<String>();
    protected String _destinationOption = ALL_DESTINATIONS;
    protected List<String> _destinationIdList = new ArrayList<String>();
    protected String _scheduleName = "";
    protected String _scheduleId = "";
    protected String _scheduleItemId = "";
    protected int _scheduleCount = 0;
    protected int _reservedEnRoute = 0;
    protected int _reservationFactor = 100;
    protected int _mode = 1;
    protected boolean _holdCustomLoads = false;
    protected String _dropOption = "Any";
    protected String _pickupOption = "Any";
    public static final String ANY = "Any";
    public static final String TRAINS = "trains";
    public static final String ROUTES = "routes";
    public static final String EXCLUDE_TRAINS = "excludeTrains";
    public static final String EXCLUDE_ROUTES = "excludeRoutes";
    protected List<String> _dropList = new ArrayList<String>();
    protected List<String> _pickupList = new ArrayList<String>();
    protected int _loadOptions = 0;
    private static final int SWAP_GENERIC_LOADS = 1;
    private static final int EMPTY_CUSTOM_LOADS = 2;
    private static final int GENERATE_CUSTOM_LOADS = 4;
    private static final int GENERATE_CUSTOM_LOADS_ANY_SPUR = 8;
    private static final int EMPTY_GENERIC_LOADS = 16;
    private static final int GENERATE_CUSTOM_LOADS_ANY_STAGING_TRACK = 32;
    private static final int DISABLE_LOAD_CHANGE = 64;
    private static final int QUICK_SERVICE = 128;
    protected int _blockOptions = 0;
    private static final int BLOCK_CARS = 1;
    protected String _order = NORMAL;
    public static final String NORMAL = Bundle.getMessage("Normal");
    public static final String FIFO = Bundle.getMessage("FIFO");
    public static final String LIFO = Bundle.getMessage("LIFO");
    public static final String STAGING = "Staging";
    public static final String INTERCHANGE = "Interchange";
    public static final String YARD = "Yard";
    public static final String SPUR = "Spur";
    private static final String SIDING = "Siding";
    public static final int EAST = 1;
    public static final int WEST = 2;
    public static final int NORTH = 4;
    public static final int SOUTH = 8;
    public static final String ALL_ROADS = Bundle.getMessage("All");
    public static final String INCLUDE_ROADS = Bundle.getMessage("Include");
    public static final String EXCLUDE_ROADS = Bundle.getMessage("Exclude");
    public static final String ALL_LOADS = Bundle.getMessage("All");
    public static final String INCLUDE_LOADS = Bundle.getMessage("Include");
    public static final String EXCLUDE_LOADS = Bundle.getMessage("Exclude");
    public static final String ALL_DESTINATIONS = Bundle.getMessage("All");
    public static final String INCLUDE_DESTINATIONS = Bundle.getMessage("Include");
    public static final String EXCLUDE_DESTINATIONS = Bundle.getMessage("Exclude");
    protected boolean _onlyCarsWithFD = false;
    public static final int SEQUENTIAL = 0;
    public static final int MATCH = 1;
    public static final String PICKUP_OKAY = "";
    protected Pool _pool = null;
    protected int _minimumLength = 0;
    public static final String OKAY = Bundle.getMessage("okay");
    public static final String LENGTH = Bundle.getMessage("rollingStock") + " " + Bundle.getMessage("Length").toLowerCase();
    public static final String TYPE = Bundle.getMessage("type");
    public static final String ROAD = Bundle.getMessage("road");
    public static final String LOAD = Bundle.getMessage("load");
    public static final String CAPACITY = Bundle.getMessage("track") + " " + Bundle.getMessage("capacity");
    public static final String SCHEDULE = Bundle.getMessage("schedule");
    public static final String CUSTOM = Bundle.getMessage("custom");
    public static final String DESTINATION = Bundle.getMessage("carDestination");
    public static final String NO_FINAL_DESTINATION = Bundle.getMessage("noFinalDestination");
    public static final String TYPES_CHANGED_PROPERTY = "trackRollingStockTypes";
    public static final String ROADS_CHANGED_PROPERTY = "trackRoads";
    public static final String NAME_CHANGED_PROPERTY = "trackName";
    public static final String LENGTH_CHANGED_PROPERTY = "trackLength";
    public static final String MIN_LENGTH_CHANGED_PROPERTY = "trackMinLength";
    public static final String SCHEDULE_CHANGED_PROPERTY = "trackScheduleChange";
    public static final String DISPOSE_CHANGED_PROPERTY = "trackDispose";
    public static final String TRAIN_DIRECTION_CHANGED_PROPERTY = "trackTrainDirection";
    public static final String DROP_CHANGED_PROPERTY = "trackDrop";
    public static final String PICKUP_CHANGED_PROPERTY = "trackPickup";
    public static final String TRACK_TYPE_CHANGED_PROPERTY = "trackType";
    public static final String LOADS_CHANGED_PROPERTY = "trackLoads";
    public static final String POOL_CHANGED_PROPERTY = "trackPool";
    public static final String PLANNED_PICKUPS_CHANGED_PROPERTY = "plannedPickUps";
    public static final String LOAD_OPTIONS_CHANGED_PROPERTY = "trackLoadOptions";
    public static final String DESTINATIONS_CHANGED_PROPERTY = "trackDestinations";
    public static final String DESTINATION_OPTIONS_CHANGED_PROPERTY = "trackDestinationOptions";
    public static final String SCHEDULE_MODE_CHANGED_PROPERTY = "trackScheduleMode";
    public static final String SCHEDULE_ID_CHANGED_PROPERTY = "trackScheduleId";
    public static final String SERVICE_ORDER_CHANGED_PROPERTY = "trackServiceOrder";
    public static final String ALTERNATE_TRACK_CHANGED_PROPERTY = "trackAlternate";
    public static final String TRACK_BLOCKING_ORDER_CHANGED_PROPERTY = "trackBlockingOrder";
    public static final String TRACK_REPORTER_CHANGED_PROPERTY = "trackReporterChange";
    public static final String ROUTED_CHANGED_PROPERTY = "onlyCarsWithFinalDestinations";
    public static final String HOLD_CARS_CHANGED_PROPERTY = "trackHoldCarsWithCustomLoads";
    public static final String TRACK_COMMENT_CHANGED_PROPERTY = "trackComments";
    public static final String TRACK_FACTOR_CHANGED_PROPERTY = "trackReservationFactor";
    protected Reporter _reader = null;
    public static final String TRAIN_SCHEDULE = "trainSchedule";
    public static final String ALL = "all";
    private static final Logger log = LoggerFactory.getLogger(Track.class);

    public Track(String id, String name, String type, Location location) {
        log.debug("New ({}) track ({}) id: {}", new Object[]{type, name, id});
        this._location = location;
        this._trackType = type;
        this._name = name;
        this._id = id;
        this.setTypeNames(InstanceManager.getDefault(CarTypes.class).getNames());
        this.setTypeNames(InstanceManager.getDefault(EngineTypes.class).getNames());
    }

    public Track copyTrack(String newName, Location newLocation) {
        Track newTrack = newLocation.addTrack(newName, this.getTrackType());
        newTrack.clearTypeNames();
        newTrack.setAddCustomLoadsAnySpurEnabled(this.isAddCustomLoadsAnySpurEnabled());
        newTrack.setAddCustomLoadsAnyStagingTrackEnabled(this.isAddCustomLoadsAnyStagingTrackEnabled());
        newTrack.setAddCustomLoadsEnabled(this.isAddCustomLoadsEnabled());
        newTrack.setAlternateTrack(this.getAlternateTrack());
        newTrack.setBlockCarsEnabled(this.isBlockCarsEnabled());
        newTrack.setComment(this.getComment());
        newTrack.setCommentBoth(this.getCommentBothWithColor());
        newTrack.setCommentPickup(this.getCommentPickupWithColor());
        newTrack.setCommentSetout(this.getCommentSetoutWithColor());
        newTrack.setDestinationOption(this.getDestinationOption());
        newTrack.setDestinationIds(this.getDestinationIds());
        newTrack.setDropOption(this.getDropOption());
        newTrack.setDropIds(this.getDropIds());
        newTrack.setIgnoreUsedLengthPercentage(this.getIgnoreUsedLengthPercentage());
        newTrack.setLength(this.getLength());
        newTrack.setLoadEmptyEnabled(this.isLoadEmptyEnabled());
        newTrack.setLoadNames(this.getLoadNames());
        newTrack.setLoadOption(this.getLoadOption());
        newTrack.setLoadSwapEnabled(this.isLoadSwapEnabled());
        newTrack.setOnlyCarsWithFinalDestinationEnabled(this.isOnlyCarsWithFinalDestinationEnabled());
        newTrack.setPickupOption(this.getPickupOption());
        newTrack.setPickupIds(this.getPickupIds());
        if (this.getPool() != null) {
            newTrack.setPool(newLocation.addPool(this.getPool().getName()));
            newTrack.setMinimumLength(this.getMinimumLength());
        }
        newTrack.setPrintManifestCommentEnabled(this.isPrintManifestCommentEnabled());
        newTrack.setPrintSwitchListCommentEnabled(this.isPrintSwitchListCommentEnabled());
        newTrack.setRemoveCustomLoadsEnabled(this.isRemoveCustomLoadsEnabled());
        newTrack.setReservationFactor(this.getReservationFactor());
        newTrack.setRoadNames(this.getRoadNames());
        newTrack.setRoadOption(this.getRoadOption());
        newTrack.setSchedule(this.getSchedule());
        newTrack.setScheduleMode(this.getScheduleMode());
        newTrack.setServiceOrder(this.getServiceOrder());
        newTrack.setShipLoadNames(this.getShipLoadNames());
        newTrack.setShipLoadOption(this.getShipLoadOption());
        newTrack.setTrainDirections(this.getTrainDirections());
        newTrack.setTypeNames(this.getTypeNames());
        newTrack.setDisableLoadChangeEnabled(this.isDisableLoadChangeEnabled());
        newTrack.setQuickServiceEnabled(this.isQuickServiceEnabled());
        newTrack.setHoldCarsWithCustomLoadsEnabled(this.isHoldCarsWithCustomLoadsEnabled());
        return newTrack;
    }

    public String toString() {
        return this._name;
    }

    public String getId() {
        return this._id;
    }

    public Location getLocation() {
        return this._location;
    }

    public void setName(String name) {
        String old = this._name;
        this._name = name;
        if (!old.equals(name)) {
            InstanceManager.getDefault(LocationManager.class).resetNameLengths();
            this.setDirtyAndFirePropertyChange(NAME_CHANGED_PROPERTY, old, name);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getSplitName() {
        return TrainCommon.splitString(this.getName());
    }

    public Division getDivision() {
        return this.getLocation().getDivision();
    }

    public String getDivisionName() {
        return this.getLocation().getDivisionName();
    }

    public boolean isSpur() {
        return this.getTrackType().equals(SPUR);
    }

    public boolean isYard() {
        return this.getTrackType().equals(YARD);
    }

    public boolean isInterchange() {
        return this.getTrackType().equals(INTERCHANGE);
    }

    public boolean isStaging() {
        return this.getTrackType().equals(STAGING);
    }

    public boolean hasMessages() {
        return !this.getCommentBoth().isBlank() || !this.getCommentPickup().isBlank() || !this.getCommentSetout().isBlank();
    }

    public String getTrackType() {
        return this._trackType;
    }

    public void setTrackType(String type) {
        String old = this._trackType;
        this._trackType = type;
        if (!old.equals(type)) {
            this.setDirtyAndFirePropertyChange(TRACK_TYPE_CHANGED_PROPERTY, old, type);
        }
    }

    public String getTrackTypeName() {
        return Track.getTrackTypeName(this.getTrackType());
    }

    public static String getTrackTypeName(String trackType) {
        if (trackType.equals(SPUR)) {
            return Bundle.getMessage(SPUR).toLowerCase();
        }
        if (trackType.equals(YARD)) {
            return Bundle.getMessage(YARD).toLowerCase();
        }
        if (trackType.equals(INTERCHANGE)) {
            return Bundle.getMessage("Class/Interchange");
        }
        if (trackType.equals(STAGING)) {
            return Bundle.getMessage(STAGING).toLowerCase();
        }
        return "unknown";
    }

    public void setLength(int length) {
        int old = this._length;
        this._length = length;
        if (old != length) {
            this.setDirtyAndFirePropertyChange(LENGTH_CHANGED_PROPERTY, Integer.toString(old), Integer.toString(length));
        }
    }

    public int getLength() {
        return this._length;
    }

    public void setMinimumLength(int length) {
        int old = this._minimumLength;
        this._minimumLength = length;
        if (old != length) {
            this.setDirtyAndFirePropertyChange(MIN_LENGTH_CHANGED_PROPERTY, Integer.toString(old), Integer.toString(length));
        }
    }

    public int getMinimumLength() {
        return this._minimumLength;
    }

    public void setReserved(int reserved) {
        int old = this._reserved;
        this._reserved = reserved;
        if (old != reserved) {
            this.setDirtyAndFirePropertyChange("trackReserved", Integer.toString(old), Integer.toString(reserved));
        }
    }

    public int getReserved() {
        return this._reserved;
    }

    public void addReservedInRoute(Car car) {
        int old = this._reservedEnRoute;
        ++this._numberCarsEnRoute;
        this._reservedEnRoute = old + car.getTotalLength();
        if (old != this._reservedEnRoute) {
            this.setDirtyAndFirePropertyChange("trackAddReservedInRoute", Integer.toString(old), Integer.toString(this._reservedEnRoute));
        }
    }

    public void deleteReservedInRoute(Car car) {
        int old = this._reservedEnRoute;
        --this._numberCarsEnRoute;
        this._reservedEnRoute = old - car.getTotalLength();
        if (old != this._reservedEnRoute) {
            this.setDirtyAndFirePropertyChange("trackDeleteReservedInRoute", Integer.toString(old), Integer.toString(this._reservedEnRoute));
        }
    }

    public int getReservedInRoute() {
        return this._reservedEnRoute;
    }

    public int getNumberOfCarsInRoute() {
        return this._numberCarsEnRoute;
    }

    public void setReservationFactor(int factor) {
        int old = this._reservationFactor;
        this._reservationFactor = factor;
        if (old != factor) {
            this.setDirtyAndFirePropertyChange(TRACK_FACTOR_CHANGED_PROPERTY, old, factor);
        }
    }

    public int getReservationFactor() {
        return this._reservationFactor;
    }

    public void setScheduleMode(int mode) {
        int old = this._mode;
        this._mode = mode;
        if (old != mode) {
            this.setDirtyAndFirePropertyChange(SCHEDULE_MODE_CHANGED_PROPERTY, old, mode);
        }
    }

    public int getScheduleMode() {
        return this._mode;
    }

    public String getScheduleModeName() {
        if (this.getScheduleMode() == 1) {
            return Bundle.getMessage("Match");
        }
        return Bundle.getMessage("Sequential");
    }

    public void setAlternateTrack(Track track) {
        Track oldTrack = this._location.getTrackById(this._alternateTrackId);
        String old = this._alternateTrackId;
        this._alternateTrackId = track != null ? track.getId() : "";
        if (!old.equals(this._alternateTrackId)) {
            this.setDirtyAndFirePropertyChange(ALTERNATE_TRACK_CHANGED_PROPERTY, oldTrack, track);
        }
    }

    public Track getAlternateTrack() {
        if (!this.isSpur()) {
            return null;
        }
        return this._location.getTrackById(this._alternateTrackId);
    }

    public void setHoldCarsWithCustomLoadsEnabled(boolean enable) {
        boolean old = this._holdCustomLoads;
        this._holdCustomLoads = enable;
        this.setDirtyAndFirePropertyChange(HOLD_CARS_CHANGED_PROPERTY, old, enable);
    }

    public boolean isHoldCarsWithCustomLoadsEnabled() {
        return this._holdCustomLoads;
    }

    public boolean isSpaceAvailable(Car car) {
        int carLength = car.getTotalKernelLength();
        int trackLength = this.getLength();
        if (trackLength < carLength && this.getPool() == null) {
            return false;
        }
        if (this.getPool() != null && this.getPool().getMaxLengthTrack(this) < carLength) {
            return false;
        }
        if (car.getTrack() != null && car.getTrack().isStaging()) {
            return this.getLength() * this.getReservationFactor() / 100 - (this.getReservedInRoute() + carLength) >= 0;
        }
        if (this.getAlternateTrack() != null) {
            trackLength += this.getAlternateTrack().getLength();
        }
        return trackLength - (this.getReservedInRoute() + carLength) >= 0;
    }

    public void setUsedLength(int length) {
        int old = this._usedLength;
        this._usedLength = length;
        if (old != length) {
            this.setDirtyAndFirePropertyChange("trackUsedLength", Integer.toString(old), Integer.toString(length));
        }
    }

    public int getUsedLength() {
        return this._usedLength;
    }

    public void setIgnoreUsedLengthPercentage(int percentage) {
        int old = this._ignoreUsedLengthPercentage;
        this._ignoreUsedLengthPercentage = percentage;
        if (old != percentage) {
            this.setDirtyAndFirePropertyChange(PLANNED_PICKUPS_CHANGED_PROPERTY, Integer.toString(old), Integer.toString(percentage));
        }
    }

    public int getIgnoreUsedLengthPercentage() {
        return this._ignoreUsedLengthPercentage;
    }

    private void setNumberRS(int number) {
        int old = this._numberRS;
        this._numberRS = number;
        if (old != number) {
            this.setDirtyAndFirePropertyChange("trackNumberRS", Integer.toString(old), Integer.toString(number));
        }
    }

    private void setNumberCars(int number) {
        int old = this._numberCars;
        this._numberCars = number;
        if (old != number) {
            this.setDirtyAndFirePropertyChange("trackNumberCars", Integer.toString(old), Integer.toString(number));
        }
    }

    private void setNumberEngines(int number) {
        int old = this._numberEngines;
        this._numberEngines = number;
        if (old != number) {
            this.setDirtyAndFirePropertyChange("trackNumberEngines", Integer.toString(old), Integer.toString(number));
        }
    }

    public int getNumberRS() {
        return this._numberRS;
    }

    public int getNumberCars() {
        return this._numberCars;
    }

    public int getNumberEngines() {
        return this._numberEngines;
    }

    public void addRS(RollingStock rs) {
        this.setNumberRS(this.getNumberRS() + 1);
        if (rs.getClass() == Car.class) {
            this.setNumberCars(this.getNumberCars() + 1);
        } else if (rs.getClass() == Engine.class) {
            this.setNumberEngines(this.getNumberEngines() + 1);
        }
        this.setUsedLength(this.getUsedLength() + rs.getTotalLength());
    }

    public void deleteRS(RollingStock rs) {
        this.setNumberRS(this.getNumberRS() - 1);
        if (rs.getClass() == Car.class) {
            this.setNumberCars(this.getNumberCars() - 1);
        } else if (rs.getClass() == Engine.class) {
            this.setNumberEngines(this.getNumberEngines() - 1);
        }
        this.setUsedLength(this.getUsedLength() - rs.getTotalLength());
    }

    public void addPickupRS(RollingStock rs) {
        int old = this._pickupRS++;
        if (Setup.isBuildAggressive()) {
            this.setReserved(this.getReserved() - rs.getTotalLength());
        }
        this.setDirtyAndFirePropertyChange("trackPickupRS", Integer.toString(old), Integer.toString(this._pickupRS));
    }

    public void deletePickupRS(RollingStock rs) {
        int old = this._pickupRS;
        if (Setup.isBuildAggressive()) {
            this.setReserved(this.getReserved() + rs.getTotalLength());
        }
        --this._pickupRS;
        this.setDirtyAndFirePropertyChange("trackDeletePickupRS", Integer.toString(old), Integer.toString(this._pickupRS));
    }

    public int getPickupRS() {
        return this._pickupRS;
    }

    public int getDropRS() {
        return this._dropRS;
    }

    public void addDropRS(RollingStock rs) {
        int old = this._dropRS++;
        this.bumpMoves();
        this.setReserved(this.getReserved() + rs.getTotalLength());
        this._reservedLengthDrops += rs.getTotalLength();
        this.setDirtyAndFirePropertyChange("trackAddDropRS", Integer.toString(old), Integer.toString(this._dropRS));
    }

    public void deleteDropRS(RollingStock rs) {
        int old = this._dropRS--;
        this.setReserved(this.getReserved() - rs.getTotalLength());
        this._reservedLengthDrops -= rs.getTotalLength();
        this.setDirtyAndFirePropertyChange("trackDeleteDropRS", Integer.toString(old), Integer.toString(this._dropRS));
    }

    public void setComment(String comment) {
        String old = this._comment;
        this._comment = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange("trackComment", old, comment);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public void setCommentPickup(String comment) {
        String old = this._commentPickup;
        this._commentPickup = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange(TRACK_COMMENT_CHANGED_PROPERTY, old, comment);
        }
    }

    public String getCommentPickup() {
        return TrainCommon.getTextColorString(this.getCommentPickupWithColor());
    }

    public String getCommentPickupWithColor() {
        return this._commentPickup;
    }

    public void setCommentSetout(String comment) {
        String old = this._commentSetout;
        this._commentSetout = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange(TRACK_COMMENT_CHANGED_PROPERTY, old, comment);
        }
    }

    public String getCommentSetout() {
        return TrainCommon.getTextColorString(this.getCommentSetoutWithColor());
    }

    public String getCommentSetoutWithColor() {
        return this._commentSetout;
    }

    public void setCommentBoth(String comment) {
        String old = this._commentBoth;
        this._commentBoth = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange(TRACK_COMMENT_CHANGED_PROPERTY, old, comment);
        }
    }

    public String getCommentBoth() {
        return TrainCommon.getTextColorString(this.getCommentBothWithColor());
    }

    public String getCommentBothWithColor() {
        return this._commentBoth;
    }

    public boolean isPrintManifestCommentEnabled() {
        return this._printCommentManifest;
    }

    public void setPrintManifestCommentEnabled(boolean enable) {
        boolean old = this.isPrintManifestCommentEnabled();
        this._printCommentManifest = enable;
        this.setDirtyAndFirePropertyChange("trackPrintManifestComment", old, enable);
    }

    public boolean isPrintSwitchListCommentEnabled() {
        return this._printCommentSwitchList;
    }

    public void setPrintSwitchListCommentEnabled(boolean enable) {
        boolean old = this.isPrintSwitchListCommentEnabled();
        this._printCommentSwitchList = enable;
        this.setDirtyAndFirePropertyChange("trackPrintSwitchListComment", old, enable);
    }

    public String[] getTypeNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (String typeName : this._typeList) {
            if (!this._location.acceptsTypeName(typeName)) continue;
            list.add(typeName);
        }
        return list.toArray(new String[0]);
    }

    private void setTypeNames(String[] types) {
        if (types.length > 0) {
            Arrays.sort(types);
            for (String type : types) {
                if (this._typeList.contains(type)) continue;
                this._typeList.add(type);
            }
        }
    }

    private void clearTypeNames() {
        this._typeList.clear();
    }

    public void addTypeName(String type) {
        if (type == null || this._typeList.contains(type)) {
            return;
        }
        this._typeList.add(0, type);
        log.debug("Track ({}) add rolling stock type ({})", (Object)this.getName(), (Object)type);
        this.setDirtyAndFirePropertyChange(TYPES_CHANGED_PROPERTY, this._typeList.size() - 1, this._typeList.size());
    }

    public void deleteTypeName(String type) {
        if (this._typeList.remove(type)) {
            log.debug("Track ({}) delete rolling stock type ({})", (Object)this.getName(), (Object)type);
            this.setDirtyAndFirePropertyChange(TYPES_CHANGED_PROPERTY, this._typeList.size() + 1, this._typeList.size());
        }
    }

    public boolean isTypeNameAccepted(String type) {
        if (!this._location.acceptsTypeName(type)) {
            return false;
        }
        return this._typeList.contains(type);
    }

    public void setTrainDirections(int direction) {
        int old = this._trainDir;
        this._trainDir = direction;
        if (old != direction) {
            this.setDirtyAndFirePropertyChange(TRAIN_DIRECTION_CHANGED_PROPERTY, Integer.toString(old), Integer.toString(direction));
        }
    }

    public int getTrainDirections() {
        return this._trainDir;
    }

    public String getRoadOption() {
        return this._roadOption;
    }

    public String getRoadOptionString() {
        Object s = this.getRoadOption().equals(INCLUDE_ROADS) ? Bundle.getMessage("AcceptOnly") + " " + this.getRoadNames().length + " " + Bundle.getMessage("Roads") : (this.getRoadOption().equals(EXCLUDE_ROADS) ? Bundle.getMessage("Exclude") + " " + this.getRoadNames().length + " " + Bundle.getMessage("Roads") : Bundle.getMessage("AcceptsAllRoads"));
        return s;
    }

    public void setRoadOption(String option) {
        String old = this._roadOption;
        this._roadOption = option;
        this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, old, option);
    }

    public String[] getRoadNames() {
        Object[] roads = this._roadList.toArray(new String[0]);
        if (this._roadList.size() > 0) {
            Arrays.sort(roads);
        }
        return roads;
    }

    private void setRoadNames(String[] roads) {
        if (roads.length > 0) {
            Arrays.sort(roads);
            for (String roadName : roads) {
                if (roadName.equals("")) continue;
                this._roadList.add(roadName);
            }
        }
    }

    public void addRoadName(String road) {
        if (!this._roadList.contains(road)) {
            this._roadList.add(road);
            log.debug("Track ({}) add car road ({})", (Object)this.getName(), (Object)road);
            this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, this._roadList.size() - 1, this._roadList.size());
        }
    }

    public void deleteRoadName(String road) {
        if (this._roadList.remove(road)) {
            log.debug("Track ({}) delete car road ({})", (Object)this.getName(), (Object)road);
            this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, this._roadList.size() + 1, this._roadList.size());
        }
    }

    public boolean isRoadNameAccepted(String road) {
        if (this._roadOption.equals(ALL_ROADS)) {
            return true;
        }
        if (this._roadOption.equals(INCLUDE_ROADS)) {
            return this._roadList.contains(road);
        }
        return !this._roadList.contains(road);
    }

    public boolean containsRoadName(String road) {
        return this._roadList.contains(road);
    }

    public String getLoadOption() {
        return this._loadOption;
    }

    public String getLoadOptionString() {
        Object s = this.getLoadOption().equals(INCLUDE_LOADS) ? Bundle.getMessage("AcceptOnly") + " " + this.getLoadNames().length + " " + Bundle.getMessage("Loads") : (this.getLoadOption().equals(EXCLUDE_LOADS) ? Bundle.getMessage("Exclude") + " " + this.getLoadNames().length + " " + Bundle.getMessage("Loads") : Bundle.getMessage("AcceptsAllLoads"));
        return s;
    }

    public void setLoadOption(String option) {
        String old = this._loadOption;
        this._loadOption = option;
        this.setDirtyAndFirePropertyChange(LOADS_CHANGED_PROPERTY, old, option);
    }

    private void setLoadNames(String[] loads) {
        if (loads.length > 0) {
            Arrays.sort(loads);
            for (String loadName : loads) {
                if (loadName.equals("")) continue;
                this._loadList.add(loadName);
            }
        }
    }

    public String[] getLoadNames() {
        Object[] loads = this._loadList.toArray(new String[0]);
        if (this._loadList.size() > 0) {
            Arrays.sort(loads);
        }
        return loads;
    }

    public void addLoadName(String load) {
        if (!this._loadList.contains(load)) {
            this._loadList.add(load);
            log.debug("track ({}) add car load ({})", (Object)this.getName(), (Object)load);
            this.setDirtyAndFirePropertyChange(LOADS_CHANGED_PROPERTY, this._loadList.size() - 1, this._loadList.size());
        }
    }

    public void deleteLoadName(String load) {
        if (this._loadList.remove(load)) {
            log.debug("track ({}) delete car load ({})", (Object)this.getName(), (Object)load);
            this.setDirtyAndFirePropertyChange(LOADS_CHANGED_PROPERTY, this._loadList.size() + 1, this._loadList.size());
        }
    }

    public boolean isLoadNameAccepted(String load) {
        if (this._loadOption.equals(ALL_LOADS)) {
            return true;
        }
        if (this._loadOption.equals(INCLUDE_LOADS)) {
            return this._loadList.contains(load);
        }
        return !this._loadList.contains(load);
    }

    public boolean isLoadNameAndCarTypeAccepted(String load, String type) {
        if (this._loadOption.equals(ALL_LOADS)) {
            return true;
        }
        if (this._loadOption.equals(INCLUDE_LOADS)) {
            return this._loadList.contains(load) || this._loadList.contains(type + " & " + load);
        }
        return !this._loadList.contains(load) && !this._loadList.contains(type + " & " + load);
    }

    public String getShipLoadOption() {
        if (!this.isStaging()) {
            return ALL_LOADS;
        }
        return this._shipLoadOption;
    }

    public String getShipLoadOptionString() {
        Object s = this.getShipLoadOption().equals(INCLUDE_LOADS) ? Bundle.getMessage("ShipOnly") + " " + this.getShipLoadNames().length + " " + Bundle.getMessage("Loads") : (this.getShipLoadOption().equals(EXCLUDE_LOADS) ? Bundle.getMessage("Exclude") + " " + this.getShipLoadNames().length + " " + Bundle.getMessage("Loads") : Bundle.getMessage("ShipsAllLoads"));
        return s;
    }

    public void setShipLoadOption(String option) {
        String old = this._shipLoadOption;
        this._shipLoadOption = option;
        this.setDirtyAndFirePropertyChange(LOADS_CHANGED_PROPERTY, old, option);
    }

    private void setShipLoadNames(String[] loads) {
        if (loads.length > 0) {
            Arrays.sort(loads);
            for (String shipLoadName : loads) {
                if (shipLoadName.equals("")) continue;
                this._shipLoadList.add(shipLoadName);
            }
        }
    }

    public String[] getShipLoadNames() {
        Object[] loads = this._shipLoadList.toArray(new String[0]);
        if (this._shipLoadList.size() > 0) {
            Arrays.sort(loads);
        }
        return loads;
    }

    public void addShipLoadName(String load) {
        if (!this._shipLoadList.contains(load)) {
            this._shipLoadList.add(load);
            log.debug("track ({}) add car load ({})", (Object)this.getName(), (Object)load);
            this.setDirtyAndFirePropertyChange(LOADS_CHANGED_PROPERTY, this._shipLoadList.size() - 1, this._shipLoadList.size());
        }
    }

    public void deleteShipLoadName(String load) {
        if (this._shipLoadList.remove(load)) {
            log.debug("track ({}) delete car load ({})", (Object)this.getName(), (Object)load);
            this.setDirtyAndFirePropertyChange(LOADS_CHANGED_PROPERTY, this._shipLoadList.size() + 1, this._shipLoadList.size());
        }
    }

    public boolean isLoadNameShipped(String load) {
        if (this._shipLoadOption.equals(ALL_LOADS)) {
            return true;
        }
        if (this._shipLoadOption.equals(INCLUDE_LOADS)) {
            return this._shipLoadList.contains(load);
        }
        return !this._shipLoadList.contains(load);
    }

    public boolean isLoadNameAndCarTypeShipped(String load, String type) {
        if (this._shipLoadOption.equals(ALL_LOADS)) {
            return true;
        }
        if (this._shipLoadOption.equals(INCLUDE_LOADS)) {
            return this._shipLoadList.contains(load) || this._shipLoadList.contains(type + " & " + load);
        }
        return !this._shipLoadList.contains(load) && !this._shipLoadList.contains(type + " & " + load);
    }

    public String getDropOption() {
        if (this.isYard()) {
            return ANY;
        }
        return this._dropOption;
    }

    public void setDropOption(String option) {
        String old = this._dropOption;
        this._dropOption = option;
        if (!old.equals(option)) {
            this._dropList.clear();
        }
        this.setDirtyAndFirePropertyChange(DROP_CHANGED_PROPERTY, old, option);
    }

    public String getPickupOption() {
        if (this.isYard()) {
            return ANY;
        }
        return this._pickupOption;
    }

    public void setPickupOption(String option) {
        String old = this._pickupOption;
        this._pickupOption = option;
        if (!old.equals(option)) {
            this._pickupList.clear();
        }
        this.setDirtyAndFirePropertyChange(PICKUP_CHANGED_PROPERTY, old, option);
    }

    public String[] getDropIds() {
        return this._dropList.toArray(new String[0]);
    }

    private void setDropIds(String[] ids) {
        for (String id : ids) {
            if (id == null) continue;
            this._dropList.add(id);
        }
    }

    public void addDropId(String id) {
        if (!this._dropList.contains(id)) {
            this._dropList.add(id);
            log.debug("Track ({}) add drop id: {}", (Object)this.getName(), (Object)id);
            this.setDirtyAndFirePropertyChange(DROP_CHANGED_PROPERTY, null, id);
        }
    }

    public void deleteDropId(String id) {
        if (this._dropList.remove(id)) {
            log.debug("Track ({}) delete drop id: {}", (Object)this.getName(), (Object)id);
            this.setDirtyAndFirePropertyChange(DROP_CHANGED_PROPERTY, id, null);
        }
    }

    public boolean isDropTrainAccepted(Train train) {
        if (this.getDropOption().equals(ANY)) {
            return true;
        }
        if (this.getDropOption().equals(TRAINS)) {
            return this.containsDropId(train.getId());
        }
        if (this.getDropOption().equals(EXCLUDE_TRAINS)) {
            return !this.containsDropId(train.getId());
        }
        if (train.getRoute() == null) {
            return false;
        }
        return this.isDropRouteAccepted(train.getRoute());
    }

    public boolean isDropRouteAccepted(Route route) {
        if (this.getDropOption().equals(ANY) || this.getDropOption().equals(TRAINS) || this.getDropOption().equals(EXCLUDE_TRAINS)) {
            return true;
        }
        if (this.getDropOption().equals(EXCLUDE_ROUTES)) {
            return !this.containsDropId(route.getId());
        }
        return this.containsDropId(route.getId());
    }

    public boolean containsDropId(String id) {
        return this._dropList.contains(id);
    }

    public String[] getPickupIds() {
        return this._pickupList.toArray(new String[0]);
    }

    private void setPickupIds(String[] ids) {
        for (String id : ids) {
            if (id == null) continue;
            this._pickupList.add(id);
        }
    }

    public void addPickupId(String id) {
        if (!this._pickupList.contains(id)) {
            this._pickupList.add(id);
            log.debug("track ({}) add pick up id {}", (Object)this.getName(), (Object)id);
            this.setDirtyAndFirePropertyChange(PICKUP_CHANGED_PROPERTY, null, id);
        }
    }

    public void deletePickupId(String id) {
        if (this._pickupList.remove(id)) {
            log.debug("track ({}) delete pick up id {}", (Object)this.getName(), (Object)id);
            this.setDirtyAndFirePropertyChange(PICKUP_CHANGED_PROPERTY, id, null);
        }
    }

    public boolean isPickupTrainAccepted(Train train) {
        if (this.getPickupOption().equals(ANY)) {
            return true;
        }
        if (this.getPickupOption().equals(TRAINS)) {
            return this.containsPickupId(train.getId());
        }
        if (this.getPickupOption().equals(EXCLUDE_TRAINS)) {
            return !this.containsPickupId(train.getId());
        }
        if (train.getRoute() == null) {
            return false;
        }
        return this.isPickupRouteAccepted(train.getRoute());
    }

    public boolean isPickupRouteAccepted(Route route) {
        if (this.getPickupOption().equals(ANY) || this.getPickupOption().equals(TRAINS) || this.getPickupOption().equals(EXCLUDE_TRAINS)) {
            return true;
        }
        if (this.getPickupOption().equals(EXCLUDE_ROUTES)) {
            return !this.containsPickupId(route.getId());
        }
        return this.containsPickupId(route.getId());
    }

    public boolean containsPickupId(String id) {
        return this._pickupList.contains(id);
    }

    public String checkPickups() {
        String status = "";
        block0: for (String carType : InstanceManager.getDefault(CarTypes.class).getNames()) {
            if (!this.isTypeNameAccepted(carType)) continue;
            for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByNameList()) {
                Route route;
                if (!train.isTypeNameAccepted(carType) || !this.isPickupTrainAccepted(train) || (route = train.getRoute()) == null) continue;
                for (RouteLocation rLoc : route.getLocationsBySequenceList()) {
                    if (!rLoc.getName().equals(this.getLocation().getName()) || !rLoc.isPickUpAllowed() || rLoc.getMaxCarMoves() <= 0 || train.isLocationSkipped(rLoc) || (this.getTrainDirections() & rLoc.getTrainDirection()) == 0 && !train.isLocalSwitcher() || (this.getLocation().getTrainDirections() & rLoc.getTrainDirection()) == 0 && !train.isLocalSwitcher()) continue;
                    continue block0;
                }
            }
            status = Bundle.getMessage("ErrorNoTrain", this.getName(), carType);
            break;
        }
        return status;
    }

    public String isRollingStockAccepted(RollingStock rs) {
        Engine eng;
        if (!this.isTypeNameAccepted(rs.getTypeName())) {
            log.debug("Rolling stock ({}) type ({}) not accepted at location ({}, {}) wrong type", new Object[]{rs.toString(), rs.getTypeName(), this.getLocation().getName(), this.getName()});
            return TYPE + " (" + rs.getTypeName() + ")";
        }
        if (!this.isRoadNameAccepted(rs.getRoadName())) {
            log.debug("Rolling stock ({}) road ({}) not accepted at location ({}, {}) wrong road", new Object[]{rs.toString(), rs.getRoadName(), this.getLocation().getName(), this.getName()});
            return ROAD + " (" + rs.getRoadName() + ")";
        }
        int rsLength = rs.getTotalLength();
        try {
            Integer.parseInt(rs.getLength());
        }
        catch (Exception e) {
            return LENGTH + " (" + rs.getLength() + ")";
        }
        if (Car.class.isInstance(rs)) {
            Car car = (Car)rs;
            if (!this.isDestinationAccepted(car.getFinalDestination())) {
                return DESTINATION + " (" + car.getFinalDestinationName() + ") " + Bundle.getMessage("carIsNotAllowed", this.getName());
            }
            if (this.isOnlyCarsWithFinalDestinationEnabled() && car.getFinalDestination() == null && !car.isCaboose() && !car.hasFred()) {
                return NO_FINAL_DESTINATION;
            }
            if (car.isLead()) {
                rsLength = car.getKernel().getTotalLength();
            }
            if (!this.isLoadNameAndCarTypeAccepted(car.getLoadName(), car.getTypeName())) {
                log.debug("Car ({}) load ({}) not accepted at location ({}, {})", new Object[]{rs.toString(), car.getLoadName(), this.getLocation(), this.getName()});
                return LOAD + " (" + car.getLoadName() + ")";
            }
        }
        if (Engine.class.isInstance(rs) && (eng = (Engine)rs).isLead()) {
            rsLength = eng.getConsist().getTotalLength();
        }
        if (rs.getTrack() != this && rs.getDestinationTrack() != this && this.getUsedLength() + this.getReserved() + rsLength > this.getLength()) {
            if (this.getPool() != null && this.getPool().requestTrackLength(this, rsLength)) {
                return OKAY;
            }
            if (this.checkPlannedPickUps(rsLength)) {
                return OKAY;
            }
            if (this.getLength() < rsLength && this.getPool() == null || this.getPool() != null && this.getPool().getTotalLengthTracks() < rsLength) {
                return Bundle.getMessage("capacityIssue", CAPACITY, rsLength, Setup.getLengthUnit().toLowerCase(), this.getLength());
            }
            log.debug("Rolling stock ({}) not accepted at location ({}, {}) no room!", new Object[]{rs.toString(), this.getLocation().getName(), this.getName()});
            return Bundle.getMessage("lengthIssue", LENGTH, rsLength, Setup.getLengthUnit().toLowerCase(), this.getAvailableTrackSpace(), this.getLength());
        }
        return OKAY;
    }

    private boolean checkPlannedPickUps(int length) {
        return this.getIgnoreUsedLengthPercentage() > 0 && this.getAvailableTrackSpace() >= length;
    }

    public int getAvailableTrackSpace() {
        int available2;
        int available = this.getLength() - (this.getUsedLength() * (100 - this.getIgnoreUsedLengthPercentage()) / 100 + this.getReserved());
        int available3 = this.getLength() + this.getLength() * this.getIgnoreUsedLengthPercentage() / 100 - this.getUsedLength() - this.getReserved();
        if (available3 < available) {
            available = available3;
        }
        if ((available2 = this.getLength() - this.getReservedLengthDrops()) < available) {
            available = available2;
        }
        return available;
    }

    public int getReservedLengthDrops() {
        return this._reservedLengthDrops;
    }

    public int getMoves() {
        return this._moves;
    }

    public void setMoves(int moves) {
        int old = this._moves;
        this._moves = moves;
        this.setDirtyAndFirePropertyChange("trackMoves", old, moves);
    }

    public void bumpMoves() {
        this.setMoves(this.getMoves() + 1);
    }

    public int getBlockingOrder() {
        return this._blockingOrder;
    }

    public void setBlockingOrder(int order) {
        int old = this._blockingOrder;
        this._blockingOrder = order;
        this.setDirtyAndFirePropertyChange(TRACK_BLOCKING_ORDER_CHANGED_PROPERTY, old, order);
    }

    public String getServiceOrder() {
        if (this.isSpur() || this.isStaging() && this.getPool() == null) {
            return NORMAL;
        }
        return this._order;
    }

    public void setServiceOrder(String order) {
        String old = this._order;
        this._order = order;
        this.setDirtyAndFirePropertyChange(SERVICE_ORDER_CHANGED_PROPERTY, old, order);
    }

    public String getScheduleName() {
        if (this.getScheduleId().equals("")) {
            return "";
        }
        Schedule schedule = this.getSchedule();
        if (schedule == null) {
            log.error("No name schedule for id: {}", (Object)this.getScheduleId());
            return "";
        }
        return schedule.getName();
    }

    public Schedule getSchedule() {
        if (this.getScheduleId().equals("")) {
            return null;
        }
        Schedule schedule = InstanceManager.getDefault(ScheduleManager.class).getScheduleById(this.getScheduleId());
        if (schedule == null) {
            log.error("No schedule for id: {}", (Object)this.getScheduleId());
        }
        return schedule;
    }

    public void setSchedule(Schedule schedule) {
        String scheduleId = "";
        if (schedule != null) {
            scheduleId = schedule.getId();
        }
        this.setScheduleId(scheduleId);
    }

    public String getScheduleId() {
        if (!this.isSpur()) {
            return "";
        }
        if (this._scheduleId.equals("") && !this._scheduleName.equals("")) {
            Schedule schedule = InstanceManager.getDefault(ScheduleManager.class).getScheduleByName(this._scheduleName);
            if (schedule == null) {
                log.error("No schedule for name: {}", (Object)this._scheduleName);
            } else {
                this._scheduleId = schedule.getId();
            }
        }
        return this._scheduleId;
    }

    public void setScheduleId(String id) {
        String old = this._scheduleId;
        this._scheduleId = id;
        if (!old.equals(id)) {
            Schedule schedule = InstanceManager.getDefault(ScheduleManager.class).getScheduleById(id);
            if (schedule == null) {
                this._scheduleName = "";
            } else {
                if (schedule.getItemsBySequenceList().size() > 0) {
                    this.setScheduleItemId(schedule.getItemsBySequenceList().get(0).getId());
                }
                this.setScheduleCount(0);
            }
            this.setDirtyAndFirePropertyChange(SCHEDULE_ID_CHANGED_PROPERTY, old, id);
        }
    }

    public String getScheduleItemId() {
        return this._scheduleItemId;
    }

    public void setScheduleItemId(String id) {
        log.debug("Set schedule item id ({}) for track ({})", (Object)id, (Object)this.getName());
        String old = this._scheduleItemId;
        this._scheduleItemId = id;
        this.setDirtyAndFirePropertyChange(SCHEDULE_CHANGED_PROPERTY, old, id);
    }

    public ScheduleItem getCurrentScheduleItem() {
        Schedule sch = this.getSchedule();
        if (sch == null) {
            log.debug("Can not find schedule id: ({}) assigned to track ({})", (Object)this.getScheduleId(), (Object)this.getName());
            return null;
        }
        ScheduleItem currentSi = sch.getItemById(this.getScheduleItemId());
        if (currentSi == null && sch.getSize() > 0) {
            log.debug("Can not find schedule item id: ({}) for schedule ({})", (Object)this.getScheduleItemId(), (Object)this.getScheduleName());
            this.setScheduleItemId(sch.getItemsBySequenceList().get(0).getId());
            currentSi = sch.getItemById(this.getScheduleItemId());
        }
        return currentSi;
    }

    public void bumpSchedule() {
        if (this.getSchedule() != null && this.getScheduleMode() == 0) {
            this.setScheduleCount(this.getScheduleCount() + 1);
            if (this.getScheduleCount() >= this.getCurrentScheduleItem().getCount()) {
                this.setScheduleCount(0);
                this.getNextScheduleItem();
            }
        }
    }

    public ScheduleItem getNextScheduleItem() {
        Schedule sch = this.getSchedule();
        if (sch == null) {
            log.warn("Can not find schedule ({}) assigned to track ({})", (Object)this.getScheduleId(), (Object)this.getName());
            return null;
        }
        List<ScheduleItem> items = sch.getItemsBySequenceList();
        ScheduleItem nextSi = null;
        for (int i = 0; i < items.size(); ++i) {
            nextSi = items.get(i);
            if (this.getCurrentScheduleItem() != nextSi) continue;
            nextSi = ++i < items.size() ? items.get(i) : items.get(0);
            this.setScheduleItemId(nextSi.getId());
            break;
        }
        return nextSi;
    }

    public int getScheduleCount() {
        return this._scheduleCount;
    }

    public void setScheduleCount(int count) {
        int old = this._scheduleCount;
        this._scheduleCount = count;
        this.setDirtyAndFirePropertyChange(SCHEDULE_CHANGED_PROPERTY, old, count);
    }

    public String checkScheduleValid() {
        if (this.getScheduleId().equals("")) {
            return "";
        }
        Schedule schedule = this.getSchedule();
        if (schedule == null) {
            return Bundle.getMessage("CanNotFindSchedule", this.getScheduleId());
        }
        return schedule.checkScheduleValid(this);
    }

    public String checkSchedule(Car car) {
        if (car.getDestinationTrack() == this) {
            return OKAY;
        }
        if (!this.isSpur()) {
            return OKAY;
        }
        if (this.getScheduleId().equals("")) {
            if (car.getLoadName().equals(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName()) || car.getLoadName().equals(InstanceManager.getDefault(CarLoads.class).getDefaultLoadName())) {
                return OKAY;
            }
            return Bundle.getMessage("carHasA", CUSTOM, LOAD, car.getLoadName());
        }
        log.debug("Track ({}) has schedule ({}) mode {} ({})", new Object[]{this.getName(), this.getScheduleName(), this.getScheduleMode(), this.getScheduleModeName()});
        ScheduleItem si = this.getCurrentScheduleItem();
        if (si == null) {
            log.error("Could not find schedule item id: ({}) for schedule ({})", (Object)this.getScheduleItemId(), (Object)this.getScheduleName());
            return SCHEDULE + " ERROR";
        }
        if (this.getScheduleMode() == 0) {
            return this.getSchedule().checkScheduleItem(si, car, this);
        }
        return this.getSchedule().searchSchedule(car, this);
    }

    public String scheduleNext(Car car) {
        if (this.getScheduleId().equals("") && car.getDestination() != null && car.getDestination().equals(car.getFinalDestination()) && car.getDestinationTrack() != null && (car.getDestinationTrack().equals(car.getFinalDestinationTrack()) || car.getFinalDestinationTrack() == null)) {
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
        }
        if (this.getScheduleId().equals("") || this.getSchedule() == null) {
            return OKAY;
        }
        if (car.getKernel() != null && !car.isLead()) {
            log.debug("Car ({}) is part of kernel ({}) not lead", (Object)car.toString(), (Object)car.getKernelName());
            return OKAY;
        }
        if (!car.getScheduleItemId().equals("")) {
            log.debug("Car ({}) has schedule item id ({})", (Object)car.toString(), (Object)car.getScheduleItemId());
            ScheduleItem si = car.getScheduleItem(this);
            if (si != null) {
                car.loadNext(si);
                return OKAY;
            }
            log.debug("Schedule id ({}) not valid for track ({})", (Object)car.getScheduleItemId(), (Object)this.getName());
            car.setScheduleItemId("");
        }
        if (this.getScheduleMode() == 1 && !this.getSchedule().searchSchedule(car, this).equals(OKAY)) {
            return Bundle.getMessage("matchMessage", SCHEDULE, this.getScheduleName(), this.getSchedule().hasRandomItem() ? Bundle.getMessage("Random") : "");
        }
        ScheduleItem currentSi = this.getCurrentScheduleItem();
        log.debug("Destination track ({}) has schedule ({}) item id ({}) mode: {} ({})", new Object[]{this.getName(), this.getScheduleName(), this.getScheduleItemId(), this.getScheduleMode(), this.getScheduleModeName()});
        if (currentSi == null || !currentSi.getSetoutTrainScheduleId().equals("") && !InstanceManager.getDefault(TrainScheduleManager.class).getTrainScheduleActiveId().equals(currentSi.getSetoutTrainScheduleId()) || !car.getTypeName().equals(currentSi.getTypeName()) || !currentSi.getRoadName().equals("") && !car.getRoadName().equals(currentSi.getRoadName()) || !currentSi.getReceiveLoadName().equals("") && !car.getLoadName().equals(currentSi.getReceiveLoadName())) {
            if (currentSi != null) {
                String scheduleName = "";
                String currentTrainScheduleName = "";
                TrainSchedule sch = InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(InstanceManager.getDefault(TrainScheduleManager.class).getTrainScheduleActiveId());
                if (sch != null) {
                    scheduleName = sch.getName();
                }
                if ((sch = InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(currentSi.getSetoutTrainScheduleId())) != null) {
                    currentTrainScheduleName = sch.getName();
                }
                return Bundle.getMessage("sequentialMessage", SCHEDULE, this.getScheduleName(), this.getScheduleModeName(), car.toString(), car.getTypeName(), scheduleName, car.getRoadName(), car.getLoadName(), currentSi.getTypeName(), currentTrainScheduleName, currentSi.getRoadName(), currentSi.getReceiveLoadName());
            }
            log.error("ERROR Track {} current schedule item is null!", (Object)this.getName());
            return SCHEDULE + " ERROR Track " + this.getName() + " current schedule item is null!";
        }
        car.setScheduleItemId(currentSi.getId());
        car.loadNext(currentSi);
        this.bumpSchedule();
        return OKAY;
    }

    public boolean checkScheduleAttribute(String attribute, String carType, Car car) {
        Schedule schedule = this.getSchedule();
        if (schedule == null) {
            return true;
        }
        if (car != null && car.getTrack() == this) {
            return true;
        }
        return schedule.checkScheduleAttribute(attribute, carType, car);
    }

    public void setLoadSwapEnabled(boolean enable) {
        boolean old = this.isLoadSwapEnabled();
        this._loadOptions = enable ? (this._loadOptions |= 1) : (this._loadOptions &= 0xFFFE);
        this.setDirtyAndFirePropertyChange(LOAD_OPTIONS_CHANGED_PROPERTY, old, enable);
    }

    public boolean isLoadSwapEnabled() {
        return 0 != (this._loadOptions & 1);
    }

    public void setLoadEmptyEnabled(boolean enable) {
        boolean old = this.isLoadEmptyEnabled();
        this._loadOptions = enable ? (this._loadOptions |= 0x10) : (this._loadOptions &= 0xFFEF);
        this.setDirtyAndFirePropertyChange(LOAD_OPTIONS_CHANGED_PROPERTY, old, enable);
    }

    public boolean isLoadEmptyEnabled() {
        return 0 != (this._loadOptions & 0x10);
    }

    public void setRemoveCustomLoadsEnabled(boolean enable) {
        boolean old = this.isRemoveCustomLoadsEnabled();
        this._loadOptions = enable ? (this._loadOptions |= 2) : (this._loadOptions &= 0xFFFD);
        this.setDirtyAndFirePropertyChange(LOAD_OPTIONS_CHANGED_PROPERTY, old, enable);
    }

    public boolean isRemoveCustomLoadsEnabled() {
        return 0 != (this._loadOptions & 2);
    }

    public void setAddCustomLoadsEnabled(boolean enable) {
        boolean old = this.isAddCustomLoadsEnabled();
        this._loadOptions = enable ? (this._loadOptions |= 4) : (this._loadOptions &= 0xFFFB);
        this.setDirtyAndFirePropertyChange(LOAD_OPTIONS_CHANGED_PROPERTY, old, enable);
    }

    public boolean isAddCustomLoadsEnabled() {
        return 0 != (this._loadOptions & 4);
    }

    public void setAddCustomLoadsAnySpurEnabled(boolean enable) {
        boolean old = this.isAddCustomLoadsAnySpurEnabled();
        this._loadOptions = enable ? (this._loadOptions |= 8) : (this._loadOptions &= 0xFFF7);
        this.setDirtyAndFirePropertyChange(LOAD_OPTIONS_CHANGED_PROPERTY, old, enable);
    }

    public boolean isAddCustomLoadsAnySpurEnabled() {
        return 0 != (this._loadOptions & 8);
    }

    public void setAddCustomLoadsAnyStagingTrackEnabled(boolean enable) {
        boolean old = this.isAddCustomLoadsAnyStagingTrackEnabled();
        this._loadOptions = enable ? (this._loadOptions |= 0x20) : (this._loadOptions &= 0xFFDF);
        this.setDirtyAndFirePropertyChange(LOAD_OPTIONS_CHANGED_PROPERTY, old, enable);
    }

    public boolean isAddCustomLoadsAnyStagingTrackEnabled() {
        return 0 != (this._loadOptions & 0x20);
    }

    public boolean isModifyLoadsEnabled() {
        return this.isLoadEmptyEnabled() || this.isLoadSwapEnabled() || this.isRemoveCustomLoadsEnabled() || this.isAddCustomLoadsAnySpurEnabled() || this.isAddCustomLoadsAnyStagingTrackEnabled() || this.isAddCustomLoadsEnabled();
    }

    public void setDisableLoadChangeEnabled(boolean enable) {
        boolean old = this.isDisableLoadChangeEnabled();
        this._loadOptions = enable ? (this._loadOptions |= 0x40) : (this._loadOptions &= 0xFFBF);
        this.setDirtyAndFirePropertyChange(LOAD_OPTIONS_CHANGED_PROPERTY, old, enable);
    }

    public boolean isDisableLoadChangeEnabled() {
        return 0 != (this._loadOptions & 0x40);
    }

    public void setQuickServiceEnabled(boolean enable) {
        boolean old = this.isQuickServiceEnabled();
        this._loadOptions = enable ? (this._loadOptions |= 0x80) : (this._loadOptions &= 0xFF7F);
        this.setDirtyAndFirePropertyChange(LOAD_OPTIONS_CHANGED_PROPERTY, old, enable);
    }

    public boolean isQuickServiceEnabled() {
        return this.isSpur() && !this.isAlternate() && 0 != (this._loadOptions & 0x80);
    }

    public void setBlockCarsEnabled(boolean enable) {
        boolean old = this.isBlockCarsEnabled();
        this._blockOptions = enable ? (this._blockOptions |= 1) : (this._blockOptions &= 0xFFFE);
        this.setDirtyAndFirePropertyChange(LOAD_OPTIONS_CHANGED_PROPERTY, old, enable);
    }

    public boolean isBlockCarsEnabled() {
        if (this.isStaging()) {
            return 0 != (this._blockOptions & 1);
        }
        return false;
    }

    public void setPool(Pool pool) {
        Pool old = this._pool;
        this._pool = pool;
        if (old != pool) {
            if (old != null) {
                old.remove(this);
            }
            if (this._pool != null) {
                this._pool.add(this);
            }
            this.setDirtyAndFirePropertyChange(POOL_CHANGED_PROPERTY, old, pool);
        }
    }

    public Pool getPool() {
        return this._pool;
    }

    public String getPoolName() {
        if (this.getPool() != null) {
            return this.getPool().getName();
        }
        return "";
    }

    public int getDestinationListSize() {
        return this._destinationIdList.size();
    }

    public void addDestination(Location destination) {
        if (!this._destinationIdList.contains(destination.getId())) {
            this._destinationIdList.add(destination.getId());
            this.setDirtyAndFirePropertyChange(DESTINATIONS_CHANGED_PROPERTY, null, destination.getName());
        }
    }

    public void deleteDestination(Location destination) {
        if (this._destinationIdList.remove(destination.getId())) {
            this.setDirtyAndFirePropertyChange(DESTINATIONS_CHANGED_PROPERTY, destination.getName(), null);
        }
    }

    public boolean isDestinationAccepted(Location destination) {
        if (this.getDestinationOption().equals(ALL_DESTINATIONS) || destination == null) {
            return true;
        }
        return this._destinationIdList.contains(destination.getId());
    }

    public void setDestinationIds(String[] ids) {
        for (String id : ids) {
            this._destinationIdList.add(id);
        }
    }

    public String[] getDestinationIds() {
        String[] ids = this._destinationIdList.toArray(new String[0]);
        return ids;
    }

    public void setDestinationOption(String option) {
        String old = this._destinationOption;
        this._destinationOption = option;
        if (!option.equals(old)) {
            this.setDirtyAndFirePropertyChange(DESTINATION_OPTIONS_CHANGED_PROPERTY, old, option);
        }
    }

    public String getDestinationOption() {
        if (this.isInterchange() || this.isStaging()) {
            return this._destinationOption;
        }
        return ALL_DESTINATIONS;
    }

    public void setOnlyCarsWithFinalDestinationEnabled(boolean enable) {
        boolean old = this._onlyCarsWithFD;
        this._onlyCarsWithFD = enable;
        this.setDirtyAndFirePropertyChange(ROUTED_CHANGED_PROPERTY, old, enable);
    }

    public boolean isOnlyCarsWithFinalDestinationEnabled() {
        if (this.isInterchange() || this.isStaging()) {
            return this._onlyCarsWithFD;
        }
        return false;
    }

    public boolean isAlternate() {
        for (Track track : this.getLocation().getTracksList()) {
            if (track.getAlternateTrack() != this) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.setName(Bundle.getMessage("NotValid", this.getName()));
        this.setDirtyAndFirePropertyChange(DISPOSE_CHANGED_PROPERTY, null, DISPOSE_CHANGED_PROPERTY);
    }

    public Track(Element e, Location location) {
        String[] roads;
        String[] ids;
        String[] loads;
        List carLoads;
        String names;
        String[] types;
        this._location = location;
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in track element when reading operations");
        }
        a = e.getAttribute("name");
        if (a != null) {
            this._name = a.getValue();
        }
        if ((a = e.getAttribute(TRACK_TYPE_CHANGED_PROPERTY)) != null) {
            this._trackType = a.getValue();
        } else {
            a = e.getAttribute("locType");
            if (a != null) {
                this._trackType = a.getValue().equals(SIDING) ? SPUR : a.getValue();
            }
        }
        a = e.getAttribute("length");
        if (a != null) {
            try {
                this._length = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Track length isn't a vaild number for track {}", (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("moves")) != null) {
            try {
                this._moves = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Track moves isn't a vaild number for track {}", (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("blockingOrder")) != null) {
            try {
                this._blockingOrder = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Track blocking order isn't a vaild number for track {}", (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("dir")) != null) {
            try {
                this._trainDir = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Track service direction isn't a vaild number for track {}", (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
        if (e.getChild("types") != null) {
            List carTypes = e.getChild("types").getChildren("carType");
            types = new String[carTypes.size()];
            for (int i = 0; i < carTypes.size(); ++i) {
                Element type = (Element)carTypes.get(i);
                a = type.getAttribute("name");
                if (a == null) continue;
                types[i] = a.getValue();
            }
            this.setTypeNames(types);
            List locoTypes = e.getChild("types").getChildren("locoType");
            types = new String[locoTypes.size()];
            for (int i = 0; i < locoTypes.size(); ++i) {
                Element type = (Element)locoTypes.get(i);
                a = type.getAttribute("name");
                if (a == null) continue;
                types[i] = a.getValue();
            }
            this.setTypeNames(types);
        } else {
            a = e.getAttribute("carTypes");
            if (a != null) {
                names = a.getValue();
                types = names.split("%%");
                this.setTypeNames(types);
            }
        }
        a = e.getAttribute("carLoadOption");
        if (a != null) {
            this._loadOption = a.getValue();
        }
        if (e.getChild("carLoads") != null) {
            carLoads = e.getChild("carLoads").getChildren("carLoad");
            loads = new String[carLoads.size()];
            for (int i = 0; i < carLoads.size(); ++i) {
                Element load = (Element)carLoads.get(i);
                a = load.getAttribute("name");
                if (a == null) continue;
                loads[i] = a.getValue();
            }
            this.setLoadNames(loads);
        } else {
            a = e.getAttribute("carLoads");
            if (a != null) {
                names = a.getValue();
                loads = names.split("%%");
                log.debug("Track ({}) {} car loads: {}", new Object[]{this.getName(), this.getLoadOption(), names});
                this.setLoadNames(loads);
            }
        }
        a = e.getAttribute("carShipLoadOption");
        if (a != null) {
            this._shipLoadOption = a.getValue();
        }
        if (e.getChild("carShipLoads") != null) {
            carLoads = e.getChild("carShipLoads").getChildren("carLoad");
            loads = new String[carLoads.size()];
            for (int i = 0; i < carLoads.size(); ++i) {
                Element load = (Element)carLoads.get(i);
                a = load.getAttribute("name");
                if (a == null) continue;
                loads[i] = a.getValue();
            }
            this.setShipLoadNames(loads);
        }
        if (e.getChild("dropIds") != null) {
            List dropIds = e.getChild("dropIds").getChildren("dropId");
            ids = new String[dropIds.size()];
            for (int i = 0; i < dropIds.size(); ++i) {
                Element dropId = (Element)dropIds.get(i);
                a = dropId.getAttribute("id");
                if (a == null) continue;
                ids[i] = a.getValue();
            }
            this.setDropIds(ids);
        } else {
            a = e.getAttribute("dropIds");
            if (a != null) {
                names = a.getValue();
                ids = names.split("%%");
                this.setDropIds(ids);
            }
        }
        a = e.getAttribute("dropOption");
        if (a != null) {
            this._dropOption = a.getValue();
        }
        if (e.getChild("pickupIds") != null) {
            List pickupIds = e.getChild("pickupIds").getChildren("pickupId");
            ids = new String[pickupIds.size()];
            for (int i = 0; i < pickupIds.size(); ++i) {
                Element pickupId = (Element)pickupIds.get(i);
                a = pickupId.getAttribute("id");
                if (a == null) continue;
                ids[i] = a.getValue();
            }
            this.setPickupIds(ids);
        } else {
            a = e.getAttribute("pickupIds");
            if (a != null) {
                names = a.getValue();
                ids = names.split("%%");
                this.setPickupIds(ids);
            }
        }
        a = e.getAttribute("pickupOption");
        if (a != null) {
            this._pickupOption = a.getValue();
        }
        if (e.getChild("carRoads") != null) {
            List carRoads = e.getChild("carRoads").getChildren("carRoad");
            roads = new String[carRoads.size()];
            for (int i = 0; i < carRoads.size(); ++i) {
                Element road = (Element)carRoads.get(i);
                a = road.getAttribute("name");
                if (a == null) continue;
                roads[i] = a.getValue();
            }
            this.setRoadNames(roads);
        } else {
            a = e.getAttribute("carRoads");
            if (a != null) {
                names = a.getValue();
                roads = names.split("%%");
                this.setRoadNames(roads);
            }
        }
        a = e.getAttribute("carRoadOption");
        if (a != null) {
            this._roadOption = a.getValue();
        } else {
            a = e.getAttribute("carRoadOperation");
            if (a != null) {
                this._roadOption = a.getValue();
            }
        }
        a = e.getAttribute("schedule");
        if (a != null) {
            this._scheduleName = a.getValue();
        }
        if ((a = e.getAttribute("scheduleId")) != null) {
            this._scheduleId = a.getValue();
        }
        if ((a = e.getAttribute("itemId")) != null) {
            this._scheduleItemId = a.getValue();
        }
        if ((a = e.getAttribute("itemCount")) != null) {
            try {
                this._scheduleCount = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Schedule count isn't a vaild number for track {}", (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("factor")) != null) {
            try {
                this._reservationFactor = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Reservation factor isn't a vaild number for track {}", (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("scheduleMode")) != null) {
            try {
                this._mode = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Schedule mode isn't a vaild number for track {}", (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("holdCustomLoads")) != null) {
            this.setHoldCarsWithCustomLoadsEnabled(a.getValue().equals("true"));
        }
        if ((a = e.getAttribute("onlyCarWithFD")) != null) {
            this.setOnlyCarsWithFinalDestinationEnabled(a.getValue().equals("true"));
        }
        if ((a = e.getAttribute("alternative")) != null) {
            this._alternateTrackId = a.getValue();
        }
        if ((a = e.getAttribute("loadOptions")) != null) {
            try {
                this._loadOptions = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Load options isn't a vaild number for track {}", (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("blockOptions")) != null) {
            try {
                this._blockOptions = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Block options isn't a vaild number for track {}", (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("order")) != null) {
            this._order = a.getValue();
        }
        if ((a = e.getAttribute("pool")) != null) {
            this.setPool(this.getLocation().addPool(a.getValue()));
            a = e.getAttribute("minLength");
            if (a != null) {
                try {
                    this._minimumLength = Integer.parseInt(a.getValue());
                }
                catch (NumberFormatException nfe) {
                    log.error("Minimum pool length isn't a vaild number for track {}", (Object)this.getName());
                }
            }
        }
        if ((a = e.getAttribute("ignoreUsedPercentage")) != null) {
            try {
                this._ignoreUsedLengthPercentage = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException nfe) {
                log.error("Ignore used percentage isn't a vaild number for track {}", (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("trackDestinationOption")) != null) {
            this._destinationOption = a.getValue();
        }
        if (e.getChild("destinations") != null) {
            List eDestinations = e.getChild("destinations").getChildren("destination");
            for (Element eDestination : eDestinations) {
                a = eDestination.getAttribute("id");
                if (a == null) continue;
                this._destinationIdList.add(a.getValue());
            }
        }
        if (e.getChild("comments") != null) {
            if (e.getChild("comments").getChild("track") != null && (a = e.getChild("comments").getChild("track").getAttribute("comment")) != null) {
                this._comment = a.getValue();
            }
            if (e.getChild("comments").getChild("both") != null && (a = e.getChild("comments").getChild("both").getAttribute("comment")) != null) {
                this._commentBoth = a.getValue();
            }
            if (e.getChild("comments").getChild("pickup") != null && (a = e.getChild("comments").getChild("pickup").getAttribute("comment")) != null) {
                this._commentPickup = a.getValue();
            }
            if (e.getChild("comments").getChild("setout") != null && (a = e.getChild("comments").getChild("setout").getAttribute("comment")) != null) {
                this._commentSetout = a.getValue();
            }
            if (e.getChild("comments").getChild("printManifest") != null && (a = e.getChild("comments").getChild("printManifest").getAttribute("comment")) != null) {
                this._printCommentManifest = a.getValue().equals("true");
            }
            if (e.getChild("comments").getChild("printSwitchLists") != null && (a = e.getChild("comments").getChild("printSwitchLists").getAttribute("comment")) != null) {
                this._printCommentSwitchList = a.getValue().equals("true");
            }
        }
        if ((a = e.getAttribute("idReader")) != null) {
            try {
                Reporter r;
                this._reader = r = InstanceManager.getDefault(ReporterManager.class).provideReporter(a.getValue());
            }
            catch (IllegalArgumentException ex) {
                log.warn("Not able to find reader: {} for location ({})", (Object)a.getValue(), (Object)this.getName());
            }
        }
    }

    public Element store() {
        Element eLoad;
        String[] loads;
        Element e = new Element("track");
        e.setAttribute("id", this.getId());
        e.setAttribute("name", this.getName());
        e.setAttribute(TRACK_TYPE_CHANGED_PROPERTY, this.getTrackType());
        e.setAttribute("dir", Integer.toString(this.getTrainDirections()));
        e.setAttribute("length", Integer.toString(this.getLength()));
        e.setAttribute("moves", Integer.toString(this.getMoves() - this.getDropRS()));
        if (this.getBlockingOrder() != 0) {
            e.setAttribute("blockingOrder", Integer.toString(this.getBlockingOrder()));
        }
        String[] types = this.getTypeNames();
        Element eTypes = new Element("types");
        for (String type : types) {
            Element eType;
            if (InstanceManager.getDefault(EngineTypes.class).containsName(type)) {
                eType = new Element("locoType");
                eType.setAttribute("name", type);
                eTypes.addContent((Content)eType);
                continue;
            }
            if (!InstanceManager.getDefault(CarTypes.class).containsName(type)) continue;
            eType = new Element("carType");
            eType.setAttribute("name", type);
            eTypes.addContent((Content)eType);
        }
        e.addContent((Content)eTypes);
        if (!this.getRoadOption().equals(ALL_ROADS)) {
            e.setAttribute("carRoadOption", this.getRoadOption());
            String[] roads = this.getRoadNames();
            Element eRoads = new Element("carRoads");
            for (String road : roads) {
                Element eRoad = new Element("carRoad");
                eRoad.setAttribute("name", road);
                eRoads.addContent((Content)eRoad);
            }
            e.addContent((Content)eRoads);
        }
        if (!this.getLoadOption().equals(ALL_LOADS)) {
            e.setAttribute("carLoadOption", this.getLoadOption());
            loads = this.getLoadNames();
            Element eLoads = new Element("carLoads");
            for (String load : loads) {
                eLoad = new Element("carLoad");
                eLoad.setAttribute("name", load);
                eLoads.addContent((Content)eLoad);
            }
            e.addContent((Content)eLoads);
        }
        if (!this.getShipLoadOption().equals(ALL_LOADS)) {
            e.setAttribute("carShipLoadOption", this.getShipLoadOption());
            loads = this.getShipLoadNames();
            Element eLoads = new Element("carShipLoads");
            for (String load : loads) {
                eLoad = new Element("carLoad");
                eLoad.setAttribute("name", load);
                eLoads.addContent((Content)eLoad);
            }
            e.addContent((Content)eLoads);
        }
        if (!this.getDropOption().equals(ANY)) {
            e.setAttribute("dropOption", this.getDropOption());
            String[] dropIds = this.getDropIds();
            Element eDropIds = new Element("dropIds");
            for (String id : dropIds) {
                Element eDropId = new Element("dropId");
                eDropId.setAttribute("id", id);
                eDropIds.addContent((Content)eDropId);
            }
            e.addContent((Content)eDropIds);
        }
        if (!this.getPickupOption().equals(ANY)) {
            e.setAttribute("pickupOption", this.getPickupOption());
            String[] pickupIds = this.getPickupIds();
            Element ePickupIds = new Element("pickupIds");
            for (String id : pickupIds) {
                Element ePickupId = new Element("pickupId");
                ePickupId.setAttribute("id", id);
                ePickupIds.addContent((Content)ePickupId);
            }
            e.addContent((Content)ePickupIds);
        }
        if (this.getSchedule() != null) {
            e.setAttribute("schedule", this.getScheduleName());
            e.setAttribute("scheduleId", this.getScheduleId());
            e.setAttribute("itemId", this.getScheduleItemId());
            e.setAttribute("itemCount", Integer.toString(this.getScheduleCount()));
            e.setAttribute("factor", Integer.toString(this.getReservationFactor()));
            e.setAttribute("scheduleMode", Integer.toString(this.getScheduleMode()));
            e.setAttribute("holdCustomLoads", this.isHoldCarsWithCustomLoadsEnabled() ? "true" : "false");
        }
        if (this.isInterchange() || this.isStaging()) {
            e.setAttribute("onlyCarWithFD", this.isOnlyCarsWithFinalDestinationEnabled() ? "true" : "false");
        }
        if (this.getAlternateTrack() != null) {
            e.setAttribute("alternative", this.getAlternateTrack().getId());
        }
        if (this._loadOptions != 0) {
            e.setAttribute("loadOptions", Integer.toString(this._loadOptions));
        }
        if (this.isBlockCarsEnabled()) {
            e.setAttribute("blockOptions", Integer.toString(this._blockOptions));
        }
        if (!this.getServiceOrder().equals(NORMAL)) {
            e.setAttribute("order", this.getServiceOrder());
        }
        if (this.getPool() != null) {
            e.setAttribute("pool", this.getPool().getName());
            e.setAttribute("minLength", Integer.toString(this.getMinimumLength()));
        }
        if (this.getIgnoreUsedLengthPercentage() > 0) {
            e.setAttribute("ignoreUsedPercentage", Integer.toString(this.getIgnoreUsedLengthPercentage()));
        }
        if ((this.isStaging() || this.isInterchange()) && !this.getDestinationOption().equals(ALL_DESTINATIONS)) {
            e.setAttribute("trackDestinationOption", this.getDestinationOption());
            String[] destIds = this.getDestinationIds();
            if (destIds.length > 0) {
                Element destinations = new Element("destinations");
                for (String id : destIds) {
                    Location loc = InstanceManager.getDefault(LocationManager.class).getLocationById(id);
                    if (loc == null) continue;
                    Element destination = new Element("destination");
                    destination.setAttribute("id", id);
                    destination.setAttribute("name", loc.getName());
                    destinations.addContent((Content)destination);
                }
                e.addContent((Content)destinations);
            }
        }
        if (!(this.getComment().equals("") && this.getCommentBothWithColor().equals("") && this.getCommentPickupWithColor().equals("") && this.getCommentSetoutWithColor().equals(""))) {
            Element comments = new Element("comments");
            Element track = new Element("track");
            Element both = new Element("both");
            Element pickup = new Element("pickup");
            Element setout = new Element("setout");
            Element printManifest = new Element("printManifest");
            Element printSwitchList = new Element("printSwitchLists");
            comments.addContent((Content)track);
            comments.addContent((Content)both);
            comments.addContent((Content)pickup);
            comments.addContent((Content)setout);
            comments.addContent((Content)printManifest);
            comments.addContent((Content)printSwitchList);
            track.setAttribute("comment", this.getComment());
            both.setAttribute("comment", this.getCommentBothWithColor());
            pickup.setAttribute("comment", this.getCommentPickupWithColor());
            setout.setAttribute("comment", this.getCommentSetoutWithColor());
            printManifest.setAttribute("comment", this.isPrintManifestCommentEnabled() ? "true" : "false");
            printSwitchList.setAttribute("comment", this.isPrintSwitchListCommentEnabled() ? "true" : "false");
            e.addContent((Content)comments);
        }
        if (this.getReporter() != null) {
            e.setAttribute("idReader", this.getReporter().getDisplayName());
        }
        return e;
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(LocationManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }

    public void setReporter(Reporter r) {
        Reporter old = this._reader;
        this._reader = r;
        if (old != r) {
            this.setDirtyAndFirePropertyChange(TRACK_REPORTER_CHANGED_PROPERTY, old, r);
        }
    }

    public Reporter getReporter() {
        return this._reader;
    }

    public String getReporterName() {
        if (this.getReporter() != null) {
            return this.getReporter().getDisplayName();
        }
        return "";
    }
}

