/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.divisions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.locations.LocationManagerXml;
import jmri.jmrit.operations.locations.divisions.Bundle;
import jmri.jmrit.operations.locations.divisions.Division;
import jmri.jmrit.operations.trains.TrainManifestHeaderText;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DivisionManager
extends PropertyChangeSupport
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize {
    public static final String LISTLENGTH_CHANGED_PROPERTY = "divisionsListLength";
    private int _id = 0;
    protected Hashtable<String, Division> _divisionHashTable = new Hashtable();
    protected int _maxDivisionNameLength = 0;
    private static final Logger log = LoggerFactory.getLogger(DivisionManager.class);

    public void dispose() {
        this._divisionHashTable.clear();
        this._id = 0;
    }

    public int getNumberOfdivisions() {
        return this._divisionHashTable.size();
    }

    public Division getDivisionByName(String name) {
        Enumeration<Division> en = this._divisionHashTable.elements();
        while (en.hasMoreElements()) {
            Division Division2 = en.nextElement();
            if (!Division2.getName().equals(name)) continue;
            return Division2;
        }
        return null;
    }

    public Division getDivisionById(String id) {
        return this._divisionHashTable.get(id);
    }

    public Division newDivision(String name) {
        Division division = this.getDivisionByName(name);
        if (division == null) {
            ++this._id;
            division = new Division(Integer.toString(this._id), name);
            Integer oldSize = this._divisionHashTable.size();
            this._divisionHashTable.put(division.getId(), division);
            this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._divisionHashTable.size());
        }
        return division;
    }

    public void register(Division division) {
        Integer oldSize = this._divisionHashTable.size();
        this._divisionHashTable.put(division.getId(), division);
        int id = Integer.parseInt(division.getId());
        if (id > this._id) {
            this._id = id;
        }
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._divisionHashTable.size());
    }

    public void deregister(Division division) {
        if (division == null) {
            return;
        }
        Integer oldSize = this._divisionHashTable.size();
        this._divisionHashTable.remove(division.getId());
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._divisionHashTable.size());
    }

    public List<Division> getDivisionsByNameList() {
        List<Division> sortList = this.getList();
        ArrayList<Division> out = new ArrayList<Division>();
        for (Division division : sortList) {
            for (int j = 0; j < out.size(); ++j) {
                if (division.getName().compareToIgnoreCase(((Division)out.get(j)).getName()) >= 0) continue;
                out.add(j, division);
                break;
            }
            if (out.contains(division)) continue;
            out.add(division);
        }
        return out;
    }

    public List<Division> getDivisionsByIdList() {
        List<Division> sortList = this.getList();
        ArrayList<Division> out = new ArrayList<Division>();
        for (Division Division2 : sortList) {
            for (int j = 0; j < out.size(); ++j) {
                try {
                    if (Integer.parseInt(Division2.getId()) >= Integer.parseInt(((Division)out.get(j)).getId())) continue;
                    out.add(j, Division2);
                    break;
                }
                catch (NumberFormatException e) {
                    log.debug("list id number isn't a number");
                }
            }
            if (out.contains(Division2)) continue;
            out.add(Division2);
        }
        return out;
    }

    public List<Division> getList() {
        ArrayList<Division> out = new ArrayList<Division>();
        Enumeration<Division> en = this._divisionHashTable.elements();
        while (en.hasMoreElements()) {
            out.add(en.nextElement());
        }
        return out;
    }

    public JComboBox<Division> getComboBox() {
        JComboBox<Division> box = new JComboBox<Division>();
        this.updateComboBox(box);
        OperationsPanel.padComboBox(box);
        return box;
    }

    public void updateComboBox(JComboBox<Division> box) {
        box.removeAllItems();
        box.addItem(null);
        for (Division division : this.getDivisionsByNameList()) {
            box.addItem(division);
        }
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Info Message")
    public int getMaxDivisionNameLength() {
        String maxName = TrainManifestHeaderText.getStringHeader_Division();
        for (Division div : this.getList()) {
            if (div.getName().length() <= maxName.length()) continue;
            maxName = div.getName();
        }
        if (maxName.length() != this._maxDivisionNameLength) {
            log.info(Bundle.getMessage("InfoMaxDivisionName", maxName, maxName.length()));
            this._maxDivisionNameLength = maxName.length();
        }
        return this._maxDivisionNameLength;
    }

    public void load(Element root) {
        if (root.getChild("divisions") != null) {
            List divisions = root.getChild("divisions").getChildren("division");
            log.debug("readFile sees {} divisions", (Object)divisions.size());
            for (Element division : divisions) {
                this.register(new Division(division));
            }
        }
    }

    public void store(Element root) {
        Element values = new Element("divisions");
        root.addContent((Content)values);
        List<Division> DivisionList = this.getDivisionsByNameList();
        for (Division division : DivisionList) {
            values.addContent((Content)division.store());
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(LocationManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }

    @Override
    public void initialize() {
    }
}

