/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.gui;

import java.beans.PropertyChangeEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.gui.Bundle;
import jmri.jmrit.operations.locations.gui.InterchangeEditFrame;
import jmri.jmrit.operations.locations.gui.TrackTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterchangeTableModel
extends TrackTableModel {
    private static final Logger log = LoggerFactory.getLogger(InterchangeTableModel.class);

    public void initTable(JTable table, Location location) {
        super.initTable(table, location, "Interchange");
    }

    @Override
    protected void editTrack(int row) {
        log.debug("Edit interchange");
        if (this.tef != null) {
            this.tef.dispose();
        }
        SwingUtilities.invokeLater(() -> {
            this.tef = new InterchangeEditFrame();
            Track interchange = (Track)this._tracksList.get(row);
            this.tef.initComponents(interchange);
        });
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return Bundle.getMessage("InterchangeName");
            }
        }
        return super.getColumnName(col);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        int row;
        Track track;
        super.propertyChange(e);
        if (e.getSource().getClass().equals(Track.class) && (track = (Track)e.getSource()).isInterchange() && (row = this._tracksList.indexOf(track)) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
    }
}

