/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.divisions.Division;
import jmri.jmrit.operations.locations.divisions.DivisionEditFrame;
import jmri.jmrit.operations.locations.divisions.DivisionManager;
import jmri.jmrit.operations.locations.gui.Bundle;
import jmri.jmrit.operations.locations.gui.InterchangeEditFrame;
import jmri.jmrit.operations.locations.gui.InterchangeTableModel;
import jmri.jmrit.operations.locations.gui.SpurEditFrame;
import jmri.jmrit.operations.locations.gui.SpurTableModel;
import jmri.jmrit.operations.locations.gui.StagingEditFrame;
import jmri.jmrit.operations.locations.gui.StagingTableModel;
import jmri.jmrit.operations.locations.gui.YardEditFrame;
import jmri.jmrit.operations.locations.gui.YardTableModel;
import jmri.jmrit.operations.locations.schedules.tools.SchedulesAndStagingAction;
import jmri.jmrit.operations.locations.tools.ChangeTracksTypeAction;
import jmri.jmrit.operations.locations.tools.EditCarTypeAction;
import jmri.jmrit.operations.locations.tools.LocationCopyAction;
import jmri.jmrit.operations.locations.tools.LocationTrackBlockingOrderAction;
import jmri.jmrit.operations.locations.tools.LocationsByCarTypeFrame;
import jmri.jmrit.operations.locations.tools.ModifyLocationsAction;
import jmri.jmrit.operations.locations.tools.ModifyLocationsCarLoadsAction;
import jmri.jmrit.operations.locations.tools.PrintLocationsAction;
import jmri.jmrit.operations.locations.tools.SetPhysicalLocationAction;
import jmri.jmrit.operations.locations.tools.ShowCarsByLocationAction;
import jmri.jmrit.operations.locations.tools.ShowTrackMovesAction;
import jmri.jmrit.operations.locations.tools.ShowTrainsServingLocationAction;
import jmri.jmrit.operations.locations.tools.TrackCopyAction;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.tools.ShowRoutesServingLocationAction;
import jmri.jmrit.operations.routes.tools.ShowRoutesServingLocationFrame;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.swing.NamedBeanComboBox;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    YardTableModel yardModel = new YardTableModel();
    JTable yardTable = new JTable(this.yardModel);
    JScrollPane yardPane = new JScrollPane(this.yardTable);
    SpurTableModel spurModel = new SpurTableModel();
    JTable spurTable = new JTable(this.spurModel){

        @Override
        public String getToolTipText(MouseEvent e) {
            int colIndex = this.columnAtPoint(e.getPoint());
            int realColumnIndex = this.convertColumnIndexToModel(colIndex);
            if (realColumnIndex == 21) {
                return Bundle.getMessage("HoldCarsWithCustomLoads");
            }
            return null;
        }
    };
    JScrollPane spurPane = new JScrollPane(this.spurTable);
    InterchangeTableModel interchangeModel = new InterchangeTableModel();
    JTable interchangeTable = new JTable(this.interchangeModel){

        @Override
        public String getToolTipText(MouseEvent e) {
            int colIndex = this.columnAtPoint(e.getPoint());
            int realColumnIndex = this.convertColumnIndexToModel(colIndex);
            if (realColumnIndex == 20) {
                return Bundle.getMessage("TipOnlyCarsWithFD");
            }
            return null;
        }
    };
    JScrollPane interchangePane = new JScrollPane(this.interchangeTable);
    StagingTableModel stagingModel = new StagingTableModel();
    JTable stagingTable = new JTable(this.stagingModel){

        @Override
        public String getToolTipText(MouseEvent e) {
            int colIndex = this.columnAtPoint(e.getPoint());
            int realColumnIndex = this.convertColumnIndexToModel(colIndex);
            if (realColumnIndex == 20) {
                return Bundle.getMessage("TipOnlyCarsWithFD");
            }
            return null;
        }
    };
    JScrollPane stagingPane = new JScrollPane(this.stagingTable);
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    public Location _location = null;
    ArrayList<JCheckBox> checkBoxes = new ArrayList();
    JPanel panelCheckBoxes = new JPanel();
    JScrollPane typePane = new JScrollPane(this.panelCheckBoxes);
    JPanel directionPanel = new JPanel();
    JButton clearButton = new JButton(Bundle.getMessage("ClearAll"));
    JButton setButton = new JButton(Bundle.getMessage("SelectAll"));
    JButton autoSelectButton = new JButton(Bundle.getMessage("AutoSelect"));
    JButton editDivisionButton = new JButton(Bundle.getMessage("ButtonEdit"));
    JButton saveLocationButton = new JButton(Bundle.getMessage("SaveLocation"));
    JButton deleteLocationButton = new JButton(Bundle.getMessage("DeleteLocation"));
    JButton addLocationButton = new JButton(Bundle.getMessage("AddLocation"));
    JButton addYardButton = new JButton(Bundle.getMessage("AddYard"));
    JButton addSpurButton = new JButton(Bundle.getMessage("AddSpur"));
    JButton addInterchangeButton = new JButton(Bundle.getMessage("AddInterchange"));
    JButton addStagingButton = new JButton(Bundle.getMessage("AddStaging"));
    JCheckBox northCheckBox = new JCheckBox(Bundle.getMessage("North"));
    JCheckBox southCheckBox = new JCheckBox(Bundle.getMessage("South"));
    JCheckBox eastCheckBox = new JCheckBox(Bundle.getMessage("East"));
    JCheckBox westCheckBox = new JCheckBox(Bundle.getMessage("West"));
    JRadioButton stagingRadioButton = new JRadioButton(Bundle.getMessage("StagingOnly"));
    JRadioButton interchangeRadioButton = new JRadioButton(Bundle.getMessage("Interchange"));
    JRadioButton yardRadioButton = new JRadioButton(Bundle.getMessage("Yards"));
    JRadioButton spurRadioButton = new JRadioButton(Bundle.getMessage("Spurs"));
    JTextField locationNameTextField = new JTextField(Control.max_len_string_location_name);
    JTextArea commentTextArea = new JTextArea(2, 60);
    JScrollPane commentScroller = new JScrollPane(this.commentTextArea, 20, 30);
    JColorChooser commentColorChooser = new JColorChooser();
    protected JComboBox<Division> divisionComboBox = InstanceManager.getDefault(DivisionManager.class).getComboBox();
    NamedBeanComboBox<Reporter> readerSelector;
    JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
    public static final String NAME = Bundle.getMessage("Name");
    public static final int MAX_NAME_LENGTH = Control.max_len_string_location_name;
    public static final String DISPOSE = "dispose";
    DivisionEditFrame def = null;
    YardEditFrame yef = null;
    SpurEditFrame sef = null;
    InterchangeEditFrame ief = null;
    StagingEditFrame stef = null;
    int x = 0;
    int y = 0;
    int numberOfCheckBoxes;
    LocationsByCarTypeFrame lctf = null;
    private static final Logger log = LoggerFactory.getLogger(LocationEditFrame.class);

    public LocationEditFrame(Location location) {
        super(Bundle.getMessage("TitleLocationEdit"));
        this._location = location;
        this.typePane = new JScrollPane(this.panelCheckBoxes);
        this.typePane.setVerticalScrollBarPolicy(20);
        this.typePane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TypesLocation")));
        this.yardPane.setVerticalScrollBarPolicy(20);
        this.yardPane.setBorder(BorderFactory.createTitledBorder(""));
        this.spurPane.setVerticalScrollBarPolicy(20);
        this.spurPane.setBorder(BorderFactory.createTitledBorder(""));
        this.interchangePane.setVerticalScrollBarPolicy(20);
        this.interchangePane.setBorder(BorderFactory.createTitledBorder(""));
        this.stagingPane.setVerticalScrollBarPolicy(20);
        this.stagingPane.setBorder(BorderFactory.createTitledBorder(""));
        ButtonGroup opsGroup = new ButtonGroup();
        opsGroup.add(this.spurRadioButton);
        opsGroup.add(this.yardRadioButton);
        opsGroup.add(this.interchangeRadioButton);
        opsGroup.add(this.stagingRadioButton);
        if (this._location != null) {
            this.enableButtons(true);
            this.locationNameTextField.setText(this._location.getName());
            this.commentTextArea.setText(this._location.getComment());
            this.divisionComboBox.setSelectedItem(this._location.getDivision());
            this.yardModel.initTable(this.yardTable, location);
            this.spurModel.initTable(this.spurTable, location);
            this.interchangeModel.initTable(this.interchangeTable, location);
            this.stagingModel.initTable(this.stagingTable, location);
            this._location.addPropertyChangeListener(this);
            if (!this._location.isStaging()) {
                if (this.spurModel.getRowCount() > 0) {
                    this.spurRadioButton.setSelected(true);
                } else if (this.yardModel.getRowCount() > 0) {
                    this.yardRadioButton.setSelected(true);
                } else if (this.interchangeModel.getRowCount() > 0) {
                    this.interchangeRadioButton.setSelected(true);
                } else {
                    this.spurRadioButton.setSelected(true);
                }
            } else {
                this.stagingRadioButton.setSelected(true);
            }
            this.setTrainDirectionBoxes();
        } else {
            this.enableButtons(false);
            this.spurRadioButton.setSelected(true);
        }
        this.setVisibleTrackType();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JScrollPane p1Pane = new JScrollPane(p1);
        p1Pane.setVerticalScrollBarPolicy(21);
        p1Pane.setMinimumSize(new Dimension(300, 3 * this.locationNameTextField.getPreferredSize().height));
        p1Pane.setBorder(BorderFactory.createTitledBorder(""));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.locationNameTextField, 0, 0);
        this.directionPanel.setLayout(new GridBagLayout());
        this.directionPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainLocation")));
        this.addItem(this.directionPanel, this.northCheckBox, 1, 0);
        this.addItem(this.directionPanel, this.southCheckBox, 2, 0);
        this.addItem(this.directionPanel, this.eastCheckBox, 3, 0);
        this.addItem(this.directionPanel, this.westCheckBox, 4, 0);
        p1.add(pName);
        p1.add(this.directionPanel);
        JPanel pDivision = new JPanel();
        pDivision.setLayout(new GridBagLayout());
        pDivision.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Division")));
        this.addItem(pDivision, this.divisionComboBox, 2, 0);
        this.addItem(pDivision, this.editDivisionButton, 3, 0);
        this.setDivisionButtonText();
        this.panelCheckBoxes.setLayout(new GridBagLayout());
        this.updateCheckboxes();
        JPanel pOp = new JPanel();
        pOp.setLayout(new GridBagLayout());
        pOp.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TracksAtLocation")));
        pOp.add(this.spurRadioButton);
        pOp.add(this.yardRadioButton);
        pOp.add(this.interchangeRadioButton);
        pOp.add(this.stagingRadioButton);
        JPanel pC = new JPanel();
        pC.setLayout(new GridBagLayout());
        pC.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        this.addItem(pC, this.commentScroller, 0, 0);
        if (this._location != null) {
            this.addItem(pC, OperationsPanel.getColorChooserPanel(this._location.getCommentWithColor(), this.commentColorChooser), 2, 0);
        } else {
            this.addItem(pC, OperationsPanel.getColorChooserPanel("", this.commentColorChooser), 2, 0);
        }
        Dimension d = new Dimension(this.getPreferredSize().width - 100, this.getPreferredSize().height);
        this.adjustTextAreaColumnWidth(this.commentScroller, this.commentTextArea, d);
        JPanel readerPanel = new JPanel();
        readerPanel.setVisible(false);
        if (Setup.isRfidEnabled()) {
            ReporterManager reporterManager = InstanceManager.getDefault(ReporterManager.class);
            this.readerSelector = new NamedBeanComboBox<Reporter>(reporterManager);
            this.readerSelector.setAllowNull(true);
            readerPanel.setLayout(new GridBagLayout());
            readerPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("idReporter")));
            this.addItem(readerPanel, this.readerSelector, 0, 0);
            readerPanel.setVisible(true);
            if (this._location != null) {
                this.readerSelector.setSelectedItem(this._location.getReporter());
            }
        }
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        this.addItem(pB, this.deleteLocationButton, 0, 0);
        this.addItem(pB, this.addLocationButton, 1, 0);
        this.addItem(pB, this.saveLocationButton, 3, 0);
        this.getContentPane().add(p1Pane);
        this.getContentPane().add(pDivision);
        this.getContentPane().add(this.typePane);
        this.getContentPane().add(pOp);
        this.getContentPane().add(this.yardPane);
        this.getContentPane().add(this.addYardButton);
        this.getContentPane().add(this.spurPane);
        this.getContentPane().add(this.addSpurButton);
        this.getContentPane().add(this.interchangePane);
        this.getContentPane().add(this.addInterchangeButton);
        this.getContentPane().add(this.stagingPane);
        this.getContentPane().add(this.addStagingButton);
        this.getContentPane().add(pC);
        this.getContentPane().add(readerPanel);
        this.getContentPane().add(pB);
        this.addButtonAction(this.setButton);
        this.addButtonAction(this.clearButton);
        this.addButtonAction(this.autoSelectButton);
        this.addButtonAction(this.editDivisionButton);
        this.addButtonAction(this.deleteLocationButton);
        this.addButtonAction(this.addLocationButton);
        this.addButtonAction(this.saveLocationButton);
        this.addButtonAction(this.addYardButton);
        this.addButtonAction(this.addSpurButton);
        this.addButtonAction(this.addInterchangeButton);
        this.addButtonAction(this.addStagingButton);
        this.autoSelectButton.setToolTipText(Bundle.getMessage("TipAutoSelect"));
        this.addRadioButtonAction(this.spurRadioButton);
        this.addRadioButtonAction(this.yardRadioButton);
        this.addRadioButtonAction(this.interchangeRadioButton);
        this.addRadioButtonAction(this.stagingRadioButton);
        this.addCheckBoxTrainAction(this.northCheckBox);
        this.addCheckBoxTrainAction(this.southCheckBox);
        this.addCheckBoxTrainAction(this.eastCheckBox);
        this.addCheckBoxTrainAction(this.westCheckBox);
        this.addComboBoxAction(this.divisionComboBox);
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(EngineTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(DivisionManager.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(Setup.class).addPropertyChangeListener(this);
        JMenuBar menuBar = new JMenuBar();
        this.loadToolMenu();
        menuBar.add(this.toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_AddLocation", true);
        this.initMinimumSize(new Dimension(600, 500));
    }

    private void loadToolMenu() {
        this.toolMenu.removeAll();
        this.toolMenu.add(new LocationCopyAction(this._location));
        this.toolMenu.add(new TrackCopyAction(null, this._location));
        this.toolMenu.add(new ChangeTracksTypeAction(this));
        if (this._location != null && !this._location.isStaging()) {
            this.toolMenu.add(new LocationTrackBlockingOrderAction(this._location));
        }
        this.toolMenu.add(new ShowTrackMovesAction());
        this.toolMenu.add(new EditCarTypeAction());
        if (Setup.isVsdPhysicalLocationEnabled()) {
            this.toolMenu.add(new SetPhysicalLocationAction(this._location));
        }
        this.toolMenu.addSeparator();
        this.toolMenu.add(new ModifyLocationsAction(this._location));
        this.toolMenu.add(new ModifyLocationsCarLoadsAction(this._location));
        this.toolMenu.addSeparator();
        this.toolMenu.add(new ShowCarsByLocationAction(false, this._location, null));
        this.toolMenu.add(new ShowTrainsServingLocationAction(this._location, null));
        this.toolMenu.add(new ShowRoutesServingLocationAction(this._location));
        if (this._location != null && this._location.isStaging()) {
            this.toolMenu.add(new SchedulesAndStagingAction());
        }
        this.toolMenu.addSeparator();
        this.toolMenu.add(new PrintLocationsAction(false, this._location));
        this.toolMenu.add(new PrintLocationsAction(true, this._location));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        Location l;
        if (ae.getSource() == this.editDivisionButton) {
            if (this.def != null) {
                this.def.dispose();
            }
            this.def = new DivisionEditFrame((Division)this.divisionComboBox.getSelectedItem());
        }
        if (ae.getSource() == this.addYardButton) {
            this.yef = new YardEditFrame();
            this.yef.initComponents(this._location, null);
        }
        if (ae.getSource() == this.addSpurButton) {
            this.sef = new SpurEditFrame();
            this.sef.initComponents(this._location, null);
        }
        if (ae.getSource() == this.addInterchangeButton) {
            this.ief = new InterchangeEditFrame();
            this.ief.initComponents(this._location, null);
        }
        if (ae.getSource() == this.addStagingButton) {
            this.stef = new StagingEditFrame();
            this.stef.initComponents(this._location, null);
        }
        if (ae.getSource() == this.saveLocationButton) {
            log.debug("location save button activated");
            l = this.locationManager.getLocationByName(this.locationNameTextField.getText());
            if (this._location == null && l == null) {
                this.saveNewLocation();
            } else {
                if (l != null && l != this._location) {
                    this.reportLocationExists(Bundle.getMessage("save"));
                    return;
                }
                this.saveLocation();
                if (Setup.isCloseWindowOnSaveEnabled()) {
                    this.dispose();
                }
            }
        }
        if (ae.getSource() == this.deleteLocationButton) {
            log.debug("location delete button activated");
            this.deleteLocation();
            OperationsXml.save();
        }
        if (ae.getSource() == this.addLocationButton) {
            l = this.locationManager.getLocationByName(this.locationNameTextField.getText());
            if (l != null) {
                this.reportLocationExists(Bundle.getMessage("add"));
                return;
            }
            this.saveNewLocation();
        }
        if (ae.getSource() == this.setButton) {
            this.selectCheckboxes(true);
        }
        if (ae.getSource() == this.clearButton) {
            this.selectCheckboxes(false);
        }
        if (ae.getSource() == this.autoSelectButton) {
            log.debug("auto select button pressed");
            if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("autoSelectCarTypes?"), Bundle.getMessage("autoSelectLocations?"), 0) != 0) {
                return;
            }
            this.autoSelectCheckboxes();
        }
    }

    private void saveNewLocation() {
        if (!this.checkName(Bundle.getMessage("add"))) {
            return;
        }
        Location location = this.locationManager.newLocation(this.locationNameTextField.getText());
        this.yardModel.initTable(this.yardTable, location);
        this.spurModel.initTable(this.spurTable, location);
        this.interchangeModel.initTable(this.interchangeTable, location);
        this.stagingModel.initTable(this.stagingTable, location);
        this._location = location;
        this._location.addPropertyChangeListener(this);
        this.updateCheckboxes();
        this.enableButtons(true);
        this.setTrainDirectionBoxes();
        this.saveLocation();
        this.loadToolMenu();
    }

    private void deleteLocation() {
        Location location = this.locationManager.getLocationByName(this.locationNameTextField.getText());
        if (location == null) {
            return;
        }
        Route route = InstanceManager.getDefault(RouteManager.class).isLocationInUse(location);
        if (route != null) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("RouteUsesLocation", route.getName(), location.getName()), Bundle.getMessage("CanNotDeleteLocation"), 0);
            ShowRoutesServingLocationFrame frame = new ShowRoutesServingLocationFrame();
            frame.initComponents(location);
            return;
        }
        int count = location.getNumberRS();
        if (count > 0 ? JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("ThereAreCars", Integer.toString(count)), Bundle.getMessage("deletelocation?"), 0) != 0 : JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("DoYouWantToDeleteLocation", this.locationNameTextField.getText()), Bundle.getMessage("deletelocation?"), 0) != 0) {
            return;
        }
        this.yardModel.dispose();
        this.spurModel.dispose();
        this.interchangeModel.dispose();
        this.stagingModel.dispose();
        if (this.yef != null) {
            this.yef.dispose();
        }
        if (this.sef != null) {
            this.sef.dispose();
        }
        if (this.ief != null) {
            this.ief.dispose();
        }
        if (this.stef != null) {
            this.stef.dispose();
        }
        this.locationManager.deregister(location);
        this._location = null;
        this.selectCheckboxes(false);
        this.enableCheckboxes(false);
        this.enableButtons(false);
    }

    private void saveLocation() {
        if (!this.checkName(Bundle.getMessage("save"))) {
            return;
        }
        if (this.spurTable.isEditing()) {
            this.spurTable.getCellEditor().stopCellEditing();
        }
        if (this.yardTable.isEditing()) {
            this.yardTable.getCellEditor().stopCellEditing();
        }
        if (this.interchangeTable.isEditing()) {
            this.interchangeTable.getCellEditor().stopCellEditing();
        }
        if (this.stagingTable.isEditing()) {
            this.stagingTable.getCellEditor().stopCellEditing();
        }
        this._location.setName(this.locationNameTextField.getText());
        this._location.setComment(TrainCommon.formatColorString(this.commentTextArea.getText(), this.commentColorChooser.getColor()));
        this._location.setDivision((Division)this.divisionComboBox.getSelectedItem());
        if (Setup.isRfidEnabled() && this.readerSelector != null) {
            this._location.setReporter((Reporter)this.readerSelector.getSelectedItem());
        }
        OperationsXml.save();
    }

    private boolean checkName(String s) {
        String locationName = this.locationNameTextField.getText().trim();
        if (locationName.isEmpty()) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MustEnterName"), Bundle.getMessage("CanNotLocation", s), 0);
            return false;
        }
        if (locationName.contains("-")) {
            String[] check = locationName.split("-");
            if (check.length == 0) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("HyphenFeature"), Bundle.getMessage("CanNotLocation", s), 0);
                return false;
            }
            locationName = check[0];
        }
        if (TrainCommon.splitString(locationName).length() > MAX_NAME_LENGTH) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LocationNameLengthMax", Integer.toString(MAX_NAME_LENGTH + 1)), Bundle.getMessage("CanNotLocation", s), 0);
            return false;
        }
        if (!OperationsXml.checkFileName(locationName)) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NameResChar") + "\n" + Bundle.getMessage("ReservedChar"), Bundle.getMessage("CanNotLocation", s), 0);
            return false;
        }
        return true;
    }

    private void reportLocationExists(String s) {
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LocationAlreadyExists"), Bundle.getMessage("CanNotLocation", s), 0);
    }

    private void enableButtons(boolean enabled) {
        this.toolMenu.setEnabled(enabled);
        this.northCheckBox.setEnabled(enabled);
        this.southCheckBox.setEnabled(enabled);
        this.eastCheckBox.setEnabled(enabled);
        this.westCheckBox.setEnabled(enabled);
        this.divisionComboBox.setEnabled(enabled);
        this.editDivisionButton.setEnabled(enabled);
        this.clearButton.setEnabled(enabled);
        this.setButton.setEnabled(enabled);
        this.autoSelectButton.setEnabled(enabled);
        this.addYardButton.setEnabled(enabled);
        this.addSpurButton.setEnabled(enabled);
        this.addInterchangeButton.setEnabled(enabled);
        this.addStagingButton.setEnabled(enabled);
        this.saveLocationButton.setEnabled(enabled);
        this.deleteLocationButton.setEnabled(enabled);
        this.addLocationButton.setEnabled(!enabled);
        this.spurRadioButton.setEnabled(enabled);
        this.yardRadioButton.setEnabled(enabled);
        this.interchangeRadioButton.setEnabled(enabled);
        this.stagingRadioButton.setEnabled(enabled);
        if (this.readerSelector != null) {
            this.readerSelector.setEnabled(enabled && Setup.isRfidEnabled());
        }
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        this.setVisibleTrackType();
    }

    private void setVisibleTrackType() {
        this.enableTrackTypeRadioButtons();
        this.interchangePane.setVisible(this.interchangeRadioButton.isSelected());
        this.addInterchangeButton.setVisible(this.interchangeRadioButton.isSelected());
        this.stagingPane.setVisible(this.stagingRadioButton.isSelected());
        this.addStagingButton.setVisible(this.stagingRadioButton.isSelected());
        this.yardPane.setVisible(this.yardRadioButton.isSelected());
        this.addYardButton.setVisible(this.yardRadioButton.isSelected());
        this.spurPane.setVisible(this.spurRadioButton.isSelected());
        this.addSpurButton.setVisible(this.spurRadioButton.isSelected());
    }

    private void enableTrackTypeRadioButtons() {
        if (this.spurModel.getRowCount() > 0 || this.yardModel.getRowCount() > 0 || this.interchangeModel.getRowCount() > 0) {
            if (this.stagingRadioButton.isSelected()) {
                this.spurRadioButton.setSelected(true);
            }
            this.stagingRadioButton.setEnabled(false);
        } else if (this.stagingModel.getRowCount() > 0) {
            this.stagingRadioButton.setSelected(true);
            this.spurRadioButton.setEnabled(false);
            this.yardRadioButton.setEnabled(false);
            this.interchangeRadioButton.setEnabled(false);
        } else if (this._location != null) {
            this.spurRadioButton.setEnabled(true);
            this.yardRadioButton.setEnabled(true);
            this.interchangeRadioButton.setEnabled(true);
            this.stagingRadioButton.setEnabled(true);
        }
    }

    private void enableCheckboxes(boolean enable) {
        for (JCheckBox checkBox : new ArrayList<JCheckBox>(this.checkBoxes)) {
            checkBox.setEnabled(enable);
        }
    }

    private void selectCheckboxes(boolean select) {
        for (JCheckBox checkBox : new ArrayList<JCheckBox>(this.checkBoxes)) {
            checkBox.setSelected(select);
            if (this._location == null) continue;
            if (select) {
                this._location.addTypeName(checkBox.getText());
                continue;
            }
            this._location.deleteTypeName(checkBox.getText());
        }
    }

    private void updateCheckboxes() {
        this.x = 0;
        this.y = 0;
        this.checkBoxes.clear();
        this.panelCheckBoxes.removeAll();
        this.numberOfCheckBoxes = this.getNumberOfCheckboxesPerLine();
        this.loadTypes(InstanceManager.getDefault(CarTypes.class).getNames());
        this.checkNewLine();
        this.loadTypes(InstanceManager.getDefault(EngineTypes.class).getNames());
        JPanel p = new JPanel();
        p.add(this.clearButton);
        p.add(this.setButton);
        p.add(this.autoSelectButton);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridwidth = this.getNumberOfCheckboxesPerLine() + 1;
        gc.gridy = ++this.y;
        this.panelCheckBoxes.add((Component)p, gc);
        this.panelCheckBoxes.revalidate();
        this.repaint();
    }

    protected void updateDivisionComboBox() {
        InstanceManager.getDefault(DivisionManager.class).updateComboBox(this.divisionComboBox);
        if (this._location != null) {
            this.divisionComboBox.setSelectedItem(this._location.getDivision());
        }
    }

    private void loadTypes(String[] types) {
        for (String type : types) {
            JCheckBox checkBox = new JCheckBox();
            this.checkBoxes.add(checkBox);
            checkBox.setText(type);
            this.addCheckBoxAction(checkBox);
            this.addItemLeft(this.panelCheckBoxes, checkBox, this.x, this.y);
            if (this._location != null) {
                if (this._location.acceptsTypeName(type)) {
                    checkBox.setSelected(true);
                }
            } else {
                checkBox.setEnabled(false);
            }
            this.checkNewLine();
        }
    }

    private void checkNewLine() {
        if (++this.x > this.numberOfCheckBoxes) {
            ++this.y;
            this.x = 0;
        }
    }

    private void autoSelectCheckboxes() {
        for (JCheckBox checkBox : new ArrayList<JCheckBox>(this.checkBoxes)) {
            checkBox.setSelected(false);
            List<Track> tracks = this._location.getTracksList();
            for (Track track : tracks) {
                if (!track.isTypeNameAccepted(checkBox.getText())) continue;
                checkBox.setSelected(true);
            }
            if (checkBox.isSelected()) continue;
            this._location.deleteTypeName(checkBox.getText());
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        JCheckBox b = (JCheckBox)ae.getSource();
        log.debug("checkbox change {}", (Object)b.getText());
        if (this._location == null) {
            return;
        }
        this._location.removePropertyChangeListener(this);
        if (b.isSelected()) {
            this._location.addTypeName(b.getText());
            if (InstanceManager.getDefault(CarTypes.class).containsName(b.getText())) {
                if (this.lctf != null) {
                    this.lctf.dispose();
                }
                this.lctf = new LocationsByCarTypeFrame();
                this.lctf.initComponents(this._location, b.getText());
            }
        } else {
            this._location.deleteTypeName(b.getText());
        }
        this._location.addPropertyChangeListener(this);
    }

    private void addCheckBoxTrainAction(JCheckBox b) {
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocationEditFrame.this.checkBoxActionTrainPerformed(e);
            }
        });
    }

    private void checkBoxActionTrainPerformed(ActionEvent ae) {
        if (this._location == null) {
            return;
        }
        int direction = 0;
        if (this.northCheckBox.isSelected()) {
            direction += 4;
        }
        if (this.southCheckBox.isSelected()) {
            direction += 8;
        }
        if (this.eastCheckBox.isSelected()) {
            ++direction;
        }
        if (this.westCheckBox.isSelected()) {
            direction += 2;
        }
        this._location.setTrainDirections(direction);
    }

    private void setTrainDirectionBoxes() {
        this.northCheckBox.setVisible((Setup.getTrainDirection() & 4) == 4);
        this.southCheckBox.setVisible((Setup.getTrainDirection() & 8) == 8);
        this.eastCheckBox.setVisible((Setup.getTrainDirection() & 1) == 1);
        this.westCheckBox.setVisible((Setup.getTrainDirection() & 2) == 2);
        this.northCheckBox.setSelected((this._location.getTrainDirections() & 4) == 4);
        this.southCheckBox.setSelected((this._location.getTrainDirections() & 8) == 8);
        this.eastCheckBox.setSelected((this._location.getTrainDirections() & 1) == 1);
        this.westCheckBox.setSelected((this._location.getTrainDirections() & 2) == 2);
    }

    @Override
    protected void comboBoxActionPerformed(ActionEvent ae) {
        this.setDivisionButtonText();
    }

    private void setDivisionButtonText() {
        if (this.divisionComboBox.getSelectedItem() == null) {
            this.editDivisionButton.setText(Bundle.getMessage("Add"));
        } else {
            this.editDivisionButton.setText(Bundle.getMessage("ButtonEdit"));
        }
    }

    @Override
    public void dispose() {
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(EngineTypes.class).removePropertyChangeListener(this);
        this.yardModel.dispose();
        this.spurModel.dispose();
        this.interchangeModel.dispose();
        this.stagingModel.dispose();
        if (this.lctf != null) {
            this.lctf.dispose();
        }
        if (this.yef != null) {
            this.yef.dispose();
        }
        if (this.sef != null) {
            this.sef.dispose();
        }
        if (this.ief != null) {
            this.ief.dispose();
        }
        if (this.stef != null) {
            this.stef.dispose();
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("EngineTypesLength") || e.getPropertyName().equals("locationTypes")) {
            this.updateCheckboxes();
        }
        if (e.getPropertyName().equals("divisionsListLength")) {
            this.updateDivisionComboBox();
        }
        if (e.getPropertyName().equals("setupTrainDirectionChange")) {
            this.setTrainDirectionBoxes();
        }
    }
}

