/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.gui;

import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.gui.Bundle;
import jmri.jmrit.operations.locations.gui.TrackEditFrame;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleEditFrame;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.locations.tools.AlternateTrackAction;
import jmri.jmrit.operations.locations.tools.ChangeTrackTypeAction;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpurEditFrame
extends TrackEditFrame {
    JLabel textSchedule = new JLabel(Bundle.getMessage("DeliverySchedule"));
    JLabel textSchError = new JLabel();
    JButton editScheduleButton = new JButton();
    JComboBox<Schedule> comboBoxSchedules = InstanceManager.getDefault(ScheduleManager.class).getComboBox();
    JPanel panelSchedule = this.panelOpt4;
    ScheduleEditFrame sef = null;
    private static final Logger log = LoggerFactory.getLogger(SpurEditFrame.class);

    public SpurEditFrame() {
        super(Bundle.getMessage("AddSpur"));
    }

    @Override
    public void initComponents(Track track) {
        this.setTitle(Bundle.getMessage("EditSpur", track.getLocation().getName()));
        this.initComponents(track.getLocation(), track);
    }

    @Override
    public void initComponents(Location location, Track track) {
        this._type = "Spur";
        this.panelSchedule.setLayout(new GridBagLayout());
        this.panelSchedule.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("DeliverySchedule")));
        this.addItem(this.panelSchedule, this.comboBoxSchedules, 0, 0);
        this.addItem(this.panelSchedule, this.editScheduleButton, 1, 0);
        this.addItem(this.panelSchedule, this.textSchError, 2, 0);
        this.textSchError.setForeground(Color.RED);
        super.initComponents(location, track);
        this._toolMenu.insert(new AlternateTrackAction(this), 0);
        this._toolMenu.insert(new ChangeTrackTypeAction(this), 7);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Spurs", true);
        this.panelTrainDir.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainSpur")));
        this.paneCheckBoxes.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TypesSpur")));
        this.deleteTrackButton.setText(Bundle.getMessage("DeleteSpur"));
        this.addTrackButton.setText(Bundle.getMessage("AddSpur"));
        this.saveTrackButton.setText(Bundle.getMessage("SaveSpur"));
        this.autoSelectButton.setToolTipText(Bundle.getMessage("TipAutoSelectSchedule"));
        this.addButtonAction(this.autoSelectButton);
        this.addButtonAction(this.editScheduleButton);
        this.addComboBoxAction(this.comboBoxSchedules);
        this.updateScheduleComboBox();
        InstanceManager.getDefault(ScheduleManager.class).addPropertyChangeListener(this);
        this.panelOrder.setVisible(false);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.autoSelectButton) {
            this.autoSelectCheckboxes();
        }
        if (ae.getSource() == this.editScheduleButton) {
            this.editAddSchedule();
        }
        super.buttonActionPerformed(ae);
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        this.removeSchedulePropertyListener();
        this.updateScheduleButtonText();
    }

    private void updateScheduleButtonText() {
        if (this.comboBoxSchedules.getSelectedItem() == null) {
            this.editScheduleButton.setText(Bundle.getMessage("Add"));
        } else {
            this.editScheduleButton.setText(Bundle.getMessage("ButtonEdit"));
        }
    }

    private void autoSelectCheckboxes() {
        if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("TipAutoSelectSchedule"), Bundle.getMessage("AutoSelect"), 0) == 0) {
            for (int i = 0; i < this.checkBoxes.size(); ++i) {
                JCheckBox checkBox = (JCheckBox)this.checkBoxes.get(i);
                if (this._track == null || this._track.getSchedule() == null) continue;
                Schedule schedule = this._track.getSchedule();
                if (schedule.checkScheduleAttribute(Track.TYPE, checkBox.getText(), null)) {
                    this._track.addTypeName(checkBox.getText());
                    continue;
                }
                this._track.deleteTypeName(checkBox.getText());
            }
        }
    }

    private void editAddSchedule() {
        log.debug("Edit/add schedule");
        if (this.sef != null) {
            this.sef.dispose();
        }
        Schedule schedule = (Schedule)this.comboBoxSchedules.getSelectedItem();
        this.sef = new ScheduleEditFrame(schedule, this._track);
    }

    @Override
    protected void enableButtons(boolean enabled) {
        this.autoSelectButton.setEnabled(enabled && this._track.getSchedule() != null);
        this.editScheduleButton.setEnabled(enabled);
        this.comboBoxSchedules.setEnabled(enabled);
        if (!enabled) {
            this.comboBoxSchedules.setSelectedItem(null);
        }
        super.enableButtons(enabled);
    }

    @Override
    protected void saveTrack(Track track) {
        Schedule schedule = (Schedule)this.comboBoxSchedules.getSelectedItem();
        track.setSchedule(schedule);
        this.textSchError.setText(track.checkScheduleValid());
        super.saveTrack(track);
    }

    @Override
    protected void addNewTrack() {
        super.addNewTrack();
        this.updateScheduleComboBox();
    }

    @Override
    protected void deleteTrack() {
        this.removeSchedulePropertyListener();
        super.deleteTrack();
    }

    private void updateScheduleComboBox() {
        InstanceManager.getDefault(ScheduleManager.class).updateComboBox(this.comboBoxSchedules);
        if (this._track != null) {
            Schedule sch = InstanceManager.getDefault(ScheduleManager.class).getScheduleById(this._track.getScheduleId());
            this.comboBoxSchedules.setSelectedItem(sch);
            this.textSchError.setText(this._track.checkScheduleValid());
            if (sch != null) {
                sch.removePropertyChangeListener(this);
                sch.addPropertyChangeListener(this);
            }
        }
    }

    @Override
    public void dispose() {
        this.removeSchedulePropertyListener();
        super.dispose();
    }

    private void removeSchedulePropertyListener() {
        Schedule sch;
        InstanceManager.getDefault(ScheduleManager.class).removePropertyChangeListener(this);
        if (this._track != null && (sch = InstanceManager.getDefault(ScheduleManager.class).getScheduleById(this._track.getScheduleId())) != null) {
            sch.removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("scheduleListLength") || e.getPropertyName().equals("trackScheduleId")) {
            this.updateScheduleComboBox();
        }
        if (e.getSource().getClass().equals(Schedule.class) && this._track != null) {
            this.textSchError.setText(this._track.checkScheduleValid());
        }
        super.propertyChange(e);
    }
}

