/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.OperationsTableModel;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.gui.Bundle;
import jmri.jmrit.operations.locations.gui.TrackEditFrame;
import jmri.jmrit.operations.locations.tools.TrackEditCommentsFrame;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TrackTableModel
extends OperationsTableModel
implements PropertyChangeListener,
TableColumnModelListener {
    protected Location _location;
    protected List<Track> _tracksList = new ArrayList<Track>();
    protected String _trackType;
    protected JTable _table;
    protected boolean _dirty = false;
    protected static final int ID_COLUMN = 0;
    protected static final int NAME_COLUMN = 1;
    protected static final int LENGTH_COLUMN = 2;
    protected static final int USED_LENGTH_COLUMN = 3;
    protected static final int RESERVED_COLUMN = 4;
    protected static final int MOVES_COLUMN = 5;
    protected static final int CARS_COLUMN = 6;
    protected static final int LOCOS_COLUMN = 7;
    protected static final int PICKUPS_COLUMN = 8;
    protected static final int SETOUT_COLUMN = 9;
    protected static final int SCHEDULE_COLUMN = 10;
    protected static final int ROAD_COLUMN = 11;
    protected static final int LOAD_COLUMN = 12;
    protected static final int DEFAULT_LOAD_COLUMN = 13;
    protected static final int CUSTOM_LOAD_COLUMN = 14;
    protected static final int DISABLE_LOAD_CHANGE_COLUMN = 15;
    protected static final int QUICK_SERVICE_COLUMN = 16;
    protected static final int SHIP_COLUMN = 17;
    protected static final int RESTRICTION_COLUMN = 18;
    protected static final int DESTINATION_COLUMN = 19;
    protected static final int ROUTED_COLUMN = 20;
    protected static final int HOLD_COLUMN = 21;
    protected static final int POOL_COLUMN = 22;
    protected static final int PLANPICKUP_COLUMN = 23;
    protected static final int ALT_TRACK_COLUMN = 24;
    protected static final int ORDER_COLUMN = 25;
    protected static final int TRAIN_DIRECTION_COLUMN = 26;
    protected static final int REPORTER_COLUMN = 27;
    protected static final int COMMENT_COLUMN = 28;
    protected static final int EDIT_COLUMN = 29;
    protected static final int HIGHESTCOLUMN = 30;
    TrackEditFrame tef = null;
    private static final Logger log = LoggerFactory.getLogger(TrackTableModel.class);

    protected void initTable(JTable table, Location location, String trackType) {
        this._table = table;
        this._location = location;
        this._trackType = trackType;
        if (this._location != null) {
            this._location.addPropertyChangeListener(this);
        }
        Setup.getDefault().addPropertyChangeListener(this);
        this.updateList();
        this.initTable();
    }

    private void updateList() {
        if (this._location == null) {
            return;
        }
        this.removePropertyChangeTracks();
        this._tracksList = this._location.getTracksByNameList(this._trackType);
        for (Track track : this._tracksList) {
            track.addPropertyChangeListener(this);
        }
    }

    private void initTable() {
        XTableColumnModel tcm = new XTableColumnModel();
        this._table.setColumnModel(tcm);
        this._table.createDefaultColumnsFromModel();
        tcm.getColumn(0).setPreferredWidth(40);
        tcm.getColumn(1).setPreferredWidth(200);
        tcm.getColumn(2).setPreferredWidth(Math.max(50, new JLabel((String)this.getColumnName((int)2)).getPreferredSize().width + 10));
        tcm.getColumn(3).setPreferredWidth(50);
        tcm.getColumn(4).setPreferredWidth(Math.max(65, new JLabel((String)this.getColumnName((int)4)).getPreferredSize().width + 10));
        tcm.getColumn(5).setPreferredWidth(60);
        tcm.getColumn(7).setPreferredWidth(60);
        tcm.getColumn(6).setPreferredWidth(60);
        tcm.getColumn(8).setPreferredWidth(Math.max(60, new JLabel((String)this.getColumnName((int)8)).getPreferredSize().width + 10));
        tcm.getColumn(9).setPreferredWidth(Math.max(60, new JLabel((String)this.getColumnName((int)9)).getPreferredSize().width + 10));
        tcm.getColumn(10).setPreferredWidth(Math.max(90, new JLabel((String)this.getColumnName((int)10)).getPreferredSize().width + 10));
        tcm.getColumn(18).setPreferredWidth(90);
        tcm.getColumn(12).setPreferredWidth(50);
        tcm.getColumn(13).setPreferredWidth(60);
        tcm.getColumn(14).setPreferredWidth(90);
        tcm.getColumn(15).setPreferredWidth(50);
        tcm.getColumn(16).setPreferredWidth(50);
        tcm.getColumn(17).setPreferredWidth(50);
        tcm.getColumn(11).setPreferredWidth(50);
        tcm.getColumn(19).setPreferredWidth(50);
        tcm.getColumn(20).setPreferredWidth(50);
        tcm.getColumn(21).setPreferredWidth(50);
        tcm.getColumn(22).setPreferredWidth(70);
        tcm.getColumn(23).setPreferredWidth(70);
        tcm.getColumn(24).setPreferredWidth(120);
        tcm.getColumn(25).setPreferredWidth(Math.max(50, new JLabel((String)this.getColumnName((int)25)).getPreferredSize().width + 10));
        tcm.getColumn(26).setPreferredWidth(30);
        tcm.getColumn(27).setPreferredWidth(70);
        tcm.getColumn(28).setPreferredWidth(80);
        tcm.getColumn(29).setPreferredWidth(80);
        tcm.getColumn(28).setCellRenderer(new ButtonRenderer());
        tcm.getColumn(28).setCellEditor(new ButtonEditor(new JButton()));
        tcm.getColumn(29).setCellRenderer(new ButtonRenderer());
        tcm.getColumn(29).setCellEditor(new ButtonEditor(new JButton()));
        OperationsPanel.loadTableDetails(this._table, "Location");
        this.setColumnsVisible();
        this.addTableColumnListeners();
    }

    private void setColumnsVisible() {
        XTableColumnModel tcm = (XTableColumnModel)this._table.getColumnModel();
        tcm.setColumnVisible(tcm.getColumnByModelIndex(0), InstanceManager.getDefault(LocationManager.class).isShowIdEnabled());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(10), this._location.hasSchedules() && this._trackType.equals("Spur"));
        tcm.setColumnVisible(tcm.getColumnByModelIndex(18), this._location.hasServiceRestrictions() && !this._trackType.equals("Yard"));
        tcm.setColumnVisible(tcm.getColumnByModelIndex(12), this._location.hasLoadRestrictions());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(13), this._trackType.equals("Staging"));
        tcm.setColumnVisible(tcm.getColumnByModelIndex(14), this._trackType.equals("Staging"));
        tcm.setColumnVisible(tcm.getColumnByModelIndex(15), this._location.hasDisableLoadChange() && this._trackType.equals("Spur"));
        tcm.setColumnVisible(tcm.getColumnByModelIndex(16), this._location.hasQuickService() && this._trackType.equals("Spur"));
        tcm.setColumnVisible(tcm.getColumnByModelIndex(17), this._location.hasShipLoadRestrictions());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(11), this._location.hasRoadRestrictions());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(19), this._location.hasDestinationRestrictions() && (this._trackType.equals("Interchange") || this._trackType.equals("Staging")));
        tcm.setColumnVisible(tcm.getColumnByModelIndex(20), this._trackType.equals("Interchange") || this._trackType.equals("Staging"));
        tcm.setColumnVisible(tcm.getColumnByModelIndex(21), this._location.hasSchedules() && this._location.hasAlternateTracks() && this._trackType.equals("Spur"));
        tcm.setColumnVisible(tcm.getColumnByModelIndex(23), this._location.hasPlannedPickups());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(22), this._location.hasPools());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(24), this._location.hasAlternateTracks());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(25), this._location.hasOrderRestrictions() && !this._trackType.equals("Spur"));
        tcm.setColumnVisible(tcm.getColumnByModelIndex(26), this._location.hasTracksWithRestrictedTrainDirections());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(27), Setup.isRfidEnabled() && this._location.hasReporters());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(5), Setup.isShowTrackMovesEnabled());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(28), this._location.hasTrackMessages());
    }

    private void addTableColumnListeners() {
        Enumeration<TableColumn> e = this._table.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            TableColumn column = e.nextElement();
            column.addPropertyChangeListener(this);
        }
        this._table.getColumnModel().addColumnModelListener(this);
    }

    private void setDirty(boolean dirty) {
        this._dirty = dirty;
    }

    private boolean isDirty() {
        return this._dirty;
    }

    @Override
    public int getRowCount() {
        return this._tracksList.size();
    }

    @Override
    public int getColumnCount() {
        return 30;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Id");
            }
            case 1: {
                return Bundle.getMessage("TrackName");
            }
            case 2: {
                return Bundle.getMessage("Length");
            }
            case 3: {
                return Bundle.getMessage("Used");
            }
            case 4: {
                return Bundle.getMessage("Reserved");
            }
            case 5: {
                return Bundle.getMessage("Moves");
            }
            case 7: {
                return Bundle.getMessage("Engines");
            }
            case 6: {
                return Bundle.getMessage("Cars");
            }
            case 8: {
                return Bundle.getMessage("Pickups");
            }
            case 9: {
                return Bundle.getMessage("Drop");
            }
            case 10: {
                return Bundle.getMessage("Schedule");
            }
            case 18: {
                return Bundle.getMessage("Restrictions");
            }
            case 12: {
                return Bundle.getMessage("Load");
            }
            case 13: {
                return Bundle.getMessage("LoadDefaultAbv");
            }
            case 14: {
                return Bundle.getMessage("LoadCustomAbv");
            }
            case 15: {
                return Bundle.getMessage("DisableLoadChange");
            }
            case 16: {
                return Bundle.getMessage("QuickLoadService");
            }
            case 17: {
                return Bundle.getMessage("Ship");
            }
            case 11: {
                return Bundle.getMessage("Road");
            }
            case 19: {
                return Bundle.getMessage("Dest");
            }
            case 20: {
                return Bundle.getMessage("Routed");
            }
            case 21: {
                return Bundle.getMessage("Hold");
            }
            case 22: {
                return Bundle.getMessage("Pool");
            }
            case 23: {
                return Bundle.getMessage("PlanPickUp");
            }
            case 24: {
                return Bundle.getMessage("AlternateTrack");
            }
            case 25: {
                return Bundle.getMessage("ServiceOrder");
            }
            case 26: {
                return Bundle.getMessage("AbbrevationDirection");
            }
            case 27: {
                return Bundle.getMessage("Reporters");
            }
            case 28: {
                return Bundle.getMessage("Comment");
            }
            case 29: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return String.class;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return Integer.class;
            }
            case 28: 
            case 29: {
                return JButton.class;
            }
            case 15: 
            case 16: 
            case 20: 
            case 21: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 5: 
            case 15: 
            case 16: 
            case 20: 
            case 28: 
            case 29: {
                return true;
            }
            case 21: {
                return this.isHoldCarEnabled(row);
            }
        }
        return false;
    }

    private boolean isHoldCarEnabled(int row) {
        Track track = this._tracksList.get(row);
        return track.getAlternateTrack() != null && track.getSchedule() != null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        Track track = this._tracksList.get(row);
        if (track == null) {
            return "ERROR track unknown " + row;
        }
        switch (col) {
            case 0: {
                return track.getId();
            }
            case 1: {
                return track.getName();
            }
            case 2: {
                return track.getLength();
            }
            case 3: {
                return track.getUsedLength();
            }
            case 4: {
                return track.getReserved();
            }
            case 5: {
                return track.getMoves();
            }
            case 7: {
                return track.getNumberEngines();
            }
            case 6: {
                return track.getNumberCars();
            }
            case 8: {
                return track.getPickupRS();
            }
            case 9: {
                return track.getDropRS();
            }
            case 10: {
                return track.getScheduleName();
            }
            case 18: {
                return this.getRestrictions(track);
            }
            case 12: {
                return this.getModifiedString(track.getLoadNames().length, track.getLoadOption().equals(Track.ALL_LOADS), track.getLoadOption().equals(Track.INCLUDE_LOADS));
            }
            case 13: {
                return this.getDefaultLoadString(track);
            }
            case 14: {
                return this.getCustomLoadString(track);
            }
            case 15: {
                return track.isDisableLoadChangeEnabled();
            }
            case 16: {
                return track.isQuickServiceEnabled();
            }
            case 17: {
                return this.getModifiedString(track.getShipLoadNames().length, track.getShipLoadOption().equals(Track.ALL_LOADS), track.getShipLoadOption().equals(Track.INCLUDE_LOADS));
            }
            case 11: {
                return this.getModifiedString(track.getRoadNames().length, track.getRoadOption().equals(Track.ALL_ROADS), track.getRoadOption().equals(Track.INCLUDE_ROADS));
            }
            case 19: {
                return this.getDestinationString(track);
            }
            case 20: {
                return track.isOnlyCarsWithFinalDestinationEnabled();
            }
            case 21: {
                return track.isHoldCarsWithCustomLoadsEnabled();
            }
            case 22: {
                return track.getPoolName();
            }
            case 23: {
                if (track.getIgnoreUsedLengthPercentage() > 0) {
                    return track.getIgnoreUsedLengthPercentage() + "%";
                }
                return "";
            }
            case 24: {
                if (track.getAlternateTrack() != null) {
                    return track.getAlternateTrack().getName();
                }
                if (track.isAlternate()) {
                    return Bundle.getMessage("ButtonYes");
                }
                return "";
            }
            case 25: {
                return track.getServiceOrder();
            }
            case 26: {
                return this.getDirection(track);
            }
            case 27: {
                return track.getReporterName();
            }
            case 28: {
                if (track.hasMessages()) {
                    return Bundle.getMessage("ButtonEdit");
                }
                return Bundle.getMessage("Add");
            }
            case 29: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown " + col;
    }

    private String getRestrictions(Track track) {
        String suffix;
        StringBuffer restrictions = new StringBuffer();
        if (!track.getDropOption().equals("Any")) {
            suffix = " ";
            if (track.getDropOption().equals("excludeRoutes") || track.getDropOption().equals("excludeTrains")) {
                suffix = "x";
            }
            restrictions.append(Bundle.getMessage("AbbreviationSetOut") + suffix + track.getDropIds().length);
        }
        if (!track.getPickupOption().equals("Any")) {
            suffix = " ";
            if (track.getPickupOption().equals("excludeRoutes") || track.getPickupOption().equals("excludeTrains")) {
                suffix = "x";
            }
            restrictions.append(" " + Bundle.getMessage("AbbreviationPickUp") + suffix + track.getPickupIds().length);
        }
        return restrictions.toString();
    }

    private String getModifiedString(int number, boolean all, boolean accept) {
        if (all) {
            return "";
        }
        if (accept) {
            return "A " + Integer.toString(number);
        }
        return "E " + Integer.toString(number);
    }

    private String getDefaultLoadString(Track track) {
        String defaultLoad = "";
        if (track.isLoadSwapEnabled()) {
            defaultLoad = Bundle.getMessage("ABV_SwapDefaultLoads");
        }
        if (track.isLoadEmptyEnabled()) {
            defaultLoad = Bundle.getMessage("ABV_EmptyDefaultLoads");
        }
        return defaultLoad;
    }

    private String getCustomLoadString(Track track) {
        StringBuffer customLoad = new StringBuffer();
        if (track.isRemoveCustomLoadsEnabled()) {
            customLoad.append(Bundle.getMessage("ABV_EmptyCustomLoads") + " ");
        }
        if (track.isAddCustomLoadsEnabled()) {
            customLoad.append(Bundle.getMessage("ABV_GenerateCustomLoad") + " ");
        }
        if (track.isAddCustomLoadsAnySpurEnabled()) {
            customLoad.append(Bundle.getMessage("ABV_GenerateCustomLoadAnySpur") + " ");
        }
        if (track.isAddCustomLoadsAnyStagingTrackEnabled()) {
            customLoad.append(Bundle.getMessage("ABV_GereateCustomLoadStaging"));
        }
        if (track.isBlockCarsEnabled()) {
            customLoad.append(Bundle.getMessage("ABV_CarBlocking"));
        }
        return customLoad.toString();
    }

    private String getDestinationString(Track track) {
        Location loc;
        int size = track.getDestinationListSize();
        if (track.getDestinationOption().equals(Track.EXCLUDE_DESTINATIONS)) {
            size = InstanceManager.getDefault(LocationManager.class).getNumberOfLocations() - size;
        } else if (size == 1 && track.getDestinationOption().equals(Track.INCLUDE_DESTINATIONS) && (loc = InstanceManager.getDefault(LocationManager.class).getLocationById(track.getDestinationIds()[0])) != null) {
            return loc.getName();
        }
        return this.getModifiedString(size, track.getDestinationOption().equals(Track.ALL_DESTINATIONS), track.getDestinationOption().equals(Track.INCLUDE_DESTINATIONS));
    }

    private String getDirection(Track track) {
        int trainDirections = track.getLocation().getTrainDirections() & Setup.getTrainDirection();
        if (trainDirections != (track.getTrainDirections() & trainDirections)) {
            switch (track.getTrainDirections() & trainDirections) {
                case 1: {
                    return Setup.EAST_DIR;
                }
                case 2: {
                    return Setup.WEST_DIR;
                }
                case 8: {
                    return Setup.SOUTH_DIR;
                }
                case 4: {
                    return Setup.NORTH_DIR;
                }
                case 0: {
                    return Bundle.getMessage("None");
                }
            }
            return "X";
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 15: {
                this.setDisableLoadChange(row, value);
                break;
            }
            case 16: {
                this.setQuickService(row, value);
                break;
            }
            case 20: {
                this.setRouted(row, value);
                break;
            }
            case 21: {
                this.setHold(row, value);
                break;
            }
            case 28: {
                this.trackComment(row);
                break;
            }
            case 29: {
                this.editTrack(row);
                break;
            }
            case 5: {
                this.setMoves(row, value);
                break;
            }
        }
    }

    protected abstract void editTrack(int var1);

    private void setDisableLoadChange(int row, Object value) {
        Track track = this._tracksList.get(row);
        track.setDisableLoadChangeEnabled((Boolean)value);
    }

    private void setQuickService(int row, Object value) {
        Track track = this._tracksList.get(row);
        track.setQuickServiceEnabled((Boolean)value);
    }

    private void setRouted(int row, Object value) {
        Track track = this._tracksList.get(row);
        track.setOnlyCarsWithFinalDestinationEnabled((Boolean)value);
    }

    private void setHold(int row, Object value) {
        Track track = this._tracksList.get(row);
        track.setHoldCarsWithCustomLoadsEnabled((Boolean)value);
    }

    private void setMoves(int row, Object value) {
        Track track = this._tracksList.get(row);
        track.setMoves((Integer)value);
    }

    private void trackComment(int row) {
        new TrackEditCommentsFrame(this._tracksList.get(row));
    }

    private void removePropertyChangeTracks() {
        for (Track track : this._tracksList) {
            track.removePropertyChangeListener(this);
        }
    }

    public void dispose() {
        if (this._table != null) {
            this._table.getRowSorter().setSortKeys(null);
            if (this.isDirty()) {
                OperationsPanel.cacheState(this._table);
                OperationsPanel.saveTableState();
                this.setDirty(false);
            }
        }
        this.removePropertyChangeTracks();
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        if (this.tef != null) {
            this.tef.dispose();
        }
        Setup.getDefault().removePropertyChangeListener(this);
        this._tracksList.clear();
        this.fireTableDataChanged();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("trackListLength") || e.getPropertyName().equals("locationTrainDirection")) {
            this.updateList();
            this.fireTableDataChanged();
        }
        if (e.getPropertyName().equals("setupShowTrackMoves") || e.getPropertyName().equals("locationTrainDirection") || e.getPropertyName().equals("setupRoutingStagingChange")) {
            this.setColumnsVisible();
        }
        if (e.getSource().getClass().equals(Track.class) && (e.getPropertyName().equals("trackDrop") || e.getPropertyName().equals("trackPickup") || e.getPropertyName().equals("trackScheduleId") || e.getPropertyName().equals("trackLoads") || e.getPropertyName().equals("trackRoads") || e.getPropertyName().equals("trackDestinationOptions") || e.getPropertyName().equals("trackPool") || e.getPropertyName().equals("plannedPickUps") || e.getPropertyName().equals("trackAlternate") || e.getPropertyName().equals("trackServiceOrder") || e.getPropertyName().equals("trackLoadOptions") || e.getPropertyName().equals("trackTrainDirection") || e.getPropertyName().equals("trackComments") || e.getPropertyName().equals("trackReporterChange"))) {
            this.setColumnsVisible();
        }
        if (e.getSource() instanceof TableColumn && e.getPropertyName().equals("preferredWidth")) {
            log.debug("Column width change");
            this.setDirty(true);
        }
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
        if (e.getFromIndex() != e.getToIndex()) {
            log.debug("Table Column Moved");
            this.setDirty(true);
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }
}

