/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.jmrit.operations.CommonConductorYardmasterPanel;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.gui.Bundle;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainSwitchListText;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YardmasterByTrackPanel
extends CommonConductorYardmasterPanel {
    protected Track _track = null;
    JTextPane textTrackCommentPane = new JTextPane();
    JComboBox<Track> trackComboBox = new JComboBox();
    JButton nextButton = new JButton(Bundle.getMessage("Next"));
    JPanel pTrack = new JPanel();
    JScrollPane pTrackPane;
    private static final Logger log = LoggerFactory.getLogger(YardmasterByTrackPanel.class);

    public YardmasterByTrackPanel() {
        this((Location)null);
    }

    public YardmasterByTrackPanel(Location location) {
        this.modifyButton.setVisible(false);
        this._location = location;
        this.textTrackCommentPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrackComment")));
        this.textTrackCommentPane.setBackground(null);
        this.textTrackCommentPane.setEditable(false);
        this.textTrackCommentPane.setMaximumSize(new Dimension(1000, 200));
        JPanel pTrackSelect = new JPanel();
        pTrackSelect.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Track")));
        pTrackSelect.add(this.trackComboBox);
        pTrackSelect.add(this.nextButton);
        this.pTrack.setLayout(new BoxLayout(this.pTrack, 1));
        this.pTrackPane = new JScrollPane(this.pTrack);
        this.pLocationName.setMaximumSize(new Dimension(2000, 200));
        pTrackSelect.setMaximumSize(new Dimension(2000, 200));
        this.pButtons.setMaximumSize(new Dimension(2000, 200));
        this.add(this.pLocationName);
        this.add(this.textLocationCommentPane);
        this.add(this.textSwitchListCommentPane);
        this.add(pTrackSelect);
        this.add(this.textTrackCommentPane);
        this.add(this.pTrackComments);
        this.add(this.pTrackPane);
        this.add(this.pButtons);
        if (this._location != null) {
            this.textLocationName.setText(this._location.getName());
            this.loadLocationComment(this._location);
            this.loadLocationSwitchListComment(this._location);
            this.updateTrackComboBox();
            this._location.addPropertyChangeListener(this);
        }
        this.update();
        this.addComboBoxAction(this.trackComboBox);
        this.addButtonAction(this.nextButton);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.nextButton) {
            this.nextButtonAction();
        }
        super.buttonActionPerformed(ae);
    }

    private void nextButtonAction() {
        log.debug("next button activated");
        if (this.trackComboBox.getItemCount() > 1) {
            int index = this.trackComboBox.getSelectedIndex();
            index = index == -1 ? 1 : ++index;
            if (index >= this.trackComboBox.getItemCount()) {
                index = 0;
            }
            this.trackComboBox.setSelectedIndex(index);
        }
    }

    @Override
    protected void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.trackComboBox && this.trackComboBox.isVisible()) {
            this._track = null;
            if (this.trackComboBox.getSelectedItem() != null) {
                this._track = (Track)this.trackComboBox.getSelectedItem();
            }
            this.update();
        }
    }

    @Override
    protected void update() {
        SwingUtilities.invokeLater(() -> this.runUpdate());
    }

    private void runUpdate() {
        log.debug("run update");
        this.removePropertyChangeListerners();
        this.trainCommon.clearUtilityCarTypes();
        this.checkBoxes.clear();
        this.pTrack.removeAll();
        if (this._track != null) {
            this.pTrackPane.setBorder(BorderFactory.createTitledBorder(this._track.getName()));
            this.textTrackCommentPane.setText(TrainCommon.getTextColorString(this._track.getComment()));
            this.textTrackCommentPane.setForeground(TrainCommon.getTextColor(this._track.getComment()));
            this.textTrackCommentPane.setVisible(!this._track.getComment().equals(""));
            for (Train train : this.trainManager.getTrainsArrivingThisLocationList(this._track.getLocation())) {
                JCheckBox checkBox;
                String text;
                JLabel header;
                JPanel pTrain = new JPanel();
                pTrain.setLayout(new BoxLayout(pTrain, 1));
                pTrain.setBorder(BorderFactory.createTitledBorder(MessageFormat.format(TrainSwitchListText.getStringScheduledWork(), train.getName(), train.getDescription())));
                boolean pickupCar = false;
                boolean setoutCar = false;
                JTextPane textTrackCommentWorkPane = this.getTrackWorkCommentPane();
                pTrain.add(textTrackCommentWorkPane);
                boolean localCar = false;
                boolean pickupEngine = false;
                boolean setoutEngine = false;
                JPanel pPickups = new JPanel();
                pPickups.setLayout(new BoxLayout(pPickups, 1));
                pPickups.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Pickup")));
                pPickups.setMaximumSize(new Dimension(2000, 2000));
                JPanel pSetouts = new JPanel();
                pSetouts.setLayout(new BoxLayout(pSetouts, 1));
                pSetouts.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SetOut")));
                pSetouts.setMaximumSize(new Dimension(2000, 2000));
                JPanel pLocal = new JPanel();
                pLocal.setLayout(new BoxLayout(pLocal, 1));
                pLocal.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LocalMoves")));
                pLocal.setMaximumSize(new Dimension(2000, 2000));
                List<Engine> engList = this.engManager.getByTrainBlockingList(train);
                if (Setup.isPrintHeadersEnabled()) {
                    for (Engine engine : engList) {
                        if (engine.getTrack() != this._track) continue;
                        JLabel header2 = new JLabel("    " + this.trainCommon.getPickupEngineHeader());
                        this.setLabelFont(header2);
                        pPickups.add(header2);
                        break;
                    }
                }
                for (Engine engine : engList) {
                    if (engine.getTrack() != this._track) continue;
                    engine.addPropertyChangeListener(this);
                    this.rollingStock.add(engine);
                    JCheckBox checkBox2 = new JCheckBox(this.trainCommon.pickupEngine(engine));
                    this.setCheckBoxFont(checkBox2, Setup.getPickupEngineColor());
                    pPickups.add(checkBox2);
                    pickupEngine = true;
                    this.checkBoxes.put(engine.getId() + "p", checkBox2);
                    this.pTrack.add(pTrain);
                }
                if (Setup.isPrintHeadersEnabled()) {
                    for (Engine engine : engList) {
                        if (engine.getDestinationTrack() != this._track) continue;
                        JLabel header2 = new JLabel("    " + this.trainCommon.getDropEngineHeader());
                        this.setLabelFont(header2);
                        pSetouts.add(header2);
                        break;
                    }
                }
                for (Engine engine : engList) {
                    if (engine.getDestinationTrack() != this._track) continue;
                    engine.addPropertyChangeListener(this);
                    this.rollingStock.add(engine);
                    JCheckBox checkBox2 = new JCheckBox(this.trainCommon.dropEngine(engine));
                    this.setCheckBoxFont(checkBox2, Setup.getDropEngineColor());
                    pSetouts.add(checkBox2);
                    setoutEngine = true;
                    this.checkBoxes.put(engine.getId(), checkBox2);
                    this.pTrack.add(pTrain);
                }
                List<Car> carList = this.carManager.getByTrainDestinationList(train);
                if (Setup.isPrintHeadersEnabled()) {
                    for (Car car : carList) {
                        if (car.getTrack() != this._track || car.getRouteDestination() == car.getRouteLocation()) continue;
                        JLabel header3 = new JLabel("    " + this.trainCommon.getPickupCarHeader(false, false));
                        this.setLabelFont(header3);
                        pPickups.add(header3);
                        break;
                    }
                }
                List<RouteLocation> list = train.getRoute().getLocationsBySequenceList();
                for (RouteLocation rl : list) {
                    for (Car car : carList) {
                        String text2;
                        if (car.getTrack() != this._track || car.getRouteDestination() == car.getRouteLocation() || car.getRouteDestination() != rl) continue;
                        car.addPropertyChangeListener(this);
                        this.rollingStock.add(car);
                        if (car.isUtility()) {
                            String text3 = this.trainCommon.pickupUtilityCars(carList, car, false, false);
                            if (text3 == null) {
                                continue;
                            }
                        } else {
                            text2 = this.trainCommon.pickupCar(car, false, false);
                        }
                        pickupCar = true;
                        JCheckBox checkBox3 = new JCheckBox(text2);
                        this.setCheckBoxFont(checkBox3, Setup.getPickupColor());
                        pPickups.add(checkBox3);
                        this.checkBoxes.put(car.getId() + "p", checkBox3);
                        this.pTrack.add(pTrain);
                    }
                }
                if (Setup.isPrintHeadersEnabled()) {
                    for (Car car : carList) {
                        if (car.getDestinationTrack() != this._track || car.getRouteDestination() == car.getRouteLocation()) continue;
                        header = new JLabel("    " + this.trainCommon.getDropCarHeader(false, false));
                        this.setLabelFont(header);
                        pSetouts.add(header);
                        break;
                    }
                }
                for (Car car : carList) {
                    if (car.getDestinationTrack() != this._track || car.getRouteLocation() == car.getRouteDestination()) continue;
                    car.addPropertyChangeListener(this);
                    this.rollingStock.add(car);
                    if (car.isUtility()) {
                        text = this.trainCommon.setoutUtilityCars(carList, car, false, false);
                        if (text == null) {
                            continue;
                        }
                    } else {
                        text = this.trainCommon.dropCar(car, false, false);
                    }
                    setoutCar = true;
                    checkBox = new JCheckBox(text);
                    this.setCheckBoxFont(checkBox, Setup.getDropColor());
                    pSetouts.add(checkBox);
                    this.checkBoxes.put(car.getId(), checkBox);
                    this.pTrack.add(pTrain);
                }
                if (Setup.isPrintHeadersEnabled()) {
                    for (Car car : carList) {
                        if (car.getTrack() != this._track && car.getDestinationTrack() != this._track || car.getRouteDestination() != car.getRouteLocation()) continue;
                        header = new JLabel("    " + this.trainCommon.getLocalMoveHeader(false));
                        this.setLabelFont(header);
                        pLocal.add(header);
                        break;
                    }
                }
                for (Car car : carList) {
                    if (car.getTrack() != this._track && car.getDestinationTrack() != this._track || car.getRouteLocation() == null || car.getRouteLocation() != car.getRouteDestination()) continue;
                    car.addPropertyChangeListener(this);
                    this.rollingStock.add(car);
                    if (car.isUtility()) {
                        text = this.trainCommon.setoutUtilityCars(carList, car, true, false);
                        if (text == null) {
                            continue;
                        }
                    } else {
                        text = this.trainCommon.localMoveCar(car, false);
                    }
                    if (car.getTrack() == this._track) {
                        pickupCar = true;
                    }
                    if (car.getDestinationTrack() == this._track) {
                        setoutCar = true;
                    }
                    checkBox = new JCheckBox(text);
                    this.setCheckBoxFont(checkBox, Setup.getLocalColor());
                    pLocal.add(checkBox);
                    localCar = true;
                    this.checkBoxes.put(car.getId(), checkBox);
                    this.pTrack.add(pTrain);
                }
                if (pickupCar && !setoutCar) {
                    textTrackCommentWorkPane.setText(this._track.getCommentPickup());
                    textTrackCommentWorkPane.setForeground(TrainCommon.getTextColor(this._track.getCommentPickupWithColor()));
                } else if (!pickupCar && setoutCar) {
                    textTrackCommentWorkPane.setText(this._track.getCommentSetout());
                    textTrackCommentWorkPane.setForeground(TrainCommon.getTextColor(this._track.getCommentSetoutWithColor()));
                } else if (pickupCar && setoutCar) {
                    textTrackCommentWorkPane.setText(this._track.getCommentBoth());
                    textTrackCommentWorkPane.setForeground(TrainCommon.getTextColor(this._track.getCommentBothWithColor()));
                }
                textTrackCommentWorkPane.setVisible(!textTrackCommentWorkPane.getText().isEmpty());
                if (pickupCar || pickupEngine) {
                    pTrain.add(pPickups);
                }
                if (setoutCar || setoutEngine) {
                    pTrain.add(pSetouts);
                }
                if (localCar) {
                    pTrain.add(pLocal);
                }
                this.pTrackPane.validate();
                pTrain.setMaximumSize(new Dimension(2000, pTrain.getHeight()));
                pTrain.revalidate();
            }
            List rsList = this.carManager.getByTrainList();
            ArrayList<Car> carList = new ArrayList<Car>();
            for (Car rs : rsList) {
                if (rs.getTrack() != this._track || rs.getRouteLocation() != null) continue;
                carList.add(rs);
            }
            JPanel pHoldCars = new JPanel();
            pHoldCars.setLayout(new BoxLayout(pHoldCars, 1));
            pHoldCars.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("HoldCars")));
            for (Car car : carList) {
                Object text;
                if (car.isUtility()) {
                    String s = this.trainCommon.pickupUtilityCars(carList, car, false, false);
                    if (s == null) continue;
                    text = TrainSwitchListText.getStringHoldCar().split("\\{")[0] + s.trim();
                } else {
                    text = MessageFormat.format(TrainSwitchListText.getStringHoldCar(), TrainCommon.padAndTruncateIfNeeded(car.getRoadName(), InstanceManager.getDefault(CarRoads.class).getMaxNameLength()), TrainCommon.padAndTruncateIfNeeded(TrainCommon.splitString(car.getNumber()), Control.max_len_string_print_road_number), TrainCommon.padAndTruncateIfNeeded(car.getTypeName().split("-")[0], InstanceManager.getDefault(CarTypes.class).getMaxNameLength()), TrainCommon.padAndTruncateIfNeeded(car.getLength() + Setup.getLengthUnitAbv(), Control.max_len_string_length_name), TrainCommon.padAndTruncateIfNeeded(car.getLoadName(), InstanceManager.getDefault(CarLoads.class).getMaxNameLength()), TrainCommon.padAndTruncateIfNeeded(this._track.getName(), InstanceManager.getDefault(LocationManager.class).getMaxTrackNameLength()), TrainCommon.padAndTruncateIfNeeded(car.getColor(), InstanceManager.getDefault(CarColors.class).getMaxNameLength()));
                }
                JCheckBox checkBox = new JCheckBox((String)text);
                this.setCheckBoxFont(checkBox, Color.black);
                pHoldCars.add(checkBox);
                this.checkBoxes.put(car.getId(), checkBox);
                this.pTrack.add(pHoldCars);
            }
            this.pTrackPane.validate();
            pHoldCars.setMaximumSize(new Dimension(2000, pHoldCars.getHeight()));
            pHoldCars.revalidate();
        } else {
            this.pTrackPane.setBorder(BorderFactory.createTitledBorder(""));
            this.textTrackCommentPane.setVisible(false);
        }
    }

    private JTextPane getTrackWorkCommentPane() {
        JTextPane textTrackCommentWorkPane = new JTextPane();
        textTrackCommentWorkPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        textTrackCommentWorkPane.setBackground(null);
        textTrackCommentWorkPane.setEditable(false);
        return textTrackCommentWorkPane;
    }

    private void updateTrackComboBox() {
        Object selectedItem = this.trackComboBox.getSelectedItem();
        this.trackComboBox.setVisible(false);
        if (this._location != null) {
            this._location.updateComboBox(this.trackComboBox);
        }
        if (selectedItem != null) {
            this.trackComboBox.setSelectedItem(selectedItem);
        }
        this.trackComboBox.setVisible(true);
    }

    @Override
    public void dispose() {
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        this.removePropertyChangeListerners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("rolling stock route location")) {
            this.update();
        }
        if (e.getPropertyName().equals("trackListLength")) {
            this.updateTrackComboBox();
        }
    }
}

