/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.jmrit.operations.CommonConductorYardmasterPanel;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.gui.Bundle;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YardmasterPanel
extends CommonConductorYardmasterPanel {
    int _visitNumber = 1;
    JComboBox<Train> trainComboBox = new JComboBox();
    JComboBox<Integer> trainVisitComboBox = new JComboBox();
    JButton nextButton = new JButton(Bundle.getMessage("Next"));
    JPanel pTrainVisit = new JPanel();
    private static final Logger log = LoggerFactory.getLogger(YardmasterPanel.class);

    public YardmasterPanel() {
        this((Location)null);
    }

    public YardmasterPanel(Location location) {
        this._location = location;
        JPanel pRow2 = new JPanel();
        pRow2.setLayout(new BoxLayout(pRow2, 0));
        pRow2.add(this.pLocationName);
        pRow2.add(this.pRailRoadName);
        JPanel pRow6 = new JPanel();
        pRow6.setLayout(new BoxLayout(pRow6, 0));
        JPanel pTrainName = new JPanel();
        pTrainName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Train")));
        pTrainName.add(this.trainComboBox);
        pTrainName.add(this.nextButton);
        this.pTrainVisit.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Visit")));
        YardmasterPanel.padComboBox(this.trainVisitComboBox, 2);
        this.pTrainVisit.add(this.trainVisitComboBox);
        pRow6.add(pTrainName);
        pRow6.add(this.pTrainVisit);
        pRow6.add(this.pTrainDescription);
        this.pButtons.setMaximumSize(new Dimension(2000, 200));
        this.add(pRow2);
        this.add(pRow6);
        this.add(this.textLocationCommentPane);
        this.add(this.textSwitchListCommentPane);
        this.add(this.textTrainCommentPane);
        this.add(this.textTrainRouteCommentPane);
        this.add(this.textTrainRouteLocationCommentPane);
        this.add(this.pTrackComments);
        this.add(this.textTrainStatusPane);
        this.add(this.locoPane);
        this.add(this.pWorkPanes);
        this.add(this.movePane);
        this.add(this.pStatus);
        this.add(this.pButtons);
        if (this._location != null) {
            this.textLocationName.setText(this._location.getName());
            this.loadLocationComment(this._location);
            this.loadLocationSwitchListComment(this._location);
            this.updateTrainsComboBox();
        }
        this.update();
        this.addComboBoxAction(this.trainComboBox);
        this.addComboBoxAction(this.trainVisitComboBox);
        this.addButtonAction(this.nextButton);
        this.addTrainListeners();
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.nextButton) {
            this.nextButtonAction();
        }
        super.buttonActionPerformed(ae);
    }

    private void nextButtonAction() {
        log.debug("next button activated");
        if (this.trainComboBox.getItemCount() > 1) {
            int index;
            if (this.pTrainVisit.isVisible() && (index = this.trainVisitComboBox.getSelectedIndex() + 1) < this.trainVisitComboBox.getItemCount()) {
                this.trainVisitComboBox.setSelectedIndex(index);
                return;
            }
            index = this.trainComboBox.getSelectedIndex();
            index = index == -1 ? 1 : ++index;
            if (index >= this.trainComboBox.getItemCount()) {
                index = 0;
            }
            this.trainComboBox.setSelectedIndex(index);
        }
    }

    @Override
    protected void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.trainComboBox && this.trainComboBox.isVisible()) {
            this._train = null;
            if (this.trainComboBox.getSelectedItem() != null) {
                this._train = (Train)this.trainComboBox.getSelectedItem();
                this._visitNumber = 1;
            }
            this.clearAndUpdate();
        }
        if (ae.getSource() == this.trainVisitComboBox && this.trainVisitComboBox.isVisible() && this.trainVisitComboBox.getSelectedItem() != null) {
            this._visitNumber = (Integer)this.trainVisitComboBox.getSelectedItem();
            this.clearAndUpdate();
        }
    }

    @Override
    protected void update() {
        log.debug("queue update");
        SwingUtilities.invokeLater(() -> {
            log.debug("update, setMode: {}", (Object)this.isSetMode);
            this.initialize();
            this.pButtons.setVisible(false);
            this.pTrainVisit.setVisible(false);
            this.trainVisitComboBox.setVisible(false);
            this.textTrainCommentPane.setVisible(false);
            this.textTrainRouteCommentPane.setVisible(false);
            this.textTrainRouteLocationCommentPane.setVisible(false);
            this.textTrainStatusPane.setVisible(false);
            this.textTrainDescription.setText("");
            this.textStatus.setText("");
            if (this._train != null && this._train.isBuilt() && this._train.getRoute() != null) {
                int i;
                this.pButtons.setVisible(true);
                this.loadTrainDescription();
                this.loadTrainComment();
                this.loadRouteComment();
                this.loadRailroadName();
                RouteLocation rl = null;
                List<RouteLocation> routeList = this._train.getRoute().getLocationsBySequenceList();
                int visitNumber = 0;
                for (i = 0; i < routeList.size(); ++i) {
                    if (!routeList.get(i).getSplitName().equals(this._location.getSplitName()) || ++visitNumber != this._visitNumber) continue;
                    rl = routeList.get(i);
                }
                if (rl != null) {
                    if (visitNumber > 1) {
                        this.trainVisitComboBox.removeAllItems();
                        for (i = 0; i < visitNumber; ++i) {
                            this.trainVisitComboBox.addItem(i + 1);
                        }
                        this.trainVisitComboBox.setSelectedItem(this._visitNumber);
                        this.trainVisitComboBox.setVisible(true);
                        this.pTrainVisit.setVisible(true);
                    }
                    if (Setup.isSwitchListRouteLocationCommentEnabled()) {
                        this.loadRouteLocationComment(rl);
                    }
                    this.textLocationName.setText(rl.getLocation().getName());
                    this.updateTrackComments(rl, false);
                    String msg = TrainCommon.getSwitchListTrainStatus(this._train, rl);
                    this.textTrainStatusPane.setText(msg);
                    this.textTrainStatusPane.setVisible(!msg.isBlank());
                    this.updateLocoPanes(rl);
                    this.blockCars(rl, false);
                    this.textStatus.setText(this.getStatus(rl, false));
                }
                this.updateComplete();
            }
        });
    }

    private void updateTrainsComboBox() {
        Object selectedItem = this.trainComboBox.getSelectedItem();
        this.trainComboBox.setVisible(false);
        this.trainComboBox.removeAllItems();
        this.trainComboBox.addItem(null);
        if (this._location != null) {
            List<Train> trains = this.trainManager.getTrainsArrivingThisLocationList(this._location);
            trains.stream().filter(train -> TrainCommon.isThereWorkAtLocation(train, this._location)).forEach(train -> this.trainComboBox.addItem((Train)train));
        }
        if (selectedItem != null) {
            this.trainComboBox.setSelectedItem(selectedItem);
        }
        YardmasterPanel.padComboBox(this.trainComboBox);
        this.trainComboBox.setVisible(true);
    }

    private void addTrainListeners() {
        log.debug("Adding train listerners");
        List<Train> trains = InstanceManager.getDefault(TrainManager.class).getTrainsByIdList();
        trains.stream().forEach(train -> train.addPropertyChangeListener(this));
        InstanceManager.getDefault(TrainManager.class).addPropertyChangeListener(this);
    }

    private void removeTrainListeners() {
        log.debug("Removing train listerners");
        List<Train> trains = InstanceManager.getDefault(TrainManager.class).getTrainsByIdList();
        trains.stream().forEach(train -> train.removePropertyChangeListener(this));
        InstanceManager.getDefault(TrainManager.class).removePropertyChangeListener(this);
    }

    @Override
    public void dispose() {
        this.removeTrainListeners();
        this.removePropertyChangeListerners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("rolling stock route location") && e.getNewValue() == null || e.getPropertyName().equals("rolling stock route destination") && e.getNewValue() == null || e.getPropertyName().equals("rolling stock train") || e.getPropertyName().equals("TrainModified")) {
            if (e.getSource().getClass().equals(Car.class)) {
                Car car = (Car)e.getSource();
                this.removeCarFromList(car);
            }
            this.update();
        }
        if (e.getPropertyName().equals("TrainBuilt")) {
            this.updateTrainsComboBox();
        }
        if (e.getPropertyName().equals("TrainMoveComplete") && e.getSource() == this._train) {
            this.update();
        }
    }
}

