/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import jmri.InstanceManager;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.LocationManagerXml;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.Bundle;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schedule
extends PropertyChangeSupport
implements PropertyChangeListener {
    protected String _id = "";
    protected String _name = "";
    protected String _comment = "";
    protected Hashtable<String, ScheduleItem> _scheduleHashTable = new Hashtable();
    protected int _IdNumber = 0;
    protected int _sequenceNum = 0;
    public static final String LISTCHANGE_CHANGED_PROPERTY = "scheduleListChange";
    public static final String DISPOSE = "scheduleDispose";
    public static final String SCHEDULE_OKAY = "";
    private static boolean debugFlag = false;
    private static final Logger log = LoggerFactory.getLogger(Schedule.class);

    public Schedule(String id, String name) {
        log.debug("New schedule ({}) id: {}", (Object)name, (Object)id);
        this._name = name;
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        String old = this._name;
        this._name = name;
        if (!old.equals(name)) {
            this.setDirtyAndFirePropertyChange("ScheduleName", old, name);
        }
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public int getSize() {
        return this._scheduleHashTable.size();
    }

    public void setComment(String comment) {
        String old = this._comment;
        this._comment = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange("ScheduleComment", old, comment);
        }
    }

    public String getComment() {
        return this._comment;
    }

    public void dispose() {
        this.setDirtyAndFirePropertyChange(DISPOSE, null, DISPOSE);
    }

    public void resetHitCounts() {
        for (ScheduleItem si : this.getItemsByIdList()) {
            si.setHits(0);
        }
    }

    public boolean hasRandomItem() {
        for (ScheduleItem si : this.getItemsByIdList()) {
            if (si.getRandom().equals(SCHEDULE_OKAY)) continue;
            return true;
        }
        return false;
    }

    public ScheduleItem addItem(String type) {
        ++this._IdNumber;
        ++this._sequenceNum;
        String id = this._id + "c" + Integer.toString(this._IdNumber);
        log.debug("Adding new item to ({}) id: {}", (Object)this.getName(), (Object)id);
        ScheduleItem si = new ScheduleItem(id, type);
        si.setSequenceId(this._sequenceNum);
        Integer old = this._scheduleHashTable.size();
        this._scheduleHashTable.put(si.getId(), si);
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, old, this._scheduleHashTable.size());
        si.addPropertyChangeListener(this);
        return si;
    }

    public ScheduleItem addItem(String carType, int sequence) {
        ScheduleItem si = this.addItem(carType);
        if (sequence < 0 || sequence > this._scheduleHashTable.size()) {
            return si;
        }
        for (int i = 0; i < this._scheduleHashTable.size() - sequence - 1; ++i) {
            this.moveItemUp(si);
        }
        return si;
    }

    public void register(ScheduleItem si) {
        Integer old = this._scheduleHashTable.size();
        this._scheduleHashTable.put(si.getId(), si);
        String[] getId = si.getId().split("c");
        int id = Integer.parseInt(getId[1]);
        if (id > this._IdNumber) {
            this._IdNumber = id;
        }
        if (si.getSequenceId() > this._sequenceNum) {
            this._sequenceNum = si.getSequenceId();
        }
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, old, this._scheduleHashTable.size());
        si.addPropertyChangeListener(this);
    }

    public void deleteItem(ScheduleItem si) {
        if (si != null) {
            si.removePropertyChangeListener(this);
            String id = si.getId();
            si.dispose();
            Integer old = this._scheduleHashTable.size();
            this._scheduleHashTable.remove(id);
            this.resequenceIds();
            this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, old, this._scheduleHashTable.size());
        }
    }

    private void resequenceIds() {
        List<ScheduleItem> scheduleItems = this.getItemsBySequenceList();
        for (int i = 0; i < scheduleItems.size(); ++i) {
            scheduleItems.get(i).setSequenceId(i + 1);
            this._sequenceNum = i + 1;
        }
    }

    public ScheduleItem getItemByType(String carType) {
        List<ScheduleItem> scheduleSequenceList = this.getItemsBySequenceList();
        for (int i = scheduleSequenceList.size() - 1; i >= 0; --i) {
            ScheduleItem si = scheduleSequenceList.get(i);
            if (!si.getTypeName().equals(carType)) continue;
            return si;
        }
        return null;
    }

    public ScheduleItem getItemById(String id) {
        return this._scheduleHashTable.get(id);
    }

    private List<ScheduleItem> getItemsByIdList() {
        Object[] arr = new String[this._scheduleHashTable.size()];
        ArrayList<ScheduleItem> out = new ArrayList<ScheduleItem>();
        Enumeration<String> en = this._scheduleHashTable.keys();
        int i = 0;
        while (en.hasMoreElements()) {
            arr[i++] = en.nextElement();
        }
        Arrays.sort(arr);
        for (i = 0; i < arr.length; ++i) {
            out.add(this.getItemById((String)arr[i]));
        }
        return out;
    }

    public List<ScheduleItem> getItemsBySequenceList() {
        List<ScheduleItem> sortList = this.getItemsByIdList();
        ArrayList<ScheduleItem> out = new ArrayList<ScheduleItem>();
        for (ScheduleItem si : sortList) {
            for (int j = 0; j < out.size(); ++j) {
                if (si.getSequenceId() >= ((ScheduleItem)out.get(j)).getSequenceId()) continue;
                out.add(j, si);
                break;
            }
            if (out.contains(si)) continue;
            out.add(si);
        }
        return out;
    }

    public void moveItemUp(ScheduleItem si) {
        int sequenceId = si.getSequenceId();
        if (sequenceId - 1 <= 0) {
            si.setSequenceId(this._sequenceNum + 1);
            this.resequenceIds();
        } else {
            ScheduleItem replaceSi = this.getItemBySequenceId(sequenceId - 1);
            if (replaceSi != null) {
                replaceSi.setSequenceId(sequenceId);
                si.setSequenceId(sequenceId - 1);
            } else {
                this.resequenceIds();
            }
        }
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, null, Integer.toString(sequenceId));
    }

    public void moveItemDown(ScheduleItem si) {
        int sequenceId = si.getSequenceId();
        if (sequenceId + 1 > this._sequenceNum) {
            si.setSequenceId(0);
            this.resequenceIds();
        } else {
            ScheduleItem replaceSi = this.getItemBySequenceId(sequenceId + 1);
            if (replaceSi != null) {
                replaceSi.setSequenceId(sequenceId);
                si.setSequenceId(sequenceId + 1);
            } else {
                this.resequenceIds();
            }
        }
        this.setDirtyAndFirePropertyChange(LISTCHANGE_CHANGED_PROPERTY, null, Integer.toString(sequenceId));
    }

    public ScheduleItem getItemBySequenceId(int sequenceId) {
        for (ScheduleItem si : this.getItemsByIdList()) {
            if (si.getSequenceId() != sequenceId) continue;
            return si;
        }
        return null;
    }

    public String checkScheduleValid(Track track) {
        ScheduleItem si;
        List<ScheduleItem> scheduleItems = this.getItemsBySequenceList();
        if (scheduleItems.size() == 0) {
            return Bundle.getMessage("empty");
        }
        String status = SCHEDULE_OKAY;
        Iterator<ScheduleItem> iterator = scheduleItems.iterator();
        while (iterator.hasNext() && (status = this.checkScheduleItemValid(si = iterator.next(), track)).equals(SCHEDULE_OKAY)) {
        }
        return status;
    }

    public String checkScheduleItemValid(ScheduleItem si, Track track) {
        String status = SCHEDULE_OKAY;
        if (!si.getSetoutTrainScheduleId().equals(SCHEDULE_OKAY) && InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(si.getSetoutTrainScheduleId()) == null) {
            status = Bundle.getMessage("NotValid", si.getSetoutTrainScheduleId());
        } else if (!si.getPickupTrainScheduleId().equals(SCHEDULE_OKAY) && InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(si.getPickupTrainScheduleId()) == null) {
            status = Bundle.getMessage("NotValid", si.getPickupTrainScheduleId());
        } else if (!track.getLocation().acceptsTypeName(si.getTypeName())) {
            status = Bundle.getMessage("NotValid", si.getTypeName());
        } else if (!track.isTypeNameAccepted(si.getTypeName())) {
            status = Bundle.getMessage("NotValid", si.getTypeName());
        } else if (!(si.getRoadName().equals(SCHEDULE_OKAY) || track.isRoadNameAccepted(si.getRoadName()) && InstanceManager.getDefault(CarRoads.class).containsName(si.getRoadName()) && InstanceManager.getDefault(CarManager.class).getByTypeAndRoad(si.getTypeName(), si.getRoadName()) != null)) {
            status = Bundle.getMessage("NotValid", si.getRoadName());
        } else if (!(si.getReceiveLoadName().equals(SCHEDULE_OKAY) || track.isLoadNameAndCarTypeAccepted(si.getReceiveLoadName(), si.getTypeName()) && InstanceManager.getDefault(CarLoads.class).getNames(si.getTypeName()).contains(si.getReceiveLoadName()))) {
            status = Bundle.getMessage("NotValid", si.getReceiveLoadName());
        } else if (!si.getShipLoadName().equals(SCHEDULE_OKAY) && !InstanceManager.getDefault(CarLoads.class).getNames(si.getTypeName()).contains(si.getShipLoadName())) {
            status = Bundle.getMessage("NotValid", si.getShipLoadName());
        } else if (!(si.getDestination() == null || si.getDestination().acceptsTypeName(si.getTypeName()) && InstanceManager.getDefault(LocationManager.class).getLocationById(si.getDestination().getId()) != null)) {
            status = Bundle.getMessage("NotValid", si.getDestination());
        } else if (si.getDestination() != null && si.getDestinationTrack() != null) {
            if (!si.getDestination().isTrackAtLocation(si.getDestinationTrack())) {
                status = Bundle.getMessage("NotValid", si.getDestinationTrack() + " (" + Bundle.getMessage("Track") + ")");
            } else if (!si.getDestinationTrack().isTypeNameAccepted(si.getTypeName())) {
                status = Bundle.getMessage("NotValid", si.getDestinationTrack() + " (" + Bundle.getMessage("Type") + ")");
            } else if (!si.getRoadName().equals(SCHEDULE_OKAY) && !si.getDestinationTrack().isRoadNameAccepted(si.getRoadName())) {
                status = Bundle.getMessage("NotValid", si.getDestinationTrack() + " (" + Bundle.getMessage("Road") + ")");
            } else if (!si.getShipLoadName().equals(SCHEDULE_OKAY) && !si.getDestinationTrack().isLoadNameAndCarTypeAccepted(si.getShipLoadName(), si.getTypeName())) {
                status = Bundle.getMessage("NotValid", si.getDestinationTrack() + " (" + Bundle.getMessage("Load") + ")");
            }
        }
        return status;
    }

    public String searchSchedule(Car car, Track track) {
        ScheduleItem si;
        if (debugFlag) {
            log.debug("Search match for car ({}) type ({}) load ({})", new Object[]{car.toString(), car.getTypeName(), car.getLoadName()});
        }
        if (!car.getScheduleItemId().equals(SCHEDULE_OKAY) && (si = this.getItemById(car.getScheduleItemId())) != null) {
            String status = this.checkScheduleItem(si, car, track);
            if (status.equals(Track.OKAY)) {
                track.setScheduleItemId(si.getId());
                return Track.OKAY;
            }
            log.debug("Car ({}) with schedule id ({}) failed check, status: {}", new Object[]{car.toString(), car.getScheduleItemId(), status});
        }
        if (!this.checkScheduleAttribute(Track.TYPE, car.getTypeName(), car)) {
            return Bundle.getMessage("scheduleNotType", Track.SCHEDULE, this.getName(), car.getTypeName());
        }
        for (int i = 0; i < this.getSize(); ++i) {
            String status;
            ScheduleItem si2 = track.getNextScheduleItem();
            if (debugFlag) {
                log.debug("Item id: ({}) requesting type ({}) load ({}) final dest ({}, {})", new Object[]{si2.getId(), si2.getTypeName(), si2.getReceiveLoadName(), si2.getDestinationName(), si2.getDestinationTrackName()});
            }
            if ((status = this.checkScheduleItem(si2, car, track)).equals(Track.OKAY)) {
                log.debug("Found item match ({}) car ({}) type ({}) load ({}) ship ({}) destination ({}, {})", new Object[]{si2.getId(), car.toString(), car.getTypeName(), si2.getReceiveLoadName(), si2.getShipLoadName(), si2.getDestinationName(), si2.getDestinationTrackName()});
                car.setScheduleItemId(si2.getId());
                return Track.OKAY;
            }
            if (!debugFlag) continue;
            log.debug("Item id: ({}) status ({})", (Object)si2.getId(), (Object)status);
        }
        if (debugFlag) {
            log.debug("No Match");
        }
        car.setScheduleItemId(SCHEDULE_OKAY);
        return Bundle.getMessage("matchMessage", Track.SCHEDULE, this.getName(), this.hasRandomItem() ? Bundle.getMessage("Random") : SCHEDULE_OKAY);
    }

    public String checkScheduleItem(ScheduleItem si, Car car, Track track) {
        TrainSchedule trainSch;
        if (!(car.getScheduleItemId().equals(si.getId()) || si.getSetoutTrainScheduleId().equals(SCHEDULE_OKAY) || InstanceManager.getDefault(TrainScheduleManager.class).getTrainScheduleActiveId().equals(si.getSetoutTrainScheduleId()) || (trainSch = InstanceManager.getDefault(TrainScheduleManager.class).getScheduleById(si.getSetoutTrainScheduleId())) == null)) {
            return Bundle.getMessage("requestCarOnly", Track.SCHEDULE, this.getName(), Track.TYPE, si.getTypeName(), trainSch.getName());
        }
        if (!car.getTypeName().equals(si.getTypeName())) {
            return Bundle.getMessage("requestCarType", Track.SCHEDULE, this.getName(), Track.TYPE, si.getTypeName());
        }
        if (!si.getRoadName().equals(SCHEDULE_OKAY) && !car.getRoadName().equals(si.getRoadName())) {
            return Bundle.getMessage("requestCar", Track.SCHEDULE, this.getName(), Track.TYPE, si.getTypeName(), Track.ROAD, si.getRoadName());
        }
        if (!si.getReceiveLoadName().equals(SCHEDULE_OKAY) && !car.getLoadName().equals(si.getReceiveLoadName())) {
            return Bundle.getMessage("requestCar", Track.SCHEDULE, this.getName(), Track.TYPE, si.getTypeName(), Track.LOAD, si.getReceiveLoadName());
        }
        if (!(car.getFinalDestinationTrack() == track || si.getRandom().equals(SCHEDULE_OKAY) || car.getScheduleItemId().equals(si.getId()) || si.doRandom())) {
            return Bundle.getMessage("scheduleRandom", Track.SCHEDULE, this.getName(), si.getId(), si.getRandom(), si.getCalculatedRandom());
        }
        return Track.OKAY;
    }

    public boolean checkScheduleAttribute(String attribute, String carType, Car car) {
        List<ScheduleItem> scheduleItems = this.getItemsBySequenceList();
        for (ScheduleItem si : scheduleItems) {
            if (!si.getTypeName().equals(carType)) continue;
            if (attribute.equals(Track.TYPE)) {
                return true;
            }
            if (attribute.equals(Track.LOAD) && (si.getReceiveLoadName().equals(SCHEDULE_OKAY) || car == null || si.getReceiveLoadName().equals(car.getLoadName()))) {
                return true;
            }
            if (attribute.equals(Track.ROAD) && (si.getRoadName().equals(SCHEDULE_OKAY) || car == null || si.getRoadName().equals(car.getRoadName()))) {
                return true;
            }
            if (attribute.equals("trainSchedule") && (si.getSetoutTrainScheduleId().isEmpty() || InstanceManager.getDefault(TrainScheduleManager.class).getTrainScheduleActiveId().equals(si.getSetoutTrainScheduleId()))) {
                return true;
            }
            if (!attribute.equals("all") || !si.getReceiveLoadName().equals(SCHEDULE_OKAY) && car != null && !si.getReceiveLoadName().equals(car.getLoadName()) || !si.getRoadName().equals(SCHEDULE_OKAY) && car != null && !si.getRoadName().equals(car.getRoadName()) || !si.getSetoutTrainScheduleId().equals(SCHEDULE_OKAY) && !InstanceManager.getDefault(TrainScheduleManager.class).getTrainScheduleActiveId().equals(si.getSetoutTrainScheduleId())) continue;
            return true;
        }
        return false;
    }

    public Schedule(Element e) {
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in schedule element when reading operations");
        }
        a = e.getAttribute("name");
        if (a != null) {
            this._name = a.getValue();
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
        if (e.getChildren("item") != null) {
            List eScheduleItems = e.getChildren("item");
            log.debug("schedule: {} has {} items", (Object)this.getName(), (Object)eScheduleItems.size());
            for (Element eScheduleItem : eScheduleItems) {
                this.register(new ScheduleItem(eScheduleItem));
            }
        }
    }

    public Element store() {
        Element e = new Element("schedule");
        e.setAttribute("id", this.getId());
        e.setAttribute("name", this.getName());
        e.setAttribute("comment", this.getComment());
        for (ScheduleItem si : this.getItemsBySequenceList()) {
            e.addContent((Content)si.store());
        }
        return e;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.setDirtyAndFirePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(LocationManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }
}

