/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.LocationManagerXml;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.Bundle;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.locations.schedules.ScheduleTableModel;
import jmri.jmrit.operations.locations.schedules.tools.ScheduleCopyAction;
import jmri.jmrit.operations.locations.schedules.tools.ScheduleOptionsAction;
import jmri.jmrit.operations.locations.schedules.tools.ScheduleResetHitsAction;
import jmri.jmrit.operations.locations.schedules.tools.SchedulesAndStagingAction;
import jmri.jmrit.operations.locations.schedules.tools.SchedulesByLoadAction;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.swing.JTablePersistenceManager;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    ScheduleTableModel scheduleModel = new ScheduleTableModel();
    JTable scheduleTable = new JTable(this.scheduleModel);
    JScrollPane schedulePane;
    ScheduleManager manager;
    LocationManagerXml managerXml;
    Schedule _schedule = null;
    ScheduleItem _scheduleItem = null;
    Location _location = null;
    public Track _track = null;
    JButton addTypeButton = new JButton(Bundle.getMessage("AddType"));
    JButton saveScheduleButton = new JButton(Bundle.getMessage("SaveSchedule"));
    JButton deleteScheduleButton = new JButton(Bundle.getMessage("DeleteSchedule"));
    JButton addScheduleButton = new JButton(Bundle.getMessage("AddSchedule"));
    JCheckBox checkBox;
    JRadioButton addLocAtTop = new JRadioButton(Bundle.getMessage("Top"));
    JRadioButton addLocAtMiddle = new JRadioButton(Bundle.getMessage("Middle"));
    JRadioButton addLocAtBottom = new JRadioButton(Bundle.getMessage("Bottom"));
    JRadioButton sequentialRadioButton = new JRadioButton(Bundle.getMessage("Sequential"));
    JRadioButton matchRadioButton = new JRadioButton(Bundle.getMessage("Match"));
    JTextField scheduleNameTextField = new JTextField(20);
    JTextField commentTextField = new JTextField(35);
    JComboBox<String> typeBox = new JComboBox();
    public static final int MAX_NAME_LENGTH = Control.max_len_string_location_name;
    public static final String NAME = Bundle.getMessage("Name");
    public static final String DISPOSE = "dispose";
    private static final Logger log = LoggerFactory.getLogger(ScheduleEditFrame.class);

    public ScheduleEditFrame(Schedule schedule, Track track) {
        this._schedule = schedule;
        this._location = track.getLocation();
        this._track = track;
        this.manager = InstanceManager.getDefault(ScheduleManager.class);
        this.managerXml = InstanceManager.getDefault(LocationManagerXml.class);
        this.schedulePane = new JScrollPane(this.scheduleTable);
        this.schedulePane.setVerticalScrollBarPolicy(20);
        this.scheduleModel.initTable(this, this.scheduleTable, schedule, this._location, this._track);
        if (this._schedule != null) {
            this.scheduleNameTextField.setText(this._schedule.getName());
            this.commentTextField.setText(this._schedule.getComment());
            this.setTitle(Bundle.getMessage("TitleScheduleEdit", this._track.getName()));
            this.enableButtons(true);
        } else {
            this.setTitle(Bundle.getMessage("TitleScheduleAdd", this._track.getName()));
            this.enableButtons(false);
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JScrollPane p1Pane = new JScrollPane(p1);
        p1Pane.setVerticalScrollBarPolicy(21);
        p1Pane.setMinimumSize(new Dimension(300, 3 * this.scheduleNameTextField.getPreferredSize().height));
        p1Pane.setMaximumSize(new Dimension(2000, 200));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.scheduleNameTextField, 0, 0);
        JPanel pC = new JPanel();
        pC.setLayout(new GridBagLayout());
        pC.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        this.addItem(pC, this.commentTextField, 0, 0);
        JPanel pMode = new JPanel();
        pMode.setLayout(new GridBagLayout());
        pMode.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ScheduleMode")));
        this.addItem(pMode, this.sequentialRadioButton, 0, 0);
        this.addItem(pMode, this.matchRadioButton, 1, 0);
        this.sequentialRadioButton.setToolTipText(Bundle.getMessage("TipSequential"));
        this.matchRadioButton.setToolTipText(Bundle.getMessage("TipMatch"));
        ButtonGroup modeGroup = new ButtonGroup();
        modeGroup.add(this.sequentialRadioButton);
        modeGroup.add(this.matchRadioButton);
        this.sequentialRadioButton.setSelected(this._track.getScheduleMode() == 0);
        this.matchRadioButton.setSelected(this._track.getScheduleMode() == 1);
        this.scheduleModel.setMatchMode(this._track.getScheduleMode() == 1);
        p1.add(pName);
        p1.add(pC);
        p1.add(pMode);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridBagLayout());
        p3.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("AddItem")));
        this.addItem(p3, this.typeBox, 0, 1);
        this.addItem(p3, this.addTypeButton, 1, 1);
        this.addItem(p3, this.addLocAtTop, 2, 1);
        this.addItem(p3, this.addLocAtMiddle, 3, 1);
        this.addItem(p3, this.addLocAtBottom, 4, 1);
        ButtonGroup group = new ButtonGroup();
        group.add(this.addLocAtTop);
        group.add(this.addLocAtMiddle);
        group.add(this.addLocAtBottom);
        this.addLocAtBottom.setSelected(true);
        p3.setMaximumSize(new Dimension(2000, 200));
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        pB.setBorder(BorderFactory.createTitledBorder(""));
        pB.setMaximumSize(new Dimension(2000, 200));
        this.addItem(pB, this.deleteScheduleButton, 0, 0);
        this.addItem(pB, this.addScheduleButton, 1, 0);
        this.addItem(pB, this.saveScheduleButton, 3, 0);
        this.getContentPane().add(p1Pane);
        this.getContentPane().add(this.schedulePane);
        this.getContentPane().add(p3);
        this.getContentPane().add(pB);
        this.addButtonAction(this.addTypeButton);
        this.addButtonAction(this.deleteScheduleButton);
        this.addButtonAction(this.addScheduleButton);
        this.addButtonAction(this.saveScheduleButton);
        this.addRadioButtonAction(this.sequentialRadioButton);
        this.addRadioButtonAction(this.matchRadioButton);
        this.loadTypeComboBox();
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        menuBar.add(toolMenu);
        toolMenu.add(new ScheduleCopyAction(schedule));
        toolMenu.add(new ScheduleOptionsAction(this));
        toolMenu.add(new ScheduleResetHitsAction(schedule));
        toolMenu.addSeparator();
        toolMenu.add(new SchedulesByLoadAction());
        toolMenu.add(new SchedulesAndStagingAction());
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_Schedules", true);
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        this._location.addPropertyChangeListener(this);
        this._track.addPropertyChangeListener(this);
        this.initMinimumSize(new Dimension(700, 400));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        Schedule schedule;
        if (ae.getSource() == this.addTypeButton) {
            this.addNewScheduleItem();
        }
        if (ae.getSource() == this.saveScheduleButton) {
            log.debug("schedule save button activated");
            schedule = this.manager.getScheduleByName(this.scheduleNameTextField.getText());
            if (this._schedule == null && schedule == null) {
                this.saveNewSchedule();
            } else {
                if (schedule != null && schedule != this._schedule) {
                    this.reportScheduleExists(Bundle.getMessage("save"));
                    return;
                }
                this.saveSchedule();
            }
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
        if (ae.getSource() == this.deleteScheduleButton) {
            log.debug("schedule delete button activated");
            if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("DoYouWantToDeleteSchedule", this.scheduleNameTextField.getText()), Bundle.getMessage("DeleteSchedule?"), 0) != 0) {
                return;
            }
            schedule = this.manager.getScheduleByName(this.scheduleNameTextField.getText());
            if (schedule == null) {
                return;
            }
            if (this._track != null) {
                this._track.setScheduleId("");
            }
            this.manager.deregister(schedule);
            this._schedule = null;
            this.enableButtons(false);
            OperationsXml.save();
        }
        if (ae.getSource() == this.addScheduleButton) {
            schedule = this.manager.getScheduleByName(this.scheduleNameTextField.getText());
            if (schedule != null) {
                this.reportScheduleExists(Bundle.getMessage("add"));
                return;
            }
            this.saveNewSchedule();
        }
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("Radio button action");
        this.scheduleModel.setMatchMode(ae.getSource() == this.matchRadioButton);
    }

    private void addNewScheduleItem() {
        if (this.typeBox.getSelectedItem() == null) {
            return;
        }
        if (this.addLocAtTop.isSelected()) {
            this._schedule.addItem((String)this.typeBox.getSelectedItem(), 0);
        } else if (this.addLocAtMiddle.isSelected()) {
            if (this.scheduleTable.getSelectedRow() >= 0) {
                int row = this.scheduleTable.getSelectedRow();
                log.debug("Selected row: {}", (Object)row);
                this._schedule.addItem((String)this.typeBox.getSelectedItem(), row);
                this.scheduleTable.getSelectionModel().setSelectionInterval(row, row);
            } else {
                this._schedule.addItem((String)this.typeBox.getSelectedItem(), this._schedule.getSize() / 2);
            }
        } else {
            this._schedule.addItem((String)this.typeBox.getSelectedItem());
        }
        if (this._track.getScheduleMode() == 1 && this.typeBox.getSelectedIndex() < this.typeBox.getItemCount() - 1) {
            this.typeBox.setSelectedIndex(this.typeBox.getSelectedIndex() + 1);
        }
    }

    private void saveNewSchedule() {
        if (!this.checkName(Bundle.getMessage("add"))) {
            return;
        }
        Schedule schedule = this.manager.newSchedule(this.scheduleNameTextField.getText());
        this.scheduleModel.initTable(this, this.scheduleTable, schedule, this._location, this._track);
        this._schedule = schedule;
        this.enableButtons(true);
        this.saveSchedule();
    }

    private void saveSchedule() {
        if (!this.checkName(Bundle.getMessage("save"))) {
            return;
        }
        this._schedule.setName(this.scheduleNameTextField.getText());
        this._schedule.setComment(this.commentTextField.getText());
        if (this.scheduleTable.isEditing()) {
            log.debug("schedule table edit true");
            this.scheduleTable.getCellEditor().stopCellEditing();
            this.scheduleTable.clearSelection();
        }
        if (this._track != null) {
            if (!this._track.getScheduleId().equals(this._schedule.getId())) {
                InstanceManager.getDefault(LocationManager.class).resetMoves();
            }
            this._track.setSchedule(this._schedule);
            if (this.sequentialRadioButton.isSelected()) {
                this._track.setScheduleMode(0);
            } else {
                this._track.setScheduleMode(1);
            }
            String status = this._track.checkScheduleValid();
            if (this._schedule.getItemsBySequenceList().size() != 0 && !status.equals("")) {
                JmriJOptionPane.showMessageDialog(this, status, Bundle.getMessage("ErrorTitle"), 0);
            }
        }
        OperationsXml.save();
    }

    private void loadTypeComboBox() {
        this.typeBox.removeAllItems();
        for (String typeName : InstanceManager.getDefault(CarTypes.class).getNames()) {
            if (!this._track.isTypeNameAccepted(typeName)) continue;
            this.typeBox.addItem(typeName);
        }
    }

    private boolean checkName(String s) {
        if (this.scheduleNameTextField.getText().trim().isEmpty()) {
            return false;
        }
        if (this.scheduleNameTextField.getText().length() > MAX_NAME_LENGTH) {
            log.error("Schedule name must be less than 26 charaters");
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ScheduleNameLengthMax", Integer.toString(MAX_NAME_LENGTH + 1)), Bundle.getMessage("CanNotSchedule", s), 0);
            return false;
        }
        return true;
    }

    private void reportScheduleExists(String s) {
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("ReportExists"), Bundle.getMessage("CanNotSchedule", s), 0);
    }

    private void enableButtons(boolean enabled) {
        this.typeBox.setEnabled(enabled);
        this.addTypeButton.setEnabled(enabled);
        this.addLocAtTop.setEnabled(enabled);
        this.addLocAtMiddle.setEnabled(enabled);
        this.addLocAtBottom.setEnabled(enabled);
        this.saveScheduleButton.setEnabled(enabled);
        this.deleteScheduleButton.setEnabled(enabled);
        this.scheduleTable.setEnabled(enabled);
        this.addScheduleButton.setEnabled(!enabled);
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        this._location.removePropertyChangeListener(this);
        this._track.removePropertyChangeListener(this);
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.scheduleTable));
        this.scheduleModel.dispose();
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("trackRollingStockTypes") || e.getPropertyName().equals("locationTypes")) {
            this.loadTypeComboBox();
        }
    }
}

