/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.LocationManagerXml;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.LocationTrackPair;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleManager
extends PropertyChangeSupport
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize,
PropertyChangeListener {
    public static final String LISTLENGTH_CHANGED_PROPERTY = "scheduleListLength";
    private int _id = 0;
    protected Hashtable<String, Schedule> _scheduleHashTable = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(ScheduleManager.class);

    public void dispose() {
        this._scheduleHashTable.clear();
    }

    public int numEntries() {
        return this._scheduleHashTable.size();
    }

    public Schedule getScheduleByName(String name) {
        Enumeration<Schedule> en = this._scheduleHashTable.elements();
        while (en.hasMoreElements()) {
            Schedule s = en.nextElement();
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public Schedule getScheduleById(String id) {
        return this._scheduleHashTable.get(id);
    }

    public Schedule newSchedule(String name) {
        Schedule schedule = this.getScheduleByName(name);
        if (schedule == null && !name.isBlank()) {
            ++this._id;
            schedule = new Schedule(Integer.toString(this._id), name);
            Integer oldSize = this._scheduleHashTable.size();
            this._scheduleHashTable.put(schedule.getId(), schedule);
            this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._scheduleHashTable.size());
        }
        return schedule;
    }

    public void register(Schedule schedule) {
        Integer oldSize = this._scheduleHashTable.size();
        this._scheduleHashTable.put(schedule.getId(), schedule);
        int id = Integer.parseInt(schedule.getId());
        if (id > this._id) {
            this._id = id;
        }
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._scheduleHashTable.size());
    }

    public void deregister(Schedule schedule) {
        if (schedule == null) {
            return;
        }
        schedule.dispose();
        Integer oldSize = this._scheduleHashTable.size();
        this._scheduleHashTable.remove(schedule.getId());
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this._scheduleHashTable.size());
    }

    public List<Schedule> getSchedulesByNameList() {
        List<Schedule> sortList = this.getList();
        ArrayList<Schedule> out = new ArrayList<Schedule>();
        for (Schedule sch : sortList) {
            for (int j = 0; j < out.size(); ++j) {
                if (sch.getName().compareToIgnoreCase(((Schedule)out.get(j)).getName()) >= 0) continue;
                out.add(j, sch);
                break;
            }
            if (out.contains(sch)) continue;
            out.add(sch);
        }
        return out;
    }

    public List<Schedule> getSchedulesByIdList() {
        List<Schedule> sortList = this.getList();
        ArrayList<Schedule> out = new ArrayList<Schedule>();
        for (Schedule sch : sortList) {
            for (int j = 0; j < out.size(); ++j) {
                try {
                    if (Integer.parseInt(sch.getId()) >= Integer.parseInt(((Schedule)out.get(j)).getId())) continue;
                    out.add(j, sch);
                    break;
                }
                catch (NumberFormatException e) {
                    log.debug("list id number isn't a number");
                }
            }
            if (out.contains(sch)) continue;
            out.add(sch);
        }
        return out;
    }

    private List<Schedule> getList() {
        ArrayList<Schedule> out = new ArrayList<Schedule>();
        Enumeration<Schedule> en = this._scheduleHashTable.elements();
        while (en.hasMoreElements()) {
            out.add(en.nextElement());
        }
        return out;
    }

    public Schedule copySchedule(Schedule schedule, String newScheduleName) {
        Schedule newSchedule = this.newSchedule(newScheduleName);
        for (ScheduleItem si : schedule.getItemsBySequenceList()) {
            ScheduleItem newSi = newSchedule.addItem(si.getTypeName());
            newSi.copyScheduleItem(si);
        }
        return newSchedule;
    }

    public void resetHitCounts() {
        for (Schedule schedule : this.getList()) {
            schedule.resetHitCounts();
        }
    }

    public JComboBox<Schedule> getComboBox() {
        JComboBox<Schedule> box = new JComboBox<Schedule>();
        this.updateComboBox(box);
        return box;
    }

    public void updateComboBox(JComboBox<Schedule> box) {
        box.removeAllItems();
        box.addItem(null);
        for (Schedule schedule : this.getSchedulesByNameList()) {
            box.addItem(schedule);
        }
    }

    public void replaceType(String oldType, String newType) {
        for (Schedule sch : this.getSchedulesByIdList()) {
            for (ScheduleItem si : sch.getItemsBySequenceList()) {
                if (!si.getTypeName().equals(oldType)) continue;
                si.setTypeName(newType);
            }
        }
    }

    public void replaceRoad(String oldRoad, String newRoad) {
        if (newRoad == null) {
            return;
        }
        for (Schedule sch : this.getSchedulesByIdList()) {
            for (ScheduleItem si : sch.getItemsBySequenceList()) {
                if (!si.getRoadName().equals(oldRoad)) continue;
                si.setRoadName(newRoad);
            }
        }
    }

    public void replaceLoad(String type, String oldLoad, String newLoad) {
        for (Schedule sch : this.getSchedulesByIdList()) {
            for (ScheduleItem si : sch.getItemsBySequenceList()) {
                if (si.getTypeName().equals(type) && si.getReceiveLoadName().equals(oldLoad)) {
                    if (newLoad != null) {
                        si.setReceiveLoadName(newLoad);
                    } else {
                        si.setReceiveLoadName("");
                    }
                }
                if (!si.getTypeName().equals(type) || !si.getShipLoadName().equals(oldLoad)) continue;
                if (newLoad != null) {
                    si.setShipLoadName(newLoad);
                    continue;
                }
                si.setShipLoadName("");
            }
        }
    }

    public void replaceTrack(Track oldTrack, Track newTrack) {
        for (Schedule sch : this.getSchedulesByIdList()) {
            for (ScheduleItem si : sch.getItemsBySequenceList()) {
                if (si.getDestinationTrack() != oldTrack) continue;
                si.setDestination(newTrack.getLocation());
                si.setDestinationTrack(newTrack);
            }
        }
    }

    public JComboBox<LocationTrackPair> getSpursByScheduleComboBox(Schedule schedule) {
        JComboBox<LocationTrackPair> box = new JComboBox<LocationTrackPair>();
        for (Track spur : this.getListSpurs(schedule)) {
            if (!spur.getScheduleId().equals(schedule.getId())) continue;
            LocationTrackPair ltp = new LocationTrackPair(spur);
            box.addItem(ltp);
        }
        return box;
    }

    public List<Track> getListSpurs(Schedule schedule) {
        ArrayList<Track> spurs = new ArrayList<Track>();
        for (Location location : InstanceManager.getDefault(LocationManager.class).getLocationsByNameList()) {
            for (Track spur : location.getTracksByNameList("Spur")) {
                if (!spur.getScheduleId().equals(schedule.getId())) continue;
                spurs.add(spur);
            }
        }
        return spurs;
    }

    public void load(Element root) {
        if (root.getChild("schedules") != null) {
            List eSchedules = root.getChild("schedules").getChildren("schedule");
            log.debug("readFile sees {} schedules", (Object)eSchedules.size());
            for (Element eSchedule : eSchedules) {
                this.register(new Schedule(eSchedule));
            }
        }
    }

    public void store(Element root) {
        Element values = new Element("schedules");
        root.addContent((Content)values);
        for (Schedule schedule : this.getSchedulesByIdList()) {
            values.addContent((Content)schedule.store());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarTypes Name")) {
            this.replaceType((String)e.getOldValue(), (String)e.getNewValue());
        }
        if (e.getPropertyName().equals("CarRoads Name")) {
            this.replaceRoad((String)e.getOldValue(), (String)e.getNewValue());
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(LocationManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }

    @Override
    public void initialize() {
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarRoads.class).addPropertyChangeListener(this);
    }
}

