/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.schedules.Bundle;
import jmri.jmrit.operations.locations.schedules.SchedulesTableModel;
import jmri.jmrit.operations.locations.schedules.tools.ExportSchedulesAction;
import jmri.jmrit.operations.locations.schedules.tools.ScheduleCopyAction;
import jmri.jmrit.operations.locations.schedules.tools.SchedulesAndStagingAction;
import jmri.jmrit.operations.locations.schedules.tools.SchedulesByLoadAction;
import jmri.jmrit.operations.locations.schedules.tools.SchedulesResetHitsAction;
import jmri.jmrit.operations.locations.tools.PrintLocationsAction;
import jmri.swing.JTablePersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulesTableFrame
extends OperationsFrame {
    SchedulesTableModel schedulesModel = new SchedulesTableModel();
    JTable schedulesTable = new JTable(this.schedulesModel);
    JScrollPane schedulesPane;
    JLabel textSort = new JLabel();
    JLabel textSep = new JLabel();
    JRadioButton sortByName = new JRadioButton(Bundle.getMessage("Name"));
    JRadioButton sortById = new JRadioButton(Bundle.getMessage("Id"));
    private static final Logger log = LoggerFactory.getLogger(SchedulesTableFrame.class);

    public SchedulesTableFrame() {
        super(Bundle.getMessage("TitleSchedulesTable"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.schedulesPane = new JScrollPane(this.schedulesTable);
        this.schedulesPane.setVerticalScrollBarPolicy(20);
        this.schedulesPane.setHorizontalScrollBarPolicy(30);
        this.schedulesModel.initTable(this, this.schedulesTable);
        this.getContentPane().add(this.schedulesPane);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout());
        this.textSort.setText(Bundle.getMessage("SortBy"));
        controlPanel.add(this.textSort);
        controlPanel.add(this.sortByName);
        this.sortByName.setSelected(true);
        controlPanel.add(this.sortById);
        this.textSep.setText("          ");
        controlPanel.add(this.textSep);
        controlPanel.setMaximumSize(new Dimension(1025, 50));
        this.getContentPane().add(controlPanel);
        this.addRadioButtonAction(this.sortByName);
        this.addRadioButtonAction(this.sortById);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new ScheduleCopyAction());
        toolMenu.add(new SchedulesResetHitsAction());
        toolMenu.add(new ExportSchedulesAction());
        toolMenu.addSeparator();
        toolMenu.add(new SchedulesByLoadAction());
        toolMenu.add(new SchedulesAndStagingAction());
        toolMenu.addSeparator();
        toolMenu.add(new PrintLocationsAction(false));
        toolMenu.add(new PrintLocationsAction(true));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_LocationSchedules", true);
        this.initMinimumSize();
        if (this.getWidth() == 500) {
            this.setSize(1025, this.getHeight());
        }
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        this.clearTableSort(this.schedulesTable);
        if (ae.getSource() == this.sortByName) {
            this.sortByName.setSelected(true);
            this.sortById.setSelected(false);
            this.schedulesModel.setSort(this.schedulesModel.SORTBYNAME);
        }
        if (ae.getSource() == this.sortById) {
            this.sortByName.setSelected(false);
            this.sortById.setSelected(true);
            this.schedulesModel.setSort(this.schedulesModel.SORTBYID);
        }
    }

    @Override
    public void dispose() {
        this.schedulesModel.dispose();
        InstanceManager.getOptionalDefault(JTablePersistenceManager.class).ifPresent(tpm -> tpm.stopPersisting(this.schedulesTable));
        super.dispose();
    }
}

