/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsTableModel;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.Bundle;
import jmri.jmrit.operations.locations.schedules.LocationTrackPair;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleEditFrame;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.locations.schedules.SchedulesTableFrame;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulesTableModel
extends OperationsTableModel
implements PropertyChangeListener {
    ScheduleManager scheduleManager;
    static final int ID_COLUMN = 0;
    static final int NAME_COLUMN = 1;
    static final int SCHEDULE_STATUS_COLUMN = 2;
    static final int SPUR_NUMBER_COLUMN = 3;
    static final int SPUR_COLUMN = 4;
    static final int STATUS_COLUMN = 5;
    static final int MODE_COLUMN = 6;
    static final int EDIT_COLUMN = 7;
    static final int DELETE_COLUMN = 8;
    private static final int HIGHEST_COLUMN = 9;
    public final int SORTBYNAME = 1;
    public final int SORTBYID = 2;
    private int _sort = 1;
    List<Schedule> sysList = null;
    JTable _table;
    ScheduleEditFrame sef = null;
    protected Hashtable<Schedule, String> comboSelect = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(SchedulesTableModel.class);

    public SchedulesTableModel() {
        this.scheduleManager = InstanceManager.getDefault(ScheduleManager.class);
        this.scheduleManager.addPropertyChangeListener(this);
        this.updateList();
    }

    public void setSort(int sort) {
        this._sort = sort;
        this.updateList();
        this.fireTableDataChanged();
    }

    private void updateList() {
        this.removePropertyChangeSchedules();
        this.removePropertyChangeTracks();
        this.sysList = this._sort == 2 ? this.scheduleManager.getSchedulesByIdList() : this.scheduleManager.getSchedulesByNameList();
        for (Schedule sch : this.sysList) {
            sch.addPropertyChangeListener(this);
        }
        this.addPropertyChangeTracks();
    }

    public void initTable(SchedulesTableFrame frame, JTable table) {
        this._table = table;
        super.initTable(table);
        TableColumnModel tcm = table.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(7).setCellRenderer(buttonRenderer);
        tcm.getColumn(7).setCellEditor(buttonEditor);
        tcm.getColumn(8).setCellRenderer(buttonRenderer);
        tcm.getColumn(8).setCellEditor(buttonEditor);
        table.getColumnModel().getColumn(0).setPreferredWidth(40);
        table.getColumnModel().getColumn(1).setPreferredWidth(200);
        table.getColumnModel().getColumn(2).setPreferredWidth(80);
        table.getColumnModel().getColumn(3).setPreferredWidth(40);
        table.getColumnModel().getColumn(4).setPreferredWidth(350);
        table.getColumnModel().getColumn(5).setPreferredWidth(150);
        table.getColumnModel().getColumn(6).setPreferredWidth(70);
        table.getColumnModel().getColumn(7).setPreferredWidth(70);
        table.getColumnModel().getColumn(8).setPreferredWidth(90);
        frame.loadTableDetails(table);
    }

    @Override
    public int getRowCount() {
        return this.sysList.size();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Id");
            }
            case 1: {
                return Bundle.getMessage("Name");
            }
            case 2: {
                return Bundle.getMessage("Status");
            }
            case 3: {
                return Bundle.getMessage("Number");
            }
            case 4: {
                return Bundle.getMessage("Spurs");
            }
            case 5: {
                return Bundle.getMessage("StatusSpur");
            }
            case 6: {
                return Bundle.getMessage("ScheduleMode");
            }
            case 7: {
                return Bundle.getMessage("ButtonEdit");
            }
            case 8: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return String.class;
            }
            case 4: {
                return JComboBox.class;
            }
            case 3: {
                return Integer.class;
            }
            case 7: 
            case 8: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 4: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        Schedule schedule = this.sysList.get(row);
        if (schedule == null) {
            return "ERROR schedule unknown " + row;
        }
        switch (col) {
            case 0: {
                return schedule.getId();
            }
            case 1: {
                return schedule.getName();
            }
            case 2: {
                return this.getScheduleStatus(row);
            }
            case 3: {
                return this.scheduleManager.getSpursByScheduleComboBox(schedule).getItemCount();
            }
            case 4: {
                return this.getComboBox(row, schedule);
            }
            case 5: {
                return this.getSpurStatus(row);
            }
            case 6: {
                return this.getSpurMode(row);
            }
            case 7: {
                return Bundle.getMessage("ButtonEdit");
            }
            case 8: {
                return Bundle.getMessage("ButtonDelete");
            }
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 7: {
                this.editSchedule(row);
                break;
            }
            case 8: {
                this.deleteSchedule(row);
                break;
            }
            case 4: {
                this.selectJComboBox(value, row);
                break;
            }
        }
    }

    @Override
    protected Color getForegroundColor(int row) {
        if (!this.getScheduleStatus(row).equals(Bundle.getMessage("ButtonOK"))) {
            return Color.red;
        }
        return super.getForegroundColor(row);
    }

    private void editSchedule(int row) {
        log.debug("Edit schedule");
        if (this.sef != null) {
            this.sef.dispose();
        }
        Schedule sch = this.sysList.get(row);
        LocationTrackPair ltp = this.getLocationTrackPair(row);
        if (ltp == null) {
            log.debug("Need location track pair");
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AssignSchedule", sch.getName()), Bundle.getMessage("CanNotSchedule", Bundle.getMessage("ButtonEdit")), 0);
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.sef = new ScheduleEditFrame(sch, ltp.getTrack());
        });
    }

    private void deleteSchedule(int row) {
        log.debug("Delete schedule");
        Schedule sch = this.sysList.get(row);
        if (JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("DoYouWantToDeleteSchedule", sch.getName()), Bundle.getMessage("DeleteSchedule?"), 0) == 0) {
            this.scheduleManager.deregister(sch);
            OperationsXml.save();
        }
    }

    private void selectJComboBox(Object value, int row) {
        Schedule schedule = this.sysList.get(row);
        JComboBox box = (JComboBox)value;
        if (box.getSelectedIndex() >= 0) {
            this.comboSelect.put(schedule, Integer.toString(box.getSelectedIndex()));
        }
        this.fireTableRowsUpdated(row, row);
    }

    private LocationTrackPair getLocationTrackPair(int row) {
        Schedule s = this.sysList.get(row);
        JComboBox<LocationTrackPair> box = this.scheduleManager.getSpursByScheduleComboBox(s);
        String index = this.comboSelect.get(this.sysList.get(row));
        LocationTrackPair ltp = index != null ? box.getItemAt(Integer.parseInt(index)) : box.getItemAt(0);
        return ltp;
    }

    private String getScheduleStatus(int row) {
        Schedule sch = this.sysList.get(row);
        JComboBox<LocationTrackPair> box = this.scheduleManager.getSpursByScheduleComboBox(sch);
        for (int i = 0; i < box.getItemCount(); ++i) {
            LocationTrackPair ltp = box.getItemAt(i);
            String status = ltp.getTrack().checkScheduleValid();
            if (status.equals("")) continue;
            return Bundle.getMessage("ErrorTitle");
        }
        return Bundle.getMessage("ButtonOK");
    }

    private JComboBox<LocationTrackPair> getComboBox(int row, Schedule schedule) {
        JComboBox<LocationTrackPair> box = this.scheduleManager.getSpursByScheduleComboBox(schedule);
        String index = this.comboSelect.get(this.sysList.get(row));
        if (index != null && box.getItemCount() > Integer.parseInt(index)) {
            box.setSelectedIndex(Integer.parseInt(index));
        }
        box.addActionListener(e -> this.comboBoxActionPerformed(e));
        return box;
    }

    protected void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("combobox action");
        if (this._table.isEditing()) {
            this._table.getCellEditor().stopCellEditing();
        }
    }

    private String getSpurStatus(int row) {
        LocationTrackPair ltp = this.getLocationTrackPair(row);
        if (ltp == null) {
            return "";
        }
        String status = ltp.getTrack().checkScheduleValid();
        if (!status.equals("")) {
            return status;
        }
        return Bundle.getMessage("ButtonOK");
    }

    private String getSpurMode(int row) {
        LocationTrackPair ltp = this.getLocationTrackPair(row);
        if (ltp == null) {
            return "";
        }
        return ltp.getTrack().getScheduleModeName();
    }

    private void removePropertyChangeSchedules() {
        if (this.sysList != null) {
            for (Schedule sch : this.sysList) {
                sch.removePropertyChangeListener(this);
            }
        }
    }

    private void addPropertyChangeTracks() {
        for (Track track : InstanceManager.getDefault(LocationManager.class).getTracks("Spur")) {
            track.addPropertyChangeListener(this);
        }
    }

    private void removePropertyChangeTracks() {
        for (Track track : InstanceManager.getDefault(LocationManager.class).getTracks("Spur")) {
            track.removePropertyChangeListener(this);
        }
    }

    public void dispose() {
        if (this.sef != null) {
            this.sef.dispose();
        }
        this.scheduleManager.removePropertyChangeListener(this);
        this.removePropertyChangeSchedules();
        this.removePropertyChangeTracks();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Schedule schedule;
        int row;
        if (e.getPropertyName().equals("scheduleListLength")) {
            this.updateList();
            this.fireTableDataChanged();
        } else if (e.getSource().getClass().equals(Schedule.class) && (row = this.sysList.indexOf(schedule = (Schedule)e.getSource())) >= 0) {
            this.fireTableRowsUpdated(row, row);
        }
        if (e.getSource().getClass().equals(Track.class)) {
            Track track = (Track)e.getSource();
            Schedule schedule2 = track.getSchedule();
            int row2 = this.sysList.indexOf(schedule2);
            if (row2 >= 0) {
                this.fireTableRowsUpdated(row2, row2);
            } else {
                this.fireTableDataChanged();
            }
        }
        if (e.getPropertyName().equals("trackScheduleId")) {
            this.fireTableDataChanged();
        }
    }
}

