/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.locations.schedules.tools.Bundle;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.util.swing.JmriJOptionPane;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportSchedules
extends XmlFile {
    private static String operationsFileName = "ExportOperationsSchedules.csv";
    private static final Logger log = LoggerFactory.getLogger(ExportSchedules.class);

    public void writeOperationsScheduleFile() {
        this.makeBackupFile(ExportSchedules.defaultOperationsFilename());
        try {
            if (!this.checkFile(ExportSchedules.defaultOperationsFilename())) {
                File file = new File(ExportSchedules.defaultOperationsFilename());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("File created");
                }
            }
            this.writeFile(ExportSchedules.defaultOperationsFilename());
        }
        catch (IOException e) {
            log.error("Exception while writing the new CSV operations file, may not be complete: {}", (Object)e.getLocalizedMessage());
        }
    }

    public void writeFile(String name) {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
            fileOut.printRecord(new Object[]{Bundle.getMessage("ScheduleName"), Bundle.getMessage("Id"), Bundle.getMessage("Type"), Bundle.getMessage("Random"), Bundle.getMessage("Delivery"), Bundle.getMessage("Road"), Bundle.getMessage("Receive"), Bundle.getMessage("Ship"), Bundle.getMessage("Destination"), Bundle.getMessage("Track"), Bundle.getMessage("Pickup"), Bundle.getMessage("Count"), Bundle.getMessage("Wait"), Bundle.getMessage("Hits"), Bundle.getMessage("Comment"), Bundle.getMessage("Number"), Bundle.getMessage("Location"), Bundle.getMessage("Spur"), Bundle.getMessage("ScheduleMode")});
            ScheduleManager scheduleManager = InstanceManager.getDefault(ScheduleManager.class);
            List<Schedule> schedules = scheduleManager.getSchedulesByNameList();
            for (Schedule schedule : schedules) {
                List<Track> spurs = scheduleManager.getListSpurs(schedule);
                int size = spurs.size();
                for (ScheduleItem scheduleItem : schedule.getItemsBySequenceList()) {
                    String num = "";
                    String locationName = "";
                    String spurName = "";
                    String scheduleMode = "";
                    if (size > 0) {
                        num = Integer.toString(size);
                        Track spur = spurs.get(--size);
                        locationName = spur.getLocation().getName();
                        spurName = spur.getName();
                        scheduleMode = spur.getScheduleModeName();
                    }
                    fileOut.printRecord(new Object[]{schedule.getName(), scheduleItem.getId(), scheduleItem.getTypeName(), scheduleItem.getRandom(), scheduleItem.getSetoutTrainScheduleName(), scheduleItem.getRoadName(), scheduleItem.getReceiveLoadName(), scheduleItem.getShipLoadName(), scheduleItem.getDestinationName(), scheduleItem.getDestinationTrackName(), scheduleItem.getPickupTrainScheduleName(), scheduleItem.getCount(), scheduleItem.getWait(), scheduleItem.getHits(), schedule.getComment(), num, locationName, spurName, scheduleMode});
                }
            }
            fileOut.flush();
            fileOut.close();
            log.info("Exported {} schedules to file {}", (Object)schedules.size(), (Object)ExportSchedules.defaultOperationsFilename());
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ExportedSchedulesToFile", schedules.size(), ExportSchedules.defaultOperationsFilename()), Bundle.getMessage("ExportComplete"), 1);
        }
        catch (IOException e) {
            log.error("Can not open export schedules CSV file: {}", (Object)e.getLocalizedMessage());
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ExportedSchedulesToFile", 0, ExportSchedules.defaultOperationsFilename()), Bundle.getMessage("ExportFailed"), 0);
        }
    }

    public static String defaultOperationsFilename() {
        return OperationsSetupXml.getFileLocation() + OperationsSetupXml.getOperationsDirectoryName() + File.separator + ExportSchedules.getOperationsFileName();
    }

    public static void setOperationsFileName(String name) {
        operationsFileName = name;
    }

    public static String getOperationsFileName() {
        return operationsFileName;
    }
}

