/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.locations.schedules.tools.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.tools.CarLoadEditFrameAction;
import jmri.jmrit.operations.rollingstock.cars.tools.PrintCarLoadsAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulesAndStagingFrame
extends OperationsFrame
implements PropertyChangeListener {
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    CarLoads carLoads = InstanceManager.getDefault(CarLoads.class);
    CarTypes carTypes = InstanceManager.getDefault(CarTypes.class);
    JComboBox<String> typesComboBox = this.carTypes.getComboBox();
    JComboBox<String> loadsComboBox = new JComboBox();
    JPanel locationsPanel;
    JCheckBox generatedLoadsCheckBox = new JCheckBox(Bundle.getMessage("generatedLoads"));
    JCheckBox allLoadsCheckBox = new JCheckBox(Bundle.getMessage("allLoads"));
    int x;
    private static final Logger log = LoggerFactory.getLogger(SchedulesAndStagingFrame.class);

    public SchedulesAndStagingFrame() {
        super(Bundle.getMessage("MenuItemStagingSchedules"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setMaximumSize(new Dimension(2000, 200));
        p1.setLayout(new BoxLayout(p1, 0));
        JPanel type = new JPanel();
        type.setLayout(new GridBagLayout());
        type.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        this.addItem(type, this.typesComboBox, 0, 0);
        JPanel load = new JPanel();
        load.setLayout(new GridBagLayout());
        load.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Load")));
        this.addItem(load, this.loadsComboBox, 0, 0);
        this.addItem(load, this.generatedLoadsCheckBox, 1, 0);
        this.addItem(load, this.allLoadsCheckBox, 2, 0);
        p1.add(type);
        p1.add(load);
        this.locationsPanel = new JPanel();
        this.locationsPanel.setLayout(new GridBagLayout());
        JScrollPane locationsPane = new JScrollPane(this.locationsPanel);
        locationsPane.setVerticalScrollBarPolicy(20);
        locationsPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Staging")));
        this.getContentPane().add(p1);
        this.getContentPane().add(locationsPane);
        this.addComboBoxAction(this.typesComboBox);
        this.addComboBoxAction(this.loadsComboBox);
        this.generatedLoadsCheckBox.setSelected(true);
        this.generatedLoadsCheckBox.setToolTipText(Bundle.getMessage("generatedLoadsTip"));
        this.addCheckBoxAction(this.generatedLoadsCheckBox);
        this.addCheckBoxAction(this.allLoadsCheckBox);
        this.locationManager.addPropertyChangeListener(this);
        this.carTypes.addPropertyChangeListener(this);
        this.carLoads.addPropertyChangeListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new CarLoadEditFrameAction());
        toolMenu.add(new PrintCarLoadsAction(true));
        toolMenu.add(new PrintCarLoadsAction(false));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ShowStagingAndSchedulesByCarTypeAndLoad", true);
        this.typesComboBox.setSelectedIndex(0);
        this.initMinimumSize(new Dimension(700, 250));
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.typesComboBox) {
            this.updateLoadComboBox();
        }
        if (ae.getSource() == this.loadsComboBox) {
            this.updateLocations();
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        this.loadsComboBox.setEnabled(!this.allLoadsCheckBox.isSelected());
        this.updateLocations();
    }

    private void updateLoadComboBox() {
        String type = (String)this.typesComboBox.getSelectedItem();
        this.carLoads.updateComboBox(type, this.loadsComboBox);
    }

    private void updateLocations() {
        this.locationsPanel.removeAll();
        this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("Track")), 1, 0);
        this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("CarLoadOptions")), 2, 0);
        this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("ShipLoadOption")), 3, 0);
        this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("Load")), 4, 0);
        this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("destinationTrack")), 5, 0);
        this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("LoadOption")), 6, 0);
        this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("Schedule")), 7, 0);
        this.x = 1;
        for (Location location : this.locationManager.getLocationsByNameList()) {
            if (!location.isStaging()) continue;
            location.removePropertyChangeListener(this);
            location.addPropertyChangeListener(this);
            this.addItemLeft(this.locationsPanel, new JLabel(location.getName()), 0, this.x++);
            for (Track track : location.getTracksByNameList("Staging")) {
                track.removePropertyChangeListener(this);
                track.addPropertyChangeListener(this);
                this.addItemLeft(this.locationsPanel, new JLabel(track.getName()), 1, this.x);
                this.addItemLeft(this.locationsPanel, new JLabel(this.getTrackCarLoadOptions(track)), 2, this.x);
                this.addItemLeft(this.locationsPanel, new JLabel(track.getShipLoadOptionString()), 3, this.x);
                this.listSpurs(track);
                ++this.x;
            }
        }
        this.locationsPanel.revalidate();
        this.revalidate();
        this.repaint();
    }

    private String getTrackCarLoadOptions(Track track) {
        StringBuffer options = new StringBuffer();
        if (track.isLoadSwapEnabled()) {
            options.append(Bundle.getMessage("ABV_SwapDefaultLoads") + ", ");
        }
        if (track.isLoadEmptyEnabled()) {
            options.append(Bundle.getMessage("ABV_EmptyDefaultLoads") + ", ");
        }
        if (track.isRemoveCustomLoadsEnabled()) {
            options.append(Bundle.getMessage("ABV_EmptyCustomLoads") + ", ");
        }
        if (track.isAddCustomLoadsEnabled()) {
            options.append(Bundle.getMessage("ABV_GenerateCustomLoad") + ", ");
        }
        if (track.isAddCustomLoadsAnySpurEnabled()) {
            options.append(Bundle.getMessage("ABV_GenerateCustomLoadAnySpur") + ", ");
        }
        if (track.isAddCustomLoadsAnyStagingTrackEnabled()) {
            options.append(Bundle.getMessage("ABV_GereateCustomLoadStaging"));
        }
        return options.toString();
    }

    private void listSpurs(Track track) {
        if (!track.isAddCustomLoadsAnySpurEnabled() && !track.isAddCustomLoadsEnabled()) {
            return;
        }
        String type = (String)this.typesComboBox.getSelectedItem();
        if (!track.isTypeNameAccepted(type)) {
            return;
        }
        if (this.allLoadsCheckBox.isSelected()) {
            for (String load : this.carLoads.getNames(type)) {
                this.listSpurs(track, type, load);
            }
        } else {
            String load = (String)this.loadsComboBox.getSelectedItem();
            this.listSpurs(track, type, load);
        }
    }

    private void listSpurs(Track track, String type, String load) {
        if (load == null || !track.isLoadNameAndCarTypeShipped(load, type)) {
            return;
        }
        if (this.generatedLoadsCheckBox.isSelected() && (load.equals(this.carLoads.getDefaultEmptyName()) || load.equals(this.carLoads.getDefaultLoadName()))) {
            return;
        }
        for (Location location : this.locationManager.getLocationsByNameList()) {
            if (!location.hasSpurs()) continue;
            for (Track spur : location.getTracksByNameList("Spur")) {
                Schedule sch = spur.getSchedule();
                if (sch == null) continue;
                spur.removePropertyChangeListener(this);
                spur.addPropertyChangeListener(this);
                sch.removePropertyChangeListener(this);
                sch.addPropertyChangeListener(this);
                if (!spur.isLoadNameAndCarTypeAccepted(load, type)) continue;
                for (ScheduleItem si : sch.getItemsBySequenceList()) {
                    if (!si.getTypeName().equals(type) || !si.getReceiveLoadName().equals(load) && (!si.getReceiveLoadName().equals("") || this.generatedLoadsCheckBox.isSelected())) continue;
                    this.addItemLeft(this.locationsPanel, new JLabel(load), 4, this.x);
                    this.addItemLeft(this.locationsPanel, new JLabel(location.getName() + " (" + spur.getName() + ")"), 5, this.x);
                    this.addItemLeft(this.locationsPanel, new JLabel(spur.getLoadOptionString()), 6, this.x);
                    this.addItemLeft(this.locationsPanel, new JLabel(sch.getName() + " " + si.getId()), 7, this.x++);
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.locationManager.removePropertyChangeListener(this);
        this.carTypes.removePropertyChangeListener(this);
        this.carLoads.removePropertyChangeListener(this);
        for (Location location : this.locationManager.getLocationsByNameList()) {
            location.removePropertyChangeListener(this);
        }
        for (Track spur : this.locationManager.getTracks("Spur")) {
            Schedule sch = spur.getSchedule();
            if (sch == null) continue;
            spur.removePropertyChangeListener(this);
            sch.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change ({}) old: ({}) new: ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        if (e.getPropertyName().equals("CarTypes Length")) {
            this.carTypes.updateComboBox(this.typesComboBox);
        }
        if (e.getSource().getClass().equals(CarLoads.class)) {
            this.carLoads.updateComboBox((String)this.typesComboBox.getSelectedItem(), this.loadsComboBox);
        }
        if (e.getSource().getClass().equals(Schedule.class) || e.getSource().getClass().equals(LocationManager.class) || e.getPropertyName().equals("trackLoads") || e.getPropertyName().equals("trackLoadOptions") || e.getPropertyName().equals("locationTypes") || e.getPropertyName().equals("trackRollingStockTypes")) {
            this.updateLocations();
        }
    }
}

