/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.schedules.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.locations.schedules.tools.Bundle;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.tools.CarLoadEditFrameAction;
import jmri.jmrit.operations.rollingstock.cars.tools.PrintCarLoadsAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulesByLoadFrame
extends OperationsFrame
implements PropertyChangeListener {
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    CarLoads carLoads = InstanceManager.getDefault(CarLoads.class);
    CarTypes carTypes = InstanceManager.getDefault(CarTypes.class);
    JComboBox<String> typesComboBox = this.carTypes.getComboBox();
    JComboBox<String> loadsComboBox = new JComboBox();
    JPanel locationsPanel;
    JCheckBox allLoadsCheckBox = new JCheckBox(Bundle.getMessage("allLoads"));
    JCheckBox allTypesCheckBox = new JCheckBox(Bundle.getMessage("allTypes"));
    private static final Logger log = LoggerFactory.getLogger(SchedulesByLoadFrame.class);

    public SchedulesByLoadFrame() {
        super(Bundle.getMessage("MenuItemShowSchedulesByLoad"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setMaximumSize(new Dimension(2000, 200));
        p1.setLayout(new BoxLayout(p1, 0));
        JPanel type = new JPanel();
        type.setLayout(new GridBagLayout());
        type.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        this.addItem(type, this.typesComboBox, 0, 0);
        this.addItem(type, this.allTypesCheckBox, 1, 0);
        JPanel load = new JPanel();
        load.setLayout(new GridBagLayout());
        load.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Load")));
        this.addItem(load, this.loadsComboBox, 0, 0);
        this.addItem(load, this.allLoadsCheckBox, 1, 0);
        p1.add(type);
        p1.add(load);
        this.locationsPanel = new JPanel();
        this.locationsPanel.setLayout(new GridBagLayout());
        JScrollPane locationsPane = new JScrollPane(this.locationsPanel);
        locationsPane.setVerticalScrollBarPolicy(20);
        locationsPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Locations")));
        this.getContentPane().add(p1);
        this.getContentPane().add(locationsPane);
        this.addComboBoxAction(this.typesComboBox);
        this.addComboBoxAction(this.loadsComboBox);
        this.addCheckBoxAction(this.allTypesCheckBox);
        this.addCheckBoxAction(this.allLoadsCheckBox);
        this.locationManager.addPropertyChangeListener(this);
        this.carTypes.addPropertyChangeListener(this);
        this.carLoads.addPropertyChangeListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new CarLoadEditFrameAction());
        toolMenu.add(new PrintCarLoadsAction(true));
        toolMenu.add(new PrintCarLoadsAction(false));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ShowSchedulesByCarTypeAndLoad", true);
        this.typesComboBox.setSelectedIndex(0);
        this.initMinimumSize(new Dimension(700, 250));
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.typesComboBox) {
            this.updateLoadComboBox();
        }
        if (ae.getSource() == this.loadsComboBox) {
            this.updateLocations();
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        this.typesComboBox.setEnabled(!this.allTypesCheckBox.isSelected());
        this.loadsComboBox.setEnabled(!this.allLoadsCheckBox.isSelected());
        this.updateLoadComboBox();
        this.updateLocations();
    }

    private void updateLoadComboBox() {
        if (this.allTypesCheckBox.isSelected()) {
            this.carLoads.updateComboBox(this.loadsComboBox);
        } else if (this.typesComboBox.getSelectedItem() != null) {
            String type = (String)this.typesComboBox.getSelectedItem();
            this.carLoads.updateComboBox(type, this.loadsComboBox);
        }
    }

    private void updateLocations() {
        String type = (String)this.typesComboBox.getSelectedItem();
        String load = (String)this.loadsComboBox.getSelectedItem();
        log.debug("Update locations for type ({}) load ({})", (Object)type, (Object)load);
        this.locationsPanel.removeAll();
        int x = 0;
        this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("trackSchedule")), 1, x);
        this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("receiveTypeLoad")), 2, x);
        this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("shipLoad")), 3, x);
        this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("destinationTrack")), 4, x++);
        boolean defaultLoad = this.carLoads.getDefaultLoadName().equals(load) || this.carLoads.getDefaultEmptyName().equals(load);
        for (Location location : this.locationManager.getLocationsByNameList()) {
            if (!location.hasSpurs()) continue;
            this.addItemLeft(this.locationsPanel, new JLabel(location.getName()), 0, x++);
            for (Track spur : location.getTracksByNameList("Spur")) {
                Schedule sch = spur.getSchedule();
                if (sch == null) continue;
                spur.removePropertyChangeListener(this);
                spur.addPropertyChangeListener(this);
                sch.removePropertyChangeListener(this);
                sch.addPropertyChangeListener(this);
                for (ScheduleItem si : sch.getItemsBySequenceList()) {
                    if (this.allTypesCheckBox.isSelected() && !this.allLoadsCheckBox.isSelected() && !this.carLoads.containsName(si.getTypeName(), load) || !this.allTypesCheckBox.isSelected() && !si.getTypeName().equals(type) || !this.allLoadsCheckBox.isSelected() && !si.getReceiveLoadName().equals(load) && !si.getReceiveLoadName().equals("") && !si.getShipLoadName().equals(load) && (!si.getShipLoadName().equals("") || !defaultLoad)) continue;
                    String status = spur.checkScheduleValid();
                    if (!status.equals("")) {
                        this.addItemLeft(this.locationsPanel, new JLabel("  " + status), 0, x);
                    }
                    this.addItemLeft(this.locationsPanel, new JLabel(spur.getName() + " (" + spur.getScheduleName() + ")"), 1, x);
                    String s = si.getTypeName() + ", " + si.getSetoutTrainScheduleName() + ", " + si.getRoadName() + ", " + si.getReceiveLoadName();
                    this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("Receive") + " (" + s + ")"), 2, x);
                    this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("Ship") + " (" + si.getShipLoadName() + ", " + si.getPickupTrainScheduleName() + ")"), 3, x++);
                    if (si.getDestination() != null) {
                        this.addItemLeft(this.locationsPanel, new JLabel(si.getDestinationName() + " (" + si.getDestinationTrackName() + ")"), 4, x - 1);
                    }
                    if (this.allLoadsCheckBox.isSelected() || !si.getReceiveLoadName().equals("") || spur.isLoadNameAndCarTypeAccepted(load, type)) continue;
                    this.addItemLeft(this.locationsPanel, new JLabel(Bundle.getMessage("spurNotTypeLoad", spur.getName(), type, load)), 2, x++);
                }
            }
        }
        this.locationsPanel.revalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void dispose() {
        this.locationManager.removePropertyChangeListener(this);
        this.carTypes.removePropertyChangeListener(this);
        this.carLoads.removePropertyChangeListener(this);
        for (Track spur : this.locationManager.getTracks("Spur")) {
            Schedule sch = spur.getSchedule();
            if (sch == null) continue;
            spur.removePropertyChangeListener(this);
            sch.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change ({}) old: ({}) new: ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        if (e.getPropertyName().equals("CarTypes Length")) {
            this.carTypes.updateComboBox(this.typesComboBox);
        }
        if (e.getSource().getClass().equals(CarLoads.class)) {
            this.carLoads.updateComboBox((String)this.typesComboBox.getSelectedItem(), this.loadsComboBox);
        }
        if (e.getSource().getClass().equals(Schedule.class) || e.getSource().getClass().equals(LocationManager.class) || e.getPropertyName().equals("trackLoads") || e.getPropertyName().equals("trackRollingStockTypes")) {
            this.updateLocations();
        }
    }
}

