/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.gui.TrackEditFrame;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AlternateTrackFrame
extends OperationsFrame
implements PropertyChangeListener {
    JComboBox<Track> trackBox = new JComboBox();
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    Track _track;
    private static final Logger log = LoggerFactory.getLogger(AlternateTrackFrame.class);

    public AlternateTrackFrame(TrackEditFrame tef) {
        super(Bundle.getMessage("AlternateTrack"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this._track = tef._track;
        JPanel pAlternate = new JPanel();
        pAlternate.setLayout(new GridBagLayout());
        pAlternate.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pAlternate, this.trackBox, 0, 0);
        if (this._track != null) {
            this.updateTrackCombobox();
            this._track.addPropertyChangeListener(this);
            this._track.getLocation().addPropertyChangeListener(this);
        }
        JPanel pControls = new JPanel();
        pControls.add(this.saveButton);
        this.saveButton.setEnabled(this._track != null);
        this.addButtonAction(this.saveButton);
        this.getContentPane().add(pAlternate);
        this.getContentPane().add(pControls);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_AlternateTrack", true);
        this.initMinimumSize(new Dimension(400, 200));
    }

    private void updateTrackCombobox() {
        this._track.getLocation().updateComboBox(this.trackBox);
        this.trackBox.removeItem(this._track);
        this.trackBox.setSelectedItem(this._track.getAlternateTrack());
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            if (this.trackBox.getSelectedItem() != null && this._track.getIgnoreUsedLengthPercentage() > 0) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("PPWarningAlternate"), Bundle.getMessage("PPWarningConfiguration"), 0);
            }
            this._track.setAlternateTrack((Track)this.trackBox.getSelectedItem());
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    @Override
    public void dispose() {
        if (this._track != null) {
            this._track.removePropertyChangeListener(this);
            this._track.getLocation().removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("trackAlternate") || e.getPropertyName().equals("trackListLength")) {
            this.updateTrackCombobox();
        }
    }
}

