/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.gui.TrackEditFrame;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangeTrackFrame
extends OperationsFrame {
    JRadioButton spurRadioButton = new JRadioButton(Bundle.getMessage("Spur"));
    JRadioButton yardRadioButton = new JRadioButton(Bundle.getMessage("Yard"));
    JRadioButton interchangeRadioButton = new JRadioButton(Bundle.getMessage("Interchange"));
    ButtonGroup group = new ButtonGroup();
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    private Track _track;
    private TrackEditFrame _tef;
    private static final Logger log = LoggerFactory.getLogger(ChangeTrackFrame.class);

    public ChangeTrackFrame(TrackEditFrame tef) {
        super(Bundle.getMessage("MenuItemChangeTrackType"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this._tef = tef;
        this._track = tef._track;
        if (this._track == null) {
            log.debug("track is null, change track not possible");
            return;
        }
        String trackName = this._track.getName();
        JPanel p1 = new JPanel();
        p1.setLayout(new GridBagLayout());
        p1.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrackType", trackName)));
        this.addItem(p1, this.spurRadioButton, 0, 0);
        this.addItem(p1, this.yardRadioButton, 1, 0);
        this.addItem(p1, this.interchangeRadioButton, 2, 0);
        JPanel p2 = new JPanel();
        p2.add(this.saveButton);
        this.group.add(this.spurRadioButton);
        this.group.add(this.yardRadioButton);
        this.group.add(this.interchangeRadioButton);
        this.spurRadioButton.setSelected(this._track.isSpur());
        this.yardRadioButton.setSelected(this._track.isYard());
        this.interchangeRadioButton.setSelected(this._track.isInterchange());
        this.saveButton.setEnabled(!this._track.isStaging());
        this.addButtonAction(this.saveButton);
        this.getContentPane().add(p1);
        this.getContentPane().add(p2);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ChangeTrackType", true);
        this.initMinimumSize(new Dimension(400, 200));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            if (this.spurRadioButton.isSelected() && !this._track.isSpur()) {
                this.changeTrack("Spur");
            } else if (this.yardRadioButton.isSelected() && !this._track.isYard()) {
                this.changeTrack("Yard");
            } else if (this.interchangeRadioButton.isSelected() && !this._track.isInterchange()) {
                this.changeTrack("Interchange");
            }
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    private void changeTrack(String type) {
        log.debug("change track to {}", (Object)type);
        this._track.setTrackType(type);
        OperationsXml.save();
        this._tef.dispose();
        this.dispose();
    }
}

