/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.gui.LocationEditFrame;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.setup.Setup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChangeTracksFrame
extends OperationsFrame {
    JRadioButton spurRadioButton = new JRadioButton(Bundle.getMessage("Spur"));
    JRadioButton yardRadioButton = new JRadioButton(Bundle.getMessage("Yard"));
    JRadioButton interchangeRadioButton = new JRadioButton(Bundle.getMessage("Interchange"));
    JRadioButton stagingRadioButton = new JRadioButton(Bundle.getMessage("Staging"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    private LocationEditFrame _lef;
    private Location _location;
    private static final Logger log = LoggerFactory.getLogger(ChangeTracksFrame.class);

    public ChangeTracksFrame(LocationEditFrame lef) {
        super(Bundle.getMessage("MenuItemChangeTrackType"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this._lef = lef;
        if (this._lef._location == null) {
            log.debug("location is null, change location track types not possible");
            return;
        }
        this._location = this._lef._location;
        JPanel p1 = new JPanel();
        p1.setLayout(new GridBagLayout());
        p1.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrackType", this._location.getName())));
        this.addItem(p1, this.spurRadioButton, 0, 0);
        this.addItem(p1, this.yardRadioButton, 1, 0);
        this.addItem(p1, this.interchangeRadioButton, 2, 0);
        this.addItem(p1, this.stagingRadioButton, 3, 0);
        JPanel p2 = new JPanel();
        p2.add(this.saveButton);
        ButtonGroup group = new ButtonGroup();
        group.add(this.spurRadioButton);
        group.add(this.yardRadioButton);
        group.add(this.interchangeRadioButton);
        group.add(this.stagingRadioButton);
        this.stagingRadioButton.setSelected(this._location.isStaging());
        this.addButtonAction(this.saveButton);
        this.getContentPane().add(p1);
        this.getContentPane().add(p2);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ChangeTrackTypeLocation", true);
        this.initMinimumSize(new Dimension(400, 200));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            if (this.spurRadioButton.isSelected()) {
                this.changeTracks("Spur");
            } else if (this.yardRadioButton.isSelected()) {
                this.changeTracks("Yard");
            } else if (this.interchangeRadioButton.isSelected()) {
                this.changeTracks("Interchange");
            } else if (this.stagingRadioButton.isSelected()) {
                this.changeTracks("Staging");
            }
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    private void changeTracks(String type) {
        log.debug("change tracks to {}", (Object)type);
        this._location.changeTrackType(type);
        OperationsXml.save();
        this._lef.dispose();
        this.dispose();
    }
}

