/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.util.swing.JmriJOptionPane;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportLocations
extends XmlFile {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    RouteManager routeManager = InstanceManager.getDefault(RouteManager.class);
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    private static String operationsFileName = "ExportOperationsLocationRoster.csv";
    private static final Logger log = LoggerFactory.getLogger(ExportLocations.class);

    public void writeOperationsLocationFile() {
        this.makeBackupFile(ExportLocations.defaultOperationsFilename());
        try {
            if (!this.checkFile(ExportLocations.defaultOperationsFilename())) {
                File file = new File(ExportLocations.defaultOperationsFilename());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("File created");
                }
            }
            this.writeFile(ExportLocations.defaultOperationsFilename());
        }
        catch (IOException e) {
            log.error("Exception while writing the new CSV operations file, may not be complete: {}", (Object)e.getLocalizedMessage());
        }
    }

    public void writeFile(String name) {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
            fileOut.printRecord(new Object[]{Bundle.getMessage("Location"), Bundle.getMessage("Track"), Bundle.getMessage("Type"), Bundle.getMessage("Length"), Bundle.getMessage("Used"), Bundle.getMessage("Cars"), Bundle.getMessage("Engines"), Bundle.getMessage("Moves"), Bundle.getMessage("Division"), Bundle.getMessage("ServicedByTrains"), Bundle.getMessage("RollingStock"), Bundle.getMessage("ServiceOrder"), Bundle.getMessage("RoadOption"), Bundle.getMessage("Roads"), Bundle.getMessage("LoadOption"), Bundle.getMessage("Loads"), Bundle.getMessage("ShipLoadOption"), Bundle.getMessage("Ships"), Bundle.getMessage("SetOutRestrictions"), Bundle.getMessage("Restrictions"), Bundle.getMessage("PickUpRestrictions"), Bundle.getMessage("Restrictions"), Bundle.getMessage("ScheduleName"), Bundle.getMessage("ScheduleMode"), Bundle.getMessage("PercentStaging"), Bundle.getMessage("AlternateTrack"), Bundle.getMessage("PoolName"), Bundle.getMessage("Minimum"), Bundle.getMessage("TitleTrackBlockingOrder"), Bundle.getMessage("MenuItemPlannedPickups"), Bundle.getMessage("MenuItemDestinations"), Bundle.getMessage("Destinations"), Bundle.getMessage("HoldCarsWithCustomLoads"), Bundle.getMessage("DisableLoadChange"), Bundle.getMessage("SwapCarLoads"), Bundle.getMessage("EmptyDefaultCarLoads"), Bundle.getMessage("EmptyCarLoads"), Bundle.getMessage("LoadCarLoads"), Bundle.getMessage("LoadAnyCarLoads"), Bundle.getMessage("LoadsStaging"), Bundle.getMessage("BlockCars"), Bundle.getMessage("Comment"), Bundle.getMessage("CommentBoth"), Bundle.getMessage("CommentPickup"), Bundle.getMessage("CommentSetout")});
            List<Location> locations = this.locationManager.getLocationsByNameList();
            for (Location location : locations) {
                for (Track track : location.getTracksByNameList(null)) {
                    int n;
                    String shipName2;
                    String[] directions;
                    StringBuilder trainDirections = new StringBuilder();
                    for (String dir : directions = Setup.getDirectionStrings(Setup.getTrainDirection() & location.getTrainDirections() & track.getTrainDirections())) {
                        if (dir == null) continue;
                        trainDirections.append(dir).append("; ");
                    }
                    StringBuilder rollingStockNames = new StringBuilder();
                    for (String rollingStockName : track.getTypeNames()) {
                        rollingStockNames.append(rollingStockName).append("; ");
                    }
                    StringBuilder roadNames = new StringBuilder();
                    if (!track.getRoadOption().equals(Track.ALL_ROADS)) {
                        for (String roadName : track.getRoadNames()) {
                            roadNames.append(roadName).append("; ");
                        }
                    }
                    StringBuilder loadNames = new StringBuilder();
                    if (!track.getLoadOption().equals(Track.ALL_LOADS)) {
                        for (String loadName : track.getLoadNames()) {
                            loadNames.append(loadName).append("; ");
                        }
                    }
                    StringBuilder shipNames = new StringBuilder();
                    if (!track.getShipLoadOption().equals(Track.ALL_LOADS)) {
                        for (String shipName2 : track.getShipLoadNames()) {
                            shipNames.append(shipName2).append("; ");
                        }
                    }
                    String setOutRestriction = Bundle.getMessage("None");
                    switch (track.getDropOption()) {
                        case "trains": {
                            setOutRestriction = Bundle.getMessage("Trains");
                            break;
                        }
                        case "routes": {
                            setOutRestriction = Bundle.getMessage("Routes");
                            break;
                        }
                        case "excludeTrains": {
                            setOutRestriction = Bundle.getMessage("ExcludeTrains");
                            break;
                        }
                        case "excludeRoutes": {
                            setOutRestriction = Bundle.getMessage("ExcludeRoutes");
                            break;
                        }
                    }
                    StringBuilder setOutRestrictions = new StringBuilder();
                    if (track.getDropOption().equals("trains") || track.getDropOption().equals("excludeTrains")) {
                        String[] loadName = track.getDropIds();
                        int shipName2 = loadName.length;
                        for (n = 0; n < shipName2; ++n) {
                            String id = loadName[n];
                            Train train = this.trainManager.getTrainById(id);
                            if (train == null) continue;
                            setOutRestrictions.append(train.getName()).append("; ");
                        }
                    }
                    if (track.getDropOption().equals("routes") || track.getDropOption().equals("excludeRoutes")) {
                        for (String id : track.getDropIds()) {
                            Route route = this.routeManager.getRouteById(id);
                            if (route == null) continue;
                            setOutRestrictions.append(route.getName()).append("; ");
                        }
                    }
                    String pickUpRestriction = Bundle.getMessage("None");
                    shipName2 = track.getPickupOption();
                    n = -1;
                    switch (shipName2.hashCode()) {
                        case -865710229: {
                            if (!shipName2.equals("trains")) break;
                            n = 0;
                            break;
                        }
                        case -925132982: {
                            if (!shipName2.equals("routes")) break;
                            n = 1;
                            break;
                        }
                        case 608226789: {
                            if (!shipName2.equals("excludeTrains")) break;
                            n = 2;
                            break;
                        }
                        case 548804036: {
                            if (!shipName2.equals("excludeRoutes")) break;
                            n = 3;
                        }
                    }
                    switch (n) {
                        case 0: {
                            pickUpRestriction = Bundle.getMessage("Trains");
                            break;
                        }
                        case 1: {
                            pickUpRestriction = Bundle.getMessage("Routes");
                            break;
                        }
                        case 2: {
                            pickUpRestriction = Bundle.getMessage("ExcludeTrains");
                            break;
                        }
                        case 3: {
                            pickUpRestriction = Bundle.getMessage("ExcludeRoutes");
                            break;
                        }
                    }
                    StringBuilder pickUpRestrictions = new StringBuilder();
                    if (track.getPickupOption().equals("trains") || track.getPickupOption().equals("excludeTrains")) {
                        for (String id : track.getPickupIds()) {
                            Train train = this.trainManager.getTrainById(id);
                            if (train == null) continue;
                            pickUpRestrictions.append(train.getName()).append("; ");
                        }
                    }
                    if (track.getPickupOption().equals("routes") || track.getPickupOption().equals("excludeRoutes")) {
                        for (String id : track.getPickupIds()) {
                            Route route = this.routeManager.getRouteById(id);
                            if (route == null) continue;
                            pickUpRestrictions.append(route.getName()).append("; ");
                        }
                    }
                    String alternateTrackName = "";
                    if (track.getAlternateTrack() != null) {
                        alternateTrackName = track.getAlternateTrack().getName();
                    }
                    if (track.isAlternate()) {
                        alternateTrackName = Bundle.getMessage("ButtonYes");
                    }
                    StringBuilder destinationNames = new StringBuilder();
                    for (String id : track.getDestinationIds()) {
                        Location destination = this.locationManager.getLocationById(id);
                        if (destination == null) continue;
                        destinationNames.append(destination.getName()).append("; ");
                    }
                    fileOut.printRecord(new Object[]{location.getName(), track.getName(), track.getTrackTypeName(), track.getLength(), track.getUsedLength(), track.getNumberCars(), track.getNumberEngines(), track.getMoves(), track.getDivision(), trainDirections.toString(), rollingStockNames.toString(), track.getServiceOrder(), track.getRoadOptionString(), roadNames.toString(), track.getLoadOptionString(), loadNames.toString(), track.getShipLoadOptionString(), shipNames.toString(), setOutRestriction, setOutRestrictions.toString(), pickUpRestriction, pickUpRestrictions.toString(), track.getScheduleName(), track.getScheduleModeName(), track.getReservationFactor(), alternateTrackName, track.getPoolName(), track.getMinimumLength(), track.getBlockingOrder(), track.getIgnoreUsedLengthPercentage(), Bundle.getMessage(track.getDestinationOption().equals(Track.ALL_DESTINATIONS) ? "All" : "Include"), destinationNames.toString(), track.isHoldCarsWithCustomLoadsEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isDisableLoadChangeEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isLoadSwapEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isLoadEmptyEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isRemoveCustomLoadsEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isAddCustomLoadsEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isAddCustomLoadsAnySpurEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isAddCustomLoadsAnyStagingTrackEnabled() ? Bundle.getMessage("ButtonYes") : "", track.isBlockCarsEnabled() ? Bundle.getMessage("ButtonYes") : "", track.getComment().replace('\n', ' '), track.getCommentBoth().replace('\n', ' '), track.getCommentPickup().replace('\n', ' '), track.getCommentSetout().replace('\n', ' ')});
                }
            }
            fileOut.flush();
            fileOut.close();
            log.info("Exported {} locations to file {}", (Object)locations.size(), (Object)ExportLocations.defaultOperationsFilename());
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ExportedLocationsToFile", locations.size(), ExportLocations.defaultOperationsFilename()), Bundle.getMessage("ExportComplete"), 1);
        }
        catch (IOException e) {
            log.error("Can not open export locations CSV file: {}", (Object)e.getLocalizedMessage());
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ExportedLocationsToFile", 0, ExportLocations.defaultOperationsFilename()), Bundle.getMessage("ExportFailed"), 0);
        }
    }

    public static String defaultOperationsFilename() {
        return OperationsSetupXml.getFileLocation() + OperationsSetupXml.getOperationsDirectoryName() + File.separator + ExportLocations.getOperationsFileName();
    }

    public static void setOperationsFileName(String name) {
        operationsFileName = name;
    }

    public static String getOperationsFileName() {
        return operationsFileName;
    }
}

