/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.gui.TrackEditFrame;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IgnoreUsedTrackFrame
extends OperationsFrame {
    JRadioButton zeroPercent = new JRadioButton(Bundle.getMessage("Disabled"));
    JRadioButton twentyfivePercent = new JRadioButton("25%");
    JRadioButton fiftyPercent = new JRadioButton("50%");
    JRadioButton seventyfivePercent = new JRadioButton("75%");
    JRadioButton hundredPercent = new JRadioButton("100%");
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    protected Track _track;
    private static final Logger log = LoggerFactory.getLogger(IgnoreUsedTrackFrame.class);

    public IgnoreUsedTrackFrame(TrackEditFrame tef) {
        this.setTitle(Bundle.getMessage("MenuItemPlannedPickups"));
        this._track = tef._track;
        if (this._track == null) {
            log.debug("track is null!");
            return;
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.setMaximumSize(new Dimension(2000, 250));
        JPanel pTrackName = new JPanel();
        pTrackName.setLayout(new GridBagLayout());
        pTrackName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Track")));
        this.addItem(pTrackName, new JLabel(this._track.getName()), 0, 0);
        JPanel pLocationName = new JPanel();
        pLocationName.setLayout(new GridBagLayout());
        pLocationName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        this.addItem(pLocationName, new JLabel(this._track.getLocation().getName()), 0, 0);
        p1.add(pTrackName);
        p1.add(pLocationName);
        JPanel p2 = new JPanel();
        p2.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PrePlanedPickups")));
        p2.add(this.zeroPercent);
        if (!this._track.isStaging()) {
            p2.add(this.twentyfivePercent);
            p2.add(this.fiftyPercent);
            p2.add(this.seventyfivePercent);
        }
        p2.add(this.hundredPercent);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.zeroPercent);
        buttonGroup.add(this.twentyfivePercent);
        buttonGroup.add(this.fiftyPercent);
        buttonGroup.add(this.seventyfivePercent);
        buttonGroup.add(this.hundredPercent);
        int percentage = this._track.getIgnoreUsedLengthPercentage();
        this.zeroPercent.setSelected(percentage >= 0);
        this.twentyfivePercent.setSelected(percentage >= 25);
        this.fiftyPercent.setSelected(percentage >= 50);
        this.seventyfivePercent.setSelected(percentage >= 75);
        this.hundredPercent.setSelected(percentage >= 100);
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 1));
        p3.add(new JLabel(Bundle.getMessage("PPWarningMessage")));
        p3.add(new JLabel(Bundle.getMessage("PPWarningMessage2")));
        JPanel pW = new JPanel();
        pW.setLayout(new GridBagLayout());
        this.addItem(pW, p3, 0, 1);
        this.addItem(pW, this.saveButton, 0, 2);
        this.getContentPane().add(p1);
        this.getContentPane().add(p2);
        this.getContentPane().add(pW);
        this.addButtonAction(this.saveButton);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_PlannedPickUps", true);
        this.initMinimumSize(new Dimension(600, 300));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            int percentage = 0;
            if (this.twentyfivePercent.isSelected()) {
                percentage = 25;
            } else if (this.fiftyPercent.isSelected()) {
                percentage = 50;
            } else if (this.seventyfivePercent.isSelected()) {
                percentage = 75;
            } else if (this.hundredPercent.isSelected()) {
                percentage = 100;
            }
            if (this._track != null) {
                this._track.setIgnoreUsedLengthPercentage(percentage);
                if (this._track.getAlternateTrack() != null && percentage > 0) {
                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("PPWarningAlternate"), Bundle.getMessage("PPWarningConfiguration"), 0);
                }
            }
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }
}

