/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.io.BufferedReader;
import java.io.File;
import java.util.Locale;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Pool;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.divisions.Division;
import jmri.jmrit.operations.locations.divisions.DivisionManager;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.rollingstock.ImportCommon;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportLocations
extends ImportCommon {
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    DivisionManager divisionManager = InstanceManager.getDefault(DivisionManager.class);
    int tracksAdded = 0;
    protected static final int FIELD_LOCATION = 0;
    protected static final int FIELD_TRACK = 1;
    protected static final int FIELD_TYPE = 2;
    protected static final int FIELD_LENGTH = 3;
    protected static final int FIELD_USED = 4;
    protected static final int FIELD_CARS = 5;
    protected static final int FIELD_LOCOS = 6;
    protected static final int FIELD_MOVES = 7;
    protected static final int FIELD_DIVISION = 8;
    protected static final int FIELD_SERVICED_BY = 9;
    protected static final int FIELD_ROLLING_STOCK = 10;
    protected static final int FIELD_ORDER = 11;
    protected static final int FIELD_ROAD_OPTION = 12;
    protected static final int FIELD_ROADS = 13;
    protected static final int FIELD_LOAD_OPTION = 14;
    protected static final int FIELD_LOADS = 15;
    protected static final int FIELD_SHIP_LOAD_OPTION = 16;
    protected static final int FIELD_SHIPS = 17;
    protected static final int FIELD_SET_OUT_RESTRICTIONS = 18;
    protected static final int FIELD_RESTRICTIONS_1 = 19;
    protected static final int FIELD_PICK_UP_RESTRICTIONS = 20;
    protected static final int FIELD_RESTRICTIONS_2 = 21;
    protected static final int FIELD_SCHEDULE_NAME = 22;
    protected static final int FIELD_SCHEDULE_MODE = 23;
    protected static final int FIELD_PERCENT_STAGING = 24;
    protected static final int FIELD_ALTERNATE_TRACK = 25;
    protected static final int FIELD_POOL_NAME = 26;
    protected static final int FIELD_TRACK_MINIMUM_POOL = 27;
    protected static final int FIELD_TRACK_BLOCKING_ORDER = 28;
    protected static final int FIELD_PLANNED_PICK_UPS = 29;
    protected static final int FIELD_TRACK_DESTINATIONS = 30;
    protected static final int FIELD_DESTINATIONS = 31;
    protected static final int FIELD_HOLD_CARS_CUSTOM_LOADS = 32;
    protected static final int FIELD_DISABLE_LOAD_CHANGE = 33;
    protected static final int FIELD_SWAP_DEFAULT = 34;
    protected static final int FIELD_EMPTY_DEFAULT_LOADS = 35;
    protected static final int FIELD_EMPTY_CUSTOM_LOADS = 36;
    protected static final int FIELD_GENERATE_SPUR = 37;
    protected static final int FIELD_GENERATE_ANY_SPUR = 38;
    protected static final int FIELD_GENERATE_STAGING = 39;
    protected static final int FIELD_BLOCK_CARS_BY_PICKUP = 40;
    protected static final int FIELD_COMMENT = 41;
    protected static final int FIELD_COMMENT_BOTH = 42;
    protected static final int FIELD_COMMENT_PICKUPS = 43;
    protected static final int FIELD_COMMENT_SETOUTS = 44;
    private static final Logger log = LoggerFactory.getLogger(ImportLocations.class);

    @Override
    public void run() {
        File file = this.getFile();
        if (file == null) {
            return;
        }
        BufferedReader rdr = this.getBufferedReader(file);
        if (rdr == null) {
            return;
        }
        this.createStatusFrame(Bundle.getMessage("ImportLocations"));
        boolean headerFound = false;
        block10: while (true) {
            String fieldComment;
            String ignoreUsedLength;
            String fieldTrackBlockingOrder;
            String minPool;
            String alternateTrackName;
            String scheduleMode;
            String[] loads;
            String loadOptions;
            Object optionValue;
            String fieldServiceOrder;
            String[] trackDir2;
            int n;
            String fieldDivision;
            String[] inputLine;
            if ((inputLine = this.readNextLine(rdr)) == BREAK) break;
            if (inputLine.length < 1) {
                log.debug("Skipping blank line");
                continue;
            }
            String fieldLocation = "";
            String fieldTrack = "";
            String fieldType = "";
            String fieldLength = "";
            if (!headerFound && inputLine[0].equals(Bundle.getMessage("Location"))) {
                headerFound = true;
                int elementNum = 0;
                String[] stringArray = inputLine;
                int n2 = stringArray.length;
                int n3 = 0;
                while (true) {
                    if (n3 >= n2) continue block10;
                    String lineElement = stringArray[n3];
                    log.debug("Header {} is: {}", (Object)elementNum++, (Object)lineElement);
                    ++n3;
                }
            }
            if (inputLine.length < 4) {
                log.info("Skipping row {} as we need at least 4 fields (Location, Track, Type and Length)", (Object)Integer.toString(this.lineNum));
                continue;
            }
            fieldLocation = inputLine[0];
            Location location = this.locationManager.getLocationByName(fieldLocation);
            if (location == null) {
                log.debug("adding location - {}", (Object)fieldLocation);
                location = this.locationManager.newLocation(fieldLocation);
            }
            fieldTrack = inputLine[1];
            fieldLength = inputLine[3].trim();
            fieldType = inputLine[2].trim();
            String typeValue = null;
            if (fieldType.length() > 0) {
                typeValue = fieldType.equals(Bundle.getMessage("Spur").toLowerCase(Locale.ROOT)) ? "Spur" : (fieldType.equals(Bundle.getMessage("Yard").toLowerCase(Locale.ROOT)) ? "Yard" : (fieldType.equals(Bundle.getMessage("Class/Interchange")) ? "Interchange" : (fieldType.equals(Bundle.getMessage("Staging").toLowerCase(Locale.ROOT)) ? "Staging" : "unknown")));
            }
            Track thisTrack = location.getTrackByName(fieldTrack, null);
            Integer trackLength = null;
            try {
                trackLength = Integer.parseInt(fieldLength);
            }
            catch (NumberFormatException exception) {
                log.info("Import caught an exception converting the length field of the new track - value was {} at line number {}", (Object)fieldLength, (Object)Integer.toString(this.lineNum));
            }
            if (thisTrack != null) {
                if (!thisTrack.getTrackType().equals(typeValue)) {
                    log.debug("Import is changing type of track for Location {} track {} to {}", new Object[]{location.getName(), thisTrack.getName(), typeValue});
                    thisTrack.setTrackType(typeValue);
                }
            } else {
                log.debug("Import is adding location {} new track {} of type {}", new Object[]{location.getName(), fieldTrack, typeValue});
                thisTrack = location.addTrack(fieldTrack, typeValue);
                ++this.tracksAdded;
            }
            if (trackLength != null) {
                thisTrack.setLength(trackLength);
            }
            if (inputLine.length >= 8 && (fieldDivision = inputLine[8].trim()).length() > 0) {
                Division division = this.divisionManager.newDivision(fieldDivision);
                location.setDivision(division);
                log.debug("Setting this location to division {}", (Object)division);
            }
            if (inputLine.length >= 9) {
                String[] directions = inputLine[9].split("; ");
                log.debug("this track is serviced by {} directions", (Object)directions.length);
                int trackDir2 = 0;
                String[] stringArray = directions;
                n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String dir = stringArray[i];
                    trackDir2 += Setup.getDirectionInt(dir);
                }
                thisTrack.setTrainDirections(trackDir2);
                log.debug("setting this location to directions {}", (Object)trackDir2);
            }
            if (inputLine.length >= 10 && inputLine[10].length() > 0) {
                String[] rollingStock;
                log.debug("Setting track to accepting the following rolling stock: {}", (Object)inputLine[10]);
                for (String typeName : thisTrack.getTypeNames()) {
                    thisTrack.deleteTypeName(typeName);
                }
                trackDir2 = rollingStock = inputLine[10].split("; ");
                int n4 = trackDir2.length;
                for (n = 0; n < n4; ++n) {
                    String typeName = trackDir2[n];
                    thisTrack.addTypeName(typeName);
                }
            }
            if (inputLine.length >= 11 && (fieldServiceOrder = inputLine[11].trim()).length() > 0) {
                thisTrack.setServiceOrder(fieldServiceOrder);
                log.debug("Setting the service order to {}", (Object)fieldServiceOrder);
            }
            if (inputLine.length >= 13) {
                log.debug("setting the road names to: {}", (Object)inputLine[13]);
                if (inputLine[13].length() > 0) {
                    String[] roads;
                    trackDir2 = roads = inputLine[13].split("; ");
                    int n5 = trackDir2.length;
                    for (n = 0; n < n5; ++n) {
                        String road = trackDir2[n];
                        thisTrack.addRoadName(road);
                    }
                }
            }
            if (inputLine.length >= 12) {
                String roadOptions = inputLine[12].trim();
                optionValue = "";
                if (roadOptions.length() > 0) {
                    if (roadOptions.startsWith(Bundle.getMessage("AcceptsAllRoads"))) {
                        optionValue = Track.ALL_ROADS;
                    } else if (roadOptions.startsWith(Bundle.getMessage("AcceptOnly"))) {
                        optionValue = Track.INCLUDE_ROADS;
                    } else if (roadOptions.startsWith(Bundle.getMessage("Exclude"))) {
                        optionValue = Track.EXCLUDE_ROADS;
                    }
                    thisTrack.setRoadOption((String)optionValue);
                    log.debug("setting the road options to {}", optionValue);
                }
            }
            if (inputLine.length >= 14) {
                loadOptions = inputLine[14].trim();
                optionValue = "";
                if (loadOptions.length() > 0) {
                    if (loadOptions.startsWith(Bundle.getMessage("AcceptsAllLoads"))) {
                        optionValue = Track.ALL_LOADS;
                    } else if (loadOptions.startsWith(Bundle.getMessage("AcceptOnly"))) {
                        optionValue = Track.INCLUDE_ROADS;
                    } else if (loadOptions.startsWith(Bundle.getMessage("Exclude"))) {
                        optionValue = Track.EXCLUDE_LOADS;
                    } else {
                        log.error("Locations Import load option was not recognized: {} ", (Object)loadOptions);
                    }
                    thisTrack.setLoadOption((String)optionValue);
                }
            }
            if (inputLine.length >= 15 && inputLine[15].length() > 0) {
                loads = inputLine[15].split("; ");
                log.debug("This location is surviced by {} loads", (Object)loads.length);
                optionValue = loads;
                int n6 = ((String[])optionValue).length;
                for (n = 0; n < n6; ++n) {
                    String load = optionValue[n];
                    thisTrack.addLoadName(load);
                }
            }
            if (inputLine.length >= 16) {
                loadOptions = inputLine[16].trim();
                optionValue = "";
                if (loadOptions.length() > 0) {
                    if (loadOptions.startsWith(Bundle.getMessage("ShipsAllLoads"))) {
                        optionValue = Track.ALL_LOADS;
                    } else if (loadOptions.startsWith(Bundle.getMessage("ShipOnly"))) {
                        optionValue = Track.INCLUDE_ROADS;
                    } else if (loadOptions.startsWith(Bundle.getMessage("Exclude"))) {
                        optionValue = Track.EXCLUDE_LOADS;
                    } else {
                        log.error("Locations Import ship load option was not recognized: {} ", (Object)loadOptions);
                    }
                    thisTrack.setShipLoadOption((String)optionValue);
                }
            }
            if (inputLine.length >= 17 && inputLine[17].length() > 0) {
                loads = inputLine[17].split("; ");
                log.debug("This location ships {} loads", (Object)loads.length);
                optionValue = loads;
                int n7 = ((String[])optionValue).length;
                for (n = 0; n < n7; ++n) {
                    String load = optionValue[n];
                    thisTrack.addShipLoadName(load);
                }
            }
            if (inputLine.length >= 22) {
                String scheduleName = inputLine[22].trim();
                Schedule schedule = InstanceManager.getDefault(ScheduleManager.class).newSchedule(scheduleName);
                thisTrack.setSchedule(schedule);
            }
            if (inputLine.length >= 23 && (scheduleMode = inputLine[23].trim()).equals(Bundle.getMessage("Sequential"))) {
                thisTrack.setScheduleMode(0);
            }
            if (inputLine.length >= 24) {
                String percentStaging = inputLine[24].trim();
                try {
                    thisTrack.setReservationFactor(Integer.parseInt(percentStaging));
                }
                catch (NumberFormatException exception) {
                    log.debug("Exception converting percentage from staging - value was {}", (Object)percentStaging);
                }
            }
            if (inputLine.length >= 25 && !(alternateTrackName = inputLine[25].trim()).isBlank() && !alternateTrackName.equals(Bundle.getMessage("ButtonYes"))) {
                Track altTrack = location.getTrackByName(alternateTrackName, null);
                if (altTrack == null) {
                    altTrack = location.addTrack(alternateTrackName, "Yard");
                    ++this.tracksAdded;
                }
                thisTrack.setAlternateTrack(altTrack);
            }
            if (inputLine.length >= 26) {
                String poolName = inputLine[26].trim();
                Pool pool = location.addPool(poolName);
                thisTrack.setPool(pool);
            }
            if (inputLine.length >= 27 && (minPool = inputLine[27].trim()).length() > 0) {
                log.debug("setting track pool minimum: {}", (Object)minPool);
                try {
                    thisTrack.setMinimumLength(Integer.parseInt(minPool));
                }
                catch (NumberFormatException exception) {
                    log.debug("Exception converting the ignore minimum to a number - value was {}", (Object)minPool);
                }
            }
            if (inputLine.length >= 28 && (fieldTrackBlockingOrder = inputLine[28].trim()).length() > 0) {
                log.debug("setting the blocking order to {}", (Object)fieldTrackBlockingOrder);
                Integer blockingOrder = null;
                try {
                    blockingOrder = Integer.parseInt(fieldTrackBlockingOrder);
                    thisTrack.setBlockingOrder(blockingOrder);
                }
                catch (NumberFormatException exception) {
                    log.debug("Exception converting the track blocking order to a number - value was {}", (Object)fieldTrackBlockingOrder);
                }
            }
            if (inputLine.length >= 29 && (ignoreUsedLength = inputLine[29].trim()).length() > 0) {
                try {
                    Integer ignorePercentage = Integer.parseInt(ignoreUsedLength);
                    thisTrack.setIgnoreUsedLengthPercentage(ignorePercentage);
                }
                catch (NumberFormatException exception) {
                    log.debug("Exception converting field Ignore Used track Percentage - value was {}", (Object)ignoreUsedLength);
                }
            }
            if (inputLine.length >= 41 && (fieldComment = inputLine[41].trim()).length() > 0) {
                log.debug("setting the location comment to: {}", (Object)fieldComment);
                thisTrack.setComment(fieldComment);
            }
            if (inputLine.length >= 42) {
                String commentBoth = inputLine[42].trim();
                thisTrack.setCommentBoth(commentBoth);
            }
            if (inputLine.length >= 43) {
                String commentPickups = inputLine[43].trim();
                thisTrack.setCommentPickup(commentPickups);
            }
            if (inputLine.length < 44) continue;
            String commentSetouts = inputLine[44].trim();
            thisTrack.setCommentSetout(commentSetouts);
        }
        log.debug("Done");
        ThreadingUtil.runOnGUI(() -> {
            if (this.importOkay) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportTracksAdded", this.tracksAdded), Bundle.getMessage("SuccessfulImport"), 1);
            } else {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ImportTracksAdded", this.tracksAdded), Bundle.getMessage("ImportFailed"), 0);
            }
        });
        this.fstatus.dispose();
    }
}

