/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.RollingStockManager;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationCopyFrame
extends OperationsFrame
implements PropertyChangeListener {
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    JTextField loctionNameTextField = new JTextField(Control.max_len_string_location_name);
    JButton copyButton = new JButton(Bundle.getMessage("ButtonCopy"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JComboBox<Location> locationBox = this.locationManager.getComboBox();
    JCheckBox moveRollingStockCheckBox = new JCheckBox(Bundle.getMessage("MoveRollingStock"));
    JCheckBox deleteTrackCheckBox = new JCheckBox(Bundle.getMessage("DeleteCopiedTrack"));
    static boolean moveRollingStock = false;
    static boolean deleteTrack = false;
    Location _location;
    private static final Logger log = LoggerFactory.getLogger(LocationCopyFrame.class);

    public LocationCopyFrame(Location location) {
        super(Bundle.getMessage("MenuItemCopyLocation"));
        this._location = location;
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LocationName")));
        this.addItem(pName, this.loctionNameTextField, 0, 0);
        JPanel pCopy = new JPanel();
        pCopy.setLayout(new GridBagLayout());
        pCopy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectLocationToCopy")));
        this.addItem(pCopy, this.locationBox, 0, 0);
        JPanel pOptions = new JPanel();
        pOptions.setLayout(new GridBagLayout());
        pOptions.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Options")));
        this.addItemLeft(pOptions, this.moveRollingStockCheckBox, 0, 1);
        this.addItemLeft(pOptions, this.deleteTrackCheckBox, 0, 2);
        JPanel pButton = new JPanel();
        pButton.setLayout(new GridBagLayout());
        this.addItem(pButton, this.copyButton, 0, 0);
        this.addItem(pButton, this.saveButton, 1, 0);
        this.getContentPane().add(pName);
        this.getContentPane().add(pCopy);
        this.getContentPane().add(pOptions);
        this.getContentPane().add(pButton);
        this.moveRollingStockCheckBox.setSelected(moveRollingStock);
        this.deleteTrackCheckBox.setSelected(deleteTrack);
        this.deleteTrackCheckBox.setEnabled(this.moveRollingStockCheckBox.isSelected());
        this.locationManager.addPropertyChangeListener(this);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_CopyLocation", true);
        this.initMinimumSize(new Dimension(400, 400));
        this.addButtonAction(this.copyButton);
        this.addButtonAction(this.saveButton);
        this.addCheckBoxAction(this.moveRollingStockCheckBox);
        this.locationBox.setSelectedItem(this._location);
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    protected void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.copyButton) {
            log.debug("copy location button activated");
            if (!this.checkName()) {
                return;
            }
            if (this.locationBox.getSelectedItem() == null) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("SelectLocationToCopy"), Bundle.getMessage("CanNotLocation", Bundle.getMessage("ButtonCopy")), 0);
                return;
            }
            Location location = (Location)this.locationBox.getSelectedItem();
            if (this.moveRollingStockCheckBox.isSelected()) {
                for (Track track : location.getTracksList()) {
                    if (track.getPickupRS() > 0) {
                        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("FoundRollingStockPickUp", track.getPickupRS()), Bundle.getMessage("TrainsServicingTrack", track.getName()), 2);
                        return;
                    }
                    if (track.getDropRS() <= 0) continue;
                    JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("FoundRollingStockDrop", track.getDropRS()), Bundle.getMessage("TrainsServicingTrack", track.getName()), 2);
                    return;
                }
            }
            Location newLocation = this.locationManager.newLocation(this.loctionNameTextField.getText());
            location.copyLocation(newLocation);
            if (this.moveRollingStockCheckBox.isSelected()) {
                for (Track track : location.getTracksList()) {
                    this.moveRollingStock(track, newLocation.getTrackByName(track.getName(), null));
                    if (!this.deleteTrackCheckBox.isSelected()) continue;
                    location.deleteTrack(track);
                }
            }
        }
        if (ae.getSource() == this.saveButton) {
            log.debug("save track button activated");
            moveRollingStock = this.moveRollingStockCheckBox.isSelected();
            deleteTrack = this.deleteTrackCheckBox.isSelected();
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    @Override
    protected void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.moveRollingStockCheckBox) {
            this.deleteTrackCheckBox.setEnabled(this.moveRollingStockCheckBox.isSelected());
            this.deleteTrackCheckBox.setSelected(false);
        }
    }

    protected void updateComboBoxes() {
        log.debug("update location combobox");
        Object item = this.locationBox.getSelectedItem();
        this.locationManager.updateComboBox(this.locationBox);
        this.locationBox.setSelectedItem(item);
    }

    protected boolean checkName() {
        if (this.loctionNameTextField.getText().trim().isEmpty()) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MustEnterName"), Bundle.getMessage("CanNotLocation", Bundle.getMessage("ButtonCopy")), 0);
            return false;
        }
        if (TrainCommon.splitString(this.loctionNameTextField.getText()).length() > Control.max_len_string_location_name) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LocationNameLengthMax", Integer.toString(Control.max_len_string_location_name + 1)), Bundle.getMessage("CanNotLocation", Bundle.getMessage("ButtonCopy")), 0);
            return false;
        }
        Location check = this.locationManager.getLocationByName(this.loctionNameTextField.getText());
        if (check != null) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LocationAlreadyExists"), Bundle.getMessage("CanNotLocation", Bundle.getMessage("ButtonCopy")), 0);
            return false;
        }
        return true;
    }

    protected void moveRollingStock(Track fromTrack, Track toTrack) {
        this.moveRollingStock(fromTrack, toTrack, InstanceManager.getDefault(CarManager.class));
        this.moveRollingStock(fromTrack, toTrack, InstanceManager.getDefault(EngineManager.class));
    }

    private void moveRollingStock(Track fromTrack, Track toTrack, RollingStockManager<? extends RollingStock> manager) {
        for (RollingStock rollingStock : manager.getByIdList()) {
            if (rollingStock.getTrack() != fromTrack) continue;
            rollingStock.setLocation(toTrack.getLocation(), toTrack, true);
        }
    }

    @Override
    public void dispose() {
        this.locationManager.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("PropertyChange ({}) new: ({})", (Object)e.getPropertyName(), e.getNewValue());
        if (e.getPropertyName().equals("locationsListLength")) {
            this.updateComboBoxes();
        }
    }
}

