/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationTrackBlockingOrderTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    protected Location _location;
    protected List<Track> _tracksList = new ArrayList<Track>();
    protected JTable _table;
    protected static final int ID_COLUMN = 0;
    protected static final int NAME_COLUMN = 1;
    protected static final int TYPE_COLUMN = 2;
    protected static final int ORDER_COLUMN = 3;
    protected static final int UP_COLUMN = 4;
    protected static final int DOWN_COLUMN = 5;
    protected static final int HIGHESTCOLUMN = 6;
    private static final Logger log = LoggerFactory.getLogger(LocationTrackBlockingOrderTableModel.class);

    private void updateList() {
        if (this._location == null) {
            return;
        }
        this.removePropertyChangeTracks();
        this._tracksList = this._location.getTracksByBlockingOrderList(null);
        for (Track track : this._tracksList) {
            track.addPropertyChangeListener(this);
        }
        this.fireTableDataChanged();
    }

    protected void initTable(JTable table, Location location) {
        this._table = table;
        this._location = location;
        if (this._location != null) {
            this._location.addPropertyChangeListener(this);
        }
        this.initTable();
        table.setRowHeight(new JComboBox<E>().getPreferredSize().height);
        table.setAutoResizeMode(0);
        this.updateList();
    }

    private void initTable() {
        XTableColumnModel tcm = new XTableColumnModel();
        this._table.setColumnModel(tcm);
        this._table.createDefaultColumnsFromModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(4).setCellRenderer(buttonRenderer);
        tcm.getColumn(4).setCellEditor(buttonEditor);
        tcm.getColumn(5).setCellRenderer(buttonRenderer);
        tcm.getColumn(5).setCellEditor(buttonEditor);
        tcm.getColumn(0).setPreferredWidth(40);
        tcm.getColumn(1).setPreferredWidth(200);
        tcm.getColumn(2).setPreferredWidth(80);
        tcm.getColumn(3).setPreferredWidth(60);
        tcm.getColumn(4).setPreferredWidth(60);
        tcm.getColumn(5).setPreferredWidth(70);
    }

    @Override
    public int getRowCount() {
        return this._tracksList.size();
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("Id");
            }
            case 1: {
                return Bundle.getMessage("TrackName");
            }
            case 2: {
                return Bundle.getMessage("Type");
            }
            case 3: {
                return Bundle.getMessage("ServiceOrder");
            }
            case 4: {
                return Bundle.getMessage("Up");
            }
            case 5: {
                return Bundle.getMessage("Down");
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return JButton.class;
            }
            case 5: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        Track track = this._tracksList.get(row);
        if (track == null) {
            return "ERROR track unknown " + row;
        }
        switch (col) {
            case 0: {
                return track.getId();
            }
            case 1: {
                return track.getName();
            }
            case 2: {
                return track.getTrackTypeName();
            }
            case 3: {
                return track.getBlockingOrder();
            }
            case 4: {
                return Bundle.getMessage("Up");
            }
            case 5: {
                return Bundle.getMessage("Down");
            }
        }
        return "unknown " + col;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (row >= this.getRowCount()) {
            return;
        }
        Track track = this._tracksList.get(row);
        if (track == null) {
            return;
        }
        switch (col) {
            case 3: {
                if ((Integer)value < 0) break;
                track.setBlockingOrder((Integer)value);
                break;
            }
            case 4: {
                this._location.changeTrackBlockingOrderEarlier(track);
                break;
            }
            case 5: {
                this._location.changeTrackBlockingOrderLater(track);
                break;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("trackListLength") || e.getPropertyName().equals("locationTrackBlockingOrder")) {
            this.updateList();
        }
        if (e.getPropertyName().equals("trackBlockingOrder") || e.getPropertyName().equals("trackName") || e.getPropertyName().equals("trackType")) {
            this.fireTableDataChanged();
        }
    }

    protected void removePropertyChangeTracks() {
        for (Track track : this._tracksList) {
            track.removePropertyChangeListener(this);
        }
    }

    public void dispose() {
        this.removePropertyChangeTracks();
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        this._tracksList.clear();
        this.fireTableDataChanged();
    }
}

