/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.locations.tools.PrintLocationsByCarTypesAction;
import jmri.jmrit.operations.locations.tools.TrackLoadEditFrame;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationsByCarLoadFrame
extends OperationsFrame
implements PropertyChangeListener {
    private static final String RECEIVE = "r";
    private static final String SHIP = "s";
    private static final String HYPHEN = "-";
    LocationManager locationManager;
    ArrayList<JCheckBox> trackCheckBoxList = new ArrayList();
    JPanel locationCheckBoxes = new JPanel();
    JPanel pLocations;
    JButton clearButton = new JButton(Bundle.getMessage("ClearAll"));
    JButton setButton = new JButton(Bundle.getMessage("SelectAll"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JCheckBox loadAndTypeCheckBox = new JCheckBox(Bundle.getMessage("TypeAndLoad"));
    JComboBox<String> typeComboBox = InstanceManager.getDefault(CarTypes.class).getComboBox();
    JComboBox<String> loadComboBox = InstanceManager.getDefault(CarLoads.class).getComboBox(null);
    Location _location;
    TrackLoadEditFrame tlef;
    private static final Logger log = LoggerFactory.getLogger(LocationsByCarLoadFrame.class);

    public void initComponents(Location location) {
        this._location = location;
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.locationManager = InstanceManager.getDefault(LocationManager.class);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pCarType = new JPanel();
        pCarType.setLayout(new GridBagLayout());
        pCarType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        this.addItem(pCarType, this.typeComboBox, 0, 0);
        JPanel pLoad = new JPanel();
        pLoad.setLayout(new GridBagLayout());
        pLoad.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Load")));
        this.addItem(pLoad, this.loadComboBox, 0, 0);
        this.addItem(pLoad, this.loadAndTypeCheckBox, 1, 0);
        this.pLocations = new JPanel();
        this.pLocations.setLayout(new GridBagLayout());
        JScrollPane locationPane = new JScrollPane(this.pLocations);
        locationPane.setVerticalScrollBarPolicy(20);
        locationPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Locations")));
        this.updateLoadComboBox();
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridBagLayout());
        pButtons.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pButtons, this.clearButton, 0, 0);
        this.addItem(pButtons, this.setButton, 1, 0);
        this.addItem(pButtons, this.saveButton, 2, 0);
        this.getContentPane().add(pCarType);
        this.getContentPane().add(pLoad);
        this.getContentPane().add(locationPane);
        this.getContentPane().add(pButtons);
        this.addComboBoxAction(this.typeComboBox);
        this.addComboBoxAction(this.loadComboBox);
        this.addButtonAction(this.setButton);
        this.addButtonAction(this.clearButton);
        this.addButtonAction(this.saveButton);
        this.addCheckBoxAction(this.loadAndTypeCheckBox);
        this.locationManager.addPropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarLoads.class).addPropertyChangeListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new PrintLocationsByCarTypesAction(false));
        toolMenu.add(new PrintLocationsByCarTypesAction(true));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ModifyLocationsByCarType", true);
        this.setPreferredSize(null);
        this.pack();
        this.setMinimumSize(new Dimension(300, 250));
        this.setSize(this.getWidth() + 25, this.getHeight());
        if (this._location != null) {
            this.setTitle(Bundle.getMessage("TitleModifyLocationLoad"));
        } else {
            this.setTitle(Bundle.getMessage("TitleModifyLocationsLoad"));
        }
        this.setVisible(true);
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("combo box action");
        if (ae.getSource() == this.loadComboBox) {
            log.debug("Load combobox change, selected load: ({})", this.loadComboBox.getSelectedItem());
            if (this.loadComboBox.isEnabled() && this.loadComboBox.getSelectedItem() != null) {
                this.updateLocations();
            }
        }
        if (ae.getSource() == this.typeComboBox) {
            this.updateLoadComboBox();
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            this.save();
        }
        if (ae.getSource() == this.setButton) {
            this.selectCheckboxes(true);
        }
        if (ae.getSource() == this.clearButton) {
            this.selectCheckboxes(false);
        }
    }

    private void save() {
        log.debug("save");
        OperationsXml.save();
        if (Setup.isCloseWindowOnSaveEnabled()) {
            this.dispose();
        }
    }

    private void updateLocations() {
        log.debug("update checkboxes");
        this.removePropertyChangeLocations();
        this.trackCheckBoxList.clear();
        int x = 0;
        this.pLocations.removeAll();
        String type = (String)this.typeComboBox.getSelectedItem();
        String load = (String)this.loadComboBox.getSelectedItem();
        log.debug("Selected car type : ({}) load ({})", (Object)type, (Object)load);
        if (this._location != null && this.locationManager.getLocationByName(this._location.getName()) == null) {
            this._location = null;
        }
        List<Location> locations = this.locationManager.getLocationsByNameList();
        for (Location location : locations) {
            if (this._location != null && this._location != location) continue;
            location.addPropertyChangeListener(this);
            JLabel locationName = new JLabel(location.getName());
            this.addItemLeft(this.pLocations, locationName, 0, x++);
            List<Track> tracks = location.getTracksByNameList(null);
            for (Track track : tracks) {
                track.addPropertyChangeListener(this);
                JCheckBox cb = new JCheckBox(track.getName());
                cb.setName(track.getId() + "-r");
                this.addCheckBoxAction(cb);
                this.trackCheckBoxList.add(cb);
                cb.setEnabled(track.isTypeNameAccepted(type));
                cb.setSelected(track.isLoadNameAndCarTypeAccepted(load, type));
                this.addItemLeft(this.pLocations, cb, 1, x++);
                if (cb.isEnabled()) {
                    cb.setToolTipText(Bundle.getMessage("TipTrackCarLoad", load));
                    continue;
                }
                cb.setToolTipText(Bundle.getMessage("TipTrackNotThisType", type));
            }
            if (!location.isStaging()) continue;
            JLabel ships = new JLabel(location.getName() + " (" + Bundle.getMessage("Ships") + ")");
            this.addItemLeft(this.pLocations, ships, 0, x++);
            for (Track track : tracks) {
                JCheckBox cb = new JCheckBox(track.getName());
                cb.setName(track.getId() + "-s");
                this.addCheckBoxAction(cb);
                this.trackCheckBoxList.add(cb);
                cb.setEnabled(track.isTypeNameAccepted(type));
                cb.setSelected(track.isLoadNameAndCarTypeShipped(load, type));
                this.addItemLeft(this.pLocations, cb, 1, x++);
                if (cb.isEnabled()) {
                    cb.setToolTipText(Bundle.getMessage("TipTrackCarShipsLoad", load));
                    continue;
                }
                cb.setToolTipText(Bundle.getMessage("TipTrackNotThisType", type));
            }
        }
        this.pLocations.revalidate();
        this.repaint();
    }

    private void updateTypeComboBox() {
        log.debug("update type combobox");
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.typeComboBox);
    }

    private void updateLoadComboBox() {
        log.debug("update load combobox");
        if (this.typeComboBox.getSelectedItem() != null) {
            String type = (String)this.typeComboBox.getSelectedItem();
            String load = (String)this.loadComboBox.getSelectedItem();
            log.debug("Selected car type : ({}) load ({})", (Object)type, (Object)load);
            InstanceManager.getDefault(CarLoads.class).updateComboBox(type, this.loadComboBox);
            this.loadComboBox.setEnabled(false);
            if (load != null) {
                this.loadComboBox.setSelectedItem(load);
            }
            this.loadComboBox.setEnabled(true);
            this.updateLocations();
        }
    }

    private void updateLoadStatusCheckBox(Track track) {
        String type = (String)this.typeComboBox.getSelectedItem();
        String load = (String)this.loadComboBox.getSelectedItem();
        log.debug("Update load status for track ({}, {})", (Object)track.getLocation().getName(), (Object)track.getName());
        for (JCheckBox cb : this.trackCheckBoxList) {
            if (!cb.getName().split(HYPHEN)[0].equals(track.getId())) continue;
            if (cb.getName().split(HYPHEN)[1].equals(RECEIVE)) {
                cb.setSelected(track.isLoadNameAndCarTypeAccepted(load, type));
                continue;
            }
            cb.setSelected(track.isLoadNameAndCarTypeShipped(load, type));
        }
    }

    private void selectCheckboxes(boolean select) {
        for (JCheckBox cb : this.trackCheckBoxList) {
            if (!cb.isEnabled()) continue;
            cb.setSelected(select);
            this.checkBoxUpdate(cb);
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.loadAndTypeCheckBox) {
            this.updateLocations();
            return;
        }
        JCheckBox cb = (JCheckBox)ae.getSource();
        this.checkBoxUpdate(cb);
    }

    private void checkBoxUpdate(JCheckBox cb) {
        String[] locId = cb.getName().split(HYPHEN);
        Location loc = this.locationManager.getLocationById(locId[0].split(SHIP)[0]);
        if (loc != null) {
            Track track = loc.getTrackById(locId[0]);
            log.debug("CheckBox : {} track: ({}) isEnabled: {} isSelected: {}", new Object[]{cb.getName(), track.getName(), cb.isEnabled(), cb.isSelected()});
            if (cb.isEnabled()) {
                boolean needLoadTrackEditFrame = false;
                Object loadName = (String)this.loadComboBox.getSelectedItem();
                String load = loadName;
                String type = (String)this.typeComboBox.getSelectedItem();
                log.debug("Selected load ({})", loadName);
                if (this.loadAndTypeCheckBox.isSelected()) {
                    loadName = type + " & " + (String)loadName;
                }
                if (locId[1].equals(RECEIVE)) {
                    if (cb.isSelected()) {
                        if (track.getLoadOption().equals(Track.ALL_LOADS)) {
                            log.debug("All loads selected for track ({})", (Object)track.getName());
                        } else if (track.getLoadOption().equals(Track.INCLUDE_LOADS)) {
                            track.addLoadName((String)loadName);
                        } else if (track.getLoadOption().equals(Track.EXCLUDE_LOADS)) {
                            track.deleteLoadName((String)loadName);
                            if (track.getLoadNames().length == 0) {
                                track.setLoadOption(Track.ALL_LOADS);
                            }
                            if (!track.isLoadNameAccepted(load)) {
                                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("WarningExcludeTrackLoad", track.getLocation().getName(), track.getName(), load), Bundle.getMessage("WarningTitle"), 2);
                                needLoadTrackEditFrame = true;
                            } else if (!track.isLoadNameAndCarTypeAccepted(load, type)) {
                                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("WarningExcludeTrackTypeAndLoad", track.getLocation().getName(), track.getName(), type, load, "\n" + type + " & " + load), Bundle.getMessage("WarningTitle"), 2);
                                needLoadTrackEditFrame = true;
                            }
                        }
                    } else if (track.getLoadOption().equals(Track.INCLUDE_LOADS)) {
                        track.deleteLoadName((String)loadName);
                        if (track.isLoadNameAccepted(load)) {
                            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("WarningAcceptTrackLoad", track.getLocation().getName(), track.getName(), load), Bundle.getMessage("WarningTitle"), 2);
                            needLoadTrackEditFrame = true;
                        } else if (track.isLoadNameAndCarTypeAccepted(load, type)) {
                            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("WarningAcceptTrackTypeAndLoad", track.getLocation().getName(), track.getName(), type, load, "\n" + type + " & " + load), Bundle.getMessage("WarningTitle"), 2);
                            needLoadTrackEditFrame = true;
                        }
                    } else if (track.getLoadOption().equals(Track.EXCLUDE_LOADS)) {
                        track.addLoadName((String)loadName);
                    } else if (track.getLoadOption().equals(Track.ALL_LOADS)) {
                        track.setLoadOption(Track.EXCLUDE_LOADS);
                        track.addLoadName((String)loadName);
                    }
                }
                if (locId[1].equals(SHIP)) {
                    if (cb.isSelected()) {
                        if (track.getShipLoadOption().equals(Track.ALL_LOADS)) {
                            log.debug("Ship all loads selected for track ({})", (Object)track.getName());
                        } else if (track.getShipLoadOption().equals(Track.INCLUDE_LOADS)) {
                            track.addShipLoadName((String)loadName);
                        } else if (track.getShipLoadOption().equals(Track.EXCLUDE_LOADS)) {
                            track.deleteShipLoadName((String)loadName);
                            if (track.getShipLoadNames().length == 0) {
                                track.setShipLoadOption(Track.ALL_LOADS);
                            }
                            if (!track.isLoadNameShipped(load)) {
                                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("WarningExcludeTrackShipLoad", track.getLocation().getName(), track.getName(), load), Bundle.getMessage("WarningTitle"), 2);
                                needLoadTrackEditFrame = true;
                            } else if (!track.isLoadNameAndCarTypeShipped(load, type)) {
                                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("WarningExcludeTrackShipTypeAndLoad", track.getLocation().getName(), track.getName(), type, load, "\n" + type + " & " + load), Bundle.getMessage("WarningTitle"), 2);
                                needLoadTrackEditFrame = true;
                            }
                        }
                    } else if (track.getShipLoadOption().equals(Track.INCLUDE_LOADS)) {
                        track.deleteShipLoadName((String)loadName);
                        if (track.isLoadNameShipped(load)) {
                            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("WarningShipTrackLoad", track.getLocation().getName(), track.getName(), load), Bundle.getMessage("WarningTitle"), 2);
                            needLoadTrackEditFrame = true;
                        } else if (track.isLoadNameAndCarTypeShipped(load, type)) {
                            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("WarningShipTrackTypeAndLoad", track.getLocation().getName(), track.getName(), type, load, "\n" + type + " & " + load), Bundle.getMessage("WarningTitle"), 2);
                            needLoadTrackEditFrame = true;
                        }
                    } else if (track.getShipLoadOption().equals(Track.EXCLUDE_LOADS)) {
                        track.addShipLoadName((String)loadName);
                    } else if (track.getShipLoadOption().equals(Track.ALL_LOADS)) {
                        track.setShipLoadOption(Track.EXCLUDE_LOADS);
                        track.addShipLoadName((String)loadName);
                    }
                }
                if (needLoadTrackEditFrame) {
                    if (this.tlef != null) {
                        this.tlef.dispose();
                    }
                    this.tlef = new TrackLoadEditFrame();
                    this.tlef.initComponents(track.getLocation(), track);
                }
            }
        }
    }

    private void removePropertyChangeLocations() {
        for (Location location : this.locationManager.getList()) {
            location.removePropertyChangeListener(this);
            List<Track> tracks = location.getTracksList();
            for (Track track : tracks) {
                track.removePropertyChangeListener(this);
            }
        }
    }

    @Override
    public void dispose() {
        this.locationManager.removePropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarLoads.class).removePropertyChangeListener(this);
        this.removePropertyChangeLocations();
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change: ({}) old: ({}) new: ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        if (e.getPropertyName().equals("locationsListLength") || e.getPropertyName().equals("locationTypes") || e.getPropertyName().equals("locationName") || e.getPropertyName().equals("trackListLength") || e.getPropertyName().equals("trackRollingStockTypes") || e.getPropertyName().equals("trackName")) {
            this.updateLocations();
        }
        if (e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("CarTypes Name")) {
            this.updateTypeComboBox();
        }
        if (e.getPropertyName().equals("CarLoads_Load")) {
            this.updateLoadComboBox();
        }
        if (e.getPropertyName().equals("trackLoads") && e.getSource().getClass().equals(Track.class)) {
            Track track = (Track)e.getSource();
            this.updateLoadStatusCheckBox(track);
        }
    }
}

