/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.locations.tools.PrintLocationsByCarTypesAction;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationsByCarTypeFrame
extends OperationsFrame
implements PropertyChangeListener {
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    ArrayList<JCheckBox> locationCheckBoxList = new ArrayList();
    ArrayList<JCheckBox> trackCheckBoxList = new ArrayList();
    JPanel locationCheckBoxes = new JPanel();
    JPanel pLocations;
    JButton clearButton = new JButton(Bundle.getMessage("ClearAll"));
    JButton setButton = new JButton(Bundle.getMessage("SelectAll"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JCheckBox copyCheckBox = new JCheckBox(Bundle.getMessage("ButtonCopy"));
    JComboBox<String> typeComboBox = InstanceManager.getDefault(CarTypes.class).getComboBox();
    JComboBox<String> copyComboBox = InstanceManager.getDefault(CarTypes.class).getComboBox();
    Location _location;
    private static final Logger log = LoggerFactory.getLogger(LocationsByCarTypeFrame.class);

    @Override
    public void initComponents() {
        this.initComponents("");
    }

    public void initComponents(Location location) {
        this._location = location;
        this.initComponents("");
    }

    public void initComponents(Location location, String carType) {
        this._location = location;
        this.initComponents(carType);
    }

    public void initComponents(String carType) {
        this.locationManager = InstanceManager.getDefault(LocationManager.class);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pCarType = new JPanel();
        pCarType.setLayout(new GridBagLayout());
        pCarType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        JPanel pCarCopy = new JPanel();
        pCarCopy.setLayout(new GridBagLayout());
        this.addItem(pCarCopy, this.copyComboBox, 0, 0);
        pCarCopy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CopyType")));
        this.addItem(pCarType, this.typeComboBox, 0, 0);
        this.addItem(pCarType, this.copyCheckBox, 1, 0);
        this.addItem(pCarType, pCarCopy, 2, 0);
        this.typeComboBox.setSelectedItem(carType);
        this.copyCheckBox.setToolTipText(Bundle.getMessage("TipCopyCarType"));
        this.pLocations = new JPanel();
        this.pLocations.setLayout(new GridBagLayout());
        JScrollPane locationPane = new JScrollPane(this.pLocations);
        locationPane.setVerticalScrollBarPolicy(20);
        locationPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Locations")));
        this.updateLocations();
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridBagLayout());
        pButtons.setBorder(BorderFactory.createTitledBorder(""));
        this.addItem(pButtons, this.clearButton, 0, 0);
        this.addItem(pButtons, this.setButton, 1, 0);
        this.addItem(pButtons, this.saveButton, 2, 0);
        this.getContentPane().add(pCarType);
        this.getContentPane().add(locationPane);
        this.getContentPane().add(pButtons);
        this.addComboBoxAction(this.typeComboBox);
        this.addComboBoxAction(this.copyComboBox);
        this.addButtonAction(this.setButton);
        this.addButtonAction(this.clearButton);
        this.addButtonAction(this.saveButton);
        this.addCheckBoxAction(this.copyCheckBox);
        this.locationManager.addPropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new PrintLocationsByCarTypesAction(false));
        toolMenu.add(new PrintLocationsByCarTypesAction(true));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ModifyLocationsByCarType", true);
        if (this._location != null) {
            this.setTitle(Bundle.getMessage("TitleModifyLocation"));
        } else {
            this.setTitle(Bundle.getMessage("TitleModifyLocations"));
        }
        this.setPreferredSize(null);
        this.initMinimumSize(new Dimension(300, 250));
        this.setSize(this.getWidth() + 25, this.getHeight());
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("combo box action");
        this.updateLocations();
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            this.save();
        }
        if (ae.getSource() == this.setButton) {
            this.selectCheckboxes(true);
        }
        if (ae.getSource() == this.clearButton) {
            this.selectCheckboxes(false);
        }
    }

    private void save() {
        if (this.copyCheckBox.isSelected() && JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("CopyCarType", this.typeComboBox.getSelectedItem(), this.copyComboBox.getSelectedItem()), Bundle.getMessage("CopyCarTypeTitle"), 0) != 0) {
            return;
        }
        log.debug("save {} locations", (Object)this.locationCheckBoxList.size());
        this.removePropertyChangeLocations();
        for (JCheckBox cb : new ArrayList<JCheckBox>(this.locationCheckBoxList)) {
            Location loc = this.locationManager.getLocationById(cb.getName());
            if (cb.isSelected()) {
                loc.addTypeName((String)this.typeComboBox.getSelectedItem());
                for (JCheckBox cbt : new ArrayList<JCheckBox>(this.trackCheckBoxList)) {
                    String[] id = cbt.getName().split("s");
                    if (!loc.getId().equals(id[0])) continue;
                    Track track = loc.getTrackById(cbt.getName());
                    if (cbt.isSelected()) {
                        track.addTypeName((String)this.typeComboBox.getSelectedItem());
                        continue;
                    }
                    track.deleteTypeName((String)this.typeComboBox.getSelectedItem());
                }
                continue;
            }
            loc.deleteTypeName((String)this.typeComboBox.getSelectedItem());
        }
        OperationsXml.save();
        this.updateLocations();
        if (Setup.isCloseWindowOnSaveEnabled()) {
            this.dispose();
        }
    }

    private void updateLocations() {
        log.debug("update checkboxes");
        this.removePropertyChangeLocations();
        this.locationCheckBoxList.clear();
        this.trackCheckBoxList.clear();
        int x = 0;
        this.pLocations.removeAll();
        String carType = (String)this.typeComboBox.getSelectedItem();
        if (this.copyCheckBox.isSelected()) {
            carType = (String)this.copyComboBox.getSelectedItem();
        }
        if (this._location != null && this.locationManager.getLocationByName(this._location.getName()) == null) {
            this._location = null;
        }
        List<Location> locations = this.locationManager.getLocationsByNameList();
        for (Location loc : locations) {
            if (this._location != null && this._location != loc) continue;
            loc.addPropertyChangeListener(this);
            JCheckBox cb = new JCheckBox(loc.getName());
            cb.setName(loc.getId());
            cb.setToolTipText(Bundle.getMessage("TipLocCarType", carType));
            this.addCheckBoxAction(cb);
            this.locationCheckBoxList.add(cb);
            boolean locAcceptsType = loc.acceptsTypeName(carType);
            cb.setSelected(locAcceptsType);
            this.addItemLeft(this.pLocations, cb, 0, x++);
            List<Track> tracks = loc.getTracksByNameList(null);
            for (Track track : tracks) {
                track.addPropertyChangeListener(this);
                cb = new JCheckBox(track.getName());
                cb.setName(track.getId());
                cb.setToolTipText(Bundle.getMessage("TipTrackCarType", carType));
                this.addCheckBoxAction(cb);
                this.trackCheckBoxList.add(cb);
                cb.setSelected(track.isTypeNameAccepted(carType));
                this.addItemLeft(this.pLocations, cb, 1, x++);
            }
        }
        this.pLocations.revalidate();
        this.repaint();
    }

    private void updateComboBox() {
        log.debug("update combobox");
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.typeComboBox);
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.copyComboBox);
    }

    private void selectCheckboxes(boolean select) {
        for (JCheckBox cb : new ArrayList<JCheckBox>(this.locationCheckBoxList)) {
            cb.setSelected(select);
        }
        for (JCheckBox cb : new ArrayList<JCheckBox>(this.trackCheckBoxList)) {
            cb.setSelected(select);
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.copyCheckBox) {
            this.updateLocations();
        } else {
            JCheckBox cb = (JCheckBox)ae.getSource();
            log.debug("Checkbox {} text: {}", (Object)cb.getName(), (Object)cb.getText());
            if (this.locationCheckBoxList.contains(cb)) {
                log.debug("Checkbox location {}", (Object)cb.getText());
                if (!cb.isSelected()) {
                    String locId = cb.getName();
                    for (JCheckBox tcb : new ArrayList<JCheckBox>(this.trackCheckBoxList)) {
                        String[] id = tcb.getName().split("s");
                        if (!locId.equals(id[0])) continue;
                        tcb.setSelected(false);
                    }
                }
            } else if (this.trackCheckBoxList.contains(cb)) {
                log.debug("Checkbox track {}", (Object)cb.getText());
                if (cb.isSelected()) {
                    String[] loc = cb.getName().split("s");
                    for (JCheckBox lcb : new ArrayList<JCheckBox>(this.locationCheckBoxList)) {
                        if (!lcb.getName().equals(loc[0])) continue;
                        lcb.setSelected(true);
                        break;
                    }
                }
            } else {
                log.error("Error checkbox not found");
            }
        }
    }

    private void removePropertyChangeLocations() {
        for (JCheckBox cb : new ArrayList<JCheckBox>(this.locationCheckBoxList)) {
            Location loc = this.locationManager.getLocationById(cb.getName());
            if (loc == null) continue;
            loc.removePropertyChangeListener(this);
            List<Track> tracks = loc.getTracksList();
            for (Track track : tracks) {
                track.removePropertyChangeListener(this);
            }
        }
    }

    @Override
    public void dispose() {
        this.locationManager.removePropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        this.removePropertyChangeLocations();
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change: ({}) old: ({}) new: ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        if (e.getPropertyName().equals("locationsListLength") || e.getPropertyName().equals("locationTypes") || e.getPropertyName().equals("locationName") || e.getPropertyName().equals("trackListLength") || e.getPropertyName().equals("trackRollingStockTypes") || e.getPropertyName().equals("trackName")) {
            this.updateLocations();
        }
        if (e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("CarTypes Name")) {
            this.updateComboBox();
        }
    }
}

