/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintLocationsFrame
extends OperationsFrame {
    static final String FORM_FEED = "\f";
    static final String TAB = "\t";
    static final int TAB_LENGTH = 10;
    static final String SPACES_2 = "  ";
    static final String SPACES_3 = "   ";
    static final String SPACES_4 = "    ";
    static final int MAX_NAME_LENGTH = Control.max_len_string_location_name;
    JCheckBox printLocations = new JCheckBox(Bundle.getMessage("PrintLocations"));
    JCheckBox printSchedules = new JCheckBox(Bundle.getMessage("PrintSchedules"));
    JCheckBox printComments = new JCheckBox(Bundle.getMessage("PrintComments"));
    JCheckBox printDetails = new JCheckBox(Bundle.getMessage("PrintDetails"));
    JCheckBox printAnalysis = new JCheckBox(Bundle.getMessage("PrintAnalysis"));
    JCheckBox printErrorAnalysis = new JCheckBox(Bundle.getMessage("PrintErrorAnalysis"));
    JButton okayButton = new JButton(Bundle.getMessage("ButtonOK"));
    LocationManager lmanager = InstanceManager.getDefault(LocationManager.class);
    CarTypes cts = InstanceManager.getDefault(CarTypes.class);
    CarLoads cls = InstanceManager.getDefault(CarLoads.class);
    CarRoads crs = InstanceManager.getDefault(CarRoads.class);
    boolean _isPreview;
    Location _location;
    private int charactersPerLine = 70;
    HardcopyWriter writer;
    private final boolean showStaging = true;
    private static final Logger log = LoggerFactory.getLogger(PrintLocationsFrame.class);

    public PrintLocationsFrame(boolean isPreview, Location location) {
        this._isPreview = isPreview;
        this._location = location;
        JPanel pPanel = new JPanel();
        pPanel.setLayout(new GridBagLayout());
        pPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PrintOptions")));
        this.addItemLeft(pPanel, this.printLocations, 0, 0);
        this.addItemLeft(pPanel, this.printSchedules, 0, 3);
        this.addItemLeft(pPanel, this.printComments, 0, 5);
        this.addItemLeft(pPanel, this.printDetails, 0, 7);
        this.addItemLeft(pPanel, this.printAnalysis, 0, 9);
        this.addItemLeft(pPanel, this.printErrorAnalysis, 0, 11);
        this.printLocations.setSelected(true);
        this.printSchedules.setSelected(false);
        this.printComments.setSelected(false);
        this.printDetails.setSelected(false);
        this.printAnalysis.setSelected(false);
        this.printErrorAnalysis.setSelected(false);
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridBagLayout());
        pButtons.add(this.okayButton);
        this.addButtonAction(this.okayButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(pPanel);
        this.getContentPane().add(pButtons);
        this.setPreferredSize(null);
        if (this._isPreview) {
            this.setTitle(Bundle.getMessage("MenuItemPreview"));
        } else {
            this.setTitle(Bundle.getMessage("MenuItemPrint"));
        }
        this.initMinimumSize(new Dimension(300, 250));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        this.setVisible(false);
        this.printLocations();
    }

    private void printLocations() {
        if (!(this.printLocations.isSelected() || this.printSchedules.isSelected() || this.printComments.isSelected() || this.printDetails.isSelected() || this.printAnalysis.isSelected() || this.printErrorAnalysis.isSelected())) {
            return;
        }
        String title = Bundle.getMessage("TitleLocationsTable");
        if (this._location != null) {
            title = this._location.getName();
        }
        try (HardcopyWriter writer = new HardcopyWriter(new Frame(), title, Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview);){
            this.writer = writer;
            this.charactersPerLine = writer.getCharactersPerLine();
            if (this.printLocations.isSelected()) {
                this.printLocationsSelected();
            }
            if (this.printSchedules.isSelected()) {
                this.printSchedulesSelected();
            }
            if (this.printComments.isSelected()) {
                this.printCommentsSelected();
            }
            if (this.printDetails.isSelected()) {
                this.printDetailsSelected();
            }
            if (this.printAnalysis.isSelected()) {
                this.printAnalysisSelected();
            }
            if (this.printErrorAnalysis.isSelected()) {
                this.printErrorAnalysisSelected();
            }
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print canceled");
        }
        catch (IOException we) {
            log.error("Error printing PrintLocationAction: {}", (Object)we.getLocalizedMessage());
        }
    }

    private void printLocationsSelected() throws IOException {
        List<Location> locations = this.lmanager.getLocationsByNameList();
        int totalLength = 0;
        int usedLength = 0;
        int numberRS = 0;
        int numberCars = 0;
        int numberEngines = 0;
        String s = Bundle.getMessage("Location") + "\t\t\t" + Bundle.getMessage("Length") + " " + Bundle.getMessage("Used") + TAB + Bundle.getMessage("RS") + TAB + Bundle.getMessage("Cars") + TAB + Bundle.getMessage("Engines") + TAB + Bundle.getMessage("Pickups") + " " + Bundle.getMessage("Drop") + "\n";
        this.writer.write(s);
        for (Location location : locations) {
            List<Track> stagingTracks;
            List<Track> list;
            List<Track> spurs;
            if (this._location != null && location != this._location) continue;
            s = this.padOutString(location.getName(), MAX_NAME_LENGTH) + "\t  " + Integer.toString(location.getLength()) + TAB + Integer.toString(location.getUsedLength()) + TAB + Integer.toString(location.getNumberRS()) + TAB + Integer.toString(location.getNumberCars()) + TAB + Integer.toString(location.getNumberEngines()) + TAB + Integer.toString(location.getPickupRS()) + TAB + Integer.toString(location.getDropRS()) + "\n";
            this.writer.write(s);
            if (location.getDivision() != null) {
                this.writer.write(SPACES_3 + Bundle.getMessage("Division") + ": " + location.getDivisionName() + "\n");
            }
            totalLength += location.getLength();
            usedLength += location.getUsedLength();
            numberRS += location.getNumberRS();
            List<Track> yards = location.getTracksByNameList("Yard");
            if (yards.size() > 0) {
                this.writer.write(SPACES_3 + Bundle.getMessage("YardName") + "\n");
                for (Track track : yards) {
                    this.writer.write(this.getTrackString(track));
                    numberCars += track.getNumberCars();
                    numberEngines += track.getNumberEngines();
                }
            }
            if ((spurs = location.getTracksByNameList("Spur")).size() > 0) {
                this.writer.write(SPACES_3 + Bundle.getMessage("SpurName") + "\n");
                for (Object spur : spurs) {
                    this.writer.write(this.getTrackString((Track)spur));
                    numberCars += ((Track)spur).getNumberCars();
                    numberEngines += ((Track)spur).getNumberEngines();
                }
            }
            if ((list = location.getTracksByNameList("Interchange")).size() > 0) {
                Object spur;
                this.writer.write(SPACES_3 + Bundle.getMessage("InterchangeName") + "\n");
                spur = list.iterator();
                while (spur.hasNext()) {
                    Track interchange = (Track)spur.next();
                    this.writer.write(this.getTrackString(interchange));
                    numberCars += interchange.getNumberCars();
                    numberEngines += interchange.getNumberEngines();
                }
            }
            if ((stagingTracks = location.getTracksByNameList("Staging")).size() > 0) {
                this.writer.write(SPACES_3 + Bundle.getMessage("StagingName") + "\n");
                for (Track staging : stagingTracks) {
                    this.writer.write(this.getTrackString(staging));
                    numberCars += staging.getNumberCars();
                    numberEngines += staging.getNumberEngines();
                }
            }
            this.writer.write("\n");
        }
        s = MessageFormat.format(Bundle.getMessage("TotalLengthMsg"), Integer.toString(totalLength), Integer.toString(usedLength), totalLength > 0 ? Integer.toString(usedLength * 100 / totalLength) : Integer.valueOf(0)) + "\n";
        this.writer.write(s);
        s = MessageFormat.format(Bundle.getMessage("TotalRollingMsg"), Integer.toString(numberRS), Integer.toString(numberCars), Integer.toString(numberEngines)) + "\n";
        this.writer.write(s);
        if (numberRS != numberCars + numberEngines) {
            s = Bundle.getMessage("NoteRSMsg", Integer.toString(numberRS - (numberCars + numberEngines))) + "\n";
            this.writer.write(s);
        }
        if (this.printSchedules.isSelected() || this.printComments.isSelected() || this.printDetails.isSelected() || this.printAnalysis.isSelected() || this.printErrorAnalysis.isSelected()) {
            this.writer.write(FORM_FEED);
        }
    }

    private void printSchedulesSelected() throws IOException {
        List<Location> locations = this.lmanager.getLocationsByNameList();
        Object s = this.padOutString(Bundle.getMessage("Schedules"), MAX_NAME_LENGTH) + " " + Bundle.getMessage("Location") + " - " + Bundle.getMessage("SpurName") + "\n";
        this.writer.write((String)s);
        List<Schedule> schedules = InstanceManager.getDefault(ScheduleManager.class).getSchedulesByNameList();
        for (Schedule schedule : schedules) {
            for (Location location : locations) {
                if (this._location != null && location != this._location) continue;
                List<Track> spurs = location.getTracksByNameList("Spur");
                for (Track spur : spurs) {
                    if (!spur.getScheduleId().equals(schedule.getId())) continue;
                    s = this.padOutString(schedule.getName(), MAX_NAME_LENGTH) + " " + location.getName() + " - " + spur.getName();
                    String status = spur.checkScheduleValid();
                    if (!status.equals("")) {
                        StringBuffer buf = new StringBuffer((String)s);
                        for (int m = ((String)s).length(); m < 63; ++m) {
                            buf.append(" ");
                        }
                        s = buf.toString();
                        if (((String)s).length() > 63) {
                            s = ((String)s).substring(0, 63);
                        }
                        s = (String)s + TAB + status;
                    }
                    s = (String)s + "\n";
                    this.writer.write((String)s);
                    s = this.padOutString("", MAX_NAME_LENGTH) + SPACES_3 + Bundle.getMessage("ScheduleMode") + ": " + spur.getScheduleModeName() + "\n";
                    this.writer.write((String)s);
                    if (spur.getAlternateTrack() != null) {
                        s = this.padOutString("", MAX_NAME_LENGTH) + SPACES_3 + Bundle.getMessage("AlternateTrackName", spur.getAlternateTrack().getName()) + "\n";
                        this.writer.write((String)s);
                    }
                    if (spur.getReservationFactor() == 100) continue;
                    s = this.padOutString("", MAX_NAME_LENGTH) + SPACES_3 + Bundle.getMessage("PercentageStaging", spur.getReservationFactor()) + "\n";
                    this.writer.write((String)s);
                }
            }
        }
        for (Schedule schedule : schedules) {
            this.writer.write(FORM_FEED);
            s = schedule.getName() + "\n";
            this.writer.write((String)s);
            for (ScheduleItem si : schedule.getItemsBySequenceList()) {
                s = this.padOutString(Bundle.getMessage("Type"), this.cts.getMaxNameLength() + 1) + this.padOutString(Bundle.getMessage("Receive"), this.cls.getMaxNameLength() + 1) + this.padOutString(Bundle.getMessage("Ship"), this.cls.getMaxNameLength() + 1) + this.padOutString(Bundle.getMessage("Destination"), this.lmanager.getMaxLocationNameLength() + 1) + Bundle.getMessage("Track") + "\n";
                this.writer.write((String)s);
                s = this.padOutString(si.getTypeName(), this.cts.getMaxNameLength() + 1) + this.padOutString(si.getReceiveLoadName(), this.cls.getMaxNameLength() + 1) + this.padOutString(si.getShipLoadName(), this.cls.getMaxNameLength() + 1) + this.padOutString(si.getDestinationName(), this.lmanager.getMaxLocationNameLength() + 1) + si.getDestinationTrackName() + "\n";
                this.writer.write((String)s);
                s = this.padOutString("", this.cts.getMaxNameLength() + 1) + this.padOutString(Bundle.getMessage("Random"), Bundle.getMessage("Random").length() + 1) + this.padOutString(Bundle.getMessage("Delivery"), Bundle.getMessage("Delivery").length() + 1) + this.padOutString(Bundle.getMessage("Road"), this.crs.getMaxNameLength() + 1) + this.padOutString(Bundle.getMessage("Pickup"), Bundle.getMessage("Delivery").length() + 1) + Bundle.getMessage("Wait") + "\n";
                this.writer.write((String)s);
                s = this.padOutString("", this.cts.getMaxNameLength() + 1) + this.padOutString(si.getRandom(), Bundle.getMessage("Random").length() + 1) + this.padOutString(si.getSetoutTrainScheduleName(), Bundle.getMessage("Delivery").length() + 1) + this.padOutString(si.getRoadName(), this.crs.getMaxNameLength() + 1) + this.padOutString(si.getPickupTrainScheduleName(), Bundle.getMessage("Delivery").length() + 1) + si.getWait() + "\n";
                this.writer.write((String)s);
            }
        }
        if (this.printComments.isSelected() || this.printDetails.isSelected() || this.printAnalysis.isSelected() || this.printErrorAnalysis.isSelected()) {
            this.writer.write(FORM_FEED);
        }
    }

    private void printCommentsSelected() throws IOException {
        String s = Bundle.getMessage("PrintComments") + "\n\n";
        this.writer.write(s);
        List<Location> locations = this.lmanager.getLocationsByNameList();
        for (Location location : locations) {
            if (this._location != null && location != this._location) continue;
            s = location.getName() + "\n";
            this.writer.write(s);
            s = SPACES_3 + location.getComment() + "\n";
            this.writer.write(s);
            for (Track track : location.getTracksByNameList(null)) {
                if (track.getComment().equals("") && track.getCommentBoth().equals("") && track.getCommentPickup().equals("") && track.getCommentSetout().equals("")) continue;
                s = SPACES_2 + track.getName() + "\n";
                this.writer.write(s);
                if (!track.getComment().equals("")) {
                    s = SPACES_4 + track.getComment() + "\n";
                    this.writer.write(s);
                }
                if (!track.getCommentBoth().equals("")) {
                    s = SPACES_3 + Bundle.getMessage("CommentBoth") + ":\n";
                    this.writer.write(s);
                    s = SPACES_4 + track.getCommentBoth() + "\n";
                    this.writer.write(s);
                }
                if (!track.getCommentPickup().equals("")) {
                    s = SPACES_3 + Bundle.getMessage("CommentPickup") + ":\n";
                    this.writer.write(s);
                    s = SPACES_4 + track.getCommentPickup() + "\n";
                    this.writer.write(s);
                }
                if (track.getCommentSetout().equals("")) continue;
                s = SPACES_3 + Bundle.getMessage("CommentSetout") + ":\n";
                this.writer.write(s);
                s = SPACES_4 + track.getCommentSetout() + "\n";
                this.writer.write(s);
            }
        }
        if (this.printDetails.isSelected() || this.printAnalysis.isSelected() || this.printErrorAnalysis.isSelected()) {
            this.writer.write(FORM_FEED);
        }
    }

    private void printDetailsSelected() throws IOException {
        List<Location> locations = this.lmanager.getLocationsByNameList();
        Object s = Bundle.getMessage("DetailedReport") + "\n";
        this.writer.write((String)s);
        for (Location location : locations) {
            List<Track> staging;
            List<Track> interchanges;
            List<Track> yards;
            if (this._location != null && location != this._location) continue;
            String name = location.getName();
            int dir = location.getTrainDirections();
            s = "\n" + name + this.getDirection(dir);
            this.writer.write((String)s);
            if (location.getDivision() != null) {
                s = SPACES_3 + Bundle.getMessage("Division") + ": " + location.getDivisionName() + "\n";
                this.writer.write((String)s);
            }
            s = this.getLocationTypes(location);
            this.writer.write((String)s);
            List<Track> spurs = location.getTracksByNameList("Spur");
            if (spurs.size() > 0) {
                s = SPACES_3 + Bundle.getMessage("SpurName") + "\n";
                this.writer.write((String)s);
                this.printTrackInfo(location, spurs);
            }
            if ((yards = location.getTracksByNameList("Yard")).size() > 0) {
                s = SPACES_3 + Bundle.getMessage("YardName") + "\n";
                this.writer.write((String)s);
                this.printTrackInfo(location, yards);
            }
            if ((interchanges = location.getTracksByNameList("Interchange")).size() > 0) {
                s = SPACES_3 + Bundle.getMessage("InterchangeName") + "\n";
                this.writer.write((String)s);
                this.printTrackInfo(location, interchanges);
            }
            if ((staging = location.getTracksByNameList("Staging")).size() <= 0) continue;
            s = SPACES_3 + Bundle.getMessage("StagingName") + "\n";
            this.writer.write((String)s);
            this.printTrackInfo(location, staging);
        }
        if (this.printAnalysis.isSelected() || this.printErrorAnalysis.isSelected()) {
            this.writer.write(FORM_FEED);
        }
    }

    private void printAnalysisSelected() throws IOException {
        CarManager carManager = InstanceManager.getDefault(CarManager.class);
        List<Location> locations = this.lmanager.getLocationsByNameList();
        List<Car> cars = carManager.getByLocationList();
        String[] carTypes = this.cts.getNames();
        String s = Bundle.getMessage("TrackAnalysis") + "\n";
        this.writer.write(s);
        for (String type : carTypes) {
            int numberOfCars = 0;
            int totalTrackLength = 0;
            for (Car car : cars) {
                if (!car.getTypeName().equals(type) || car.getLocation() == null) continue;
                ++numberOfCars;
                totalTrackLength += car.getTotalLength();
            }
            this.writer.write(Bundle.getMessage("NumberTypeLength", numberOfCars, type, totalTrackLength, Setup.getLengthUnit().toLowerCase()) + "\n");
            if (numberOfCars <= 0) continue;
            this.writer.write(SPACES_3 + Bundle.getMessage("SpurTrackThatAccept", type) + "\n");
            int trackLength = this.getTrackLengthAcceptType(locations, type, "Spur");
            if (trackLength > 0) {
                this.writer.write(SPACES_3 + Bundle.getMessage("TotalLengthSpur", type, trackLength, Setup.getLengthUnit().toLowerCase(), Math.ceil(100.0 * (double)totalTrackLength / (double)trackLength)) + "\n");
            } else {
                this.writer.write(SPACES_3 + Bundle.getMessage("None") + "\n");
            }
            this.writer.write(SPACES_3 + Bundle.getMessage("YardTrackThatAccept", type) + "\n");
            trackLength = this.getTrackLengthAcceptType(locations, type, "Yard");
            if (trackLength > 0) {
                this.writer.write(SPACES_3 + Bundle.getMessage("TotalLengthYard", type, trackLength, Setup.getLengthUnit().toLowerCase(), Math.ceil(100.0 * (double)totalTrackLength / (double)trackLength)) + "\n");
            } else {
                this.writer.write(SPACES_3 + Bundle.getMessage("None") + "\n");
            }
            this.writer.write(SPACES_3 + Bundle.getMessage("InterchangesThatAccept", type) + "\n");
            trackLength = this.getTrackLengthAcceptType(locations, type, "Interchange");
            if (trackLength > 0) {
                this.writer.write(SPACES_3 + Bundle.getMessage("TotalLengthInterchange", type, trackLength, Setup.getLengthUnit().toLowerCase(), Math.ceil(100.0 * (double)totalTrackLength / (double)trackLength)) + "\n");
            } else {
                this.writer.write(SPACES_3 + Bundle.getMessage("None") + "\n");
            }
            this.writer.write(SPACES_3 + Bundle.getMessage("StageTrackThatAccept", type) + "\n");
            trackLength = this.getTrackLengthAcceptType(locations, type, "Staging");
            if (trackLength > 0) {
                this.writer.write(SPACES_3 + Bundle.getMessage("TotalLengthStage", type, trackLength, Setup.getLengthUnit().toLowerCase(), Math.ceil(100.0 * (double)totalTrackLength / (double)trackLength)) + "\n");
                continue;
            }
            this.writer.write(SPACES_3 + Bundle.getMessage("None") + "\n");
        }
        if (this.printErrorAnalysis.isSelected()) {
            this.writer.write(FORM_FEED);
        }
    }

    private void printErrorAnalysisSelected() throws IOException {
        this.writer.write(Bundle.getMessage("TrackErrorAnalysis") + "\n");
        boolean foundError = false;
        for (Location location : this.lmanager.getLocationsByNameList()) {
            if (this._location != null && location != this._location) continue;
            this.writer.write(location.getName() + "\n");
            for (Track track : location.getTracksByNameList(null)) {
                if (track.checkPickups().equals("")) continue;
                this.writer.write(TAB + track.checkPickups() + "\n");
                foundError = true;
            }
        }
        if (!foundError) {
            this.writer.write(Bundle.getMessage("NoErrors"));
        }
    }

    private int getTrackLengthAcceptType(List<Location> locations, String carType, String trackType) throws IOException {
        int trackLength = 0;
        for (Location location : locations) {
            if (this._location != null && location != this._location) continue;
            List<Track> tracks = location.getTracksByNameList(trackType);
            for (Track track : tracks) {
                if (!track.isTypeNameAccepted(carType)) continue;
                trackLength += track.getLength();
                this.writer.write("      " + Bundle.getMessage("LocationTrackLength", location.getName(), track.getName(), track.getLength(), Setup.getLengthUnit().toLowerCase()) + "\n");
            }
        }
        return trackLength;
    }

    private String getTrackString(Track track) {
        String s = TAB + this.padOutString(track.getName(), Control.max_len_string_track_name) + " " + Integer.toString(track.getLength()) + TAB + Integer.toString(track.getUsedLength()) + TAB + Integer.toString(track.getNumberRS()) + TAB + Integer.toString(track.getNumberCars()) + TAB + Integer.toString(track.getNumberEngines()) + TAB + Integer.toString(track.getPickupRS()) + TAB + Integer.toString(track.getDropRS()) + "\n";
        return s;
    }

    private String getDirection(int dir) {
        if ((Setup.getTrainDirection() & dir) == 0) {
            return " " + Bundle.getMessage("LocalOnly") + "\n";
        }
        StringBuffer direction = new StringBuffer(" " + Bundle.getMessage("ServicedByTrain") + " ");
        if ((Setup.getTrainDirection() & dir & 4) == 4) {
            direction.append(Bundle.getMessage("North") + " ");
        }
        if ((Setup.getTrainDirection() & dir & 8) == 8) {
            direction.append(Bundle.getMessage("South") + " ");
        }
        if ((Setup.getTrainDirection() & dir & 1) == 1) {
            direction.append(Bundle.getMessage("East") + " ");
        }
        if ((Setup.getTrainDirection() & dir & 2) == 2) {
            direction.append(Bundle.getMessage("West") + " ");
        }
        direction.append("\n");
        return direction.toString();
    }

    private void printTrackInfo(Location location, List<Track> tracks) {
        for (Track track : tracks) {
            try {
                String s = TAB + track.getName() + this.getDirection(location.getTrainDirections() & track.getTrainDirections());
                this.writer.write(s);
                this.isAlternate(track);
                this.writer.write(this.getTrackCarTypes(track));
                this.writer.write(this.getTrackEngineTypes(track));
                this.writer.write(this.getTrackRoads(track));
                this.writer.write(this.getTrackLoads(track));
                this.writer.write(this.getTrackShipLoads(track));
                this.writer.write(this.getCarOrder(track));
                this.writer.write(this.getSetOutTrains(track));
                this.writer.write(this.getPickUpTrains(track));
                this.writer.write(this.getDestinations(track));
                this.writer.write(this.getTrackInfo(track));
                this.writer.write(this.getSpurInfo(track));
                this.writer.write(this.getSchedule(track));
                this.writer.write(this.getStagingInfo(track));
                this.writer.write("\n");
            }
            catch (IOException we) {
                log.error("Error printing PrintLocationAction: {}", (Object)we.getLocalizedMessage());
            }
        }
    }

    private String getLocationTypes(Location location) {
        StringBuffer buf = new StringBuffer("\t\t" + Bundle.getMessage("TypesServiced") + "\n\t\t");
        int charCount = 0;
        int typeCount = 0;
        for (String type : this.cts.getNames()) {
            if (!location.acceptsTypeName(type)) continue;
            ++typeCount;
            if ((charCount += type.length() + 2) > this.charactersPerLine - 20) {
                buf.append("\n\t\t");
                charCount = type.length() + 2;
            }
            buf.append(type + ", ");
        }
        for (String type : InstanceManager.getDefault(EngineTypes.class).getNames()) {
            if (!location.acceptsTypeName(type)) continue;
            ++typeCount;
            if ((charCount += type.length() + 2) > this.charactersPerLine - 20) {
                buf.append("\n\t\t");
                charCount = type.length() + 2;
            }
            buf.append(type + ", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        if (typeCount == this.cts.getNames().length + InstanceManager.getDefault(EngineTypes.class).getNames().length) {
            buf = new StringBuffer("\t\t" + Bundle.getMessage("LocationAcceptsAllTypes"));
        }
        buf.append("\n");
        return buf.toString();
    }

    private String getTrackCarTypes(Track track) {
        StringBuffer buf = new StringBuffer("\t\t" + Bundle.getMessage("CarTypesServicedTrack") + "\n\t\t");
        int charCount = 0;
        int typeCount = 0;
        for (String type : this.cts.getNames()) {
            if (!track.isTypeNameAccepted(type)) continue;
            ++typeCount;
            if ((charCount += type.length() + 2) > this.charactersPerLine - 20) {
                buf.append("\n\t\t");
                charCount = type.length() + 2;
            }
            buf.append(type + ", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        if (typeCount == this.cts.getNames().length) {
            buf = new StringBuffer("\t\t" + Bundle.getMessage("TrackAcceptsAllCarTypes"));
        }
        buf.append("\n");
        return buf.toString();
    }

    private String getTrackEngineTypes(Track track) {
        StringBuffer buf = new StringBuffer("\t\t" + Bundle.getMessage("EngineTypesServicedTrack") + "\n\t\t");
        int charCount = 0;
        int typeCount = 0;
        for (String type : InstanceManager.getDefault(EngineTypes.class).getNames()) {
            if (!track.isTypeNameAccepted(type)) continue;
            ++typeCount;
            if ((charCount += type.length() + 2) > this.charactersPerLine - 20) {
                buf.append("\n\t\t");
                charCount = type.length() + 2;
            }
            buf.append(type + ", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        if (typeCount == InstanceManager.getDefault(EngineTypes.class).getNames().length) {
            buf = new StringBuffer("\t\t" + Bundle.getMessage("TrackAcceptsAllEngTypes"));
        }
        buf.append("\n");
        return buf.toString();
    }

    private String getTrackRoads(Track track) {
        if (track.getRoadOption().equals(Track.ALL_ROADS)) {
            return "\t\t" + Bundle.getMessage("AcceptsAllRoads") + "\n";
        }
        String op = Bundle.getMessage("RoadsServicedTrack");
        if (track.getRoadOption().equals(Track.EXCLUDE_ROADS)) {
            op = Bundle.getMessage("ExcludeRoadsTrack");
        }
        StringBuffer buf = new StringBuffer("\t\t" + op + "\n\t\t");
        int charCount = 0;
        for (String road : track.getRoadNames()) {
            if ((charCount += road.length() + 2) > this.charactersPerLine - 20) {
                buf.append("\n\t\t");
                charCount = road.length() + 2;
            }
            buf.append(road + ", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append("\n");
        return buf.toString();
    }

    private String getTrackLoads(Track track) {
        if (track.getLoadOption().equals(Track.ALL_LOADS)) {
            return "\t\t" + Bundle.getMessage("AcceptsAllLoads") + "\n";
        }
        String op = Bundle.getMessage("LoadsServicedTrack");
        if (track.getLoadOption().equals(Track.EXCLUDE_LOADS)) {
            op = Bundle.getMessage("ExcludeLoadsTrack");
        }
        StringBuffer buf = new StringBuffer("\t\t" + op + "\n\t\t");
        int charCount = 0;
        for (String load : track.getLoadNames()) {
            if ((charCount += load.length() + 2) > this.charactersPerLine - 20) {
                buf.append("\n\t\t");
                charCount = load.length() + 2;
            }
            buf.append(load + ", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append("\n");
        return buf.toString();
    }

    private String getTrackShipLoads(Track track) {
        if (!track.isStaging()) {
            return "";
        }
        if (track.getShipLoadOption().equals(Track.ALL_LOADS)) {
            return "\t\t" + Bundle.getMessage("ShipsAllLoads") + "\n";
        }
        String op = Bundle.getMessage("LoadsShippedTrack");
        if (track.getShipLoadOption().equals(Track.EXCLUDE_LOADS)) {
            op = Bundle.getMessage("ExcludeLoadsShippedTrack");
        }
        StringBuffer buf = new StringBuffer("\t\t" + op + "\n\t\t");
        int charCount = 0;
        for (String load : track.getShipLoadNames()) {
            if ((charCount += load.length() + 2) > this.charactersPerLine - 20) {
                buf.append("\n\t\t");
                charCount = load.length() + 2;
            }
            buf.append(load + ", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append("\n");
        return buf.toString();
    }

    private String getCarOrder(Track track) {
        if (track.isSpur() || track.isStaging() || track.getServiceOrder().equals(Track.NORMAL)) {
            return "";
        }
        if (track.getServiceOrder().equals(Track.FIFO)) {
            return "\t\t" + Bundle.getMessage("TrackPickUpOrderFIFO") + "\n";
        }
        return "\t\t" + Bundle.getMessage("TrackPickUpOrderLIFO") + "\n";
    }

    private String getSetOutTrains(Track track) {
        StringBuffer buf;
        if (track.getDropOption().equals("Any")) {
            return "\t\t" + Bundle.getMessage("SetOutAllTrains") + "\n";
        }
        int charCount = 0;
        String[] ids = track.getDropIds();
        if (track.getDropOption().equals("trains") || track.getDropOption().equals("excludeTrains")) {
            String trainType = Bundle.getMessage("TrainsSetOutTrack");
            if (track.getDropOption().equals("excludeTrains")) {
                trainType = Bundle.getMessage("ExcludeTrainsSetOutTrack");
            }
            buf = new StringBuffer("\t\t" + trainType + "\n\t\t");
            for (String id : ids) {
                Train train = InstanceManager.getDefault(TrainManager.class).getTrainById(id);
                if (train == null) {
                    log.info("Could not find a train for id: {} track ({})", (Object)id, (Object)track.getName());
                    continue;
                }
                if ((charCount += train.getName().length() + 2) > this.charactersPerLine - 20) {
                    buf.append("\n\t\t");
                    charCount = train.getName().length() + 2;
                }
                buf.append(train.getName() + ", ");
            }
        } else {
            String routeType = Bundle.getMessage("RoutesSetOutTrack");
            if (track.getDropOption().equals("excludeRoutes")) {
                routeType = Bundle.getMessage("ExcludeRoutesSetOutTrack");
            }
            buf = new StringBuffer("\t\t" + routeType + "\n\t\t");
            for (String id : ids) {
                Route route = InstanceManager.getDefault(RouteManager.class).getRouteById(id);
                if (route == null) {
                    log.info("Could not find a route for id: {} location ({}) track ({})", new Object[]{id, track.getLocation().getName(), track.getName()});
                    continue;
                }
                if ((charCount += route.getName().length() + 2) > this.charactersPerLine - 20) {
                    buf.append("\n\t\t");
                    charCount = route.getName().length() + 2;
                }
                buf.append(route.getName() + ", ");
            }
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append("\n");
        return buf.toString();
    }

    private String getPickUpTrains(Track track) {
        StringBuffer buf;
        if (track.getPickupOption().equals("Any")) {
            return "\t\t" + Bundle.getMessage("PickUpAllTrains") + "\n";
        }
        int charCount = 0;
        String[] ids = track.getPickupIds();
        if (track.getPickupOption().equals("trains") || track.getPickupOption().equals("excludeTrains")) {
            String trainType = Bundle.getMessage("TrainsPickUpTrack");
            if (track.getPickupOption().equals("excludeTrains")) {
                trainType = Bundle.getMessage("ExcludeTrainsPickUpTrack");
            }
            buf = new StringBuffer("\t\t" + trainType + "\n\t\t");
            for (String id : ids) {
                Train train = InstanceManager.getDefault(TrainManager.class).getTrainById(id);
                if (train == null) {
                    log.info("Could not find a train for id: {} track ({})", (Object)id, (Object)track.getName());
                    continue;
                }
                if ((charCount += train.getName().length() + 2) > this.charactersPerLine - 20) {
                    buf.append("\n\t\t");
                    charCount = train.getName().length() + 2;
                }
                buf.append(train.getName() + ", ");
            }
        } else {
            String routeType = Bundle.getMessage("RoutesPickUpTrack");
            if (track.getPickupOption().equals("excludeRoutes")) {
                routeType = Bundle.getMessage("ExcludeRoutesPickUpTrack");
            }
            buf = new StringBuffer("\t\t" + routeType + "\n\t\t");
            for (String id : ids) {
                Route route = InstanceManager.getDefault(RouteManager.class).getRouteById(id);
                if (route == null) {
                    log.info("Could not find a route for id: {} location ({}) track ({})", new Object[]{id, track.getLocation().getName(), track.getName()});
                    continue;
                }
                if ((charCount += route.getName().length() + 2) > this.charactersPerLine - 20) {
                    buf.append("\n\t\t");
                    charCount = route.getName().length() + 2;
                }
                buf.append(route.getName() + ", ");
            }
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append("\n");
        return buf.toString();
    }

    private String getDestinations(Track track) {
        StringBuffer buf = new StringBuffer();
        if (track.isOnlyCarsWithFinalDestinationEnabled()) {
            buf.append("\t\t" + Bundle.getMessage("OnlyCarsWithFD"));
            buf.append("\n");
        }
        if (track.getDestinationOption().equals(Track.ALL_DESTINATIONS)) {
            return buf.toString();
        }
        String op = Bundle.getMessage("AcceptOnly") + " " + track.getDestinationListSize() + " " + Bundle.getMessage("Destinations") + ":";
        if (track.getDestinationOption().equals(Track.EXCLUDE_DESTINATIONS)) {
            op = Bundle.getMessage("Exclude") + " " + (this.lmanager.getNumberOfLocations() - track.getDestinationListSize()) + " " + Bundle.getMessage("Destinations") + ":";
        }
        buf.append("\t\t" + op + "\n\t\t");
        String[] destIds = track.getDestinationIds();
        int charCount = 0;
        for (String id : destIds) {
            Location location = this.lmanager.getLocationById(id);
            if (location == null) continue;
            if ((charCount += location.getName().length() + 2) > this.charactersPerLine - 20) {
                buf.append("\n\t\t");
                charCount = location.getName().length() + 2;
            }
            buf.append(location.getName() + ", ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - 2);
        }
        buf.append("\n");
        return buf.toString();
    }

    private String getTrackInfo(Track track) {
        if (track.getPool() != null) {
            StringBuffer buf = new StringBuffer("\t\t" + Bundle.getMessage("Pool") + ": " + track.getPoolName() + "\n");
            return buf.toString();
        }
        return "";
    }

    private String getSchedule(Track track) {
        if (!track.isSpur() || track.getSchedule() == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer("\t\t" + Bundle.getMessage("TrackScheduleName", track.getScheduleName()) + "\n");
        if (track.getAlternateTrack() != null) {
            buf.append("\t\t" + Bundle.getMessage("AlternateTrackName", track.getAlternateTrack().getName()) + "\n");
        }
        if (track.getReservationFactor() != 100) {
            buf.append("\t\t" + Bundle.getMessage("PercentageStaging", track.getReservationFactor()) + "\n");
        }
        return buf.toString();
    }

    private void isAlternate(Track track) throws IOException {
        if (track.isAlternate()) {
            this.writer.write("\t\t" + Bundle.getMessage("AlternateTrack") + "\n");
        }
    }

    private String getSpurInfo(Track track) {
        if (!track.isSpur()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (track.isHoldCarsWithCustomLoadsEnabled()) {
            buf.append("\t\t" + Bundle.getMessage("HoldCarsWithCustomLoads") + "\n");
        }
        if (track.isDisableLoadChangeEnabled()) {
            buf.append("\t\t" + Bundle.getMessage("DisableLoadChange") + "\n");
        }
        return buf.toString();
    }

    private String getStagingInfo(Track track) {
        if (!track.isStaging()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (track.isLoadSwapEnabled() || track.isLoadEmptyEnabled()) {
            buf.append("\t   " + Bundle.getMessage("OptionalLoads") + "\n");
            if (track.isLoadSwapEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("SwapCarLoads") + "\n");
            }
            if (track.isLoadEmptyEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("EmptyDefaultCarLoads") + "\n");
            }
        }
        if (track.isRemoveCustomLoadsEnabled() || track.isAddCustomLoadsEnabled() || track.isAddCustomLoadsAnySpurEnabled() || track.isAddCustomLoadsAnyStagingTrackEnabled()) {
            buf.append("\t   " + Bundle.getMessage("OptionalCustomLoads") + "\n");
            if (track.isRemoveCustomLoadsEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("EmptyCarLoads") + "\n");
            }
            if (track.isAddCustomLoadsEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("LoadCarLoads") + "\n");
            }
            if (track.isAddCustomLoadsAnySpurEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("LoadAnyCarLoads") + "\n");
            }
            if (track.isAddCustomLoadsAnyStagingTrackEnabled()) {
                buf.append("\t\t" + Bundle.getMessage("LoadsStaging") + "\n");
            }
        }
        if (track.isBlockCarsEnabled()) {
            buf.append("\t   " + Bundle.getMessage("OptionalBlocking") + "\n");
            buf.append("\t\t" + Bundle.getMessage("BlockCars") + "\n");
        }
        return buf.toString();
    }

    private String padOutString(String s, int length) {
        return TrainCommon.padAndTruncate(s, length);
    }
}

