/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Frame;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintTrainsServingLocation {
    public static final String NEW_LINE = "\n";
    static final String TAB = "\t";
    boolean _isPreview;
    Location _location;
    Track _track;
    String _carType;
    private static final Logger log = LoggerFactory.getLogger(PrintTrainsServingLocation.class);

    public PrintTrainsServingLocation(boolean isPreview, Location location, Track track, String carType) {
        this._isPreview = isPreview;
        this._location = location;
        this._track = track;
        this._carType = carType;
        this.printLocations();
    }

    private void printLocations() {
        String title = Bundle.getMessage("TitleLocationsTable");
        if (this._location != null) {
            title = this._location.getName();
        }
        try (HardcopyWriter writer = new HardcopyWriter(new Frame(), title, Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview);){
            this.printTrains(writer);
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print canceled");
        }
        catch (IOException we) {
            log.error("Error printing PrintLocationAction: {}", (Object)we.getLocalizedMessage());
        }
    }

    private void printTrains(HardcopyWriter writer) throws IOException {
        if (this._track != null) {
            writer.write(Bundle.getMessage("Track") + TAB + this._track.getName() + NEW_LINE);
        }
        if (!this._carType.isEmpty()) {
            writer.write(Bundle.getMessage("Type") + TAB + this._carType + NEW_LINE);
        }
        writer.write(this.getHeader());
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByNameList()) {
            Route route = train.getRoute();
            if (route == null || !this._carType.isEmpty() && !train.isTypeNameAccepted(this._carType)) continue;
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                if (this._location == null || !rl.getName().equals(this._location.getName())) continue;
                boolean pickup = false;
                boolean setout = false;
                if (!(!rl.isPickUpAllowed() || rl.getMaxCarMoves() <= 0 || train.isLocationSkipped(rl) || !train.isLocalSwitcher() && (rl.getTrainDirection() & this._location.getTrainDirections()) == 0 || !train.isLocalSwitcher() && this._track != null && (rl.getTrainDirection() & this._track.getTrainDirections()) == 0 || this._track != null && !this._track.isPickupTrainAccepted(train))) {
                    pickup = true;
                }
                if (!(!rl.isDropAllowed() || rl.getMaxCarMoves() <= 0 || train.isLocationSkipped(rl) || !train.isLocalSwitcher() && (rl.getTrainDirection() & this._location.getTrainDirections()) == 0 || !train.isLocalSwitcher() && this._track != null && (rl.getTrainDirection() & this._track.getTrainDirections()) == 0 || this._track != null && !this._track.isDropTrainAccepted(train) || this._track != null && !this._carType.isEmpty() && !this._track.checkScheduleAttribute(Track.TYPE, this._carType, null))) {
                    setout = true;
                }
                if (!pickup && !setout) continue;
                StringBuffer sb = new StringBuffer(this.padOutString(train.getName(), Control.max_len_string_train_name));
                sb.append(rl.getTrainDirectionString() + TAB);
                if (pickup) {
                    sb.append(Bundle.getMessage("OkayPickUp") + TAB);
                } else {
                    sb.append(Bundle.getMessage("NoPickUp") + TAB);
                }
                if (setout) {
                    sb.append(Bundle.getMessage("OkaySetOut"));
                } else {
                    sb.append(Bundle.getMessage("NoSetOut"));
                }
                writer.write(sb.toString() + NEW_LINE);
            }
        }
    }

    private String getHeader() {
        String s = this.padOutString(Bundle.getMessage("Trains"), Control.max_len_string_train_name) + Bundle.getMessage("AbbrevationDirection") + TAB + Bundle.getMessage("Pickups") + TAB + Bundle.getMessage("Drop") + NEW_LINE;
        return s;
    }

    private String padOutString(String s, int length) {
        return TrainCommon.padAndTruncate(s, length);
    }
}

