/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.locations.tools.PrintTrainsServingLocationAction;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowTrainsServingLocationFrame
extends OperationsFrame
implements PropertyChangeListener {
    Location _location = null;
    Track _track = null;
    JPanel pTrains = new JPanel();
    JComboBox<Location> locationComboBox = new JComboBox();
    JComboBox<Track> trackComboBox = new JComboBox();
    JComboBox<String> typeComboBox = new JComboBox();
    JCheckBox showAllTrainsCheckBox = new JCheckBox(Bundle.getMessage("ShowAllTrains"));
    private static boolean isShowAllTrains = false;
    String _carType = "";
    private static final Logger log = LoggerFactory.getLogger(ShowTrainsServingLocationFrame.class);

    public ShowTrainsServingLocationFrame() {
        super(Bundle.getMessage("TitleShowTrains"));
    }

    public void initComponents(Location location, Track track) {
        this._location = location;
        this._track = track;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pLocations = new JPanel();
        pLocations.setLayout(new GridBagLayout());
        pLocations.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        pLocations.setMaximumSize(new Dimension(2000, 50));
        this.addItem(pLocations, this.locationComboBox, 0, 0);
        JPanel pTracks = new JPanel();
        pTracks.setLayout(new GridBagLayout());
        pTracks.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Track")));
        pTracks.setMaximumSize(new Dimension(2000, 50));
        this.addItem(pTracks, this.trackComboBox, 0, 0);
        JPanel pCarType = new JPanel();
        pCarType.setLayout(new GridBagLayout());
        pCarType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        pCarType.setMaximumSize(new Dimension(2000, 50));
        this.addItem(pCarType, this.typeComboBox, 0, 0);
        JPanel pOptions = new JPanel();
        pOptions.setLayout(new GridBagLayout());
        pOptions.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Options")));
        this.addItem(pOptions, this.showAllTrainsCheckBox, 0, 0);
        this.pTrains.setLayout(new GridBagLayout());
        JScrollPane trainsPane = new JScrollPane(this.pTrains);
        trainsPane.setVerticalScrollBarPolicy(20);
        trainsPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Trains")));
        this.getContentPane().add(pLocations);
        this.getContentPane().add(pTracks);
        this.getContentPane().add(pCarType);
        this.getContentPane().add(pOptions);
        this.getContentPane().add(trainsPane);
        this.showAllTrainsCheckBox.setToolTipText(Bundle.getMessage("TipDeselectedShowAllTrains"));
        this.addCheckBoxAction(this.showAllTrainsCheckBox);
        this.showAllTrainsCheckBox.setSelected(isShowAllTrains);
        this.updateLocationsComboBox();
        this.updateTracksComboBox();
        this.updateTypeComboBox();
        this.addComboBoxAction(this.locationComboBox);
        this.addComboBoxAction(this.trackComboBox);
        this.addComboBoxAction(this.typeComboBox);
        Dimension boxsize = this.typeComboBox.getMinimumSize();
        if (boxsize != null) {
            boxsize.setSize(boxsize.width + 10, boxsize.height);
            this.typeComboBox.setMinimumSize(boxsize);
        }
        if (location != null) {
            location.addPropertyChangeListener(this);
        }
        if (track != null) {
            track.addPropertyChangeListener(this);
        }
        this.addPropertyChangeAllTrains();
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new PrintTrainsServingLocationAction(this, false));
        toolMenu.add(new PrintTrainsServingLocationAction(this, true));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ShowTrainsServicingThisLocation", true);
        this.setPreferredSize(null);
        this.initMinimumSize();
    }

    private void updateTrainPane() {
        log.debug("Updating for location ({}), Track ({})", (Object)this._location, (Object)this._track);
        this.pTrains.removeAll();
        int y = 0;
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByNameList()) {
            Route route = train.getRoute();
            if (route == null) continue;
            boolean typeAccepted = train.isTypeNameAccepted(this._carType);
            if (this._carType.equals("")) {
                for (int i = 0; i < this.typeComboBox.getItemCount(); ++i) {
                    if (!train.isTypeNameAccepted(this.typeComboBox.getItemAt(i))) continue;
                    typeAccepted = true;
                    break;
                }
            }
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                if (this._location == null || !rl.getName().equals(this._location.getName())) continue;
                boolean pickup = false;
                boolean setout = false;
                train.getRoute().removePropertyChangeListener(this);
                train.getRoute().addPropertyChangeListener(this);
                if (rl.isPickUpAllowed() && rl.getMaxCarMoves() > 0 && !train.isLocationSkipped(rl) && typeAccepted && (train.isLocalSwitcher() || (rl.getTrainDirection() & this._location.getTrainDirections()) != 0) && (train.isLocalSwitcher() || this._track == null || (rl.getTrainDirection() & this._track.getTrainDirections()) != 0) && (this._track == null || this._track.isPickupTrainAccepted(train))) {
                    pickup = true;
                }
                if (rl.isDropAllowed() && rl.getMaxCarMoves() > 0 && !train.isLocationSkipped(rl) && typeAccepted && (train.isLocalSwitcher() || (rl.getTrainDirection() & this._location.getTrainDirections()) != 0) && (train.isLocalSwitcher() || this._track == null || (rl.getTrainDirection() & this._track.getTrainDirections()) != 0) && (this._track == null || this._track.isDropTrainAccepted(train)) && (this._track == null || this._carType.equals("") || this._track.checkScheduleAttribute(Track.TYPE, this._carType, null))) {
                    setout = true;
                }
                if (this.showAllTrainsCheckBox.isSelected() || pickup || setout) {
                    this.addItemLeft(this.pTrains, new JLabel(train.getName()), 0, y);
                    this.addItem(this.pTrains, new JLabel(rl.getTrainDirectionString()), 1, y);
                    if (pickup) {
                        this.addItem(this.pTrains, new JLabel(Bundle.getMessage("OkayPickUp")), 2, y);
                    } else {
                        this.addItem(this.pTrains, new JLabel(Bundle.getMessage("NoPickUp")), 2, y);
                    }
                    if (setout) {
                        this.addItem(this.pTrains, new JLabel(Bundle.getMessage("OkaySetOut")), 3, y);
                    } else {
                        this.addItem(this.pTrains, new JLabel(Bundle.getMessage("NoSetOut")), 3, y);
                    }
                }
                ++y;
            }
        }
        this.pTrains.repaint();
        this.pTrains.revalidate();
        this.pack();
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    public void checkBoxActionPerformed(ActionEvent ae) {
        log.debug("check box action");
        isShowAllTrains = this.showAllTrainsCheckBox.isSelected();
        this.updateTrainPane();
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource().equals(this.locationComboBox)) {
            this._location = (Location)this.locationComboBox.getSelectedItem();
            this.updateTracksComboBox();
            this.updateTypeComboBox();
            this.updateTrainPane();
        }
        if (ae.getSource().equals(this.trackComboBox)) {
            if (this._track != null) {
                this._track.removePropertyChangeListener(this);
            }
            this._track = (Track)this.trackComboBox.getSelectedItem();
            if (this._track != null) {
                this._track.addPropertyChangeListener(this);
            }
            this.updateTypeComboBox();
            this.updateTrainPane();
        }
        if (this.typeComboBox.isEnabled() && ae.getSource().equals(this.typeComboBox)) {
            if (this.typeComboBox.getSelectedItem() != null) {
                this._carType = (String)this.typeComboBox.getSelectedItem();
            }
            this.updateTrainPane();
        }
    }

    private void updateLocationsComboBox() {
        InstanceManager.getDefault(LocationManager.class).updateComboBox(this.locationComboBox);
        this.locationComboBox.setSelectedItem(this._location);
    }

    private void updateTracksComboBox() {
        if (this._location != null) {
            this._location.updateComboBox(this.trackComboBox);
        }
        this.trackComboBox.setSelectedItem(this._track);
    }

    private void updateTypeComboBox() {
        log.debug("update type combobox");
        this.typeComboBox.setEnabled(false);
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.typeComboBox);
        for (int i = this.typeComboBox.getItemCount() - 1; i >= 0; --i) {
            String type = this.typeComboBox.getItemAt(i);
            if (this._location != null && !this._location.acceptsTypeName(type)) {
                this.typeComboBox.removeItem(type);
            }
            if (this._track == null || this._track.isTypeNameAccepted(type)) continue;
            this.typeComboBox.removeItem(type);
        }
        this.typeComboBox.insertItemAt("", 0);
        this.typeComboBox.setSelectedItem(this._carType);
        this.updateTrainPane();
        this.typeComboBox.setEnabled(true);
    }

    @Override
    public void dispose() {
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        if (this._track != null) {
            this._track.removePropertyChangeListener(this);
        }
        this.removePropertyChangeAllTrains();
        super.dispose();
    }

    public void addPropertyChangeAllTrains() {
        InstanceManager.getDefault(TrainManager.class).addPropertyChangeListener(this);
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByNameList()) {
            train.addPropertyChangeListener(this);
        }
    }

    public void removePropertyChangeAllTrains() {
        InstanceManager.getDefault(TrainManager.class).removePropertyChangeListener(this);
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByNameList()) {
            train.removePropertyChangeListener(this);
            if (train.getRoute() == null) continue;
            train.getRoute().removePropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("locationTypes") || e.getPropertyName().equals("trackRollingStockTypes")) {
            this.updateTypeComboBox();
        }
        if (e.getPropertyName().equals("locationTrainDirection") || e.getPropertyName().equals("trackTrainDirection") || e.getPropertyName().equals("trackDrop") || e.getPropertyName().equals("trackPickup") || e.getPropertyName().equals("TrainRoute") || e.getPropertyName().equals("TrainTypes") || e.getPropertyName().equals("TrainStops") || e.getPropertyName().equals("routeListChange")) {
            this.updateTrainPane();
        }
        if (e.getPropertyName().equals("TrainsListLength")) {
            this.removePropertyChangeAllTrains();
            this.addPropertyChangeAllTrains();
        }
    }
}

