/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.ScheduleManager;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.RollingStockManager;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackCopyFrame
extends OperationsFrame
implements PropertyChangeListener {
    JTextField trackNameTextField = new JTextField(Control.max_len_string_track_name);
    JButton copyButton = new JButton(Bundle.getMessage("ButtonCopy"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JComboBox<Location> locationBox = InstanceManager.getDefault(LocationManager.class).getComboBox();
    JComboBox<Track> trackBox = new JComboBox();
    JComboBox<Location> destinationBox = InstanceManager.getDefault(LocationManager.class).getComboBox();
    JCheckBox sameNameCheckBox = new JCheckBox(Bundle.getMessage("SameName"));
    JCheckBox moveRollingStockCheckBox = new JCheckBox(Bundle.getMessage("MoveRollingStock"));
    JCheckBox deleteTrackCheckBox = new JCheckBox(Bundle.getMessage("DeleteCopiedTrack"));
    Location _location;
    Location _destination;
    static boolean sameName = false;
    static boolean moveRollingStock = false;
    static boolean deleteTrack = false;
    private static final Logger log = LoggerFactory.getLogger(TrackCopyFrame.class);

    public TrackCopyFrame(Track track, Location destination) {
        this._destination = destination;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrackName")));
        this.addItem(pName, this.trackNameTextField, 0, 0);
        JPanel pCopy = new JPanel();
        pCopy.setLayout(new GridBagLayout());
        pCopy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectTrackToCopy")));
        this.addItem(pCopy, this.locationBox, 0, 0);
        this.addItem(pCopy, this.trackBox, 1, 0);
        JPanel pCopyTo = new JPanel();
        pCopyTo.setLayout(new GridBagLayout());
        pCopyTo.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectCopyToLocation")));
        this.addItem(pCopyTo, this.destinationBox, 0, 0);
        JPanel pOptions = new JPanel();
        pOptions.setLayout(new GridBagLayout());
        pOptions.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Options")));
        this.addItemLeft(pOptions, this.sameNameCheckBox, 0, 0);
        this.addItemLeft(pOptions, this.moveRollingStockCheckBox, 0, 1);
        this.addItemLeft(pOptions, this.deleteTrackCheckBox, 0, 2);
        JPanel pButton = new JPanel();
        pButton.setLayout(new GridBagLayout());
        this.addItem(pButton, this.copyButton, 0, 0);
        this.addItem(pButton, this.saveButton, 1, 0);
        this.getContentPane().add(pName);
        this.getContentPane().add(pCopy);
        this.getContentPane().add(pCopyTo);
        this.getContentPane().add(pOptions);
        this.getContentPane().add(pButton);
        this.addComboBoxAction(this.locationBox);
        this.addComboBoxAction(this.trackBox);
        this.addComboBoxAction(this.destinationBox);
        this.sameNameCheckBox.setSelected(sameName);
        this.moveRollingStockCheckBox.setSelected(moveRollingStock);
        this.deleteTrackCheckBox.setSelected(deleteTrack);
        this.deleteTrackCheckBox.setEnabled(this.moveRollingStockCheckBox.isSelected());
        InstanceManager.getDefault(LocationManager.class).addPropertyChangeListener(this);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_CopyTrack", true);
        this.pack();
        this.setMinimumSize(new Dimension(400, 400));
        if (track != null) {
            this.locationBox.setSelectedItem(track.getLocation());
            this.trackBox.setSelectedItem(track);
        }
        this.destinationBox.setSelectedItem(destination);
        this.addButtonAction(this.copyButton);
        this.addButtonAction(this.saveButton);
        this.addCheckBoxAction(this.sameNameCheckBox);
        this.addCheckBoxAction(this.moveRollingStockCheckBox);
        this.setTitle(Bundle.getMessage("MenuItemCopyTrack"));
    }

    @Override
    protected void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.locationBox) {
            this.updateTrackComboBox();
        }
        if (ae.getSource() == this.trackBox) {
            this.updateTrackName();
        }
        if (ae.getSource() == this.destinationBox) {
            this._destination = (Location)this.destinationBox.getSelectedItem();
            this.copyButton.setEnabled(this._destination != null);
        }
    }

    protected void updateTrackComboBox() {
        log.debug("update track combobox");
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        if (this.locationBox.getSelectedItem() == null) {
            this.trackBox.removeAllItems();
        } else {
            log.debug("copy from location: {}", this.locationBox.getSelectedItem());
            this._location = (Location)this.locationBox.getSelectedItem();
            Track track = (Track)this.trackBox.getSelectedItem();
            this._location.updateComboBox(this.trackBox);
            this.trackBox.setSelectedItem(track);
            this._location.addPropertyChangeListener(this);
        }
    }

    protected void updateTrackName() {
        if (this.sameNameCheckBox.isSelected() && this.trackBox.getSelectedItem() != null) {
            this.trackNameTextField.setText(this.trackBox.getSelectedItem().toString());
        }
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GUI ease of use")
    protected void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.copyButton) {
            log.debug("copy track button activated");
            if (!this.checkName()) {
                return;
            }
            if (this.trackBox.getSelectedItem() == null || this.trackBox.getSelectedItem().equals("") || this._destination == null) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("SelectLocationAndTrack"), Bundle.getMessage("SelectTrackToCopy"), 1);
                return;
            }
            Track fromTrack = (Track)this.trackBox.getSelectedItem();
            if (this.moveRollingStockCheckBox.isSelected() && fromTrack.getPickupRS() > 0) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("FoundRollingStockPickUp", fromTrack.getPickupRS()), Bundle.getMessage("TrainsServicingTrack", fromTrack.getName()), 2);
                return;
            }
            if (this.moveRollingStockCheckBox.isSelected() && fromTrack.getDropRS() > 0) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("FoundRollingStockDrop", fromTrack.getDropRS()), Bundle.getMessage("TrainsServicingTrack", fromTrack.getName()), 2);
                return;
            }
            if (fromTrack.isStaging() ^ this._destination.isStaging()) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("TrackTypeWrong", fromTrack.getTrackType(), this._destination.getName()), Bundle.getMessage("CanNotCopy", fromTrack.getName()), 0);
                return;
            }
            Track toTrack = fromTrack.copyTrack(this.trackNameTextField.getText(), this._destination);
            if (this.moveRollingStockCheckBox.isSelected()) {
                this.moveRollingStock(fromTrack, toTrack);
                if (this.deleteTrackCheckBox.isSelected()) {
                    InstanceManager.getDefault(ScheduleManager.class).replaceTrack(fromTrack, toTrack);
                    fromTrack.getLocation().deleteTrack(fromTrack);
                }
            }
        }
        if (ae.getSource() == this.saveButton) {
            log.debug("save track button activated");
            sameName = this.sameNameCheckBox.isSelected();
            moveRollingStock = this.moveRollingStockCheckBox.isSelected();
            deleteTrack = this.deleteTrackCheckBox.isSelected();
            OperationsXml.save();
        }
    }

    @Override
    protected void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.sameNameCheckBox) {
            this.updateTrackName();
        }
        if (ae.getSource() == this.moveRollingStockCheckBox) {
            this.deleteTrackCheckBox.setEnabled(this.moveRollingStockCheckBox.isSelected());
            this.deleteTrackCheckBox.setSelected(false);
        }
    }

    protected void updateComboBoxes() {
        log.debug("update location combobox");
        InstanceManager.getDefault(LocationManager.class).updateComboBox(this.locationBox);
        InstanceManager.getDefault(LocationManager.class).updateComboBox(this.destinationBox);
    }

    protected boolean checkName() {
        if (this.trackNameTextField.getText().trim().isEmpty()) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MustEnterName"), Bundle.getMessage("CanNotTrack", Bundle.getMessage("ButtonCopy")), 0);
            return false;
        }
        if (TrainCommon.splitString(this.trackNameTextField.getText()).length() > Control.max_len_string_track_name) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("TrackNameLengthMax", Integer.toString(Control.max_len_string_track_name + 1)), Bundle.getMessage("CanNotTrack", Bundle.getMessage("ButtonCopy")), 0);
            return false;
        }
        if (this._destination == null) {
            return false;
        }
        Track check = this._destination.getTrackByName(this.trackNameTextField.getText(), null);
        if (check != null) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("TrackAlreadyExists"), Bundle.getMessage("CanNotTrack", Bundle.getMessage("ButtonCopy")), 0);
            return false;
        }
        return true;
    }

    protected void moveRollingStock(Track fromTrack, Track toTrack) {
        this.moveRollingStock(fromTrack, toTrack, InstanceManager.getDefault(CarManager.class));
        this.moveRollingStock(fromTrack, toTrack, InstanceManager.getDefault(EngineManager.class));
    }

    private void moveRollingStock(Track fromTrack, Track toTrack, RollingStockManager<? extends RollingStock> manager) {
        for (RollingStock rollingStock : manager.getByIdList()) {
            if (rollingStock.getTrack() != fromTrack) continue;
            rollingStock.setLocation(toTrack.getLocation(), toTrack, true);
        }
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(LocationManager.class).removePropertyChangeListener(this);
        if (this._destination != null) {
            this._destination.removePropertyChangeListener(this);
        }
        if (this._location != null) {
            this._location.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("PropertyChange ({}) old ({}) new ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        if (e.getPropertyName().equals("locationsListLength")) {
            this.updateComboBoxes();
        }
        if (e.getSource() == this._location) {
            this.updateTrackComboBox();
        }
        if (e.getSource() == this._destination && e.getPropertyName().equals("locationDispose")) {
            this.dispose();
        }
    }
}

