/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.locations.tools;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.gui.TrackEditFrame;
import jmri.jmrit.operations.locations.tools.Bundle;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.router.Router;
import jmri.jmrit.operations.setup.Setup;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackDestinationEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    Track _track = null;
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    JPanel pControls = new JPanel();
    JPanel panelDestinations = new JPanel();
    JScrollPane paneDestinations = new JScrollPane(this.panelDestinations);
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JButton checkDestinationsButton = new JButton(Bundle.getMessage("CheckDestinations"));
    JRadioButton destinationsAll = new JRadioButton(Bundle.getMessage("AcceptAll"));
    JRadioButton destinationsInclude = new JRadioButton(Bundle.getMessage("AcceptOnly"));
    JRadioButton destinationsExclude = new JRadioButton(Bundle.getMessage("Exclude"));
    JCheckBox onlyCarsWithFD = new JCheckBox(Bundle.getMessage("OnlyCarsWithFD"));
    JLabel trackName = new JLabel();
    public static final String DISPOSE = "dispose";
    private static final Logger log = LoggerFactory.getLogger(TrackDestinationEditFrame.class);

    public TrackDestinationEditFrame() {
        super(Bundle.getMessage("TitleEditTrackDestinations"));
    }

    public void initComponents(TrackEditFrame tef) {
        this._track = tef._track;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.setMaximumSize(new Dimension(2000, 250));
        JPanel pTrackName = new JPanel();
        pTrackName.setLayout(new GridBagLayout());
        pTrackName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Track")));
        this.addItem(pTrackName, this.trackName, 0, 0);
        JPanel pLocationName = new JPanel();
        pLocationName.setLayout(new GridBagLayout());
        pLocationName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Location")));
        this.addItem(pLocationName, new JLabel(this._track.getLocation().getName()), 0, 0);
        p1.add(pTrackName);
        p1.add(pLocationName);
        JPanel pFD = new JPanel();
        pFD.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Options")));
        pFD.add(this.onlyCarsWithFD);
        pFD.setMaximumSize(new Dimension(2000, 200));
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 1));
        JScrollPane pane3 = new JScrollPane(p3);
        pane3.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("DestinationTrack")));
        pane3.setMaximumSize(new Dimension(2000, 400));
        JPanel pRadioButtons = new JPanel();
        pRadioButtons.setLayout(new FlowLayout());
        pRadioButtons.add(this.destinationsAll);
        pRadioButtons.add(this.destinationsInclude);
        pRadioButtons.add(this.destinationsExclude);
        p3.add(pRadioButtons);
        this.panelDestinations.setLayout(new GridBagLayout());
        this.paneDestinations.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Destinations")));
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.destinationsAll);
        bGroup.add(this.destinationsInclude);
        bGroup.add(this.destinationsExclude);
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridBagLayout());
        panelButtons.setBorder(BorderFactory.createTitledBorder(""));
        panelButtons.setMaximumSize(new Dimension(2000, 200));
        this.addItem(panelButtons, this.checkDestinationsButton, 0, 0);
        this.addItem(panelButtons, this.saveButton, 1, 0);
        this.getContentPane().add(p1);
        this.getContentPane().add(pFD);
        this.getContentPane().add(pane3);
        this.getContentPane().add(this.paneDestinations);
        this.getContentPane().add(panelButtons);
        this.addButtonAction(this.checkDestinationsButton);
        this.addButtonAction(this.saveButton);
        this.addRadioButtonAction(this.destinationsAll);
        this.addRadioButtonAction(this.destinationsInclude);
        this.addRadioButtonAction(this.destinationsExclude);
        if (this._track != null) {
            this._track.addPropertyChangeListener(this);
            this.trackName.setText(this._track.getName());
            this.onlyCarsWithFD.setSelected(this._track.isOnlyCarsWithFinalDestinationEnabled());
            pFD.setVisible(this._track.isInterchange() || this._track.isStaging());
            this.enableButtons(true);
        } else {
            this.enableButtons(false);
        }
        this.updateDestinations();
        this.locationManager.addPropertyChangeListener(this);
        this.initMinimumSize(new Dimension(400, 500));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (this._track == null) {
            return;
        }
        if (ae.getSource() == this.saveButton) {
            log.debug("track save button activated");
            this._track.setOnlyCarsWithFinalDestinationEnabled(this.onlyCarsWithFD.isSelected());
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
        if (ae.getSource() == this.checkDestinationsButton) {
            this.checkDestinationsButton.setEnabled(false);
            this.checkDestinationsValid();
        }
    }

    protected void enableButtons(boolean enabled) {
        this.saveButton.setEnabled(enabled);
        this.checkDestinationsButton.setEnabled(enabled);
        this.destinationsAll.setEnabled(enabled);
        this.destinationsInclude.setEnabled(enabled);
        this.destinationsExclude.setEnabled(enabled);
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        if (ae.getSource() == this.destinationsAll) {
            this._track.setDestinationOption(Track.ALL_DESTINATIONS);
        }
        if (ae.getSource() == this.destinationsInclude) {
            this._track.setDestinationOption(Track.INCLUDE_DESTINATIONS);
        }
        if (ae.getSource() == this.destinationsExclude) {
            this._track.setDestinationOption(Track.EXCLUDE_DESTINATIONS);
        }
        this.updateDestinations();
    }

    private void updateDestinations() {
        log.debug("Update destinations");
        this.panelDestinations.removeAll();
        if (this._track != null) {
            this.destinationsAll.setSelected(this._track.getDestinationOption().equals(Track.ALL_DESTINATIONS));
            this.destinationsInclude.setSelected(this._track.getDestinationOption().equals(Track.INCLUDE_DESTINATIONS));
            this.destinationsExclude.setSelected(this._track.getDestinationOption().equals(Track.EXCLUDE_DESTINATIONS));
        }
        List<Location> locations = this.locationManager.getLocationsByNameList();
        for (int i = 0; i < locations.size(); ++i) {
            Location loc = locations.get(i);
            JCheckBox cb = new JCheckBox(loc.getName());
            this.addItemLeft(this.panelDestinations, cb, 0, i);
            cb.setEnabled(!this.destinationsAll.isSelected());
            this.addCheckBoxAction(cb);
            if (this.destinationsAll.isSelected()) {
                cb.setSelected(true);
                continue;
            }
            if (this._track == null || !(this._track.isDestinationAccepted(loc) ^ this._track.getDestinationOption().equals(Track.EXCLUDE_DESTINATIONS))) continue;
            cb.setSelected(true);
        }
        this.panelDestinations.revalidate();
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        JCheckBox b = (JCheckBox)ae.getSource();
        log.debug("checkbox change {}", (Object)b.getText());
        if (this._track == null) {
            return;
        }
        Location loc = this.locationManager.getLocationByName(b.getText());
        if (loc != null) {
            if (b.isSelected() ^ this._track.getDestinationOption().equals(Track.EXCLUDE_DESTINATIONS)) {
                this._track.addDestination(loc);
            } else {
                this._track.deleteDestination(loc);
            }
        }
    }

    private void checkDestinationsValid() {
        SwingUtilities.invokeLater(() -> {
            if (this.checkLocationsLoop()) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("OkayMessage"));
            }
            this.checkDestinationsButton.setEnabled(true);
        });
    }

    private boolean checkLocationsLoop() {
        boolean noIssues = true;
        ArrayList<String> ignoreType = new ArrayList<String>();
        for (Location destination : this.locationManager.getLocationsByNameList()) {
            ignoreType.clear();
            if (!this._track.isDestinationAccepted(destination)) continue;
            log.debug("Track ({}) accepts destination ({})", (Object)this._track.getName(), (Object)destination.getName());
            if (this._track.getLocation() == destination) continue;
            block1: for (String type : InstanceManager.getDefault(CarTypes.class).getNames()) {
                if (!this._track.isTypeNameAccepted(type)) continue;
                if (!destination.acceptsTypeName(type)) {
                    noIssues = false;
                    int response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("WarningDestinationCarType", destination.getName(), type), Bundle.getMessage("WarningCarMayNotMove"), 2);
                    if (response == 0) {
                        ignoreType.add(type);
                        continue;
                    }
                    return false;
                }
                for (Track track : destination.getTracksList()) {
                    if (!track.isTypeNameAccepted(type)) continue;
                    continue block1;
                }
                noIssues = false;
                int response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("WarningDestinationTrackCarType", destination.getName(), type), Bundle.getMessage("WarningCarMayNotMove"), 2);
                if (response == 0) {
                    ignoreType.add(type);
                    continue;
                }
                return false;
            }
            for (String type : InstanceManager.getDefault(CarTypes.class).getNames()) {
                if (!this._track.isTypeNameAccepted(type) || ignoreType.contains(type)) continue;
                block4: for (String string : InstanceManager.getDefault(CarRoads.class).getNames(type)) {
                    if (!this._track.isRoadNameAccepted(string)) continue;
                    for (Track track : destination.getTracksList()) {
                        if (!track.isTypeNameAccepted(type) || !track.isRoadNameAccepted(string)) continue;
                        continue block4;
                    }
                    noIssues = false;
                    int response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("WarningDestinationTrackCarRoad", destination.getName(), type, string), Bundle.getMessage("WarningCarMayNotMove"), 2);
                    if (response == 0) continue;
                    return false;
                }
            }
            for (String type : InstanceManager.getDefault(CarTypes.class).getNames()) {
                if (!this._track.isTypeNameAccepted(type) || ignoreType.contains(type)) continue;
                List<String> loads = InstanceManager.getDefault(CarLoads.class).getNames(type);
                block7: for (String load : loads) {
                    if (!this._track.isLoadNameAccepted(load)) continue;
                    for (Track track : destination.getTracksList()) {
                        if (!track.isTypeNameAccepted(type) || !track.isLoadNameAndCarTypeAccepted(load, type)) continue;
                        continue block7;
                    }
                    noIssues = false;
                    int response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("WarningDestinationTrackCarLoad", destination.getName(), type, load), Bundle.getMessage("WarningCarMayNotMove"), 2);
                    if (response == 0) continue;
                    return false;
                }
                block9: for (String load : loads) {
                    if (!this._track.isLoadNameAndCarTypeAccepted(load, type)) continue;
                    for (Track track : destination.getTracksList()) {
                        if (!track.isLoadNameAndCarTypeAccepted(load, type)) continue;
                        continue block9;
                    }
                    noIssues = false;
                    int response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("WarningDestinationTrackCarLoad", destination.getName(), type, load), Bundle.getMessage("WarningCarMayNotMove"), 2);
                    if (response == 0) continue;
                    return false;
                }
            }
            Car car = new Car();
            car.setLength(Integer.toString(-RollingStock.COUPLERS));
            for (String type : InstanceManager.getDefault(CarTypes.class).getNames()) {
                if (!this._track.isTypeNameAccepted(type)) continue;
                List<String> list = InstanceManager.getDefault(CarLoads.class).getNames(type);
                for (String load : list) {
                    if (!this._track.isLoadNameAndCarTypeAccepted(load, type)) continue;
                    for (String road : InstanceManager.getDefault(CarRoads.class).getNames(type)) {
                        Object rs22;
                        if (!this._track.isRoadNameAccepted(road)) continue;
                        boolean foundCar = false;
                        for (Object rs22 : InstanceManager.getDefault(CarManager.class).getList()) {
                            if (!((RollingStock)rs22).getTypeName().equals(type) || !((RollingStock)rs22).getRoadName().equals(road)) continue;
                            foundCar = true;
                            break;
                        }
                        if (!foundCar) continue;
                        car.setTypeName(type);
                        car.setRoadName(road);
                        car.setLoadName(load);
                        car.setTrack(this._track);
                        car.setFinalDestination(destination);
                        String testDest = "NO_TYPE";
                        rs22 = destination.getTracksList().iterator();
                        while (rs22.hasNext()) {
                            Track track = (Track)rs22.next();
                            if (!track.isTypeNameAccepted(type)) continue;
                            if (track.getScheduleMode() == 0) {
                                track.setScheduleMode(1);
                                String itemId = track.getScheduleItemId();
                                testDest = car.checkDestination(destination, track);
                                track.setScheduleMode(0);
                                track.setScheduleItemId(itemId);
                            } else {
                                testDest = car.checkDestination(destination, track);
                            }
                            if (!testDest.equals(Track.OKAY)) continue;
                            break;
                        }
                        if (testDest.equals("NO_TYPE")) continue;
                        if (!testDest.equals(Track.OKAY)) {
                            noIssues = false;
                            int response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("WarningNoTrack", destination.getName(), type, road, load, destination.getName()), Bundle.getMessage("WarningCarMayNotMove"), 2);
                            if (response == 0) continue;
                            return false;
                        }
                        log.debug("Find train for car type ({}), road ({}), load ({})", new Object[]{type, road, load});
                        boolean results = InstanceManager.getDefault(Router.class).setDestination(car, null, null);
                        car.setDestination(null, null);
                        if (results) continue;
                        noIssues = false;
                        int response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("WarningNoTrain", type, road, load, destination.getName()), Bundle.getMessage("WarningCarMayNotMove"), 2);
                        if (response == 0) continue;
                        return false;
                    }
                }
            }
        }
        return noIssues;
    }

    @Override
    public void dispose() {
        if (this._track != null) {
            this._track.removePropertyChangeListener(this);
        }
        this.locationManager.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("locationsListLength") || e.getPropertyName().equals("trackDestinations")) {
            this.updateDestinations();
        }
        if (e.getPropertyName().equals("onlyCarsWithFinalDestinations")) {
            this.onlyCarsWithFD.setSelected((Boolean)e.getNewValue());
        }
    }
}

