/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.rollingstock;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJFileChooser;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImportCommon
extends Thread {
    protected static final String NEW_LINE = "\n";
    protected JLabel lineNumber = new JLabel();
    protected JLabel importLine = new JLabel();
    protected boolean importOkay = false;
    protected static final String[] BREAK = new String[0];
    protected int lineNum = 0;
    protected static final String LOCATION_TRACK_SEPARATOR = "-";
    protected JmriJFrame fstatus;
    private static final Logger log = LoggerFactory.getLogger(ImportCommon.class);

    protected File getFile() {
        JmriJFileChooser fc = new JmriJFileChooser(OperationsXml.getFileLocation());
        fc.setFileFilter(new FileNameExtensionFilter(Bundle.getMessage("Text&CSV"), "txt", "csv"));
        int retVal = fc.showOpenDialog(null);
        if (retVal != 0) {
            return null;
        }
        log.info("Importing from file: {}", (Object)fc.getSelectedFile());
        return fc.getSelectedFile();
    }

    protected BufferedReader getBufferedReader(File file) {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected void createStatusFrame(String title) {
        JPanel ps = new JPanel();
        ps.setLayout(new BoxLayout(ps, 1));
        this.fstatus = new JmriJFrame(title);
        this.fstatus.setLocation(10, 10);
        this.fstatus.setSize(1025, 100);
        ps.add(this.lineNumber);
        ps.add(this.importLine);
        this.fstatus.getContentPane().add(ps);
        this.fstatus.setVisible(true);
    }

    protected String[] parseCommaLine(String line) {
        Object[] outLine = new String[]{};
        try {
            CSVRecord record = (CSVRecord)CSVParser.parse((String)line, (CSVFormat)CSVFormat.DEFAULT).getRecords().get(0);
            outLine = new String[record.size()];
            for (int i = 0; i < outLine.length; ++i) {
                outLine[i] = record.get(i);
            }
        }
        catch (IndexOutOfBoundsException record) {
        }
        catch (IOException ex) {
            log.error("Error parsing CSV: {}, {}", (Object)line, (Object)ex.getLocalizedMessage());
            Arrays.fill(outLine, "");
        }
        return outLine;
    }

    protected String[] readNextLine(BufferedReader rdr) {
        String line = " ";
        try {
            line = rdr.readLine();
        }
        catch (IOException e) {
            return BREAK;
        }
        if (line == null) {
            this.importOkay = true;
            return BREAK;
        }
        if (!this.fstatus.isShowing()) {
            return BREAK;
        }
        this.lineNumber.setText(Bundle.getMessage("LineNumber", Integer.toString(++this.lineNum)));
        line = line.trim();
        this.importLine.setText(line);
        String[] inputLine = this.parseCommaLine(line);
        log.debug("Import line number {} has {} elements", (Object)this.lineNum, (Object)inputLine.length);
        return inputLine;
    }
}

